/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.sign.Signlink;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class CacheDownloader {
    private static final Logger log = Logger.getLogger(CacheDownloader.class.getName());
    public static int cacheVersionRemote;
    public static int cacheVersionLocal;
    private static final String CACHE_VERSION_DOWNLOAD_LINK = "https://valoria-rsps.com/rsps/cache-version.txt";
    private final Client client;
    private static final int BUFFER = 1024;
    private Path fileLocation;

    public CacheDownloader(Client client) {
        Objects.requireNonNull(Signlink.getCacheDirectory(), "Cache directory is null");
        this.client = client;
        this.fileLocation = Paths.get(Signlink.getCacheDirectory(), this.getArchivedName());
    }

    public CacheDownloader downloadCache() {
        if (Signlink.usingDevCache()) {
            System.out.println("Using local_cache, skipping cache update.");
            return null;
        }
        try {
            int vers;
            this.ensureCacheDir();
            URL tmp = new URL(CACHE_VERSION_DOWNLOAD_LINK);
            File versionFile = new File(Signlink.getCacheDirectory(), "version.dat");
            BufferedReader br = new BufferedReader(new InputStreamReader(tmp.openStream()));
            cacheVersionRemote = vers = Integer.parseInt(br.readLine());
            boolean present = this.isCachePresent();
            boolean hasVersion = versionFile.exists();
            if (!hasVersion && !present) {
                log.info("No version.dat and cache markers missing, downloading fresh cache.");
                this.update();
                return null;
            }
            if (!hasVersion) {
                log.info("Missing version.dat, downloading to align with remote version.");
                this.update();
                return null;
            }
            cacheVersionLocal = this.getLocalVersion();
            log.info("Cache version local=" + cacheVersionLocal + ", remote=" + cacheVersionRemote);
            if (cacheVersionLocal == cacheVersionRemote) {
                if (!present) {
                    log.warning("Version matches but markers missing. Skipping download. Adjust isCachePresent() to your ZIP layout or verify extracted files.");
                    return null;
                }
                return null;
            }
            log.info("Version mismatch, updating cache.");
            this.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.client.drawLoadingText(0, "Valoria - Cache download failed: " + e.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private int getLocalVersion() {
        int n;
        File vf = new File(Signlink.getCacheDirectory(), "version.dat");
        if (!vf.exists()) {
            return -1;
        }
        BufferedReader fr = new BufferedReader(new FileReader(vf));
        try {
            n = Integer.parseInt(fr.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1;
            }
        }
        fr.close();
        return n;
    }

    public void writeVersion(int version) {
        File versionFile = new File(Signlink.getCacheDirectory(), "version.dat");
        if (versionFile.exists()) {
            versionFile.delete();
        }
        try (BufferedWriter br = new BufferedWriter(new FileWriter(versionFile));){
            br.write(Integer.toString(version));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void ensureCacheDir() throws IOException {
        Path dir = Paths.get(Signlink.getCacheDirectory(), new String[0]);
        log.info("Cache directory = " + dir.toAbsolutePath());
        Files.createDirectories(dir, new FileAttribute[0]);
    }

    private void update() throws IOException {
        this.client.drawLoadingText(0, "Valoria - Downloading Cache 0%");
        this.downloadFile("https://valoria-rsps.com/rsps/.ValoriaCache.zip", this.getArchivedName());
        this.client.drawLoadingText(0, "Valoria - Installing Cache 0%");
        this.unZip();
        if (!this.isCachePresent()) {
            throw new IOException("Cache extracted but required files are missing \u00e2\u20ac\u201c wrong zip layout?");
        }
        this.writeVersion(cacheVersionRemote);
        this.deleteZip();
        this.client.drawLoadingText(100, "Valoria - Cache ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String address, String localFileName) throws IOException {
        this.ensureCacheDir();
        Path target = Paths.get(Signlink.getCacheDirectory(), localFileName);
        Path tmp = target.resolveSibling(localFileName + ".part");
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(address).openConnection();
            con.setConnectTimeout(15000);
            con.setReadTimeout(180000);
            con.setInstanceFollowRedirects(false);
            con.setRequestProperty("User-Agent", "Karmascape-Client/1.0");
            int code = con.getResponseCode();
            for (int redirects = 0; code / 100 == 3 && redirects < 5; ++redirects) {
                String loc = con.getHeaderField("Location");
                if (loc == null || loc.isEmpty()) {
                    throw new IOException("Redirect without Location");
                }
                con.disconnect();
                con = (HttpURLConnection)new URL(loc).openConnection();
                con.setConnectTimeout(15000);
                con.setReadTimeout(180000);
                con.setRequestProperty("User-Agent", "Karmascape-Client/1.0");
                code = con.getResponseCode();
            }
            if (code != 200) {
                InputStream err = con.getErrorStream();
                String msg = "HTTP " + code + " while downloading cache";
                if (err != null) {
                    try (InputStream inputStream2 = err;){
                        byte[] b = err.readAllBytes();
                        if (b.length > 0) {
                            msg = msg + ": " + new String(b);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new IOException(msg);
            }
            long contentLen = con.getContentLengthLong();
            long written = 0L;
            long start = System.currentTimeMillis();
            try (BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tmp, new OpenOption[0]));){
                int r;
                byte[] buf = new byte[0x100000];
                int lastPct = -1;
                while ((r = ((InputStream)in).read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, r);
                    int pct = contentLen > 0L ? (int)((written += (long)r) * 100L / contentLen) : (int)Math.min(99L, (System.currentTimeMillis() - start) / 500L % 100L);
                    if (pct == lastPct) continue;
                    lastPct = pct;
                    this.client.drawLoadingText(pct, "Valoria - Downloading Cache " + pct + "%");
                }
            }
            Files.move(tmp, target, StandardCopyOption.REPLACE_EXISTING);
            this.fileLocation = target;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private void unZip() throws IOException {
        Path zipPath = this.fileLocation != null ? this.fileLocation : Paths.get(Signlink.getCacheDirectory(), this.getArchivedName());
        String commonPrefix = null;
        try (ZipFile zip2 = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> it = zip2.entries();
            while (it.hasMoreElements()) {
                int slash;
                String firstSeg;
                ZipEntry ze = it.nextElement();
                if (ze.isDirectory()) continue;
                String name = ze.getName().replace('\\', '/');
                if (name.startsWith("./")) {
                    name = name.substring(2);
                }
                String string2 = firstSeg = (slash = name.indexOf(47)) > 0 ? name.substring(0, slash) : "";
                if (firstSeg.isEmpty()) {
                    commonPrefix = null;
                } else {
                    String candidate = firstSeg + "/";
                    if (commonPrefix == null) {
                        commonPrefix = candidate;
                        continue;
                    }
                    if (name.startsWith(commonPrefix)) continue;
                    commonPrefix = null;
                }
                break;
            }
        }
        zip2 = new ZipFile(zipPath.toFile());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipPath.toFile()));
             ZipInputStream zin = new ZipInputStream(in);){
            ZipEntry e;
            int files = CacheDownloader.countRegularFiles(zip2);
            int extracted = 0;
            while ((e = zin.getNextEntry()) != null) {
                if (e.isDirectory()) continue;
                int pct = files > 0 ? (int)((double)extracted * 100.0 / (double)files) : 0;
                this.client.drawLoadingText(pct, "Valoria - Installing Cache " + pct + "%");
                ++extracted;
                String name = e.getName().replace('\\', '/');
                if (name.startsWith("./")) {
                    name = name.substring(2);
                }
                if (commonPrefix != null && name.startsWith(commonPrefix)) {
                    name = name.substring(commonPrefix.length());
                }
                if (name.isEmpty()) continue;
                Path outPath = Paths.get(Signlink.getCacheDirectory(), new String[0]).resolve(name).normalize();
                if (!outPath.startsWith(Paths.get(Signlink.getCacheDirectory(), new String[0]).normalize())) {
                    throw new IOException("Blocked suspicious zip entry: " + e.getName());
                }
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(outPath, new OpenOption[0]));){
                    int r;
                    byte[] buf = new byte[65536];
                    while ((r = zin.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, r);
                    }
                }
            }
            this.client.drawLoadingText(100, "Valoria - Installing Cache 100%");
        }
        finally {
            zip2.close();
        }
    }

    public void deleteZip() {
        try {
            if (this.fileLocation != null) {
                Files.deleteIfExists(this.fileLocation);
            }
        }
        catch (IOException ex) {
            log.severe("Cannot delete cache zip file: " + ex.getMessage());
        }
    }

    private String getArchivedName() {
        String link = "https://valoria-rsps.com/rsps/.ValoriaCache.zip";
        int lastSlash = link.lastIndexOf(47);
        String name = lastSlash >= 0 && lastSlash < link.length() - 1 ? link.substring(lastSlash + 1) : "cache.zip";
        int q = name.indexOf(63);
        if (q > 0) {
            name = name.substring(0, q);
        }
        return name.isEmpty() ? "cache.zip" : name;
    }

    private static int countRegularFiles(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int numRegularFiles = 0;
        while (entries.hasMoreElements()) {
            if (entries.nextElement().isDirectory()) continue;
            ++numRegularFiles;
        }
        return numRegularFiles;
    }

    private boolean isCachePresent() {
        Path base = Paths.get(Signlink.getCacheDirectory(), new String[0]);
        boolean hasJaggrab = Files.exists(base.resolve("main_file_cache.dat2"), new LinkOption[0]) || Files.exists(base.resolve("main_file_cache.dat"), new LinkOption[0]) || Files.exists(base.resolve("main_file_cache.dat0"), new LinkOption[0]);
        boolean hasAnyIdx = Files.exists(base.resolve("idx0"), new LinkOption[0]) || Files.exists(base.resolve("idx1"), new LinkOption[0]) || Files.exists(base.resolve("indices/idx0"), new LinkOption[0]);
        boolean hasMediaArchive = Files.exists(base.resolve("media_archives/media_archive1.dat"), new LinkOption[0]) && Files.exists(base.resolve("media_archives/media_archive1.idx"), new LinkOption[0]);
        boolean hasEtcYaml = Files.exists(base.resolve("etc/item_definitions.yaml"), new LinkOption[0]) || Files.exists(base.resolve("etc/items.yaml"), new LinkOption[0]);
        return hasJaggrab && hasAnyIdx || hasMediaArchive && hasEtcYaml;
    }

    private void unzip(ZipInputStream zin, String s2) throws IOException {
        try (FileOutputStream out = new FileOutputStream(s2);){
            int len;
            byte[] b = new byte[1024];
            while ((len = zin.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
    }
}

