/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import java.io.IOException;
import java.io.RandomAccessFile;

public class Decompressor {
    public static final int INDEX_SIZE = 6;
    public static final int DATA_BLOCK_SIZE = 512;
    public static final int DATA_HEADER_SIZE = 8;
    public static final int DATA_SIZE = 520;
    private static final byte[] buffer = new byte[520];
    private final RandomAccessFile dataFile;
    private final RandomAccessFile indexFile;
    private final int fileType;

    public Decompressor(RandomAccessFile dataFile, RandomAccessFile indexFile, int fileTye) {
        this.fileType = fileTye;
        this.dataFile = dataFile;
        this.indexFile = indexFile;
    }

    public synchronized byte[] read(int fileId) {
        try {
            int read;
            this.seekTo(this.indexFile, fileId * 6);
            for (int offset = 0; offset < 6; offset += read) {
                read = this.indexFile.read(buffer, offset, 6 - offset);
                if (read != -1) continue;
                return null;
            }
            int fileSize = ((buffer[0] & 0xFF) << 16) + ((buffer[1] & 0xFF) << 8) + (buffer[2] & 0xFF);
            int sectorId = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
            if (sectorId <= 0 || (long)sectorId > this.dataFile.length() / 520L) {
                return null;
            }
            byte[] fileData = new byte[fileSize];
            int readerIndex = 0;
            int chunk = 0;
            while (readerIndex < fileSize) {
                if (sectorId == 0) {
                    return null;
                }
                this.seekTo(this.dataFile, sectorId * 520);
                int remaining = fileSize - readerIndex;
                if (remaining > 512) {
                    remaining = 512;
                }
                for (int offset = 0; offset < remaining + 8; offset += read) {
                    read = this.dataFile.read(buffer, offset, remaining + 8 - offset);
                    if (read != -1) continue;
                    return null;
                }
                int readFileId = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                int readChunkId = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                int readSectorId = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                int readTypeId = buffer[7] & 0xFF;
                if (readFileId != fileId || readChunkId != chunk || readTypeId != this.fileType) {
                    return null;
                }
                if (readSectorId < 0 || (long)readSectorId > this.dataFile.length() / 520L) {
                    return null;
                }
                for (int dataReaderIndex = 0; dataReaderIndex < remaining; ++dataReaderIndex) {
                    fileData[readerIndex++] = buffer[dataReaderIndex + 8];
                }
                sectorId = readSectorId;
                ++chunk;
            }
            return fileData;
        }
        catch (IOException _ex) {
            _ex.printStackTrace();
            return null;
        }
    }

    public synchronized boolean write(int fileSize, byte[] data2, int fileId) {
        boolean flag = this.write(true, fileId, fileSize, data2);
        if (!flag) {
            flag = this.write(false, fileId, fileSize, data2);
        }
        return flag;
    }

    public synchronized boolean write(boolean overwrite, int fileId, int fileSize, byte[] data2) {
        try {
            int firstSectorId;
            if (overwrite) {
                int read;
                this.seekTo(this.indexFile, fileId * 6);
                for (int offset = 0; offset < 6; offset += read) {
                    read = this.indexFile.read(buffer, offset, 6 - offset);
                    if (read != -1) continue;
                    return false;
                }
                firstSectorId = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                if (firstSectorId <= 0 || (long)firstSectorId > this.dataFile.length() / 520L) {
                    return false;
                }
            } else {
                firstSectorId = (int)((this.dataFile.length() + 519L) / 520L);
                if (firstSectorId == 0) {
                    firstSectorId = 1;
                }
            }
            Decompressor.buffer[0] = (byte)(fileSize >> 16);
            Decompressor.buffer[1] = (byte)(fileSize >> 8);
            Decompressor.buffer[2] = (byte)fileSize;
            Decompressor.buffer[3] = (byte)(firstSectorId >> 16);
            Decompressor.buffer[4] = (byte)(firstSectorId >> 8);
            Decompressor.buffer[5] = (byte)firstSectorId;
            this.seekTo(this.indexFile, fileId * 6);
            this.indexFile.write(buffer, 0, 6);
            int j1 = 0;
            int chunkId = 0;
            while (j1 < fileSize) {
                int currentSectorId = 0;
                if (overwrite) {
                    int length;
                    int read;
                    this.seekTo(this.dataFile, firstSectorId * 520);
                    for (length = 0; length < 8 && (read = this.dataFile.read(buffer, length, 8 - length)) != -1; length += read) {
                    }
                    if (length == 8) {
                        int storedFileId = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                        int storedChunkId = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                        currentSectorId = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                        int storedFileType = buffer[7] & 0xFF;
                        if (storedFileId != fileId || storedChunkId != chunkId || storedFileType != this.fileType) {
                            return false;
                        }
                        if (currentSectorId < 0 || (long)currentSectorId > this.dataFile.length() / 520L) {
                            return false;
                        }
                    }
                }
                if (currentSectorId == 0) {
                    overwrite = false;
                    currentSectorId = (int)((this.dataFile.length() + 519L) / 520L);
                    if (currentSectorId == 0) {
                        ++currentSectorId;
                    }
                    if (currentSectorId == firstSectorId) {
                        ++currentSectorId;
                    }
                }
                if (fileSize - j1 <= 512) {
                    currentSectorId = 0;
                }
                Decompressor.buffer[0] = (byte)(fileId >> 8);
                Decompressor.buffer[1] = (byte)fileId;
                Decompressor.buffer[2] = (byte)(chunkId >> 8);
                Decompressor.buffer[3] = (byte)chunkId;
                Decompressor.buffer[4] = (byte)(currentSectorId >> 16);
                Decompressor.buffer[5] = (byte)(currentSectorId >> 8);
                Decompressor.buffer[6] = (byte)currentSectorId;
                Decompressor.buffer[7] = (byte)this.fileType;
                this.seekTo(this.dataFile, firstSectorId * 520);
                this.dataFile.write(buffer, 0, 8);
                int k2 = fileSize - j1;
                if (k2 > 512) {
                    k2 = 512;
                }
                this.dataFile.write(data2, j1, k2);
                j1 += k2;
                firstSectorId = currentSectorId;
                ++chunkId;
            }
            return true;
        }
        catch (IOException _ex) {
            _ex.printStackTrace();
            return false;
        }
    }

    private synchronized void seekTo(RandomAccessFile randomaccessfile, int j) {
        try {
            randomaccessfile.seek(j);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

