/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Model;
import com.client.Renderable;
import com.client.definitions.ItemDefinition;
import net.runelite.api.Tile;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.rs.api.RSTile;
import net.runelite.rs.api.RSTileItem;

final class Item
extends Renderable
implements RSTileItem {
    public int ID;
    public int x;
    public int y;
    public int itemCount;

    @Override
    public final Model getRotatedModel() {
        ItemDefinition itemDef = ItemDefinition.lookup(this.ID);
        return itemDef.getModel(this.itemCount);
    }

    @Override
    public int getSpawnTime() {
        return 0;
    }

    @Override
    public int getId() {
        return this.ID;
    }

    @Override
    public void setId(int id) {
        this.ID = id;
    }

    @Override
    public int getQuantity() {
        return this.itemCount;
    }

    @Override
    public void setQuantity(int quantity) {
        this.itemCount = quantity;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public Tile getTile() {
        if (this.x == -1 || this.y == -1) {
            return null;
        }
        RSTile[][][] tiles = Client.instance.getScene().getTiles();
        return tiles[Client.instance.getPlane()][this.x][this.y];
    }

    public void quantityChanged(int quantity) {
        Client.instance.getLogger().debug("Item quantity changed: {} ({} -> {})", this.getId(), this.getQuantity(), quantity);
        ItemQuantityChanged itemQuantityChanged = new ItemQuantityChanged(this, this.getTile(), this.getQuantity(), quantity);
        Client.instance.getCallbacks().post(itemQuantityChanged);
    }
}

