/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import com.client.Client;
import com.client.CollisionMap;
import com.client.Model;
import com.client.Rasterizer3D;
import com.client.Renderable;
import com.client.SceneGraph;
import com.client.SceneObject;
import com.client.definitions.FloorDefinition;
import com.client.definitions.ObjectDefinition;
import com.client.utilities.ChunkUtil;
import com.client.utilities.ObjectKeyUtil;

public final class MapRegion {
    private final int[] hues;
    private final int[] saturations;
    private final int[] luminances;
    private final int[] chromas;
    private final int[] anIntArray128;
    private final int[][][] tileHeights;
    public short[][][] overlays;
    public static int anInt131;
    private final byte[][][] shading;
    private final int[][][] anIntArrayArrayArray135;
    public byte[][][] overlayTypes;
    private static final int[] COSINE_VERTICES;
    private final int[][] tileLighting;
    private static final int[] anIntArray140;
    public short[][][] underlays;
    private static final int[] SINE_VERTICIES;
    public static int maximumPlane;
    private final int regionSizeX;
    private final int regionSizeY;
    private final byte[][][] overlayOrientations;
    private final byte[][][] tileFlags;
    public static boolean lowMem;
    private static final int[] anIntArray152;
    private static final int BLOCKED_TILE = 1;
    public static final int BRIDGE_TILE = 2;
    private static final int FORCE_LOWEST_PLANE = 8;

    public MapRegion(byte[][][] fileFlags, int[][][] tileHeights) {
        maximumPlane = 99;
        this.regionSizeX = 104;
        this.regionSizeY = 104;
        this.tileHeights = tileHeights;
        this.tileFlags = fileFlags;
        this.underlays = new short[4][this.regionSizeX][this.regionSizeY];
        this.overlays = new short[4][this.regionSizeX][this.regionSizeY];
        this.overlayTypes = new byte[4][this.regionSizeX][this.regionSizeY];
        this.overlayOrientations = new byte[4][this.regionSizeX][this.regionSizeY];
        this.anIntArrayArrayArray135 = new int[4][this.regionSizeX + 1][this.regionSizeY + 1];
        this.shading = new byte[4][this.regionSizeX + 1][this.regionSizeY + 1];
        this.tileLighting = new int[this.regionSizeX + 1][this.regionSizeY + 1];
        this.hues = new int[this.regionSizeY];
        this.saturations = new int[this.regionSizeY];
        this.luminances = new int[this.regionSizeY];
        this.chromas = new int[this.regionSizeY];
        this.anIntArray128 = new int[this.regionSizeY];
    }

    private static int calculateNoise(int x, int y) {
        int k = x + y * 57;
        k = k << 13 ^ k;
        int l = k * (k * k * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return l >> 19 & 0xFF;
    }

    public final void createRegionScene(CollisionMap[] maps, SceneGraph scene) {
        try {
            for (int z = 0; z < 4; ++z) {
                for (int x = 0; x < 104; ++x) {
                    for (int y = 0; y < 104; ++y) {
                        if ((this.tileFlags[z][x][y] & 1) != 1) continue;
                        int plane = z;
                        if ((this.tileFlags[1][x][y] & 2) == 2) {
                            --plane;
                        }
                        if (plane < 0) continue;
                        maps[plane].block(x, y);
                    }
                }
            }
            int mapLight = Client.instance.isHdMinimapEnabled() ? 52 : 96;
            for (int z = 0; z < 4; ++z) {
                byte[][] shading = this.shading[z];
                int diffusion = 768;
                int lightX = -50;
                int lightY = -10;
                int lightZ = -50;
                int light = (int)Math.sqrt(lightX * lightX + lightY * lightY + lightZ * lightZ);
                int l3 = diffusion * light >> 8;
                for (int j4 = 1; j4 < this.regionSizeY - 1; ++j4) {
                    for (int j5 = 1; j5 < this.regionSizeX - 1; ++j5) {
                        int k6 = this.tileHeights[z][j5 + 1][j4] - this.tileHeights[z][j5 - 1][j4];
                        int l7 = this.tileHeights[z][j5][j4 + 1] - this.tileHeights[z][j5][j4 - 1];
                        int j9 = (int)Math.sqrt(k6 * k6 + 65536 + l7 * l7);
                        int k12 = (k6 << 8) / j9;
                        int l13 = 65536 / j9;
                        int j15 = (l7 << 8) / j9;
                        int j16 = 96 + (lightX * k12 + lightY * l13 + lightZ * j15) / l3;
                        int j17 = (shading[j5 - 1][j4] >> 2) + (shading[j5 + 1][j4] >> 3) + (shading[j5][j4 - 1] >> 2) + (shading[j5][j4 + 1] >> 3) + (shading[j5][j4] >> 1);
                        this.tileLighting[j5][j4] = j16 - j17;
                    }
                }
                for (int k5 = 0; k5 < this.regionSizeY; ++k5) {
                    this.hues[k5] = 0;
                    this.saturations[k5] = 0;
                    this.luminances[k5] = 0;
                    this.chromas[k5] = 0;
                    this.anIntArray128[k5] = 0;
                }
                for (int l6 = -5; l6 < this.regionSizeX + 5; ++l6) {
                    for (int i8 = 0; i8 < this.regionSizeY; ++i8) {
                        int i14;
                        int i13;
                        int l12;
                        int k9 = l6 + 5;
                        if (k9 >= 0 && k9 < this.regionSizeX && (l12 = this.underlays[z][k9][i8] & 0xFF) > 0) {
                            if (l12 > FloorDefinition.underlays.length) {
                                l12 = FloorDefinition.underlays.length;
                            }
                            FloorDefinition flo = FloorDefinition.underlays[l12 - 1];
                            int n = i8;
                            this.hues[n] = this.hues[n] + flo.blendHue;
                            int n2 = i8;
                            this.saturations[n2] = this.saturations[n2] + flo.saturation;
                            int n3 = i8;
                            this.luminances[n3] = this.luminances[n3] + flo.luminance;
                            int n4 = i8;
                            this.chromas[n4] = this.chromas[n4] + flo.blendHueMultiplier;
                            int n5 = i8;
                            this.anIntArray128[n5] = this.anIntArray128[n5] + 1;
                        }
                        if ((i13 = l6 - 5) < 0 || i13 >= this.regionSizeX || (i14 = this.underlays[z][i13][i8] & 0xFF) <= 0) continue;
                        FloorDefinition flo_1 = FloorDefinition.underlays[i14 - 1];
                        int n = i8;
                        this.hues[n] = this.hues[n] - flo_1.blendHue;
                        int n6 = i8;
                        this.saturations[n6] = this.saturations[n6] - flo_1.saturation;
                        int n7 = i8;
                        this.luminances[n7] = this.luminances[n7] - flo_1.luminance;
                        int n8 = i8;
                        this.chromas[n8] = this.chromas[n8] - flo_1.blendHueMultiplier;
                        int n9 = i8;
                        this.anIntArray128[n9] = this.anIntArray128[n9] - 1;
                    }
                    if (l6 < 1 || l6 >= this.regionSizeX - 1) continue;
                    int l9 = 0;
                    int j13 = 0;
                    int j14 = 0;
                    int k15 = 0;
                    int k16 = 0;
                    for (int k17 = -5; k17 < this.regionSizeY + 5; ++k17) {
                        int lightness;
                        int encodedMinimap;
                        int encodedTile;
                        int minimapColor;
                        int k18;
                        int j18 = k17 + 5;
                        if (j18 >= 0 && j18 < this.regionSizeY) {
                            l9 += this.hues[j18];
                            j13 += this.saturations[j18];
                            j14 += this.luminances[j18];
                            k15 += this.chromas[j18];
                            k16 += this.anIntArray128[j18];
                        }
                        if ((k18 = k17 - 5) >= 0 && k18 < this.regionSizeY) {
                            l9 -= this.hues[k18];
                            j13 -= this.saturations[k18];
                            j14 -= this.luminances[k18];
                            k15 -= this.chromas[k18];
                            k16 -= this.anIntArray128[k18];
                        }
                        if (k17 < 1 || k17 >= this.regionSizeY - 1 || lowMem && (this.tileFlags[0][l6][k17] & 2) == 0 && ((this.tileFlags[z][l6][k17] & 0x10) != 0 || this.getCollisionPlane(k17, z, l6) != anInt131)) continue;
                        if (z < maximumPlane) {
                            maximumPlane = z;
                        }
                        int l18 = this.underlays[z][l6][k17] & 0xFF;
                        int i19 = this.overlays[z][l6][k17] & 0xFF;
                        if (l18 <= 0 && i19 <= 0) continue;
                        int j19 = this.tileHeights[z][l6][k17];
                        int k19 = this.tileHeights[z][l6 + 1][k17];
                        int l19 = this.tileHeights[z][l6 + 1][k17 + 1];
                        int i20 = this.tileHeights[z][l6][k17 + 1];
                        int j20 = this.tileLighting[l6][k17];
                        int k20 = this.tileLighting[l6 + 1][k17];
                        int l20 = this.tileLighting[l6 + 1][k17 + 1];
                        int i21 = this.tileLighting[l6][k17 + 1];
                        int j21 = -1;
                        int k21 = -1;
                        if (l18 > 0) {
                            int l21 = l9 * 256 / k15;
                            int j22 = j13 / k16;
                            int l22 = j14 / k16;
                            j21 = this.encode(l21, j22, l22);
                            if (l22 < 0) {
                                l22 = 0;
                            } else if (l22 > 255) {
                                l22 = 255;
                            }
                            k21 = this.encode(l21, j22, l22);
                        }
                        if (z > 0) {
                            boolean flag = true;
                            if (l18 == 0 && this.overlayTypes[z][l6][k17] != 0) {
                                flag = false;
                            }
                            if (i19 > 0 && !FloorDefinition.overlays[i19 - 1].hideUnderlay) {
                                flag = false;
                            }
                            if (flag && j19 == k19 && j19 == l19 && j19 == i20) {
                                int[] nArray = this.anIntArrayArrayArray135[z][l6];
                                int n = k17;
                                nArray[n] = nArray[n] | 0x924;
                            }
                        }
                        int i22 = 0;
                        if (j21 != -1) {
                            i22 = Rasterizer3D.hslToRgb[MapRegion.method187(k21, mapLight)];
                        }
                        if (i19 == 0) {
                            scene.addTile(z, l6, k17, 0, 0, -1, j19, k19, l19, i20, MapRegion.method187(j21, j20), MapRegion.method187(j21, k20), MapRegion.method187(j21, l20), MapRegion.method187(j21, i21), 0, 0, 0, 0, i22, 0);
                            continue;
                        }
                        int k22 = this.overlayTypes[z][l6][k17] + 1;
                        byte byte4 = this.overlayOrientations[z][l6][k17];
                        if (i19 - 1 > FloorDefinition.overlays.length) {
                            i19 = FloorDefinition.overlays.length;
                        }
                        FloorDefinition overlay_flo = FloorDefinition.overlays[i19 - 1];
                        int texture = overlay_flo.texture;
                        if (texture >= 0) {
                            minimapColor = Rasterizer3D.textureLoader.getAverageTextureRGB(texture);
                            encodedTile = -1;
                        } else if (overlay_flo.rgb == 0xFF00FF) {
                            encodedTile = -2;
                            texture = -1;
                            minimapColor = -2;
                        } else {
                            encodedTile = this.encode(overlay_flo.hue, overlay_flo.saturation, overlay_flo.lightness);
                            encodedMinimap = overlay_flo.hue;
                            lightness = overlay_flo.lightness;
                            if (lightness < 0) {
                                lightness = 0;
                            } else if (lightness > 255) {
                                lightness = 255;
                            }
                            minimapColor = this.encode(encodedMinimap, overlay_flo.saturation, lightness);
                        }
                        encodedMinimap = 0;
                        if (minimapColor != -2) {
                            encodedMinimap = Rasterizer3D.hslToRgb[this.checkedLight(minimapColor, 96)];
                        }
                        if (overlay_flo.secondaryRgb != -1) {
                            lightness = overlay_flo.secondaryHue;
                            int secondaryLightness = overlay_flo.secondaryLightness;
                            if (secondaryLightness < 0) {
                                secondaryLightness = 0;
                            } else if (secondaryLightness > 255) {
                                secondaryLightness = 255;
                            }
                            minimapColor = this.encode(lightness, overlay_flo.secondarySaturation, secondaryLightness);
                            encodedMinimap = Rasterizer3D.hslToRgb[this.checkedLight(minimapColor, 96)];
                        }
                        scene.addTile(z, l6, k17, k22, byte4, texture, j19, k19, l19, i20, MapRegion.method187(j21, j20), MapRegion.method187(j21, k20), MapRegion.method187(j21, l20), MapRegion.method187(j21, i21), this.checkedLight(encodedTile, j20), this.checkedLight(encodedTile, k20), this.checkedLight(encodedTile, l20), this.checkedLight(encodedTile, i21), i22, encodedMinimap);
                    }
                }
                for (int j8 = 1; j8 < this.regionSizeY - 1; ++j8) {
                    for (int i10 = 1; i10 < this.regionSizeX - 1; ++i10) {
                        scene.setTileLogicHeight(z, i10, j8, this.getCollisionPlane(j8, z, i10));
                    }
                }
            }
            scene.shadeModels(-10, -50, -50);
            for (int j1 = 0; j1 < this.regionSizeX; ++j1) {
                for (int l1 = 0; l1 < this.regionSizeY; ++l1) {
                    if ((this.tileFlags[1][j1][l1] & 2) != 2) continue;
                    scene.applyBridgeMode(l1, j1);
                }
            }
            int i2 = 1;
            int j2 = 2;
            int k2 = 4;
            for (int l2 = 0; l2 < 4; ++l2) {
                if (l2 > 0) {
                    i2 <<= 3;
                    j2 <<= 3;
                    k2 <<= 3;
                }
                for (int i3 = 0; i3 <= l2; ++i3) {
                    for (int k3 = 0; k3 <= this.regionSizeY; ++k3) {
                        for (int i4 = 0; i4 <= this.regionSizeX; ++i4) {
                            int k7;
                            if ((this.anIntArrayArrayArray135[i3][i4][k3] & i2) != 0) {
                                int l10;
                                int k4;
                                int l5 = k3;
                                int i7 = i3;
                                int k8 = i3;
                                for (k4 = k3; k4 > 0 && (this.anIntArrayArrayArray135[i3][i4][k4 - 1] & i2) != 0; --k4) {
                                }
                                while (l5 < this.regionSizeY && (this.anIntArrayArrayArray135[i3][i4][l5 + 1] & i2) != 0) {
                                    ++l5;
                                }
                                block22: while (i7 > 0) {
                                    for (int j10 = k4; j10 <= l5; ++j10) {
                                        if ((this.anIntArrayArrayArray135[i7 - 1][i4][j10] & i2) == 0) break block22;
                                    }
                                    --i7;
                                }
                                block24: while (k8 < l2) {
                                    for (int k10 = k4; k10 <= l5; ++k10) {
                                        if ((this.anIntArrayArrayArray135[k8 + 1][i4][k10] & i2) == 0) break block24;
                                    }
                                    ++k8;
                                }
                                if ((l10 = (k8 + 1 - i7) * (l5 - k4 + 1)) >= 8) {
                                    int c1 = 240;
                                    int k14 = this.tileHeights[k8][i4][k4] - c1;
                                    int l15 = this.tileHeights[i7][i4][k4];
                                    SceneGraph.createNewSceneCluster(l2, i4 * 128, l15, i4 * 128, l5 * 128 + 128, k14, k4 * 128, 1);
                                    for (int l16 = i7; l16 <= k8; ++l16) {
                                        int l17 = k4;
                                        while (l17 <= l5) {
                                            int[] nArray = this.anIntArrayArrayArray135[l16][i4];
                                            int n = l17++;
                                            nArray[n] = nArray[n] & ~i2;
                                        }
                                    }
                                }
                            }
                            if ((this.anIntArrayArrayArray135[i3][i4][k3] & j2) != 0) {
                                int k11;
                                int l4;
                                int i6 = i4;
                                int j7 = i3;
                                int l8 = i3;
                                for (l4 = i4; l4 > 0 && (this.anIntArrayArrayArray135[i3][l4 - 1][k3] & j2) != 0; --l4) {
                                }
                                while (i6 < this.regionSizeX && (this.anIntArrayArrayArray135[i3][i6 + 1][k3] & j2) != 0) {
                                    ++i6;
                                }
                                block30: while (j7 > 0) {
                                    for (int i11 = l4; i11 <= i6; ++i11) {
                                        if ((this.anIntArrayArrayArray135[j7 - 1][i11][k3] & j2) == 0) break block30;
                                    }
                                    --j7;
                                }
                                block32: while (l8 < l2) {
                                    for (int j11 = l4; j11 <= i6; ++j11) {
                                        if ((this.anIntArrayArrayArray135[l8 + 1][j11][k3] & j2) == 0) break block32;
                                    }
                                    ++l8;
                                }
                                if ((k11 = (l8 + 1 - j7) * (i6 - l4 + 1)) >= 8) {
                                    int c2 = 240;
                                    int l14 = this.tileHeights[l8][l4][k3] - c2;
                                    int i16 = this.tileHeights[j7][l4][k3];
                                    SceneGraph.createNewSceneCluster(l2, l4 * 128, i16, i6 * 128 + 128, k3 * 128, l14, k3 * 128, 2);
                                    for (int i17 = j7; i17 <= l8; ++i17) {
                                        for (int i18 = l4; i18 <= i6; ++i18) {
                                            int[] nArray = this.anIntArrayArrayArray135[i17][i18];
                                            int n = k3;
                                            nArray[n] = nArray[n] & ~j2;
                                        }
                                    }
                                }
                            }
                            if ((this.anIntArrayArrayArray135[i3][i4][k3] & k2) == 0) continue;
                            int i5 = i4;
                            int j6 = i4;
                            int i9 = k3;
                            for (k7 = k3; k7 > 0 && (this.anIntArrayArrayArray135[i3][i4][k7 - 1] & k2) != 0; --k7) {
                            }
                            while (i9 < this.regionSizeY && (this.anIntArrayArrayArray135[i3][i4][i9 + 1] & k2) != 0) {
                                ++i9;
                            }
                            block38: while (i5 > 0) {
                                for (int l11 = k7; l11 <= i9; ++l11) {
                                    if ((this.anIntArrayArrayArray135[i3][i5 - 1][l11] & k2) == 0) break block38;
                                }
                                --i5;
                            }
                            block40: while (j6 < this.regionSizeX) {
                                for (int i12 = k7; i12 <= i9; ++i12) {
                                    if ((this.anIntArrayArrayArray135[i3][j6 + 1][i12] & k2) == 0) break block40;
                                }
                                ++j6;
                            }
                            if ((j6 - i5 + 1) * (i9 - k7 + 1) < 4) continue;
                            int j12 = this.tileHeights[i3][i5][k7];
                            SceneGraph.createNewSceneCluster(l2, i5 * 128, j12, j6 * 128 + 128, i9 * 128 + 128, j12, k7 * 128, 4);
                            for (int k13 = i5; k13 <= j6; ++k13) {
                                int i15 = k7;
                                while (i15 <= i9) {
                                    int[] nArray = this.anIntArrayArrayArray135[i3][k13];
                                    int n = i15++;
                                    nArray[n] = nArray[n] & ~k2;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int calculateVertexHeight(int i, int j) {
        int mapHeight = MapRegion.interpolatedNoise(i + 45365, j + 91923, 4) - 128 + (MapRegion.interpolatedNoise(i + 10294, j + 37821, 2) - 128 >> 1) + (MapRegion.interpolatedNoise(i, j, 1) - 128 >> 2);
        if ((mapHeight = (int)((double)mapHeight * 0.3) + 35) < 10) {
            mapHeight = 10;
        } else if (mapHeight > 60) {
            mapHeight = 60;
        }
        return mapHeight;
    }

    public final void initiateVertexHeights(int yOffset, int yLength, int xLength, int xOffset) {
        for (int y = yOffset; y <= yOffset + yLength; ++y) {
            for (int x = xOffset; x <= xOffset + xLength; ++x) {
                if (x < 0 || x >= this.regionSizeX || y < 0 || y >= this.regionSizeY) continue;
                this.shading[0][x][y] = 127;
                if (x == xOffset && x > 0) {
                    this.tileHeights[0][x][y] = this.tileHeights[0][x - 1][y];
                }
                if (x == xOffset + xLength && x < this.regionSizeX - 1) {
                    this.tileHeights[0][x][y] = this.tileHeights[0][x + 1][y];
                }
                if (y == yOffset && y > 0) {
                    this.tileHeights[0][x][y] = this.tileHeights[0][x][y - 1];
                }
                if (y != yOffset + yLength || y >= this.regionSizeY - 1) continue;
                this.tileHeights[0][x][y] = this.tileHeights[0][x][y + 1];
            }
        }
    }

    private void renderObject(int y, SceneGraph scene, CollisionMap class11, int type2, int z, int x, int id, int rotation) {
        int sizeX;
        if (lowMem && (this.tileFlags[0][x][y] & 2) == 0) {
            if ((this.tileFlags[z][x][y] & 0x10) != 0) {
                return;
            }
            if (this.getCollisionPlane(y, z, x) != anInt131) {
                return;
            }
        }
        if (z < maximumPlane) {
            maximumPlane = z;
        }
        int mX = Client.instance.currentRegionX - 6;
        int mY = Client.instance.currentRegionY - 6;
        int actualX = mX * 8 + x;
        int actualY = mY * 8 + y;
        int actualH = z;
        ObjectDefinition definition = ObjectDefinition.lookup(id);
        boolean flag = rotation == 1 || rotation == 3;
        int sizeY = flag ? definition.sizeY : definition.sizeX;
        int n = sizeX = flag ? definition.sizeX : definition.sizeY;
        if (actualH == 0) {
            // empty if block
        }
        flag = 104 >= sizeY + x;
        int modX = flag ? x + (sizeY >> 1) : x;
        int modX1 = flag ? x + (sizeY + 1 >> 1) : x + 1;
        flag = 104 >= sizeX + y;
        int modY = flag ? (sizeX >> 1) + y : y;
        int modY1 = flag ? y + (sizeX + 1 >> 1) : y + 1;
        int center = this.tileHeights[z][modX][modY];
        int east = this.tileHeights[z][modX1][modY];
        int northEast = this.tileHeights[z][modX1][modY1];
        int north = this.tileHeights[z][modX][modY1];
        int mean = center + east + northEast + north >> 2;
        long key = (long)rotation << 20 | (long)type2 << 14 | ((long)y << 7 | (long)x) + 0x40000000L;
        if (!definition.isInteractive) {
            key |= Long.MIN_VALUE;
        }
        if (definition.supportItems == 1) {
            key |= 0x400000L;
        }
        key |= (long)id << 32;
        byte config = (byte)((rotation << 6) + type2);
        if (type2 == 22) {
            if (lowMem && !definition.isInteractive && !definition.obstructsGround) {
                return;
            }
            Renderable obj2 = definition.animation == -1 && definition.configs == null ? definition.modelAt(22, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, 22, east, northEast, center, north, definition.animation, true);
            scene.addGroundDecoration(z, mean, y, obj2, config, key, x);
            if (definition.interactType && definition.isInteractive && class11 != null) {
                class11.block(x, y);
            }
            return;
        }
        if (type2 == 10 || type2 == 11) {
            Renderable obj1 = definition.animation == -1 && definition.configs == null ? definition.modelAt(10, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, 10, east, northEast, center, north, definition.animation, true);
            if (obj1 != null) {
                Renderable model;
                int l4;
                int j4;
                int i5 = 0;
                if (type2 == 11) {
                    i5 += 256;
                }
                if (rotation == 1 || rotation == 3) {
                    j4 = definition.sizeY;
                    l4 = definition.sizeX;
                } else {
                    j4 = definition.sizeX;
                    l4 = definition.sizeY;
                }
                if (scene.addTiledObject(key, config, mean, l4, obj1, j4, z, i5, y, x) && definition.castsShadow && (model = obj1 instanceof Model ? obj1 : definition.modelAt(10, rotation, center, east, northEast, north, -1)) != null) {
                    for (int j5 = 0; j5 <= j4; ++j5) {
                        for (int k5 = 0; k5 <= l4; ++k5) {
                            int l5 = model.diagonal2DAboveOrigin / 4;
                            if (l5 > 30) {
                                l5 = 30;
                            }
                            if (l5 <= this.shading[z][x + j5][y + k5]) continue;
                            this.shading[z][x + j5][y + k5] = (byte)l5;
                        }
                    }
                }
            }
            if (definition.interactType && class11 != null) {
                class11.method212(definition.blocksProjectile, definition.sizeX, definition.sizeY, x, y, rotation);
            }
            return;
        }
        if (type2 >= 12) {
            Renderable obj2 = definition.animation == -1 && definition.configs == null ? definition.modelAt(type2, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, type2, east, northEast, center, north, definition.animation, true);
            scene.addTiledObject(key, config, mean, 1, obj2, 1, z, 0, y, x);
            if (type2 <= 17 && type2 != 13 && z > 0) {
                int[] nArray = this.anIntArrayArrayArray135[z][x];
                int n2 = y;
                nArray[n2] = nArray[n2] | 0x924;
            }
            if (definition.interactType && class11 != null) {
                class11.method212(definition.blocksProjectile, definition.sizeX, definition.sizeY, x, y, rotation);
            }
            return;
        }
        if (type2 == 0) {
            Renderable obj3 = definition.animation == -1 && definition.configs == null ? definition.modelAt(0, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, 0, east, northEast, center, north, definition.animation, true);
            scene.addWallObject(anIntArray152[rotation], obj3, key, y, config, x, null, mean, 0, z);
            if (rotation == 0) {
                if (definition.castsShadow) {
                    this.shading[z][x][y] = 50;
                    this.shading[z][x][y + 1] = 50;
                }
                if (definition.occludes) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x];
                    int n3 = y;
                    nArray[n3] = nArray[n3] | 0x249;
                }
            } else if (rotation == 1) {
                if (definition.castsShadow) {
                    this.shading[z][x][y + 1] = 50;
                    this.shading[z][x + 1][y + 1] = 50;
                }
                if (definition.occludes) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x];
                    int n4 = y + 1;
                    nArray[n4] = nArray[n4] | 0x492;
                }
            } else if (rotation == 2) {
                if (definition.castsShadow) {
                    this.shading[z][x + 1][y] = 50;
                    this.shading[z][x + 1][y + 1] = 50;
                }
                if (definition.occludes) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x + 1];
                    int n5 = y;
                    nArray[n5] = nArray[n5] | 0x249;
                }
            } else {
                if (definition.castsShadow) {
                    this.shading[z][x][y] = 50;
                    this.shading[z][x + 1][y] = 50;
                }
                if (definition.occludes) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x];
                    int n6 = y;
                    nArray[n6] = nArray[n6] | 0x492;
                }
            }
            if (definition.interactType && class11 != null) {
                class11.method211(y, rotation, x, type2, definition.blocksProjectile);
            }
            if (definition.decorDisplacement != 16) {
                scene.method290(y, definition.decorDisplacement, x, z);
            }
            return;
        }
        if (type2 == 1) {
            Renderable obj4 = definition.animation == -1 && definition.configs == null ? definition.modelAt(1, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, 1, east, northEast, center, north, definition.animation, true);
            scene.addWallObject(anIntArray140[rotation], obj4, key, y, config, x, null, mean, 0, z);
            if (definition.castsShadow) {
                if (rotation == 0) {
                    this.shading[z][x][y + 1] = 50;
                } else if (rotation == 1) {
                    this.shading[z][x + 1][y + 1] = 50;
                } else if (rotation == 2) {
                    this.shading[z][x + 1][y] = 50;
                } else {
                    this.shading[z][x][y] = 50;
                }
            }
            if (definition.interactType && class11 != null) {
                class11.method211(y, rotation, x, type2, definition.blocksProjectile);
            }
            return;
        }
        if (type2 == 2) {
            Renderable obj12;
            Renderable obj11;
            int i3 = rotation + 1 & 3;
            if (definition.animation == -1 && definition.configs == null) {
                obj11 = definition.modelAt(2, 4 + rotation, center, east, northEast, north, -1);
                obj12 = definition.modelAt(2, i3, center, east, northEast, north, -1);
            } else {
                obj11 = new SceneObject(id, 4 + rotation, 2, east, northEast, center, north, definition.animation, true);
                obj12 = new SceneObject(id, i3, 2, east, northEast, center, north, definition.animation, true);
            }
            scene.addWallObject(anIntArray152[rotation], obj11, key, y, config, x, obj12, mean, anIntArray152[i3], z);
            if (definition.occludes) {
                if (rotation == 0) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x];
                    int n7 = y;
                    nArray[n7] = nArray[n7] | 0x249;
                    int[] nArray2 = this.anIntArrayArrayArray135[z][x];
                    int n8 = y + 1;
                    nArray2[n8] = nArray2[n8] | 0x492;
                } else if (rotation == 1) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x];
                    int n9 = y + 1;
                    nArray[n9] = nArray[n9] | 0x492;
                    int[] nArray3 = this.anIntArrayArrayArray135[z][x + 1];
                    int n10 = y;
                    nArray3[n10] = nArray3[n10] | 0x249;
                } else if (rotation == 2) {
                    int[] nArray = this.anIntArrayArrayArray135[z][x + 1];
                    int n11 = y;
                    nArray[n11] = nArray[n11] | 0x249;
                    int[] nArray4 = this.anIntArrayArrayArray135[z][x];
                    int n12 = y;
                    nArray4[n12] = nArray4[n12] | 0x492;
                } else {
                    int[] nArray = this.anIntArrayArrayArray135[z][x];
                    int n13 = y;
                    nArray[n13] = nArray[n13] | 0x492;
                    int[] nArray5 = this.anIntArrayArrayArray135[z][x];
                    int n14 = y;
                    nArray5[n14] = nArray5[n14] | 0x249;
                }
            }
            if (definition.interactType && class11 != null) {
                class11.method211(y, rotation, x, type2, definition.blocksProjectile);
            }
            if (definition.decorDisplacement != 16) {
                scene.method290(y, definition.decorDisplacement, x, z);
            }
            return;
        }
        if (type2 == 3) {
            Renderable obj5 = definition.animation == -1 && definition.configs == null ? definition.modelAt(3, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, 3, east, northEast, center, north, definition.animation, true);
            scene.addWallObject(anIntArray140[rotation], obj5, key, y, config, x, null, mean, 0, z);
            if (definition.castsShadow) {
                if (rotation == 0) {
                    this.shading[z][x][y + 1] = 50;
                } else if (rotation == 1) {
                    this.shading[z][x + 1][y + 1] = 50;
                } else if (rotation == 2) {
                    this.shading[z][x + 1][y] = 50;
                } else {
                    this.shading[z][x][y] = 50;
                }
            }
            if (definition.interactType && class11 != null) {
                class11.method211(y, rotation, x, type2, definition.blocksProjectile);
            }
            return;
        }
        if (type2 == 9) {
            Renderable obj6 = definition.animation == -1 && definition.configs == null ? definition.modelAt(type2, rotation, center, east, northEast, north, -1) : new SceneObject(id, rotation, type2, east, northEast, center, north, definition.animation, true);
            scene.addTiledObject(key, config, mean, 1, obj6, 1, z, 0, y, x);
            if (definition.interactType && class11 != null) {
                class11.method212(definition.blocksProjectile, definition.sizeX, definition.sizeY, x, y, rotation);
            }
            return;
        }
        if (definition.contouredGround) {
            if (rotation == 1) {
                int j3 = north;
                north = northEast;
                northEast = east;
                east = center;
                center = j3;
            } else if (rotation == 2) {
                int k3 = north;
                north = east;
                east = k3;
                k3 = northEast;
                northEast = center;
                center = k3;
            } else if (rotation == 3) {
                int l3 = north;
                north = center;
                center = east;
                east = northEast;
                northEast = l3;
            }
        }
        if (type2 == 4) {
            Renderable obj7 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, center, east, northEast, north, -1) : new SceneObject(id, 0, 4, east, northEast, center, north, definition.animation, true);
            scene.addWallDecoration(key, y, rotation * 512, z, 0, mean, obj7, x, config, 0, anIntArray152[rotation]);
            return;
        }
        if (type2 == 5) {
            int i4 = 16;
            long k4 = scene.getWallObjectUid(z, x, y);
            if (k4 > 0L) {
                i4 = ObjectDefinition.lookup((int)ObjectKeyUtil.getObjectId((long)k4)).decorDisplacement;
            }
            Renderable obj13 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, center, east, northEast, north, -1) : new SceneObject(id, 0, 4, east, northEast, center, north, definition.animation, true);
            scene.addWallDecoration(key, y, rotation * 512, z, COSINE_VERTICES[rotation] * i4, mean, obj13, x, config, SINE_VERTICIES[rotation] * i4, anIntArray152[rotation]);
            return;
        }
        if (type2 == 6) {
            Renderable obj8 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, center, east, northEast, north, -1) : new SceneObject(id, 0, 4, east, northEast, center, north, definition.animation, true);
            scene.addWallDecoration(key, y, rotation, z, 0, mean, obj8, x, config, 0, 256);
            return;
        }
        if (type2 == 7) {
            Renderable obj9 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, center, east, northEast, north, -1) : new SceneObject(id, 0, 4, east, northEast, center, north, definition.animation, true);
            scene.addWallDecoration(key, y, rotation, z, 0, mean, obj9, x, config, 0, 512);
            return;
        }
        if (type2 == 8) {
            Renderable obj10 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, center, east, northEast, north, -1) : new SceneObject(id, 0, 4, east, northEast, center, north, definition.animation, true);
            scene.addWallDecoration(key, y, rotation, z, 0, mean, obj10, x, config, 0, 768);
        }
    }

    private static int interpolatedNoise(int x, int y, int frequencyReciprocal) {
        int l = x / frequencyReciprocal;
        int i1 = x & frequencyReciprocal - 1;
        int j1 = y / frequencyReciprocal;
        int k1 = y & frequencyReciprocal - 1;
        int l1 = MapRegion.smoothNoise(l, j1);
        int i2 = MapRegion.smoothNoise(l + 1, j1);
        int j2 = MapRegion.smoothNoise(l, j1 + 1);
        int k2 = MapRegion.smoothNoise(l + 1, j1 + 1);
        int l2 = MapRegion.interpolate(l1, i2, i1, frequencyReciprocal);
        int i3 = MapRegion.interpolate(j2, k2, i1, frequencyReciprocal);
        return MapRegion.interpolate(l2, i3, k1, frequencyReciprocal);
    }

    private int encode(int hue, int saturation, int luminance) {
        if (luminance > 179) {
            saturation /= 2;
        }
        if (luminance > 192) {
            saturation /= 2;
        }
        if (luminance > 217) {
            saturation /= 2;
        }
        if (luminance > 243) {
            saturation /= 2;
        }
        return (hue / 4 << 10) + (saturation / 32 << 7) + luminance / 2;
    }

    public static boolean modelReady(int i, int j) {
        ObjectDefinition class46 = ObjectDefinition.lookup(i);
        if (j == 11) {
            j = 10;
        }
        if (j >= 5 && j <= 8) {
            j = 4;
        }
        return class46.modelTypeCached(j);
    }

    public final void loadMapChunk(int i, int j, CollisionMap[] clips, int l, int i1, byte[] abyte0, int j1, int k1, int l1) {
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j2 = 0; j2 < 8; ++j2) {
                if (l + i2 <= 0 || l + i2 >= 103 || l1 + j2 <= 0 || l1 + j2 >= 103) continue;
                int[] nArray = clips[k1].clipData[l + i2];
                int n = l1 + j2;
                nArray[n] = nArray[n] & 0xFEFFFFFF;
            }
        }
        Buffer stream = new Buffer(abyte0);
        for (int l2 = 0; l2 < 4; ++l2) {
            for (int i3 = 0; i3 < 64; ++i3) {
                for (int j3 = 0; j3 < 64; ++j3) {
                    if (l2 == i && i3 >= i1 && i3 < i1 + 8 && j3 >= j1 && j3 < j1 + 8) {
                        this.loadTile(l1 + ChunkUtil.getRotatedMapChunkY(j3 & 7, j, i3 & 7), 0, stream, l + ChunkUtil.getRotatedMapChunkX(j, j3 & 7, i3 & 7), k1, j, 0);
                        continue;
                    }
                    this.loadTile(-1, 0, stream, -1, 0, 0, 0);
                }
            }
        }
    }

    public final void method180(byte[] abyte0, int i, int j, int k, int l, CollisionMap[] aclass11) {
        for (int i1 = 0; i1 < 4; ++i1) {
            for (int j1 = 0; j1 < 64; ++j1) {
                for (int k1 = 0; k1 < 64; ++k1) {
                    if (j + j1 <= 0 || j + j1 >= 103 || i + k1 <= 0 || i + k1 >= 103) continue;
                    int[] nArray = aclass11[i1].clipData[j + j1];
                    int n = i + k1;
                    nArray[n] = nArray[n] & 0xFEFFFFFF;
                }
            }
        }
        Buffer stream = new Buffer(abyte0);
        for (int l1 = 0; l1 < 4; ++l1) {
            for (int i2 = 0; i2 < 64; ++i2) {
                for (int j2 = 0; j2 < 64; ++j2) {
                    this.loadTile(j2 + i, l, stream, i2 + j, l1, 0, k);
                }
            }
        }
    }

    private void loadTile(int tileY, int xOffset, Buffer stream, int tileX, int tileZ, int overlayRotation, int seed) {
        try {
            this.loadTileOLD(tileY, xOffset, stream, tileX, tileZ, overlayRotation, seed);
        }
        catch (Exception e) {
            this.loadTileOLD(tileY, xOffset, stream, tileX, tileZ, overlayRotation, seed);
        }
    }

    private void loadTileOLD(int tileY, int xOffset, Buffer stream, int tileX, int tileZ, int overlayRotation, int seed) {
        int value;
        if (tileX >= 0 && tileX < 104 && tileY >= 0 && tileY < 104) {
            this.tileFlags[tileZ][tileX][tileY] = 0;
            while (true) {
                int value2;
                if ((value2 = stream.readUnsignedByte()) == 0) {
                    if (tileZ == 0) {
                        this.tileHeights[0][tileX][tileY] = -MapRegion.calculateVertexHeight(932731 + tileX + seed, 556238 + tileY + xOffset) * 8;
                        return;
                    }
                    this.tileHeights[tileZ][tileX][tileY] = this.tileHeights[tileZ - 1][tileX][tileY] - 240;
                    return;
                }
                if (value2 == 1) {
                    int height = stream.readUnsignedByte();
                    if (height == 1) {
                        height = 0;
                    }
                    if (tileZ == 0) {
                        this.tileHeights[0][tileX][tileY] = -height * 8;
                        return;
                    }
                    this.tileHeights[tileZ][tileX][tileY] = this.tileHeights[tileZ - 1][tileX][tileY] - height * 8;
                    return;
                }
                if (value2 <= 49) {
                    this.overlays[tileZ][tileX][tileY] = stream.readSignedByte();
                    this.overlayTypes[tileZ][tileX][tileY] = (byte)((value2 - 2) / 4);
                    this.overlayOrientations[tileZ][tileX][tileY] = (byte)(value2 - 2 + overlayRotation & 3);
                    continue;
                }
                if (value2 <= 81) {
                    this.tileFlags[tileZ][tileX][tileY] = (byte)(value2 - 49);
                    continue;
                }
                this.underlays[tileZ][tileX][tileY] = (byte)(value2 - 81);
            }
        }
        while ((value = stream.readUnsignedByte()) != 0) {
            if (value == 1) {
                stream.readUnsignedByte();
                break;
            }
            if (value > 49) continue;
            stream.readUnsignedByte();
        }
    }

    private int getCollisionPlane(int y, int z, int x) {
        if ((this.tileFlags[z][x][y] & 8) != 0) {
            return 0;
        }
        if (z > 0 && (this.tileFlags[1][x][y] & 2) != 0) {
            return z - 1;
        }
        return z;
    }

    public final void readObjectMap(CollisionMap[] aclass11, SceneGraph worldController, int i, int j, int k, int l, byte[] abyte0, int i1, int j1, int k1) {
        int i2;
        Buffer stream = new Buffer(abyte0);
        int l1 = -1;
        while ((i2 = stream.readUSmart2()) != 0) {
            int k2;
            l1 += i2;
            int j2 = 0;
            while ((k2 = stream.readUSmart()) != 0) {
                int l2 = (j2 += k2 - 1) & 0x3F;
                int i3 = j2 >> 6 & 0x3F;
                int j3 = j2 >> 12;
                int k3 = stream.readUnsignedByte();
                int l3 = k3 >> 2;
                int i4 = k3 & 3;
                if (j3 != i || i3 < i1 || i3 >= i1 + 8 || l2 < k || l2 >= k + 8) continue;
                ObjectDefinition class46 = ObjectDefinition.lookup(l1);
                int j4 = j + ChunkUtil.method157(j1, class46.sizeY, i3 & 7, l2 & 7, class46.sizeX);
                int k4 = k1 + ChunkUtil.method158(l2 & 7, class46.sizeY, j1, class46.sizeX, i3 & 7);
                if (j4 <= 0 || k4 <= 0 || j4 >= 103 || k4 >= 103) continue;
                int l4 = j3;
                if ((this.tileFlags[1][j4][k4] & 2) == 2) {
                    --l4;
                }
                CollisionMap class11 = null;
                if (l4 >= 0) {
                    class11 = aclass11[l4];
                }
                this.renderObject(k4, worldController, class11, l3, l, j4, l1, i4 + j1 & 3);
            }
        }
    }

    private static int interpolate(int a, int b, int angle, int frequencyReciprocal) {
        int cosine = 65536 - Rasterizer3D.COSINE[angle * 1024 / frequencyReciprocal] >> 1;
        return (a * (65536 - cosine) >> 16) + (b * cosine >> 16);
    }

    private int checkedLight(int color, int light) {
        if (color == -2) {
            return 12345678;
        }
        if (color == -1) {
            if (SceneGraph.lowMem) {
                if (light < 0) {
                    light = 0;
                } else if (light > 127) {
                    light = 127;
                }
                light = 127 - light;
                return light;
            }
            if (light < 2) {
                light = 2;
            } else if (light > 126) {
                light = 126;
            }
            return light;
        }
        if ((light = (color & 0x7F) * light / 128) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (color & 0xFF80) + light;
    }

    private static int method187(int hslBitmap, int lightIntensity) {
        if (hslBitmap == -1) {
            return 12345678;
        }
        if ((lightIntensity = (hslBitmap & 0x7F) * lightIntensity / 128) < 2) {
            lightIntensity = 2;
        } else if (lightIntensity > 126) {
            lightIntensity = 126;
        }
        return (hslBitmap & 0xFF80) + lightIntensity;
    }

    private static int smoothNoise(int x, int y) {
        int corners = MapRegion.calculateNoise(x - 1, y - 1) + MapRegion.calculateNoise(x + 1, y - 1) + MapRegion.calculateNoise(x - 1, y + 1) + MapRegion.calculateNoise(x + 1, y + 1);
        int sides = MapRegion.calculateNoise(x - 1, y) + MapRegion.calculateNoise(x + 1, y) + MapRegion.calculateNoise(x, y - 1) + MapRegion.calculateNoise(x, y + 1);
        int center = MapRegion.calculateNoise(x, y);
        return corners / 16 + sides / 8 + center / 4;
    }

    public static void placeObject(SceneGraph worldController, int rotation, int regionY, int type2, int plane, CollisionMap class11, int[][][] ai, int regionX, int j1, int k1) {
        int l1 = ai[plane][regionX][regionY];
        int i2 = ai[plane][regionX + 1][regionY];
        int j2 = ai[plane][regionX + 1][regionY + 1];
        int k2 = ai[plane][regionX][regionY + 1];
        int l2 = l1 + i2 + j2 + k2 >> 2;
        ObjectDefinition definition = ObjectDefinition.lookup(j1);
        long key = (long)rotation << 20 | (long)type2 << 14 | ((long)regionY << 7 | (long)regionX) + 0x40000000L;
        if (!definition.isInteractive) {
            key |= Long.MIN_VALUE;
        }
        if (definition.supportItems == 1) {
            key |= 0x400000L;
        }
        key |= (long)j1 << 32;
        byte byte1 = (byte)((rotation << 6) + type2);
        if (type2 == 22) {
            Renderable obj2 = definition.animation == -1 && definition.configs == null ? definition.modelAt(22, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, 22, i2, j2, l1, k2, definition.animation, true);
            worldController.addGroundDecoration(k1, l2, regionY, obj2, byte1, key, regionX);
            if (definition.interactType && definition.isInteractive) {
                class11.block(regionX, regionY);
            }
            return;
        }
        if (type2 == 10 || type2 == 11) {
            Renderable obj1 = definition.animation == -1 && definition.configs == null ? definition.modelAt(10, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, 10, i2, j2, l1, k2, definition.animation, true);
            if (obj1 != null) {
                int i5;
                int k4;
                int j5 = 0;
                if (type2 == 11) {
                    j5 += 256;
                }
                if (rotation == 1 || rotation == 3) {
                    k4 = definition.sizeY;
                    i5 = definition.sizeX;
                } else {
                    k4 = definition.sizeX;
                    i5 = definition.sizeY;
                }
                worldController.addTiledObject(key, byte1, l2, i5, obj1, k4, k1, j5, regionY, regionX);
            }
            if (definition.interactType) {
                class11.method212(definition.blocksProjectile, definition.sizeX, definition.sizeY, regionX, regionY, rotation);
            }
            return;
        }
        if (type2 >= 12) {
            Renderable obj2 = definition.animation == -1 && definition.configs == null ? definition.modelAt(type2, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, type2, i2, j2, l1, k2, definition.animation, true);
            worldController.addTiledObject(key, byte1, l2, 1, obj2, 1, k1, 0, regionY, regionX);
            if (definition.interactType) {
                class11.method212(definition.blocksProjectile, definition.sizeX, definition.sizeY, regionX, regionY, rotation);
            }
            return;
        }
        if (type2 == 0) {
            Renderable obj3 = definition.animation == -1 && definition.configs == null ? definition.modelAt(0, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, 0, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallObject(anIntArray152[rotation], obj3, key, regionY, byte1, regionX, null, l2, 0, k1);
            if (definition.interactType) {
                class11.method211(regionY, rotation, regionX, type2, definition.blocksProjectile);
            }
            return;
        }
        if (type2 == 1) {
            Renderable obj4 = definition.animation == -1 && definition.configs == null ? definition.modelAt(1, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, 1, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallObject(anIntArray140[rotation], obj4, key, regionY, byte1, regionX, null, l2, 0, k1);
            if (definition.interactType) {
                class11.method211(regionY, rotation, regionX, type2, definition.blocksProjectile);
            }
            return;
        }
        if (type2 == 2) {
            Renderable obj12;
            Renderable obj11;
            int j3 = rotation + 1 & 3;
            if (definition.animation == -1 && definition.configs == null) {
                obj11 = definition.modelAt(2, 4 + rotation, l1, i2, j2, k2, -1);
                obj12 = definition.modelAt(2, j3, l1, i2, j2, k2, -1);
            } else {
                obj11 = new SceneObject(j1, 4 + rotation, 2, i2, j2, l1, k2, definition.animation, true);
                obj12 = new SceneObject(j1, j3, 2, i2, j2, l1, k2, definition.animation, true);
            }
            worldController.addWallObject(anIntArray152[rotation], obj11, key, regionY, byte1, regionX, obj12, l2, anIntArray152[j3], k1);
            if (definition.interactType) {
                class11.method211(regionY, rotation, regionX, type2, definition.blocksProjectile);
            }
            return;
        }
        if (type2 == 3) {
            Renderable obj5 = definition.animation == -1 && definition.configs == null ? definition.modelAt(3, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, 3, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallObject(anIntArray140[rotation], obj5, key, regionY, byte1, regionX, null, l2, 0, k1);
            if (definition.interactType) {
                class11.method211(regionY, rotation, regionX, type2, definition.blocksProjectile);
            }
            return;
        }
        if (type2 == 9) {
            Renderable obj6 = definition.animation == -1 && definition.configs == null ? definition.modelAt(type2, rotation, l1, i2, j2, k2, -1) : new SceneObject(j1, rotation, type2, i2, j2, l1, k2, definition.animation, true);
            worldController.addTiledObject(key, byte1, l2, 1, obj6, 1, k1, 0, regionY, regionX);
            if (definition.interactType) {
                class11.method212(definition.blocksProjectile, definition.sizeX, definition.sizeY, regionX, regionY, rotation);
            }
            return;
        }
        if (definition.contouredGround) {
            if (rotation == 1) {
                int k3 = k2;
                k2 = j2;
                j2 = i2;
                i2 = l1;
                l1 = k3;
            } else if (rotation == 2) {
                int l3 = k2;
                k2 = i2;
                i2 = l3;
                l3 = j2;
                j2 = l1;
                l1 = l3;
            } else if (rotation == 3) {
                int i4 = k2;
                k2 = l1;
                l1 = i2;
                i2 = j2;
                j2 = i4;
            }
        }
        if (type2 == 4) {
            Renderable obj7 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, l1, i2, j2, k2, -1) : new SceneObject(j1, 0, 4, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallDecoration(key, regionY, rotation * 512, k1, 0, l2, obj7, regionX, byte1, 0, anIntArray152[rotation]);
            return;
        }
        if (type2 == 5) {
            int j4 = 16;
            long l4 = worldController.getWallObjectUid(k1, regionX, regionY);
            if (l4 > 0L) {
                j4 = ObjectDefinition.lookup((int)ObjectKeyUtil.getObjectId((long)l4)).decorDisplacement;
            }
            Renderable obj13 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, l1, i2, j2, k2, -1) : new SceneObject(j1, 0, 4, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallDecoration(key, regionY, rotation * 512, k1, COSINE_VERTICES[rotation] * j4, l2, obj13, regionX, byte1, SINE_VERTICIES[rotation] * j4, anIntArray152[rotation]);
            return;
        }
        if (type2 == 6) {
            Renderable obj8 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, l1, i2, j2, k2, -1) : new SceneObject(j1, 0, 4, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallDecoration(key, regionY, rotation, k1, 0, l2, obj8, regionX, byte1, 0, 256);
            return;
        }
        if (type2 == 7) {
            Renderable obj9 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, l1, i2, j2, k2, -1) : new SceneObject(j1, 0, 4, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallDecoration(key, regionY, rotation, k1, 0, l2, obj9, regionX, byte1, 0, 512);
            return;
        }
        if (type2 == 8) {
            Renderable obj10 = definition.animation == -1 && definition.configs == null ? definition.modelAt(4, 0, l1, i2, j2, k2, -1) : new SceneObject(j1, 0, 4, i2, j2, l1, k2, definition.animation, true);
            worldController.addWallDecoration(key, regionY, rotation, k1, 0, l2, obj10, regionX, byte1, 0, 768);
        }
    }

    public static void requestModelPreload(byte[] is) {
        int i1;
        Buffer stream = new Buffer(is);
        int l = -1;
        while ((i1 = stream.readUSmart()) != 0) {
            int k1;
            l += i1;
            int j1 = 0;
            while ((k1 = stream.readUSmart()) != 0) {
                int j2 = (j1 += k1 - 1) >> 12;
                int k2 = stream.readUnsignedByte();
                ObjectDefinition class46 = ObjectDefinition.lookup(l);
                class46.modelCached();
            }
        }
    }

    public static boolean method189(int i, byte[] is, int i_250_) {
        int i_253_;
        boolean bool = true;
        Buffer stream = new Buffer(is);
        int i_252_ = -1;
        block0: while ((i_253_ = stream.getUIncrementalSmart()) != 0) {
            i_252_ += i_253_;
            int i_254_ = 0;
            boolean bool_255_ = false;
            while (true) {
                if (bool_255_) {
                    int i_256_ = stream.readUSmart();
                    if (i_256_ == 0) continue block0;
                    stream.readUnsignedByte();
                    continue;
                }
                int i_257_ = stream.readUSmart();
                if (i_257_ == 0) continue block0;
                int i_258_ = (i_254_ += i_257_ - 1) & 0x3F;
                int i_259_ = i_254_ >> 6 & 0x3F;
                int i_260_ = stream.readUnsignedByte() >> 2;
                int i_261_ = i_259_ + i;
                int i_262_ = i_258_ + i_250_;
                if (i_261_ <= 0 || i_262_ <= 0 || i_261_ >= 103 || i_262_ >= 103) continue;
                ObjectDefinition class46 = ObjectDefinition.lookup(i_252_);
                if (i_260_ == 22 && lowMem && !class46.isInteractive && !class46.obstructsGround) continue;
                bool &= class46.modelCached();
                bool_255_ = true;
            }
        }
        return bool;
    }

    public final void method190(int i, CollisionMap[] aclass11, int j, SceneGraph worldController, byte[] abyte0) {
        int i1;
        Buffer stream = new Buffer(abyte0);
        int l = -1;
        while ((i1 = stream.getUIncrementalSmart()) != 0) {
            int k1;
            l += i1;
            int j1 = 0;
            while ((k1 = stream.readUSmart()) != 0) {
                int l1 = (j1 += k1 - 1) & 0x3F;
                int i2 = j1 >> 6 & 0x3F;
                int j2 = j1 >> 12;
                int k2 = stream.readUnsignedByte();
                int l2 = k2 >> 2;
                int i3 = k2 & 3;
                int j3 = i2 + i;
                int k3 = l1 + j;
                if (j3 <= 0 || k3 <= 0 || j3 >= 103 || k3 >= 103 || j2 < 0 || j2 >= 4) continue;
                int l3 = j2;
                if ((this.tileFlags[1][j3][k3] & 2) == 2) {
                    --l3;
                }
                CollisionMap class11 = null;
                if (l3 >= 0) {
                    class11 = aclass11[l3];
                }
                this.renderObject(k3, worldController, class11, l2, j2, j3, l, i3);
            }
        }
    }

    static {
        COSINE_VERTICES = new int[]{1, 0, -1, 0};
        anIntArray140 = new int[]{16, 32, 64, 128};
        SINE_VERTICIES = new int[]{0, -1, 0, 1};
        maximumPlane = 99;
        lowMem = false;
        anIntArray152 = new int[]{1, 2, 4, 8};
    }
}

