/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.AABB;
import com.client.Buffer;
import com.client.Client;
import com.client.FaceNormal;
import com.client.Frame;
import com.client.FrameBase;
import com.client.ModelHeader;
import com.client.ModelLoader;
import com.client.Rasterizer2D;
import com.client.Rasterizer3D;
import com.client.Renderable;
import com.client.SceneGraph;
import com.client.VertexNormal;
import com.client.engine.impl.MouseHandler;
import com.client.utilities.ObjectKeyUtil;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.Perspective;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.api.model.Jarvis;
import net.runelite.api.model.Triangle;
import net.runelite.api.model.Vertex;
import net.runelite.rs.api.RSFrames;
import net.runelite.rs.api.RSModel;

public class Model
extends Renderable
implements RSModel {
    public boolean DEBUG_MODELS = false;
    private static boolean mouseInViewport = false;
    private int boundsType;
    boolean isBoundsCalculated;
    public int[][] animayaGroups;
    public int[][] animayaScales;
    private float[] faceTextureUVCoordinates;
    private int[] vertexNormalsX;
    private int[] vertexNormalsY;
    private int[] vertexNormalsZ;
    public short[] materials;
    public byte[] textures;
    public byte[] textureTypes;
    public static int anInt1620;
    public static Model emptyModel;
    private static int[] sharedVerticesX;
    private static int[] sharedVerticesY;
    private static int[] sharedVerticesZ;
    private static byte[] sharedTriangleAlpha;
    public int verticesCount;
    public int[] verticesX;
    public int[] verticesY;
    public int[] verticesZ;
    public int trianglesCount;
    public int[] trianglesX;
    public int[] trianglesY;
    public int[] trianglesZ;
    public int[] colorsX;
    public int[] colorsY;
    public int[] colorsZ;
    public int[] drawType;
    public byte[] renderPriorities;
    public byte[] triangleAlpha;
    public short[] colors;
    public byte facePriority = 0;
    public int texturesCount;
    public int[] texturesX;
    public int[] texturesY;
    public int[] texturesZ;
    public int minX;
    public int maxX;
    public int maxZ;
    public int minZ;
    public int diagonal2DAboveOrigin;
    public int maxY;
    public int diagonal3D;
    public int diagonal3DAboveOrigin;
    public int itemDropHeight;
    public int[] vertexData;
    public int[] triangleData;
    public int[][] vertexGroups;
    public int[][] faceGroups;
    public boolean singleTile;
    public VertexNormal[] vertexNormalsOffsets;
    private FaceNormal[] faceNormals;
    static ModelHeader[] modelHeaders;
    static boolean[] hasAnEdgeToRestrict;
    static boolean[] outOfReach;
    static int[] vertexScreenX;
    static int[] vertexScreenY;
    static int[] vertexScreenZ;
    static int[] vertexMovedX;
    static int[] vertexMovedY;
    static int[] vertexMovedZ;
    static int[] depth;
    static int[][] faceLists;
    static int[] anIntArray1673;
    static int[][] anIntArrayArray1674;
    static int[] anIntArray1676;
    static int[] anIntArray1675;
    static int[] anIntArray1677;
    static int[] xPosition;
    static int[] yPosition;
    static int[] zPosition;
    static int transformTempX;
    static int transformTempY;
    static int transformTempZ;
    public static boolean objectExist;
    public static int cursorX;
    public static int cursorY;
    public static int objectsHovering;
    public static long[] hoveringObjects;
    public static int[] SINE;
    public static int[] COSINE;
    static int[] modelColors;
    static int[] modelLocations;
    HashMap<Integer, net.runelite.api.AABB> aabb = new HashMap();
    public int bufferOffset;
    public int uvBufferOffset;
    private int sceneId;
    public int lastOrientation = -1;

    public static void clear() {
        modelHeaders = null;
        hasAnEdgeToRestrict = null;
        outOfReach = null;
        vertexScreenY = null;
        vertexScreenZ = null;
        vertexMovedX = null;
        vertexMovedY = null;
        vertexMovedZ = null;
        depth = null;
        faceLists = null;
        anIntArray1673 = null;
        anIntArrayArray1674 = null;
        anIntArray1675 = null;
        anIntArray1676 = null;
        anIntArray1677 = null;
        SINE = null;
        COSINE = null;
        modelColors = null;
        modelLocations = null;
    }

    private Model(int modelId) {
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.facePriority = 0;
        this.isBoundsCalculated = false;
        byte[] data2 = Model.modelHeaders[modelId].data;
        if (data2[data2.length - 1] == -3 && data2[data2.length - 2] == -1) {
            ModelLoader.decodeType3(this, data2);
        } else if (data2[data2.length - 1] == -2 && data2[data2.length - 2] == -1) {
            ModelLoader.decodeType2(this, data2);
        } else if (data2[data2.length - 1] == -1 && data2[data2.length - 2] == -1) {
            ModelLoader.decodeType1(this, data2);
        } else {
            ModelLoader.decodeOldFormat(this, data2);
        }
    }

    public static void loadModel(byte[] modelData, int modelId) {
        int offset;
        if (modelData == null) {
            ModelHeader modelHeader = Model.modelHeaders[modelId] = new ModelHeader();
            modelHeader.vertexCount = 0;
            modelHeader.triangleCount = 0;
            modelHeader.texturedTriangleCount = 0;
            return;
        }
        Buffer stream = new Buffer(modelData);
        stream.currentPosition = modelData.length - 18;
        ModelHeader modelHeader = Model.modelHeaders[modelId] = new ModelHeader();
        modelHeader.data = modelData;
        modelHeader.vertexCount = stream.readUShort();
        modelHeader.triangleCount = stream.readUShort();
        modelHeader.texturedTriangleCount = stream.readUnsignedByte();
        int useTextures = stream.readUnsignedByte();
        int useTrianglePriority = stream.readUnsignedByte();
        int useAlpha = stream.readUnsignedByte();
        int useTriangleSkins = stream.readUnsignedByte();
        int useVertexSkins = stream.readUnsignedByte();
        int dataLengthX = stream.readUShort();
        int dataLengthY = stream.readUShort();
        int dataLengthZ = stream.readUShort();
        int dataLengthTriangle = stream.readUShort();
        modelHeader.vertexDirectionOffset = offset = 0;
        modelHeader.triangleTypeOffset = offset += modelHeader.vertexCount;
        modelHeader.trianglePriorityOffset = offset += modelHeader.triangleCount;
        if (useTrianglePriority == 255) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.trianglePriorityOffset = -useTrianglePriority - 1;
        }
        modelHeader.triangleSkinOffset = offset;
        if (useTriangleSkins == 1) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.triangleSkinOffset = -1;
        }
        modelHeader.texturePointerOffset = offset;
        if (useTextures == 1) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.texturePointerOffset = -1;
        }
        modelHeader.vertexSkinOffset = offset;
        if (useVertexSkins == 1) {
            offset += modelHeader.vertexCount;
        } else {
            modelHeader.vertexSkinOffset = -1;
        }
        modelHeader.triangleAlphaOffset = offset;
        if (useAlpha == 1) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.triangleAlphaOffset = -1;
        }
        modelHeader.triangleDataOffset = offset;
        modelHeader.colourDataOffset = offset += dataLengthTriangle;
        modelHeader.texturedTriangleOffset = offset += modelHeader.triangleCount * 2;
        modelHeader.dataOffsetX = offset += modelHeader.texturedTriangleCount * 6;
        modelHeader.dataOffsetY = offset += dataLengthX;
        modelHeader.dataOffsetZ = offset += dataLengthY;
        offset += dataLengthZ;
    }

    public static void init() {
        modelHeaders = new ModelHeader[80000];
    }

    public static void resetModel(int model) {
        Model.modelHeaders[model] = null;
    }

    public static Model getModel(int file) {
        if (modelHeaders == null) {
            return null;
        }
        ModelHeader header = modelHeaders[file];
        if (header == null) {
            Client.instance.resourceProvider.provide(0, file);
            return null;
        }
        return new Model(file);
    }

    public static boolean isCached(int file) {
        if (modelHeaders == null) {
            return false;
        }
        ModelHeader mdl = modelHeaders[file];
        if (mdl == null) {
            Client.instance.resourceProvider.provide(0, file);
            return false;
        }
        return true;
    }

    Model() {
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.texturesCount = 0;
        this.facePriority = 0;
        this.singleTile = true;
        this.isBoundsCalculated = false;
    }

    public Model(int length, Model[] models) {
        try {
            Model build;
            this.singleTile = false;
            boolean typeFlag = false;
            boolean priorityFlag = false;
            boolean alphaFlag = false;
            boolean tSkinFlag = false;
            boolean colorFlag = false;
            boolean textureFlag = false;
            boolean coordinateFlag = false;
            this.verticesCount = 0;
            this.trianglesCount = 0;
            this.texturesCount = 0;
            this.facePriority = (byte)-1;
            for (int count = 0; count < length; ++count) {
                build = models[count];
                if (build == null) continue;
                this.verticesCount += build.verticesCount;
                this.trianglesCount += build.trianglesCount;
                this.texturesCount += build.texturesCount;
                typeFlag |= build.drawType != null;
                alphaFlag |= build.triangleAlpha != null;
                if (build.renderPriorities != null) {
                    priorityFlag = true;
                } else {
                    if (this.facePriority == -1) {
                        this.facePriority = build.facePriority;
                    }
                    if (this.facePriority != build.facePriority) {
                        priorityFlag = true;
                    }
                }
                tSkinFlag |= build.triangleData != null;
                colorFlag |= build.colors != null;
                textureFlag |= build.materials != null;
                coordinateFlag |= build.textures != null;
            }
            this.verticesX = new int[this.verticesCount];
            this.verticesY = new int[this.verticesCount];
            this.verticesZ = new int[this.verticesCount];
            this.vertexData = new int[this.verticesCount];
            this.trianglesX = new int[this.trianglesCount];
            this.trianglesY = new int[this.trianglesCount];
            this.trianglesZ = new int[this.trianglesCount];
            if (colorFlag) {
                this.colors = new short[this.trianglesCount];
            }
            if (typeFlag) {
                this.drawType = new int[this.trianglesCount];
            }
            if (priorityFlag) {
                this.renderPriorities = new byte[this.trianglesCount];
            }
            if (alphaFlag) {
                this.triangleAlpha = new byte[this.trianglesCount];
            }
            if (tSkinFlag) {
                this.triangleData = new int[this.trianglesCount];
            }
            if (textureFlag) {
                this.materials = new short[this.trianglesCount];
            }
            if (coordinateFlag) {
                this.textures = new byte[this.trianglesCount];
            }
            if (this.texturesCount > 0) {
                this.textureTypes = new byte[this.texturesCount];
                this.texturesX = new int[this.texturesCount];
                this.texturesY = new int[this.texturesCount];
                this.texturesZ = new int[this.texturesCount];
            }
            this.verticesCount = 0;
            this.trianglesCount = 0;
            this.texturesCount = 0;
            int textureFace = 0;
            for (int index = 0; index < length; ++index) {
                build = models[index];
                if (build == null) continue;
                for (int face = 0; face < build.trianglesCount; ++face) {
                    if (typeFlag && build.drawType != null) {
                        this.drawType[this.trianglesCount] = build.drawType[face];
                    }
                    if (priorityFlag) {
                        this.renderPriorities[this.trianglesCount] = build.renderPriorities == null ? build.facePriority : build.renderPriorities[face];
                    }
                    if (alphaFlag && build.triangleAlpha != null) {
                        this.triangleAlpha[this.trianglesCount] = build.triangleAlpha[face];
                    }
                    if (tSkinFlag && build.triangleData != null) {
                        this.triangleData[this.trianglesCount] = build.triangleData[face];
                    }
                    if (textureFlag) {
                        this.materials[this.trianglesCount] = build.materials != null ? build.materials[face] : -1;
                    }
                    if (coordinateFlag) {
                        this.textures[this.trianglesCount] = build.textures != null && build.textures[face] != -1 ? (int)(build.textures[face] + textureFace) : -1;
                    }
                    this.colors[this.trianglesCount] = build.colors[face];
                    this.trianglesX[this.trianglesCount] = this.getFirstIdenticalVertexId(build, build.trianglesX[face]);
                    this.trianglesY[this.trianglesCount] = this.getFirstIdenticalVertexId(build, build.trianglesY[face]);
                    this.trianglesZ[this.trianglesCount] = this.getFirstIdenticalVertexId(build, build.trianglesZ[face]);
                    ++this.trianglesCount;
                }
                for (int textureEdge = 0; textureEdge < build.texturesCount; ++textureEdge) {
                    this.texturesX[this.texturesCount] = (short)this.getFirstIdenticalVertexId(build, build.texturesX[textureEdge]);
                    this.texturesY[this.texturesCount] = (short)this.getFirstIdenticalVertexId(build, build.texturesY[textureEdge]);
                    this.texturesZ[this.texturesCount] = (short)this.getFirstIdenticalVertexId(build, build.texturesZ[textureEdge]);
                    ++this.texturesCount;
                }
                textureFace += build.texturesCount;
            }
            this.vertexNormals();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Model(Model[] models) {
        Model build;
        int currentModel;
        int modelCount = 2;
        this.singleTile = false;
        ++anInt1620;
        boolean renderTypeFlag = false;
        boolean priorityFlag = false;
        boolean alphaFlag = false;
        boolean colorFlag = false;
        boolean textureFlag = false;
        boolean coordinateFlag = false;
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.texturesCount = 0;
        this.facePriority = (byte)-1;
        for (currentModel = 0; currentModel < modelCount; ++currentModel) {
            build = models[currentModel];
            if (build == null) continue;
            this.verticesCount += build.verticesCount;
            this.trianglesCount += build.trianglesCount;
            this.texturesCount += build.texturesCount;
            renderTypeFlag |= this.drawType != null;
            if (build.renderPriorities != null) {
                priorityFlag = true;
            } else {
                if (this.facePriority == -1) {
                    this.facePriority = build.facePriority;
                }
                if (this.facePriority != build.facePriority) {
                    priorityFlag = true;
                }
            }
            alphaFlag |= build.triangleAlpha != null;
            colorFlag |= build.colors != null;
            textureFlag |= build.materials != null;
            coordinateFlag |= build.textures != null;
        }
        this.verticesX = new int[this.verticesCount];
        this.verticesY = new int[this.verticesCount];
        this.verticesZ = new int[this.verticesCount];
        this.trianglesX = new int[this.trianglesCount];
        this.trianglesY = new int[this.trianglesCount];
        this.trianglesZ = new int[this.trianglesCount];
        this.colorsX = new int[this.trianglesCount];
        this.colorsY = new int[this.trianglesCount];
        this.colorsZ = new int[this.trianglesCount];
        if (renderTypeFlag) {
            this.drawType = new int[this.trianglesCount];
        }
        if (priorityFlag) {
            this.renderPriorities = new byte[this.trianglesCount];
        }
        if (alphaFlag) {
            this.triangleAlpha = new byte[this.trianglesCount];
        }
        if (textureFlag) {
            this.materials = new short[this.trianglesCount];
        }
        if (coordinateFlag) {
            this.textures = new byte[this.trianglesCount];
        }
        if (this.texturesCount > 0) {
            this.textureTypes = new byte[this.texturesCount];
            this.texturesX = new int[this.texturesCount];
            this.texturesY = new int[this.texturesCount];
            this.texturesZ = new int[this.texturesCount];
        }
        if (colorFlag) {
            this.colors = new short[this.trianglesCount];
        }
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.texturesCount = 0;
        for (currentModel = 0; currentModel < modelCount; ++currentModel) {
            build = models[currentModel];
            if (build == null) continue;
            int vertex = this.verticesCount;
            for (int point = 0; point < build.verticesCount; ++point) {
                this.verticesX[this.verticesCount] = build.verticesX[point];
                this.verticesY[this.verticesCount] = build.verticesY[point];
                this.verticesZ[this.verticesCount] = build.verticesZ[point];
                ++this.verticesCount;
            }
            for (int face = 0; face < build.trianglesCount; ++face) {
                this.trianglesX[this.trianglesCount] = build.trianglesX[face] + vertex;
                this.trianglesY[this.trianglesCount] = build.trianglesY[face] + vertex;
                this.trianglesZ[this.trianglesCount] = build.trianglesZ[face] + vertex;
                this.colorsX[this.trianglesCount] = build.colorsX[face];
                this.colorsY[this.trianglesCount] = build.colorsY[face];
                this.colorsZ[this.trianglesCount] = build.colorsZ[face];
                if (renderTypeFlag && build.drawType != null) {
                    this.drawType[this.trianglesCount] = build.drawType[face];
                }
                if (alphaFlag && build.triangleAlpha != null) {
                    this.triangleAlpha[this.trianglesCount] = build.triangleAlpha[face];
                }
                if (priorityFlag) {
                    this.renderPriorities[this.trianglesCount] = build.renderPriorities == null ? build.facePriority : build.renderPriorities[face];
                }
                if (colorFlag && build.colors != null) {
                    this.colors[this.trianglesCount] = build.colors[face];
                }
                if (textureFlag) {
                    this.materials[this.trianglesCount] = build.materials != null ? build.materials[face] : -1;
                }
                if (coordinateFlag) {
                    this.textures[this.trianglesCount] = build.textures != null && build.textures[face] != -1 ? (int)(build.textures[face] + this.texturesCount) : -1;
                }
                ++this.trianglesCount;
            }
            for (int texture = 0; texture < build.texturesCount; ++texture) {
                this.texturesX[this.texturesCount] = (short)(build.texturesX[texture] + vertex);
                this.texturesY[this.texturesCount] = (short)(build.texturesY[texture] + vertex);
                this.texturesZ[this.texturesCount] = (short)(build.texturesZ[texture] + vertex);
                ++this.texturesCount;
            }
            this.texturesCount += build.texturesCount;
        }
        this.calculateBoundsCylinder();
        this.resetBounds();
    }

    public Model(boolean colorFlag, boolean alphaFlag, boolean animated, Model model) {
        this(colorFlag, alphaFlag, animated, false, model);
    }

    public Model(boolean colorFlag, boolean alphaFlag, boolean animated, boolean textureFlag, Model model) {
        this.singleTile = false;
        this.verticesCount = model.verticesCount;
        this.trianglesCount = model.trianglesCount;
        this.texturesCount = model.texturesCount;
        if (animated) {
            this.verticesX = model.verticesX;
            this.verticesY = model.verticesY;
            this.verticesZ = model.verticesZ;
        } else {
            this.verticesX = new int[this.verticesCount];
            this.verticesY = new int[this.verticesCount];
            this.verticesZ = new int[this.verticesCount];
            for (int point = 0; point < this.verticesCount; ++point) {
                this.verticesX[point] = model.verticesX[point];
                this.verticesY[point] = model.verticesY[point];
                this.verticesZ[point] = model.verticesZ[point];
            }
        }
        if (colorFlag) {
            this.colors = model.colors;
        } else {
            this.colors = new short[this.trianglesCount];
            System.arraycopy(model.colors, 0, this.colors, 0, this.trianglesCount);
        }
        if (!textureFlag && model.materials != null) {
            this.materials = new short[this.trianglesCount];
            System.arraycopy(model.materials, 0, this.materials, 0, this.trianglesCount);
        } else {
            this.materials = model.materials;
        }
        if (alphaFlag) {
            this.triangleAlpha = model.triangleAlpha;
        } else {
            this.triangleAlpha = new byte[this.trianglesCount];
            if (model.triangleAlpha == null) {
                for (int l = 0; l < this.trianglesCount; ++l) {
                    this.triangleAlpha[l] = 0;
                }
            } else {
                System.arraycopy(model.triangleAlpha, 0, this.triangleAlpha, 0, this.trianglesCount);
            }
        }
        this.vertexData = model.vertexData;
        this.triangleData = model.triangleData;
        this.drawType = model.drawType;
        this.trianglesX = model.trianglesX;
        this.trianglesY = model.trianglesY;
        this.trianglesZ = model.trianglesZ;
        this.renderPriorities = model.renderPriorities;
        this.facePriority = model.facePriority;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.textures = model.textures;
        this.textureTypes = model.textureTypes;
        this.normals = model.normals;
        this.faceNormals = model.faceNormals;
        this.animayaGroups = model.animayaGroups;
        this.animayaScales = model.animayaScales;
        this.vertexNormalsOffsets = model.vertexNormalsOffsets;
    }

    public Model(boolean resetVertices, boolean resetColors, Model model) {
        this.singleTile = false;
        this.verticesCount = model.verticesCount;
        this.trianglesCount = model.trianglesCount;
        this.texturesCount = model.texturesCount;
        if (resetVertices) {
            this.verticesY = new int[this.verticesCount];
            System.arraycopy(model.verticesY, 0, this.verticesY, 0, this.verticesCount);
        } else {
            this.verticesY = model.verticesY;
        }
        if (resetColors) {
            int face;
            this.colorsX = new int[this.trianglesCount];
            this.colorsY = new int[this.trianglesCount];
            this.colorsZ = new int[this.trianglesCount];
            for (face = 0; face < this.trianglesCount; ++face) {
                this.colorsX[face] = model.colorsX[face];
                this.colorsY[face] = model.colorsY[face];
                this.colorsZ[face] = model.colorsZ[face];
            }
            this.drawType = new int[this.trianglesCount];
            if (model.drawType == null) {
                for (face = 0; face < this.trianglesCount; ++face) {
                    this.drawType[face] = 0;
                }
            } else {
                System.arraycopy(model.drawType, 0, this.drawType, 0, this.trianglesCount);
            }
        } else {
            this.colorsX = model.colorsX;
            this.colorsY = model.colorsY;
            this.colorsZ = model.colorsZ;
            this.drawType = model.drawType;
        }
        this.verticesX = model.verticesX;
        this.verticesZ = model.verticesZ;
        this.colors = model.colors;
        this.triangleAlpha = model.triangleAlpha;
        this.renderPriorities = model.renderPriorities;
        this.facePriority = model.facePriority;
        this.trianglesX = model.trianglesX;
        this.trianglesY = model.trianglesY;
        this.trianglesZ = model.trianglesZ;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.modelBaseY = model.modelBaseY;
        this.textures = model.textures;
        this.materials = model.materials;
        this.diagonal2DAboveOrigin = model.diagonal2DAboveOrigin;
        this.diagonal3DAboveOrigin = model.diagonal3DAboveOrigin;
        this.diagonal3D = model.diagonal3D;
        this.minX = model.minX;
        this.maxZ = model.maxZ;
        this.minZ = model.minZ;
        this.maxX = model.maxX;
        this.vertexNormalsX = model.vertexNormalsX;
        this.vertexNormalsY = model.vertexNormalsY;
        this.vertexNormalsZ = model.vertexNormalsZ;
    }

    public void replaceModel(Model model, boolean replaceAlpha) {
        this.verticesCount = model.verticesCount;
        this.trianglesCount = model.trianglesCount;
        this.texturesCount = model.texturesCount;
        if (sharedVerticesX.length < this.verticesCount) {
            sharedVerticesX = new int[this.verticesCount + 100];
            sharedVerticesY = new int[this.verticesCount + 100];
            sharedVerticesZ = new int[this.verticesCount + 100];
        }
        this.verticesX = sharedVerticesX;
        this.verticesY = sharedVerticesY;
        this.verticesZ = sharedVerticesZ;
        for (int point = 0; point < this.verticesCount; ++point) {
            this.verticesX[point] = model.verticesX[point];
            this.verticesY[point] = model.verticesY[point];
            this.verticesZ[point] = model.verticesZ[point];
        }
        if (replaceAlpha) {
            this.triangleAlpha = model.triangleAlpha;
        } else {
            if (sharedTriangleAlpha.length < this.trianglesCount) {
                sharedTriangleAlpha = new byte[this.trianglesCount + 100];
            }
            this.triangleAlpha = sharedTriangleAlpha;
            if (model.triangleAlpha == null) {
                for (int face = 0; face < this.trianglesCount; ++face) {
                    this.triangleAlpha[face] = 0;
                }
            } else {
                System.arraycopy(model.triangleAlpha, 0, this.triangleAlpha, 0, this.trianglesCount);
            }
        }
        this.drawType = model.drawType;
        this.colors = model.colors;
        this.renderPriorities = model.renderPriorities;
        this.facePriority = model.facePriority;
        this.faceGroups = model.faceGroups;
        this.vertexGroups = model.vertexGroups;
        this.trianglesX = model.trianglesX;
        this.trianglesY = model.trianglesY;
        this.trianglesZ = model.trianglesZ;
        this.colorsX = model.colorsX;
        this.colorsY = model.colorsY;
        this.colorsZ = model.colorsZ;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.textures = model.textures;
        this.textureTypes = model.textureTypes;
        this.materials = model.materials;
        this.vertexNormalsOffsets = model.vertexNormalsOffsets;
        this.vertexNormalsX = model.vertexNormalsX;
        this.vertexNormalsY = model.vertexNormalsY;
        this.vertexNormalsZ = model.vertexNormalsZ;
        this.resetBounds();
    }

    private int getFirstIdenticalVertexId(Model model, int vertex) {
        int vertexId = -1;
        int x = model.verticesX[vertex];
        int y = model.verticesY[vertex];
        int z = model.verticesZ[vertex];
        for (int v = 0; v < this.verticesCount; ++v) {
            if (x != this.verticesX[v] || y != this.verticesY[v] || z != this.verticesZ[v]) continue;
            vertexId = v;
            break;
        }
        if (vertexId == -1) {
            this.verticesX[this.verticesCount] = x;
            this.verticesY[this.verticesCount] = y;
            this.verticesZ[this.verticesCount] = z;
            if (model.vertexData != null) {
                this.vertexData[this.verticesCount] = model.vertexData[vertex];
            }
            vertexId = this.verticesCount++;
        }
        return vertexId;
    }

    @Override
    public void calculateBoundsCylinder() {
        if (this.boundsType != 1) {
            this.boundsType = 1;
            this.modelBaseY = 0;
            this.diagonal2DAboveOrigin = 0;
            this.maxY = 0;
            for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
                int bounds;
                int x = this.verticesX[vertex];
                int y = this.verticesY[vertex];
                int z = this.verticesZ[vertex];
                if (-y > this.modelBaseY) {
                    this.modelBaseY = -y;
                }
                if (y > this.maxY) {
                    this.maxY = y;
                }
                if ((bounds = x * x + z * z) <= this.diagonal2DAboveOrigin) continue;
                this.diagonal2DAboveOrigin = bounds;
            }
            this.diagonal2DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin) + 0.99);
            this.diagonal3DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.modelBaseY * this.modelBaseY) + 0.99);
            this.diagonal3D = this.diagonal3DAboveOrigin + (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.maxY * this.maxY) + 0.99);
        }
    }

    void calculateDiagonals() {
        if (this.boundsType != 2) {
            this.boundsType = 2;
            this.diagonal2DAboveOrigin = 0;
            for (int count = 0; count < this.verticesCount; ++count) {
                int x = this.verticesX[count];
                int z = this.verticesZ[count];
                int y = this.verticesY[count];
                int bounds = x * x + z * z + y * y;
                if (bounds <= this.diagonal2DAboveOrigin) continue;
                this.diagonal2DAboveOrigin = bounds;
            }
            this.diagonal3DAboveOrigin = this.diagonal2DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin) + 0.99);
            this.diagonal3D = this.diagonal2DAboveOrigin + this.diagonal2DAboveOrigin;
        }
    }

    public void normalise() {
        this.modelBaseY = 0;
        this.maxY = 0;
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int y = this.verticesY[vertex];
            if (-y > this.modelBaseY) {
                this.modelBaseY = -y;
            }
            if (y <= this.maxY) continue;
            this.maxY = y;
        }
        this.diagonal3DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.modelBaseY * this.modelBaseY) + 0.99);
        this.diagonal3D = this.diagonal3DAboveOrigin + (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.maxY * this.maxY) + 0.99);
    }

    public void calculateBounds() {
        if (!this.isBoundsCalculated) {
            this.modelBaseY = 0;
            this.diagonal2DAboveOrigin = 0;
            this.maxY = 0;
            this.minX = 999999;
            this.maxX = -999999;
            this.maxZ = -99999;
            this.minZ = 99999;
            for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
                int bounds;
                int x = this.verticesX[vertex];
                int y = this.verticesY[vertex];
                int z = this.verticesZ[vertex];
                if (x < this.minX) {
                    this.minX = x;
                }
                if (x > this.maxX) {
                    this.maxX = x;
                }
                if (z < this.minZ) {
                    this.minZ = z;
                }
                if (z > this.maxZ) {
                    this.maxZ = z;
                }
                if (-y > this.modelBaseY) {
                    this.modelBaseY = -y;
                }
                if (y > this.maxY) {
                    this.maxY = y;
                }
                if ((bounds = x * x + z * z) <= this.diagonal2DAboveOrigin) continue;
                this.diagonal2DAboveOrigin = bounds;
            }
            this.isBoundsCalculated = true;
        }
    }

    public void generateBones() {
        if (this.vertexData != null) {
            int[] ai = new int[256];
            int j = 0;
            for (int l = 0; l < this.verticesCount; ++l) {
                int j1;
                int n = j1 = this.vertexData[l];
                ai[n] = ai[n] + 1;
                if (j1 <= j) continue;
                j = j1;
            }
            this.vertexGroups = new int[j + 1][];
            for (int k1 = 0; k1 <= j; ++k1) {
                this.vertexGroups[k1] = new int[ai[k1]];
                ai[k1] = 0;
            }
            int j2 = 0;
            while (j2 < this.verticesCount) {
                int l2;
                int n = l2 = this.vertexData[j2];
                int n2 = ai[n];
                ai[n] = n2 + 1;
                this.vertexGroups[l2][n2] = j2++;
            }
            this.vertexData = null;
        }
        if (this.triangleData != null) {
            int[] ai1 = new int[256];
            int k = 0;
            for (int i1 = 0; i1 < this.trianglesCount; ++i1) {
                int l1;
                int n = l1 = this.triangleData[i1];
                ai1[n] = ai1[n] + 1;
                if (l1 <= k) continue;
                k = l1;
            }
            this.faceGroups = new int[k + 1][];
            for (int uid = 0; uid <= k; ++uid) {
                this.faceGroups[uid] = new int[ai1[uid]];
                ai1[uid] = 0;
            }
            int k2 = 0;
            while (k2 < this.trianglesCount) {
                int i3;
                int n = i3 = this.triangleData[k2];
                int n3 = ai1[n];
                ai1[n] = n3 + 1;
                this.faceGroups[i3][n3] = k2++;
            }
            this.triangleData = null;
        }
    }

    private void transform(int animationType, int[] skinArray, int x, int y, int z) {
        int length = skinArray.length;
        if (animationType == 0) {
            int i = 0;
            transformTempX = 0;
            transformTempY = 0;
            transformTempZ = 0;
            for (int k2 = 0; k2 < length; ++k2) {
                int skin = skinArray[k2];
                if (skin >= this.vertexGroups.length) continue;
                int[] group = this.vertexGroups[skin];
                for (int i5 = 0; i5 < group.length; ++i5) {
                    int offset = group[i5];
                    transformTempX += this.verticesX[offset];
                    transformTempY += this.verticesY[offset];
                    transformTempZ += this.verticesZ[offset];
                    ++i;
                }
            }
            if (i > 0) {
                transformTempX = transformTempX / i + x;
                transformTempY = transformTempY / i + y;
                transformTempZ = transformTempZ / i + z;
                return;
            }
            transformTempX = x;
            transformTempY = y;
            transformTempZ = z;
            return;
        }
        if (animationType == 1) {
            for (int k1 = 0; k1 < length; ++k1) {
                int skin = skinArray[k1];
                if (skin >= this.vertexGroups.length) continue;
                int[] group = this.vertexGroups[skin];
                for (int i4 = 0; i4 < group.length; ++i4) {
                    int offset;
                    int n = offset = group[i4];
                    this.verticesX[n] = this.verticesX[n] + x;
                    int n2 = offset;
                    this.verticesY[n2] = this.verticesY[n2] + y;
                    int n3 = offset;
                    this.verticesZ[n3] = this.verticesZ[n3] + z;
                }
            }
            return;
        }
        if (animationType == 2) {
            for (int l1 = 0; l1 < length; ++l1) {
                int skin = skinArray[l1];
                if (skin >= this.vertexGroups.length) continue;
                int[] group = this.vertexGroups[skin];
                for (int j4 = 0; j4 < group.length; ++j4) {
                    int loc;
                    int cos;
                    int sin;
                    int offset;
                    int n = offset = group[j4];
                    this.verticesX[n] = this.verticesX[n] - transformTempX;
                    int n4 = offset;
                    this.verticesY[n4] = this.verticesY[n4] - transformTempY;
                    int n5 = offset;
                    this.verticesZ[n5] = this.verticesZ[n5] - transformTempZ;
                    int xOff = (x & 0xFF) * 8;
                    int yOff = (y & 0xFF) * 8;
                    int zOff = (z & 0xFF) * 8;
                    if (zOff != 0) {
                        sin = SINE[zOff];
                        cos = COSINE[zOff];
                        loc = this.verticesY[offset] * sin + this.verticesX[offset] * cos >> 16;
                        this.verticesY[offset] = this.verticesY[offset] * cos - this.verticesX[offset] * sin >> 16;
                        this.verticesX[offset] = loc;
                    }
                    if (xOff != 0) {
                        sin = SINE[xOff];
                        cos = COSINE[xOff];
                        loc = this.verticesY[offset] * cos - this.verticesZ[offset] * sin >> 16;
                        this.verticesZ[offset] = this.verticesY[offset] * sin + this.verticesZ[offset] * cos >> 16;
                        this.verticesY[offset] = loc;
                    }
                    if (yOff != 0) {
                        sin = SINE[yOff];
                        cos = COSINE[yOff];
                        loc = this.verticesZ[offset] * sin + this.verticesX[offset] * cos >> 16;
                        this.verticesZ[offset] = this.verticesZ[offset] * cos - this.verticesX[offset] * sin >> 16;
                        this.verticesX[offset] = loc;
                    }
                    int n6 = offset;
                    this.verticesX[n6] = this.verticesX[n6] + transformTempX;
                    int n7 = offset;
                    this.verticesY[n7] = this.verticesY[n7] + transformTempY;
                    int n8 = offset;
                    this.verticesZ[n8] = this.verticesZ[n8] + transformTempZ;
                }
            }
            return;
        }
        if (animationType == 3) {
            for (int uid = 0; uid < length; ++uid) {
                int skin = skinArray[uid];
                if (skin >= this.vertexGroups.length) continue;
                int[] group = this.vertexGroups[skin];
                for (int k4 = 0; k4 < group.length; ++k4) {
                    int offset;
                    int n = offset = group[k4];
                    this.verticesX[n] = this.verticesX[n] - transformTempX;
                    int n9 = offset;
                    this.verticesY[n9] = this.verticesY[n9] - transformTempY;
                    int n10 = offset;
                    this.verticesZ[n10] = this.verticesZ[n10] - transformTempZ;
                    this.verticesX[offset] = this.verticesX[offset] * x / 128;
                    this.verticesY[offset] = this.verticesY[offset] * y / 128;
                    this.verticesZ[offset] = this.verticesZ[offset] * z / 128;
                    int n11 = offset;
                    this.verticesX[n11] = this.verticesX[n11] + transformTempX;
                    int n12 = offset;
                    this.verticesY[n12] = this.verticesY[n12] + transformTempY;
                    int n13 = offset;
                    this.verticesZ[n13] = this.verticesZ[n13] + transformTempZ;
                }
            }
            return;
        }
        if (animationType == 5 && this.faceGroups != null && this.triangleAlpha != null) {
            for (int j2 = 0; j2 < length; ++j2) {
                int skin = skinArray[j2];
                if (skin >= this.faceGroups.length) continue;
                int[] group = this.faceGroups[skin];
                for (int l4 = 0; l4 < group.length; ++l4) {
                    int var13 = group[l4];
                    int var14 = (this.triangleAlpha[var13] & 0xFF) + x * 8;
                    if (var14 < 0) {
                        var14 = 0;
                    } else if (var14 > 255) {
                        var14 = 255;
                    }
                    this.triangleAlpha[var13] = (byte)var14;
                }
            }
        }
    }

    public void animate(int frameId) {
        if (this.vertexGroups == null) {
            return;
        }
        if (frameId == -1) {
            return;
        }
        Frame frame = Frame.method531(frameId);
        if (frame == null) {
            return;
        }
        FrameBase base = frame.base;
        transformTempX = 0;
        transformTempY = 0;
        transformTempZ = 0;
        for (int k = 0; k < frame.transformationCount; ++k) {
            int l = frame.transformationIndices[k];
            this.transform(base.transformationType[l], base.skinList[l], frame.transformX[k], frame.transformY[k], frame.transformZ[k]);
        }
        this.resetBounds();
        this.invalidate();
    }

    public void animate2(int[] label, int idle, int current) {
        int condition;
        int index;
        if (current == -1) {
            return;
        }
        if (label == null || idle == -1) {
            this.animate(current);
            return;
        }
        Frame anim = Frame.method531(current);
        if (anim == null) {
            return;
        }
        Frame skin = Frame.method531(idle);
        if (skin == null) {
            this.animate(current);
            return;
        }
        FrameBase list = anim.base;
        transformTempX = 0;
        transformTempY = 0;
        transformTempZ = 0;
        int id = 0;
        int table = label[id++];
        for (index = 0; index < anim.transformationCount; ++index) {
            condition = anim.transformationIndices[index];
            while (condition > table) {
                table = label[id++];
            }
            if (condition == table && list.transformationType[condition] != 0) continue;
            this.transform(list.transformationType[condition], list.skinList[condition], anim.transformX[index], anim.transformY[index], anim.transformZ[index]);
        }
        transformTempX = 0;
        transformTempY = 0;
        transformTempZ = 0;
        id = 0;
        table = label[id++];
        for (index = 0; index < skin.transformationCount; ++index) {
            condition = skin.transformationIndices[index];
            while (condition > table) {
                table = label[id++];
            }
            if (condition != table && list.transformationType[condition] != 0) continue;
            this.transform(list.transformationType[condition], list.skinList[condition], skin.transformX[index], skin.transformY[index], skin.transformZ[index]);
        }
        this.resetBounds();
        this.invalidate();
    }

    public void rotate90Degrees() {
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int x = this.verticesX[vertex];
            this.verticesX[vertex] = this.verticesZ[vertex];
            this.verticesZ[vertex] = -x;
        }
        this.resetBounds();
        this.invalidate();
    }

    public void rotateZ(int factor) {
        int sin = SINE[factor];
        int cos = COSINE[factor];
        for (int point = 0; point < this.verticesCount; ++point) {
            int y = this.verticesY[point] * cos - this.verticesZ[point] * sin >> 16;
            this.verticesZ[point] = this.verticesY[point] * sin + this.verticesZ[point] * cos >> 16;
            this.verticesY[point] = y;
        }
        this.resetBounds();
        this.invalidate();
    }

    public void offsetBy(int x, int y, int z) {
        int point = 0;
        while (point < this.verticesCount) {
            int n = point;
            this.verticesX[n] = this.verticesX[n] + x;
            int n2 = point;
            this.verticesY[n2] = this.verticesY[n2] + y;
            int n3 = point++;
            this.verticesZ[n3] = this.verticesZ[n3] + z;
        }
        this.resetBounds();
        this.invalidate();
    }

    public void recolor(int found, int replace) {
        if (this.colors != null) {
            for (int face = 0; face < this.trianglesCount; ++face) {
                if (this.colors[face] != (short)found) continue;
                this.colors[face] = (short)replace;
            }
        }
    }

    public void retexture(short found, short replace) {
        if (this.materials != null) {
            for (int face = 0; face < this.trianglesCount; ++face) {
                if (this.materials[face] != found) continue;
                this.materials[face] = replace;
            }
        }
    }

    public void mirror() {
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            this.verticesZ[vertex] = -this.verticesZ[vertex];
        }
        for (int face = 0; face < this.trianglesCount; ++face) {
            int newTriangleZ = this.trianglesX[face];
            this.trianglesX[face] = this.trianglesZ[face];
            this.trianglesZ[face] = newTriangleZ;
        }
    }

    public void scale(int x, int z, int y) {
        for (int index = 0; index < this.verticesCount; ++index) {
            this.verticesX[index] = this.verticesX[index] * x / 128;
            this.verticesY[index] = this.verticesY[index] * y / 128;
            this.verticesZ[index] = this.verticesZ[index] * z / 128;
        }
        this.resetBounds();
        this.invalidate();
    }

    public void calculateVertexNormals() {
        if (this.normals == null) {
            int var1;
            this.normals = new VertexNormal[this.verticesCount];
            for (var1 = 0; var1 < this.verticesCount; ++var1) {
                this.normals[var1] = new VertexNormal();
            }
            for (var1 = 0; var1 < this.trianglesCount; ++var1) {
                int var13;
                int var2 = this.trianglesX[var1];
                int var3 = this.trianglesY[var1];
                int var4 = this.trianglesZ[var1];
                int var5 = this.verticesX[var3] - this.verticesX[var2];
                int var6 = this.verticesY[var3] - this.verticesY[var2];
                int var7 = this.verticesZ[var3] - this.verticesZ[var2];
                int var8 = this.verticesX[var4] - this.verticesX[var2];
                int var9 = this.verticesY[var4] - this.verticesY[var2];
                int var10 = this.verticesZ[var4] - this.verticesZ[var2];
                int var11 = var6 * var10 - var9 * var7;
                int var12 = var7 * var8 - var10 * var5;
                for (var13 = var5 * var9 - var8 * var6; var11 > 8192 || var12 > 8192 || var13 > 8192 || var11 < -8192 || var12 < -8192 || var13 < -8192; var11 >>= 1, var12 >>= 1, var13 >>= 1) {
                }
                int var14 = (int)Math.sqrt(var11 * var11 + var12 * var12 + var13 * var13);
                if (var14 <= 0) {
                    var14 = 1;
                }
                var11 = var11 * 256 / var14;
                var12 = var12 * 256 / var14;
                var13 = var13 * 256 / var14;
                int var15 = this.drawType == null ? 0 : this.drawType[var1];
                if (var15 == 0) {
                    VertexNormal var16 = this.normals[var2];
                    var16.x += var11;
                    var16.y += var12;
                    var16.z += var13;
                    ++var16.magnitude;
                    var16 = this.normals[var3];
                    var16.x += var11;
                    var16.y += var12;
                    var16.z += var13;
                    ++var16.magnitude;
                    var16 = this.normals[var4];
                    var16.x += var11;
                    var16.y += var12;
                    var16.z += var13;
                    ++var16.magnitude;
                    continue;
                }
                if (var15 != 1) continue;
                if (this.faceNormals == null) {
                    this.faceNormals = new FaceNormal[this.trianglesCount];
                }
                FaceNormal var17 = this.faceNormals[var1] = new FaceNormal();
                var17.x = var11;
                var17.y = var12;
                var17.z = var13;
            }
        }
    }

    public void light(int ambient, int contrast, int x, int y, int z, boolean flatShading) {
        this.calculateVertexNormals();
        int magnitude = (int)Math.sqrt(z * z + x * x + y * y);
        int var7 = magnitude * contrast >> 8;
        Model model = new Model();
        model.colorsX = new int[this.trianglesCount];
        model.colorsY = new int[this.trianglesCount];
        model.colorsZ = new int[this.trianglesCount];
        if (this.texturesCount > 0 && this.textures != null) {
            int var11;
            int var10;
            int[] var9 = new int[this.texturesCount];
            for (var10 = 0; var10 < this.trianglesCount; ++var10) {
                if (this.textures[var10] == -1) continue;
                int n = this.textures[var10] & 0xFF;
                var9[n] = var9[n] + 1;
            }
            model.texturesCount = 0;
            for (var10 = 0; var10 < this.texturesCount; ++var10) {
                if (var9[var10] <= 0 || this.textureTypes[var10] != 0) continue;
                ++model.texturesCount;
            }
            model.texturesX = new int[model.texturesCount];
            model.texturesY = new int[model.texturesCount];
            model.texturesZ = new int[model.texturesCount];
            var10 = 0;
            for (var11 = 0; var11 < this.texturesCount; ++var11) {
                if (var9[var11] > 0 && this.textureTypes[var11] == 0) {
                    model.texturesX[var10] = (short)(this.texturesX[var11] & 0xFFFF);
                    model.texturesY[var10] = (short)(this.texturesY[var11] & 0xFFFF);
                    model.texturesZ[var10] = (short)(this.texturesZ[var11] & 0xFFFF);
                    var9[var11] = var10++;
                    continue;
                }
                var9[var11] = -1;
            }
            model.textures = new byte[this.trianglesCount];
            for (var11 = 0; var11 < this.trianglesCount; ++var11) {
                model.textures[var11] = this.textures[var11] != -1 ? (int)var9[this.textures[var11] & 0xFF] : -1;
            }
        }
        for (int var16 = 0; var16 < this.trianglesCount; ++var16) {
            VertexNormal var13;
            int var14;
            FaceNormal var19;
            int var17 = this.drawType == null ? 0 : this.drawType[var16];
            byte var18 = this.triangleAlpha == null ? (byte)0 : this.triangleAlpha[var16];
            int var12 = this.materials == null ? -1 : this.materials[var16];
            if (var18 == -2) {
                var17 = 3;
            }
            if (var18 == -1) {
                var17 = 2;
            }
            if (var12 == -1) {
                if (var17 != 0) {
                    if (var17 == 1) {
                        var19 = this.faceNormals[var16];
                        var14 = (y * var19.y + z * var19.z + x * var19.x) / (var7 / 2 + var7) + ambient;
                        model.colorsX[var16] = Model.light(this.colors[var16] & 0xFFFF, var14);
                        model.colorsZ[var16] = -1;
                        continue;
                    }
                    if (var17 == 3) {
                        model.colorsX[var16] = 128;
                        model.colorsZ[var16] = -1;
                        continue;
                    }
                    model.colorsZ[var16] = -2;
                    continue;
                }
                int var15 = this.colors[var16] & 0xFFFF;
                var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesX[var16]] != null ? this.vertexNormalsOffsets[this.trianglesX[var16]] : this.normals[this.trianglesX[var16]];
                var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
                model.colorsX[var16] = Model.light(var15, var14);
                var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesY[var16]] != null ? this.vertexNormalsOffsets[this.trianglesY[var16]] : this.normals[this.trianglesY[var16]];
                var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
                model.colorsY[var16] = Model.light(var15, var14);
                var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesZ[var16]] != null ? this.vertexNormalsOffsets[this.trianglesZ[var16]] : this.normals[this.trianglesZ[var16]];
                var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
                model.colorsZ[var16] = Model.light(var15, var14);
                continue;
            }
            if (var17 != 0) {
                if (var17 == 1) {
                    var19 = this.faceNormals[var16];
                    var14 = (y * var19.y + z * var19.z + x * var19.x) / (var7 / 2 + var7) + ambient;
                    model.colorsX[var16] = Model.light(var14);
                    model.colorsZ[var16] = -1;
                    continue;
                }
                model.colorsZ[var16] = -2;
                continue;
            }
            var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesX[var16]] != null ? this.vertexNormalsOffsets[this.trianglesX[var16]] : this.normals[this.trianglesX[var16]];
            var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
            model.colorsX[var16] = Model.light(var14);
            var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesY[var16]] != null ? this.vertexNormalsOffsets[this.trianglesY[var16]] : this.normals[this.trianglesY[var16]];
            var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
            model.colorsY[var16] = Model.light(var14);
            var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesZ[var16]] != null ? this.vertexNormalsOffsets[this.trianglesZ[var16]] : this.normals[this.trianglesZ[var16]];
            var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
            model.colorsZ[var16] = Model.light(var14);
        }
        this.generateBones();
        model.verticesCount = this.verticesCount;
        model.verticesX = this.verticesX;
        model.verticesY = this.verticesY;
        model.verticesZ = this.verticesZ;
        model.trianglesCount = this.trianglesCount;
        model.trianglesX = this.trianglesX;
        model.trianglesY = this.trianglesY;
        model.trianglesZ = this.trianglesZ;
        model.renderPriorities = this.renderPriorities;
        model.triangleAlpha = this.triangleAlpha;
        model.facePriority = this.facePriority;
        model.vertexGroups = this.vertexGroups;
        model.faceGroups = this.faceGroups;
        model.materials = this.materials;
        model.animayaGroups = this.animayaGroups;
        model.animayaScales = this.animayaScales;
        this.colorsX = model.colorsX;
        this.colorsY = model.colorsY;
        this.colorsZ = model.colorsZ;
        this.texturesCount = model.texturesCount;
        this.textures = model.textures;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.texturesZ = model.texturesZ;
        if (flatShading) {
            this.calculateBoundsCylinder();
        } else {
            this.vertexNormalsOffsets = new VertexNormal[this.verticesCount];
            for (int point = 0; point < this.verticesCount; ++point) {
                VertexNormal norm = this.normals[point];
                VertexNormal merge = this.vertexNormalsOffsets[point] = new VertexNormal();
                merge.x = norm.x;
                merge.y = norm.y;
                merge.z = norm.z;
                merge.magnitude = norm.magnitude;
            }
            this.calculateBounds();
        }
        this.resetBounds();
        if (this.textures == null) {
            this.vertexNormals();
        }
        VertexNormal[] vertexNormals2 = this.normals;
        VertexNormal[] vertexVertices = this.vertexNormalsOffsets;
        if (vertexNormals2 != null && this.vertexNormalsX == null) {
            int verticesCount = this.getVerticesCount();
            this.vertexNormalsX = new int[verticesCount];
            this.vertexNormalsY = new int[verticesCount];
            this.vertexNormalsZ = new int[verticesCount];
            for (int i = 0; i < verticesCount; ++i) {
                VertexNormal vertexNormal;
                if (vertexVertices != null && (vertexNormal = vertexVertices[i]) != null) {
                    this.vertexNormalsX[i] = vertexNormal.getX();
                    this.vertexNormalsY[i] = vertexNormal.getY();
                    this.vertexNormalsZ[i] = vertexNormal.getZ();
                    continue;
                }
                vertexNormal = vertexNormals2[i];
                if (vertexNormal == null) continue;
                this.vertexNormalsX[i] = vertexNormal.getX();
                this.vertexNormalsY[i] = vertexNormal.getY();
                this.vertexNormalsZ[i] = vertexNormal.getZ();
            }
        }
        this.normals = model.normals;
        this.vertexNormalsOffsets = model.vertexNormalsOffsets;
    }

    public final void setLighting(int intensity, int specular, int x, int y, int z) {
        this.setLighting(intensity, specular, x, y, z, false);
    }

    public final void setLighting(int intensity, int specular, int x, int y, int z, boolean player) {
        int face;
        for (face = 0; face < this.trianglesCount; ++face) {
            int a = this.trianglesX[face];
            int b = this.trianglesY[face];
            int c = this.trianglesZ[face];
            if (this.materials != null && player) {
                if (this.triangleAlpha != null && this.colors != null) {
                    if (this.colors[face] == 0 && this.renderPriorities[face] == 0 && this.drawType[face] == 2 && this.materials[face] == -1) {
                        this.triangleAlpha[face] = -1;
                    }
                } else if (this.triangleAlpha == null && this.colors[face] == 0 && this.renderPriorities[face] == 0 && this.materials[face] == -1) {
                    this.triangleAlpha = new byte[this.trianglesCount];
                }
            }
            if (this.drawType == null) {
                int hsl = this.colors[face] & 0xFFFF;
                VertexNormal vertex = this.normals[a];
                int dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
                this.colorsX[face] = Model.light(hsl, dir_light_intensity, 0);
                vertex = this.normals[b];
                dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
                this.colorsY[face] = Model.light(hsl, dir_light_intensity, 0);
                vertex = this.normals[c];
                dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
                this.colorsZ[face] = Model.light(hsl, dir_light_intensity, 0);
                continue;
            }
            if ((this.drawType[face] & 1) != 0) continue;
            int type2 = this.drawType[face];
            int hsl = this.colors[face] & 0xFFFF;
            VertexNormal vertex = this.normals[a];
            int dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
            this.colorsX[face] = Model.light(hsl, dir_light_intensity, type2);
            vertex = this.normals[b];
            dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
            this.colorsY[face] = Model.light(hsl, dir_light_intensity, type2);
            vertex = this.normals[c];
            dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
            this.colorsZ[face] = Model.light(hsl, dir_light_intensity, type2);
        }
        this.normals = null;
        this.vertexNormalsOffsets = null;
        this.vertexData = null;
        this.triangleData = null;
        if (this.drawType != null) {
            for (face = 0; face < this.trianglesCount; ++face) {
                if ((this.drawType[face] & 2) != 2) continue;
                return;
            }
        }
        this.colors = null;
    }

    public static final int light(int light) {
        if (light >= 2) {
            if (light > 126) {
                light = 126;
            }
        } else {
            light = 2;
        }
        return light;
    }

    public static final int light(int hsl, int light) {
        if ((light = light * (hsl & 0x7F) >> 7) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (hsl & 0xFF80) + light;
    }

    public static final int light(int hsl, int light, int type2) {
        if ((type2 & 2) == 2) {
            return Model.light(light);
        }
        return Model.light(hsl, light);
    }

    public void renderModel(int rotationY, int rotationZ, int rotationXW, int translationX, int translationY, int translationZ) {
        if (this.boundsType != 2 && this.boundsType != 1) {
            this.calculateDiagonals();
        }
        int centerX = Rasterizer3D.originViewX;
        int centerY = Rasterizer3D.originViewY;
        int sineY = SINE[rotationY];
        int cosineY = COSINE[rotationY];
        int sineZ = SINE[rotationZ];
        int cosineZ = COSINE[rotationZ];
        int sineXW = SINE[rotationXW];
        int cosineXW = COSINE[rotationXW];
        int transformation = translationY * sineXW + translationZ * cosineXW >> 16;
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int newX;
            int x = this.verticesX[vertex];
            int y = this.verticesY[vertex];
            int z = this.verticesZ[vertex];
            if (rotationZ != 0) {
                newX = y * sineZ + x * cosineZ >> 16;
                y = y * cosineZ - x * sineZ >> 16;
                x = newX;
            }
            if (rotationY != 0) {
                newX = z * sineY + x * cosineY >> 16;
                z = z * cosineY - x * sineY >> 16;
                x = newX;
            }
            int newY = (y += translationY) * cosineXW - (z += translationZ) * sineXW >> 16;
            z = y * sineXW + z * cosineXW >> 16;
            y = newY;
            Model.vertexScreenZ[vertex] = z - transformation;
            Model.vertexScreenX[vertex] = centerX + ((x += translationX) << 9) / z;
            Model.vertexScreenY[vertex] = centerY + (y << 9) / z;
            if (this.texturesCount <= 0) continue;
            Model.vertexMovedX[vertex] = x;
            Model.vertexMovedY[vertex] = y;
            Model.vertexMovedZ[vertex] = z;
        }
        try {
            this.withinObject(false, false, 0L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void cursorCalculations() {
        int mouseX = MouseHandler.mouseX;
        int mouseY = MouseHandler.mouseY;
        if (MouseHandler.lastButton != 0) {
            mouseX = MouseHandler.saveClickX;
            mouseY = MouseHandler.saveClickY;
        }
        if (mouseX >= Client.instance.getViewportXOffset() && mouseX < Client.instance.getViewportXOffset() + Client.instance.getViewportWidth() && mouseY >= Client.instance.getViewportYOffset() && mouseY < Client.instance.getViewportHeight() + Client.instance.getViewportYOffset()) {
            cursorX = mouseX - Client.instance.getViewportXOffset();
            cursorY = mouseY - Client.instance.getViewportYOffset();
            mouseInViewport = true;
        } else {
            mouseInViewport = false;
        }
        objectsHovering = 0;
    }

    @Override
    public void calculateBoundingBox(int orientation) {
        if (!this.aabb.containsKey(orientation)) {
            int minX = 0;
            int minZ = 0;
            int minY = 0;
            int maxX = 0;
            int maxZ = 0;
            int maxY = 0;
            int cosine = COSINE[orientation];
            int sine = SINE[orientation];
            for (int vert = 0; vert < this.verticesCount; ++vert) {
                int x = Rasterizer3D.method4046(this.verticesX[vert], this.verticesZ[vert], cosine, sine);
                int y = this.verticesY[vert];
                int z = Rasterizer3D.method4046(this.verticesX[vert], this.verticesZ[vert], cosine, sine);
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minZ) {
                    minZ = y;
                }
                if (y > maxZ) {
                    maxZ = y;
                }
                if (z < minY) {
                    minY = z;
                }
                if (z <= maxY) continue;
                maxY = z;
            }
            AABB aabb = new AABB((maxX + minX) / 2, (maxZ + minZ) / 2, (maxY + minY) / 2, (maxX - minX + 1) / 2, (maxZ - minZ + 1) / 2, (maxY - minY + 1) / 2);
            if (aabb.xMidOffset < 32) {
                aabb.xMidOffset = 32;
            }
            if (aabb.zMidOffset < 32) {
                aabb.zMidOffset = 32;
            }
            if (this.singleTile) {
                aabb.xMidOffset += 8;
                aabb.zMidOffset += 8;
            }
            this.aabb.put(orientation, aabb);
        }
    }

    @Override
    public byte[] getTextureFaces() {
        return this.textures;
    }

    @Override
    public int[] getTexIndices1() {
        return this.texturesX;
    }

    @Override
    public int[] getTexIndices2() {
        return this.texturesY;
    }

    @Override
    public int[] getTexIndices3() {
        return this.texturesZ;
    }

    @Override
    public final void renderAtPoint(int orientation, int pitchSine, int pitchCos, int yawSin, int yawCos, int offsetX, int offsetY, int offsetZ, long uid) {
        int id;
        int opcode;
        int y;
        int x;
        boolean gpu;
        if (this.boundsType != 1) {
            this.calculateBoundsCylinder();
        }
        this.calculateBoundingBox(orientation);
        int sceneX = offsetZ * yawCos - offsetX * yawSin >> 16;
        int sceneY = offsetY * pitchSine + sceneX * pitchCos >> 16;
        int dimensionSinY = this.diagonal2DAboveOrigin * pitchCos >> 16;
        int pos = sceneY + dimensionSinY;
        boolean bl = gpu = Client.instance.isGpu() && Rasterizer3D.world;
        if (pos <= 50 || sceneY >= 3500 && !gpu) {
            return;
        }
        int xRot = offsetZ * yawSin + offsetX * yawCos >> 16;
        int objX = (xRot - this.diagonal2DAboveOrigin) * Rasterizer3D.fieldOfView;
        if (objX / pos >= Rasterizer2D.viewportCenterX) {
            return;
        }
        int objWidth = (xRot + this.diagonal2DAboveOrigin) * Rasterizer3D.fieldOfView;
        if (objWidth / pos <= -Rasterizer2D.viewportCenterX) {
            return;
        }
        int yRot = offsetY * pitchCos - sceneX * pitchSine >> 16;
        int dimensionCosY = this.diagonal2DAboveOrigin * pitchSine >> 16;
        int var20 = (pitchCos * this.maxY >> 16) + dimensionCosY;
        int objHeight = (yRot + var20) * Rasterizer3D.fieldOfView;
        if (objHeight / pos <= -Rasterizer2D.viewportCenterY) {
            return;
        }
        int offset = dimensionCosY + (this.modelBaseY * pitchCos >> 16);
        int objY = (yRot - offset) * Rasterizer3D.fieldOfView;
        if (objY / pos >= Rasterizer2D.viewportCenterY) {
            return;
        }
        int size = dimensionSinY + (this.modelBaseY * pitchSine >> 16);
        boolean var25 = false;
        boolean nearSight = false;
        if (sceneY - size <= 50) {
            nearSight = true;
        }
        boolean inView = nearSight || this.texturesCount > 0;
        boolean highlighted = false;
        if (this.DEBUG_MODELS) {
            x = ObjectKeyUtil.getObjectX(uid);
            y = ObjectKeyUtil.getObjectY(uid);
            opcode = ObjectKeyUtil.getObjectOpcode(uid);
            id = ObjectKeyUtil.getObjectId(uid);
            System.out.println("Render at Point , ID: " + id + " at " + x + ", " + y + " = " + uid);
        }
        if (uid > 0L && mouseInViewport) {
            if (this.DEBUG_MODELS) {
                x = ObjectKeyUtil.getObjectX(uid);
                y = ObjectKeyUtil.getObjectY(uid);
                opcode = ObjectKeyUtil.getObjectOpcode(uid);
                id = ObjectKeyUtil.getObjectId(uid);
                System.out.println("Render at Point Hover, ID: " + id + " at " + x + ", " + y + " = " + uid);
            }
            boolean withinBounds = false;
            int distanceMin = 50;
            int distanceMax = 3500;
            int var43 = (cursorX - Rasterizer3D.originViewX) * distanceMin / Rasterizer3D.fieldOfView;
            int var44 = (cursorY - Rasterizer3D.originViewY) * distanceMin / Rasterizer3D.fieldOfView;
            int var45 = (cursorX - Rasterizer3D.originViewX) * distanceMax / Rasterizer3D.fieldOfView;
            int var46 = (cursorY - Rasterizer3D.originViewY) * distanceMax / Rasterizer3D.fieldOfView;
            int var47 = Rasterizer3D.method4045(var44, distanceMin, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            int var53 = Rasterizer3D.method4046(var44, distanceMin, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            var44 = var47;
            var47 = Rasterizer3D.method4045(var46, distanceMax, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            int var54 = Rasterizer3D.method4046(var46, distanceMax, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            var46 = var47;
            var47 = Rasterizer3D.method4025(var43, var53, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            var53 = Rasterizer3D.method4044(var43, var53, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            var43 = var47;
            var47 = Rasterizer3D.method4025(var45, var54, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            var54 = Rasterizer3D.method4044(var45, var54, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            int ViewportMouse_field2588 = (var43 + var47) / 2;
            int GZipDecompressor_field4821 = (var46 + var44) / 2;
            int class340_field4138 = (var54 + var53) / 2;
            int ViewportMouse_field2589 = (var47 - var43) / 2;
            int ItemComposition_field2148 = (var46 - var44) / 2;
            int User_field4308 = (var54 - var53) / 2;
            int class421_field4607 = Math.abs(ViewportMouse_field2589);
            int ViewportMouse_field2590 = Math.abs(ItemComposition_field2148);
            int class136_field1612 = Math.abs(User_field4308);
            AABB var50 = (AABB)this.aabb.get(orientation);
            int var37 = offsetX + var50.xMid;
            int var38 = offsetY + var50.yMid;
            int var39 = offsetZ + var50.zMid;
            var43 = ViewportMouse_field2588 - var37;
            var44 = GZipDecompressor_field4821 - var38;
            var45 = class340_field4138 - var39;
            withinBounds = Math.abs(var43) > var50.xMidOffset + class421_field4607 ? false : (Math.abs(var44) > var50.yMidOffset + ViewportMouse_field2590 ? false : (Math.abs(var45) > var50.zMidOffset + class136_field1612 ? false : (Math.abs(var45 * ItemComposition_field2148 - var44 * User_field4308) > var50.yMidOffset * class136_field1612 + var50.zMidOffset * ViewportMouse_field2590 ? false : (Math.abs(var43 * User_field4308 - var45 * ViewportMouse_field2589) > var50.zMidOffset * class421_field4607 + var50.xMidOffset * class136_field1612 ? false : Math.abs(var44 * ViewportMouse_field2589 - var43 * ItemComposition_field2148) <= var50.xMidOffset * ViewportMouse_field2590 + var50.yMidOffset * class421_field4607))));
            if (withinBounds) {
                if (this.singleTile) {
                    Model.hoveringObjects[Model.objectsHovering++] = uid;
                } else {
                    highlighted = true;
                }
            }
        }
        int sineX = 0;
        int cosineX = 0;
        if (orientation != 0) {
            sineX = SINE[orientation];
            cosineX = COSINE[orientation];
        }
        for (int index = 0; index < this.verticesCount; ++index) {
            int positionX = this.verticesX[index];
            int rasterY = this.verticesY[index];
            int positionZ = this.verticesZ[index];
            if (orientation != 0) {
                int rotatedX = positionZ * sineX + positionX * cosineX >> 16;
                positionZ = positionZ * cosineX - positionX * sineX >> 16;
                positionX = rotatedX;
            }
            int positionY = (positionZ += offsetZ) * yawSin + yawCos * (positionX += offsetX) >> 16;
            positionZ = yawCos * positionZ - positionX * yawSin >> 16;
            positionX = positionY;
            positionY = pitchCos * (rasterY += offsetY) - positionZ * pitchSine >> 16;
            positionZ = rasterY * pitchSine + pitchCos * positionZ >> 16;
            Model.vertexScreenZ[index] = positionZ - sceneY;
            if (positionZ >= 50) {
                Model.vertexScreenX[index] = positionX * Rasterizer3D.fieldOfView / positionZ + Rasterizer3D.originViewX;
                Model.vertexScreenY[index] = positionY * Rasterizer3D.fieldOfView / positionZ + Rasterizer3D.originViewY;
            } else {
                Model.vertexScreenX[index] = -5000;
                var25 = true;
            }
            if (!inView) continue;
            Model.vertexMovedX[index] = positionX;
            Model.vertexMovedY[index] = positionY;
            Model.vertexMovedZ[index] = positionZ;
        }
        try {
            if (!gpu || highlighted && !(Math.sqrt(offsetX * offsetX + offsetZ * offsetZ) > 4480.0)) {
                this.withinObject(var25, highlighted, uid);
            }
            if (gpu) {
                Client.instance.getDrawCallbacks().draw(this, orientation, pitchSine, pitchCos, yawSin, yawCos, offsetX, offsetY, offsetZ, uid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean inBounds(int x, int y, int z, int screenX, int screenY, int screenZ, int size) {
        int height = cursorY + size;
        if (height < x && height < y && height < z) {
            return false;
        }
        height = cursorY - size;
        if (height > x && height > y && height > z) {
            return false;
        }
        height = cursorX + size;
        if (height < screenX && height < screenY && height < screenZ) {
            return false;
        }
        height = cursorX - size;
        return height <= screenX || height <= screenY || height <= screenZ;
    }

    final void withinObject(boolean var25, boolean highlighted, long uid) {
        try {
            boolean gpu;
            boolean bl = gpu = Client.instance.isGpu() && Rasterizer3D.world;
            if (this.diagonal3D < 6000) {
                int var18;
                int var16;
                int var15;
                for (int diagonalIndex = 0; diagonalIndex < this.diagonal3D; ++diagonalIndex) {
                    Model.depth[diagonalIndex] = 0;
                }
                int size = this.singleTile ? 20 : 5;
                for (int currentTriangle = 0; currentTriangle < this.trianglesCount; ++currentTriangle) {
                    int var26;
                    int var25a;
                    int var24;
                    int index;
                    if (this.colorsZ[currentTriangle] == -2) continue;
                    int triX = this.trianglesX[currentTriangle];
                    int triY = this.trianglesY[currentTriangle];
                    int triZ = this.trianglesZ[currentTriangle];
                    int screenXX = vertexScreenX[triX];
                    int screenXY = vertexScreenX[triY];
                    int screenXZ = vertexScreenX[triZ];
                    if (gpu) {
                        if (screenXX == -5000 || screenXY == -5000 || screenXZ == -5000 || !highlighted || !this.inBounds(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], screenXX, screenXY, screenXZ, size)) continue;
                        Model.hoveringObjects[Model.objectsHovering++] = uid;
                        continue;
                    }
                    if (!var25 || screenXX != -5000 && screenXY != -5000 && screenXZ != -5000) {
                        if (highlighted && this.inBounds(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], screenXX, screenXY, screenXZ, size)) {
                            Model.hoveringObjects[Model.objectsHovering++] = uid;
                            highlighted = false;
                        }
                        if ((screenXX - screenXY) * (vertexScreenY[triZ] - vertexScreenY[triY]) - (screenXZ - screenXY) * (vertexScreenY[triX] - vertexScreenY[triY]) <= 0) continue;
                        Model.outOfReach[currentTriangle] = false;
                        Model.hasAnEdgeToRestrict[currentTriangle] = screenXX < 0 || screenXY < 0 || screenXZ < 0 || screenXX > Rasterizer3D.lastX || screenXY > Rasterizer3D.lastX || screenXZ > Rasterizer3D.lastX;
                        index = (vertexScreenZ[triX] + vertexScreenZ[triY] + vertexScreenZ[triZ]) / 3 + this.diagonal3DAboveOrigin;
                        if (index < 0) {
                            index = 0;
                        }
                        int n = index;
                        int n2 = depth[n];
                        depth[n] = n2 + 1;
                        Model.faceLists[index][n2] = currentTriangle;
                        continue;
                    }
                    index = vertexMovedX[triX];
                    var15 = vertexMovedX[triY];
                    var16 = vertexMovedX[triZ];
                    int var30 = vertexMovedY[triX];
                    var18 = vertexMovedY[triY];
                    int var19 = vertexMovedY[triZ];
                    int var20 = vertexMovedZ[triX];
                    int var21 = vertexMovedZ[triY];
                    int var22 = vertexMovedZ[triZ];
                    int var23 = (var30 -= var18) * (var22 -= var21) - (var20 -= var21) * (var19 -= var18);
                    if (var15 * var23 + var18 * (var24 = var20 * (var16 -= var15) - (index -= var15) * var22) + var21 * (var25a = index * var19 - var30 * var16) <= 0) continue;
                    Model.outOfReach[currentTriangle] = true;
                    int n = var26 = (vertexScreenZ[triX] + vertexScreenZ[triY] + vertexScreenZ[triZ]) / 3 + this.diagonal3DAboveOrigin;
                    int n3 = depth[n];
                    depth[n] = n3 + 1;
                    Model.faceLists[var26][n3] = currentTriangle;
                }
                if (gpu) {
                    return;
                }
                if (this.renderPriorities == null) {
                    for (int faceIndex = this.diagonal3D - 1; faceIndex >= 0; --faceIndex) {
                        int depth = Model.depth[faceIndex];
                        if (depth <= 0) continue;
                        for (int index = 0; index < depth; ++index) {
                            this.drawFace(faceLists[faceIndex][index]);
                        }
                    }
                } else {
                    int var11;
                    int var8;
                    for (int currentIndex = 0; currentIndex < 12; ++currentIndex) {
                        Model.anIntArray1673[currentIndex] = 0;
                        Model.anIntArray1677[currentIndex] = 0;
                    }
                    for (int depthIndex = this.diagonal3D - 1; depthIndex >= 0; --depthIndex) {
                        var8 = depth[depthIndex];
                        if (var8 <= 0) continue;
                        for (int var10 = 0; var10 < var8; ++var10) {
                            byte var31;
                            var11 = faceLists[depthIndex][var10];
                            byte by = var31 = this.renderPriorities[var11];
                            anIntArray1673[by] = anIntArray1673[by] + 1;
                            Model.anIntArrayArray1674[var31][var28] = var11;
                            if (var31 < 10) {
                                byte by2 = var31;
                                anIntArray1677[by2] = anIntArray1677[by2] + depthIndex;
                                continue;
                            }
                            if (var31 == 10) {
                                Model.anIntArray1675[var28] = depthIndex;
                                continue;
                            }
                            Model.anIntArray1676[var28] = depthIndex;
                        }
                    }
                    int var7 = 0;
                    if (anIntArray1673[1] > 0 || anIntArray1673[2] > 0) {
                        var7 = (anIntArray1677[1] + anIntArray1677[2]) / (anIntArray1673[1] + anIntArray1673[2]);
                    }
                    var8 = 0;
                    if (anIntArray1673[3] > 0 || anIntArray1673[4] > 0) {
                        var8 = (anIntArray1677[3] + anIntArray1677[4]) / (anIntArray1673[3] + anIntArray1673[4]);
                    }
                    int var9 = 0;
                    if (anIntArray1673[6] > 0 || anIntArray1673[8] > 0) {
                        var9 = (anIntArray1677[8] + anIntArray1677[6]) / (anIntArray1673[8] + anIntArray1673[6]);
                    }
                    var11 = 0;
                    int var12 = anIntArray1673[10];
                    int[] var13 = anIntArrayArray1674[10];
                    int[] var14 = anIntArray1675;
                    if (var11 == var12) {
                        var11 = 0;
                        var12 = anIntArray1673[11];
                        var13 = anIntArrayArray1674[11];
                        var14 = anIntArray1676;
                    }
                    int var10 = var11 < var12 ? var14[var11] : -1000;
                    for (var15 = 0; var15 < 10; ++var15) {
                        while (var15 == 0 && var10 > var7) {
                            this.drawFace(var13[var11++]);
                            if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                                var11 = 0;
                                var12 = anIntArray1673[11];
                                var13 = anIntArrayArray1674[11];
                                var14 = anIntArray1676;
                            }
                            if (var11 < var12) {
                                var10 = var14[var11];
                                continue;
                            }
                            var10 = -1000;
                        }
                        while (var15 == 3 && var10 > var8) {
                            this.drawFace(var13[var11++]);
                            if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                                var11 = 0;
                                var12 = anIntArray1673[11];
                                var13 = anIntArrayArray1674[11];
                                var14 = anIntArray1676;
                            }
                            if (var11 < var12) {
                                var10 = var14[var11];
                                continue;
                            }
                            var10 = -1000;
                        }
                        while (var15 == 5 && var10 > var9) {
                            this.drawFace(var13[var11++]);
                            if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                                var11 = 0;
                                var12 = anIntArray1673[11];
                                var13 = anIntArrayArray1674[11];
                                var14 = anIntArray1676;
                            }
                            if (var11 < var12) {
                                var10 = var14[var11];
                                continue;
                            }
                            var10 = -1000;
                        }
                        var16 = anIntArray1673[var15];
                        int[] var17 = anIntArrayArray1674[var15];
                        for (var18 = 0; var18 < var16; ++var18) {
                            this.drawFace(var17[var18]);
                        }
                    }
                    while (var10 != -1000) {
                        this.drawFace(var13[var11++]);
                        if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                            var11 = 0;
                            var13 = anIntArrayArray1674[11];
                            var12 = anIntArray1673[11];
                            var14 = anIntArray1676;
                        }
                        if (var11 < var12) {
                            var10 = var14[var11];
                            continue;
                        }
                        var10 = -1000;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drawFace(int face) {
        DrawCallbacks callbacks = Client.instance.getDrawCallbacks();
        if (callbacks == null || !callbacks.drawFace(this, face)) {
            if (outOfReach[face]) {
                this.faceRotation(face);
                return;
            }
            int triX = this.trianglesX[face];
            int triY = this.trianglesY[face];
            int triZ = this.trianglesZ[face];
            Rasterizer3D.textureOutOfDrawingBounds = hasAnEdgeToRestrict[face];
            Rasterizer3D.alpha = this.triangleAlpha == null ? 0 : this.triangleAlpha[face] & 0xFF;
            int type2 = this.drawType == null ? 0 : this.drawType[face] & 3;
            if (this.materials != null && this.materials[face] != -1) {
                int textureA = triX;
                int textureB = triY;
                int textureC = triZ;
                if (this.textures != null && this.textures[face] != -1) {
                    int coordinate = this.textures[face] & 0xFF;
                    textureA = this.texturesX[coordinate];
                    textureB = this.texturesY[coordinate];
                    textureC = this.texturesZ[coordinate];
                }
                if (this.colorsZ[face] == -1 || type2 == 3) {
                    Rasterizer3D.drawTexturedTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], this.colorsX[face], this.colorsX[face], this.colorsX[face], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[face]);
                } else {
                    Rasterizer3D.drawTexturedTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], this.colorsX[face], this.colorsY[face], this.colorsZ[face], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[face]);
                }
            } else if (this.colorsZ[face] == -1) {
                Rasterizer3D.drawFlatTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], modelColors[this.colorsX[face]]);
            } else {
                if (type2 == 0) {
                    Rasterizer3D.drawShadedTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], this.colorsX[face], this.colorsY[face], this.colorsZ[face]);
                }
                if (type2 == 1) {
                    Rasterizer3D.drawFlatTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], modelColors[this.colorsX[face]]);
                }
            }
        }
    }

    private final void faceRotation(int triangle) {
        int colour;
        int movedY2;
        int movedX2;
        int centreX = Rasterizer3D.originViewX;
        int centreY = Rasterizer3D.originViewY;
        int counter = 0;
        int x = this.trianglesX[triangle];
        int y = this.trianglesY[triangle];
        int z = this.trianglesZ[triangle];
        int movedX = vertexMovedZ[x];
        int movedY = vertexMovedZ[y];
        int movedZ = vertexMovedZ[z];
        if (movedX >= 50) {
            Model.xPosition[counter] = vertexScreenX[x];
            Model.yPosition[counter] = vertexScreenY[x];
            Model.zPosition[counter++] = this.colorsX[triangle];
        } else {
            movedX2 = vertexMovedX[x];
            movedY2 = vertexMovedY[x];
            colour = this.colorsX[triangle];
            if (movedZ >= 50) {
                int k5 = (50 - movedX) * modelLocations[movedZ - movedX];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[z] - movedX2) * k5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[z] - movedY2) * k5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsZ[triangle] - colour) * k5 >> 16);
            }
            if (movedY >= 50) {
                int l5 = (50 - movedX) * modelLocations[movedY - movedX];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[y] - movedX2) * l5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[y] - movedY2) * l5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsY[triangle] - colour) * l5 >> 16);
            }
        }
        if (movedY >= 50) {
            Model.xPosition[counter] = vertexScreenX[y];
            Model.yPosition[counter] = vertexScreenY[y];
            Model.zPosition[counter++] = this.colorsY[triangle];
        } else {
            movedX2 = vertexMovedX[y];
            movedY2 = vertexMovedY[y];
            colour = this.colorsY[triangle];
            if (movedX >= 50) {
                int i6 = (50 - movedY) * modelLocations[movedX - movedY];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[x] - movedX2) * i6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[x] - movedY2) * i6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsX[triangle] - colour) * i6 >> 16);
            }
            if (movedZ >= 50) {
                int j6 = (50 - movedY) * modelLocations[movedZ - movedY];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[z] - movedX2) * j6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[z] - movedY2) * j6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsZ[triangle] - colour) * j6 >> 16);
            }
        }
        if (movedZ >= 50) {
            Model.xPosition[counter] = vertexScreenX[z];
            Model.yPosition[counter] = vertexScreenY[z];
            Model.zPosition[counter++] = this.colorsZ[triangle];
        } else {
            movedX2 = vertexMovedX[z];
            movedY2 = vertexMovedY[z];
            colour = this.colorsZ[triangle];
            if (movedY >= 50) {
                int k6 = (50 - movedZ) * modelLocations[movedY - movedZ];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[y] - movedX2) * k6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[y] - movedY2) * k6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsY[triangle] - colour) * k6 >> 16);
            }
            if (movedX >= 50) {
                int l6 = (50 - movedZ) * modelLocations[movedX - movedZ];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[x] - movedX2) * l6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[x] - movedY2) * l6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsX[triangle] - colour) * l6 >> 16);
            }
        }
        int xA = xPosition[0];
        int xB = xPosition[1];
        int xC = xPosition[2];
        int yA = yPosition[0];
        int yB = yPosition[1];
        int yC = yPosition[2];
        if ((xA - xB) * (yC - yB) - (yA - yB) * (xC - xB) > 0) {
            int coordinate;
            int drawType;
            Rasterizer3D.textureOutOfDrawingBounds = false;
            int textureA = x;
            int textureB = y;
            int textureC = z;
            if (counter == 3) {
                if (xA < 0 || xB < 0 || xC < 0 || xA > Rasterizer2D.lastX || xB > Rasterizer2D.lastX || xC > Rasterizer2D.lastX) {
                    Rasterizer3D.textureOutOfDrawingBounds = true;
                }
                drawType = this.drawType == null ? 0 : this.drawType[triangle] & 3;
                if (this.materials != null && this.materials[triangle] != -1) {
                    if (this.textures != null && this.textures[triangle] != -1) {
                        coordinate = this.textures[triangle] & 0xFF;
                        textureA = this.texturesX[coordinate];
                        textureB = this.texturesY[coordinate];
                        textureC = this.texturesZ[coordinate];
                    }
                    if (this.colorsZ[triangle] == -1) {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, this.colorsX[triangle], this.colorsX[triangle], this.colorsX[triangle], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    } else {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    }
                } else if (drawType == 0) {
                    Rasterizer3D.drawShadedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2]);
                } else if (drawType == 1) {
                    Rasterizer3D.drawFlatTriangle(yA, yB, yC, xA, xB, xC, modelColors[this.colorsX[triangle]]);
                }
            }
            if (counter == 4) {
                if (xA < 0 || xB < 0 || xC < 0 || xA > Rasterizer2D.lastX || xB > Rasterizer2D.lastX || xC > Rasterizer2D.lastX || xPosition[3] < 0 || xPosition[3] > Rasterizer2D.lastX) {
                    Rasterizer3D.textureOutOfDrawingBounds = true;
                }
                drawType = this.drawType == null ? 0 : this.drawType[triangle] & 3;
                if (this.materials != null && this.materials[triangle] != -1) {
                    if (this.textures != null && this.textures[triangle] != -1) {
                        coordinate = this.textures[triangle] & 0xFF;
                        textureA = this.texturesX[coordinate];
                        textureB = this.texturesY[coordinate];
                        textureC = this.texturesZ[coordinate];
                    }
                    if (this.colorsZ[triangle] == -1) {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, this.colorsX[triangle], this.colorsX[triangle], this.colorsX[triangle], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                        Rasterizer3D.drawTexturedTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], this.colorsX[triangle], this.colorsX[triangle], this.colorsX[triangle], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    } else {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                        Rasterizer3D.drawTexturedTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], zPosition[0], zPosition[2], zPosition[3], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    }
                } else {
                    if (drawType == 0) {
                        Rasterizer3D.drawShadedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2]);
                        Rasterizer3D.drawShadedTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], zPosition[0], zPosition[2], zPosition[3]);
                        return;
                    }
                    if (drawType == 1) {
                        int l8 = modelColors[this.colorsX[triangle]];
                        Rasterizer3D.drawFlatTriangle(yA, yB, yC, xA, xB, xC, l8);
                        Rasterizer3D.drawFlatTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], l8);
                    }
                }
            }
        }
    }

    @Override
    public List<Vertex> getVertices() {
        int[] verticesX = this.getVerticesX();
        int[] verticesY = this.getVerticesY();
        int[] verticesZ = this.getVerticesZ();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.getVerticesCount());
        for (int i = 0; i < this.getVerticesCount(); ++i) {
            Vertex vertex = new Vertex(verticesX[i], verticesY[i], verticesZ[i]);
            vertices.add(vertex);
        }
        return vertices;
    }

    @Override
    public List<Triangle> getTriangles() {
        int[] trianglesX = this.getFaceIndices1();
        int[] trianglesY = this.getFaceIndices2();
        int[] trianglesZ = this.getFaceIndices3();
        List<Vertex> vertices = this.getVertices();
        ArrayList<Triangle> triangles = new ArrayList<Triangle>(this.getFaceCount());
        for (int i = 0; i < this.getFaceCount(); ++i) {
            int triangleX = trianglesX[i];
            int triangleY = trianglesY[i];
            int triangleZ = trianglesZ[i];
            Triangle triangle = new Triangle(vertices.get(triangleX), vertices.get(triangleY), vertices.get(triangleZ));
            triangles.add(triangle);
        }
        return triangles;
    }

    @Override
    public int getVerticesCount() {
        return this.verticesCount;
    }

    @Override
    public int[] getVerticesX() {
        return this.verticesX;
    }

    @Override
    public int[] getVerticesY() {
        return this.verticesY;
    }

    @Override
    public int[] getVerticesZ() {
        return this.verticesZ;
    }

    @Override
    public int getFaceCount() {
        return this.trianglesCount;
    }

    @Override
    public int[] getFaceIndices1() {
        return this.trianglesX;
    }

    @Override
    public int[] getFaceIndices2() {
        return this.trianglesY;
    }

    @Override
    public int[] getFaceIndices3() {
        return this.trianglesZ;
    }

    @Override
    public int[] getFaceColors1() {
        return this.colorsX;
    }

    @Override
    public int[] getFaceColors2() {
        return this.colorsY;
    }

    @Override
    public int[] getFaceColors3() {
        return this.colorsZ;
    }

    @Override
    public byte[] getFaceTransparencies() {
        return this.triangleAlpha;
    }

    @Override
    public int getSceneId() {
        return this.sceneId;
    }

    @Override
    public void setSceneId(int sceneId) {
        this.sceneId = sceneId;
    }

    @Override
    public int getBufferOffset() {
        return this.bufferOffset;
    }

    @Override
    public void setBufferOffset(int bufferOffset) {
        this.bufferOffset = bufferOffset;
    }

    @Override
    public int getUvBufferOffset() {
        return this.uvBufferOffset;
    }

    @Override
    public void setUvBufferOffset(int uvBufferOffset) {
        this.uvBufferOffset = uvBufferOffset;
    }

    @Override
    public int getModelHeight() {
        return this.modelBaseY;
    }

    @Override
    public void animate(int type2, int[] list, int x, int y, int z) {
    }

    @Override
    public byte[] getFaceRenderPriorities() {
        return this.renderPriorities;
    }

    @Override
    public int[][] getVertexGroups() {
        return new int[0][];
    }

    @Override
    public int getRadius() {
        return this.diagonal3DAboveOrigin;
    }

    @Override
    public int getDiameter() {
        return this.diagonal3D;
    }

    @Override
    public short[] getFaceTextures() {
        return this.materials;
    }

    @Override
    public void calculateExtreme(int orientation) {
        this.calculateBoundingBox(orientation);
    }

    @Override
    public void resetBounds() {
        this.boundsType = 0;
        this.aabb.clear();
    }

    @Override
    public RSModel toSharedModel(boolean b) {
        return null;
    }

    @Override
    public RSModel toSharedSpotAnimModel(boolean b) {
        return null;
    }

    void invalidate() {
        this.vertexNormalsOffsets = null;
        this.normals = null;
        this.faceNormals = null;
        this.isBoundsCalculated = false;
    }

    @Override
    public void rotateY90Ccw() {
        this.rotate90Degrees();
    }

    @Override
    public void rotateY180Ccw() {
        for (int vert = 0; vert < this.verticesCount; ++vert) {
            this.verticesX[vert] = -this.verticesX[vert];
            this.verticesZ[vert] = -this.verticesZ[vert];
        }
        this.resetBounds();
        this.invalidate();
    }

    @Override
    public void rotateY270Ccw() {
        for (int vert = 0; vert < this.verticesCount; ++vert) {
            int var2 = this.verticesZ[vert];
            this.verticesZ[vert] = this.verticesX[vert];
            this.verticesX[vert] = -var2;
        }
        this.resetBounds();
        this.invalidate();
    }

    @Override
    public int getXYZMag() {
        return this.diagonal2DAboveOrigin;
    }

    @Override
    public boolean isClickable() {
        return this.singleTile;
    }

    @Override
    public void interpolateFrames(RSFrames frames, int frameId, RSFrames nextFrames, int nextFrameId, int interval, int intervalCount) {
    }

    @Override
    public int[] getVertexNormalsX() {
        if (this.vertexNormalsX == null) {
            return this.getVerticesX();
        }
        return this.vertexNormalsX;
    }

    @Override
    public void setVertexNormalsX(int[] vertexNormalsX) {
        this.vertexNormalsX = vertexNormalsX;
    }

    @Override
    public int[] getVertexNormalsY() {
        if (this.vertexNormalsY == null) {
            return this.getVerticesY();
        }
        return this.vertexNormalsY;
    }

    @Override
    public void setVertexNormalsY(int[] vertexNormalsY) {
        this.vertexNormalsY = vertexNormalsY;
    }

    @Override
    public int[] getVertexNormalsZ() {
        if (this.vertexNormalsZ == null) {
            return this.getVerticesZ();
        }
        return this.vertexNormalsZ;
    }

    @Override
    public void setVertexNormalsZ(int[] vertexNormalsZ) {
        this.vertexNormalsZ = vertexNormalsZ;
    }

    @Override
    public byte getOverrideAmount() {
        return 0;
    }

    @Override
    public byte getOverrideHue() {
        return 0;
    }

    @Override
    public byte getOverrideSaturation() {
        return 0;
    }

    @Override
    public byte getOverrideLuminance() {
        return 0;
    }

    @Override
    public HashMap<Integer, net.runelite.api.AABB> getAABBMap() {
        return this.aabb;
    }

    @Override
    public Shape getConvexHull(int localX, int localY, int orientation, int tileHeight) {
        int[] x2d = new int[this.getVerticesCount()];
        int[] y2d = new int[this.getVerticesCount()];
        Perspective.modelToCanvas(Client.instance, this.getVerticesCount(), localX, localY, tileHeight, orientation, this.getVerticesX(), this.getVerticesZ(), this.getVerticesY(), x2d, y2d);
        return Jarvis.convexHull(x2d, y2d);
    }

    @Override
    public int getBottomY() {
        return this.maxY;
    }

    private void vertexNormals() {
        if (this.vertexNormalsX == null) {
            int verticesCount = this.getVerticesCount();
            this.vertexNormalsX = new int[verticesCount];
            this.vertexNormalsY = new int[verticesCount];
            this.vertexNormalsZ = new int[verticesCount];
            int[] trianglesX = this.getFaceIndices1();
            int[] trianglesY = this.getFaceIndices2();
            int[] trianglesZ = this.getFaceIndices3();
            int[] verticesX = this.getVerticesX();
            int[] verticesY = this.getVerticesY();
            int[] verticesZ = this.getVerticesZ();
            for (int i = 0; i < this.trianglesCount; ++i) {
                int var20;
                int var9 = trianglesX[i];
                int var10 = trianglesY[i];
                int var11 = trianglesZ[i];
                int var12 = verticesX[var10] - verticesX[var9];
                int var13 = verticesY[var10] - verticesY[var9];
                int var14 = verticesZ[var10] - verticesZ[var9];
                int var15 = verticesX[var11] - verticesX[var9];
                int var16 = verticesY[var11] - verticesY[var9];
                int var17 = verticesZ[var11] - verticesZ[var9];
                int var18 = var13 * var17 - var16 * var14;
                int var19 = var14 * var15 - var17 * var12;
                for (var20 = var12 * var16 - var15 * var13; var18 > 8192 || var19 > 8192 || var20 > 8192 || var18 < -8192 || var19 < -8192 || var20 < -8192; var18 >>= 1, var19 >>= 1, var20 >>= 1) {
                }
                int var21 = (int)Math.sqrt(var18 * var18 + var19 * var19 + var20 * var20);
                if (var21 <= 0) {
                    var21 = 1;
                }
                var18 = var18 * 256 / var21;
                var19 = var19 * 256 / var21;
                var20 = var20 * 256 / var21;
                int n = var9;
                this.vertexNormalsX[n] = this.vertexNormalsX[n] + var18;
                int n2 = var9;
                this.vertexNormalsY[n2] = this.vertexNormalsY[n2] + var19;
                int n3 = var9;
                this.vertexNormalsZ[n3] = this.vertexNormalsZ[n3] + var20;
                int n4 = var10;
                this.vertexNormalsX[n4] = this.vertexNormalsX[n4] + var18;
                int n5 = var10;
                this.vertexNormalsY[n5] = this.vertexNormalsY[n5] + var19;
                int n6 = var10;
                this.vertexNormalsZ[n6] = this.vertexNormalsZ[n6] + var20;
                int n7 = var11;
                this.vertexNormalsX[n7] = this.vertexNormalsX[n7] + var18;
                int n8 = var11;
                this.vertexNormalsY[n8] = this.vertexNormalsY[n8] + var19;
                int n9 = var11;
                this.vertexNormalsZ[n9] = this.vertexNormalsZ[n9] + var20;
            }
        }
    }

    @Override
    public int getLastOrientation() {
        return this.lastOrientation;
    }

    @Override
    public AABB getAABB(int orientation) {
        this.calculateExtreme(orientation);
        this.lastOrientation = orientation;
        return (AABB)this.getAABBMap().get(this.lastOrientation);
    }

    static {
        emptyModel = new Model();
        sharedVerticesX = new int[2000];
        sharedVerticesY = new int[2000];
        sharedVerticesZ = new int[2000];
        sharedTriangleAlpha = new byte[2000];
        hasAnEdgeToRestrict = new boolean[6500];
        outOfReach = new boolean[6500];
        vertexScreenX = new int[6500];
        vertexScreenY = new int[6500];
        vertexScreenZ = new int[6500];
        vertexMovedX = new int[6500];
        vertexMovedY = new int[6500];
        vertexMovedZ = new int[6500];
        depth = new int[6000];
        faceLists = new int[1600][512];
        anIntArray1673 = new int[12];
        anIntArrayArray1674 = new int[12][2000];
        anIntArray1676 = new int[2000];
        anIntArray1675 = new int[2000];
        anIntArray1677 = new int[12];
        xPosition = new int[10];
        yPosition = new int[10];
        zPosition = new int[10];
        hoveringObjects = new long[1000];
        SINE = Rasterizer3D.SINE;
        COSINE = Rasterizer3D.COSINE;
        modelColors = Rasterizer3D.hslToRgb;
        modelLocations = Rasterizer3D.anIntArray1469;
    }
}

