/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Sprite;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import javax.imageio.ImageIO;

public final class OsrsSpriteCache
implements Closeable {
    private Sprite[] cache;
    private FileChannel dataChannel;
    private FileChannel metaChannel;

    public Sprite[] getSprites() {
        return this.cache;
    }

    public void init(File dataFile, File metaFile) throws IOException {
        if (!dataFile.exists()) {
            throw new IOException(String.format("Could not find data file=%s", dataFile.getName()));
        }
        if (!metaFile.exists()) {
            throw new IOException(String.format("Could not find meta file=%s", metaFile.getName()));
        }
        this.dataChannel = FileChannel.open(dataFile.toPath(), StandardOpenOption.READ);
        this.metaChannel = FileChannel.open(metaFile.toPath(), StandardOpenOption.READ);
        int spriteCount = Math.toIntExact(this.metaChannel.size() / 10L);
        this.cache = new Sprite[spriteCount];
        System.out.println(String.format("Sprite cache size=%d", this.cache.length));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sprite lookup(int id) {
        try {
            if (this.contains(id)) {
                return this.cache[id];
            }
            if (!this.dataChannel.isOpen() || !this.metaChannel.isOpen()) {
                System.out.println("Sprite channels are closed!");
                return null;
            }
            int entries = Math.toIntExact(this.metaChannel.size() / 10L);
            if (id > entries) {
                System.out.println(String.format("id=%d > size=%d", id, entries));
                return null;
            }
            this.metaChannel.position(id * 10);
            ByteBuffer metaBuf = ByteBuffer.allocate(10);
            this.metaChannel.read(metaBuf);
            metaBuf.flip();
            int pos = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int len = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int offsetX = metaBuf.getShort() & 0xFF;
            int offsetY = metaBuf.getShort() & 0xFF;
            ByteBuffer dataBuf = ByteBuffer.allocate(len);
            this.dataChannel.position(pos);
            this.dataChannel.read(dataBuf);
            dataBuf.flip();
            try (ByteArrayInputStream is = new ByteArrayInputStream(dataBuf.array());){
                Sprite sprite;
                BufferedImage bimage = ImageIO.read(is);
                if (bimage == null) {
                    System.out.println(String.format("Could not read image at %d", id));
                    Sprite sprite2 = null;
                    return sprite2;
                }
                if (bimage.getType() != 2) {
                    bimage = OsrsSpriteCache.convert(bimage, 2);
                }
                int[] pixels = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
                this.cache[id] = sprite = new Sprite(bimage.getWidth(), bimage.getHeight(), offsetX, offsetY, pixels);
                Sprite sprite3 = sprite;
                return sprite3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(String.format("No sprite found for id=%d", id));
            return null;
        }
    }

    public boolean contains(int id) {
        return id < this.cache.length && this.cache[id] != null;
    }

    public void set(int id, Sprite sprite) {
        if (!this.contains(id)) {
            return;
        }
        this.cache[id] = sprite;
    }

    private static BufferedImage convert(BufferedImage bimage, int type2) {
        BufferedImage converted = new BufferedImage(bimage.getWidth(), bimage.getHeight(), type2);
        converted.getGraphics().drawImage(bimage, 0, 0, null);
        return converted;
    }

    @Override
    public void close() throws IOException {
        this.dataChannel.close();
        this.metaChannel.close();
    }
}

