/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.definitions.AnimationDefinition;
import com.client.definitions.NpcDefinition;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PetSystem {
    private final int[] modelArray;
    private final int modelArrayLength;
    private final int primaryModel;
    private final int secondaryModel;
    private final String name;
    private final byte[] description;
    private static int animation;
    private static int animationDelay;
    public static int animationFrame;
    public static boolean updatePetAnimations;
    public static boolean isPetAnimationRunning;
    public static int petSelected;

    public PetSystem(NpcDefinition entity) {
        this.modelArray = entity.models;
        this.modelArrayLength = entity.models.length;
        this.primaryModel = entity.models[0];
        this.secondaryModel = entity.models.length > 1 ? entity.models[1] : entity.models[0];
        this.name = entity.name;
        this.description = entity.description.getBytes();
        animation = entity.standingAnimation;
        if (animationFrame >= AnimationDefinition.anims[PetSystem.animation].durations.length - 1) {
            animationFrame = 0;
        }
        animationDelay = AnimationDefinition.anims[PetSystem.animation].durations[animationFrame];
    }

    public static void petAnimationStep() {
        if (updatePetAnimations) {
            return;
        }
        if (++animationFrame >= AnimationDefinition.anims[PetSystem.animation].primaryFrames.length) {
            animationFrame = 0;
        }
    }

    public static void updateAnimations() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                isPetAnimationRunning = true;
                PetSystem.petAnimationStep();
            }
        }, 0L, animationDelay == 0 ? 30L : (long)(animationDelay * 30), TimeUnit.MILLISECONDS);
    }

    public int getAnimationDelay() {
        return animationDelay;
    }

    public int getPrimaryModel() {
        return this.primaryModel;
    }

    public int getAnimation() {
        return animation;
    }

    public String getName() {
        return this.name;
    }

    public int getAnimationFrame() {
        return animationFrame;
    }

    public byte[] getDescription() {
        return this.description;
    }

    public int getSecondaryModel() {
        return this.secondaryModel;
    }

    public int getModelArrayLength() {
        return this.modelArrayLength;
    }

    public int[] getModelArray() {
        return this.modelArray;
    }

    public int getPetSelected() {
        return petSelected;
    }

    public void setPetSelected(int petID) {
        petSelected = petID;
    }

    static {
        updatePetAnimations = false;
        isPetAnimationRunning = false;
        petSelected = 0;
    }
}

