/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public enum PlayerRights {
    PLAYER(0, "000000", new PlayerRights[0]),
    HELPER(11, "004080", new PlayerRights[0]),
    MODERATOR(1, "#0000ff", HELPER),
    ADMINISTRATOR(2, "F5FF0F", MODERATOR),
    OWNER(3, "F5FF0F", ADMINISTRATOR),
    UNKNOWN(4, "F5FF0F", new PlayerRights[0]),
    SAPPHIRE_DONATOR(5, "B60818", new PlayerRights[0]),
    EMERALD_DONATOR(7, "118120", SAPPHIRE_DONATOR),
    RUBY_DONATOR(9, "9E6405", EMERALD_DONATOR),
    DIAMOND_DONATOR(17, "9E6405", RUBY_DONATOR),
    ONYX_DONATOR(18, "9E6405", DIAMOND_DONATOR),
    ZENYTE_DONATOR(19, "4a4a4a", ONYX_DONATOR),
    DIVINE_DONATOR(20, "4a4a4a", ZENYTE_DONATOR),
    HITBOX(12, "437100", new PlayerRights[0]),
    IRONMAN(13, "3A3A3A", new PlayerRights[0]),
    ULTIMATE_IRONMAN(14, "717070", new PlayerRights[0]),
    YOUTUBER(15, "FE0018", new PlayerRights[0]),
    GAME_DEVELOPER(16, "544FBB", ADMINISTRATOR),
    OSRS(23, "437100", new PlayerRights[0]),
    MEMBERSHIP(21, "437100", new PlayerRights[0]),
    ROGUE(25, "437100", new PlayerRights[0]),
    HC_IRONMAN(10, "60201f", new PlayerRights[0]),
    ROGUE_IRONMAN(26, "60201f", new PlayerRights[0]),
    ROGUE_HARDCORE_IRONMAN(27, "60201f", new PlayerRights[0]),
    GROUP_IRONMAN(28, "60201f", new PlayerRights[0]),
    EVENT_MAN(29, "60201f", new PlayerRights[0]);

    private final int rightsId;
    private final List<PlayerRights> inherited;
    private final String color;
    public static final EnumSet[] DISPLAY_GROUPS;

    private PlayerRights(int right, String color, PlayerRights ... inherited) {
        this.rightsId = right;
        this.inherited = Arrays.asList(inherited);
        this.color = color;
    }

    public boolean isStaffPosition() {
        return this == HELPER || this == ADMINISTRATOR || this == MODERATOR || this == OWNER || this == GAME_DEVELOPER;
    }

    public int spriteId() {
        return this.rightsId - 1;
    }

    public int crownId() {
        return this.rightsId;
    }

    public boolean hasCrown() {
        return this != PLAYER;
    }

    public int getRightsId() {
        return this.rightsId;
    }

    public static PlayerRights forRightsValue(int rightsValue) {
        Optional<PlayerRights> rights = Arrays.stream(PlayerRights.values()).filter(right -> right.getRightsId() == rightsValue).findFirst();
        if (rights.isPresent()) {
            return rights.get();
        }
        System.err.println("No rights for value " + rightsValue);
        return PLAYER;
    }

    public static List<PlayerRights> getDisplayedRights(PlayerRights[] set) {
        ArrayList<PlayerRights> rights = new ArrayList<PlayerRights>();
        for (PlayerRights right : set) {
            if (!DISPLAY_GROUPS[0].contains((Object)right)) continue;
            rights.add(right);
            break;
        }
        for (PlayerRights right : set) {
            if (!DISPLAY_GROUPS[1].contains((Object)right) || rights.size() >= 2) continue;
            rights.add(right);
        }
        return rights;
    }

    public static PlayerRights[] ordinalsToArray(int[] ordinals) {
        PlayerRights[] rights = new PlayerRights[ordinals.length];
        for (int index = 0; index < ordinals.length; ++index) {
            rights[index] = PlayerRights.values()[ordinals[index]];
        }
        return rights;
    }

    public static Pair<Integer, PlayerRights[]> readRightsFromPacket(Buffer inStream) {
        int rightsAmount = inStream.readUnsignedByte();
        int[] ordinals = new int[rightsAmount];
        for (int right = 0; right < rightsAmount; ++right) {
            ordinals[right] = inStream.readUnsignedByte();
        }
        return Pair.of(rightsAmount, PlayerRights.ordinalsToArray(ordinals));
    }

    public static boolean hasRightsOtherThan(PlayerRights[] rights, PlayerRights playerRight) {
        return Arrays.stream(rights).anyMatch(right -> right != playerRight);
    }

    public static boolean hasRights(PlayerRights[] rights, PlayerRights playerRights) {
        return Arrays.stream(rights).anyMatch(right -> right == playerRights);
    }

    public static boolean hasRightsLevel(PlayerRights[] rights, int rightsId) {
        return Arrays.stream(rights).anyMatch(right -> right.getRightsId() >= rightsId);
    }

    public static boolean hasRightsBetween(PlayerRights[] rights, int low, int high) {
        return Arrays.stream(rights).anyMatch(right -> right.getRightsId() > low && right.getRightsId() < high);
    }

    public static String buildCrownString(List<PlayerRights> rights) {
        return PlayerRights.buildCrownString(rights.toArray(new PlayerRights[0]));
    }

    public static String buildCrownString(PlayerRights[] rights) {
        StringBuilder builder = new StringBuilder();
        for (PlayerRights right : rights) {
            if (!right.hasCrown()) continue;
            builder.append("@cr" + right.crownId() + "@");
        }
        return builder.toString();
    }

    static {
        DISPLAY_GROUPS = new EnumSet[]{EnumSet.of(HELPER, new PlayerRights[]{MODERATOR, ADMINISTRATOR, GAME_DEVELOPER, OWNER, UNKNOWN, SAPPHIRE_DONATOR, EMERALD_DONATOR, RUBY_DONATOR, DIAMOND_DONATOR, ONYX_DONATOR, ZENYTE_DONATOR, DIVINE_DONATOR, YOUTUBER}), EnumSet.of(HITBOX, new PlayerRights[]{EVENT_MAN, IRONMAN, ULTIMATE_IRONMAN, OSRS, MEMBERSHIP, HC_IRONMAN, ROGUE, ROGUE_HARDCORE_IRONMAN, ROGUE_IRONMAN, GROUP_IRONMAN})};
    }
}

