/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Frame;
import com.client.Model;
import com.client.Renderable;
import com.client.definitions.GraphicsDefinition;
import net.runelite.api.Actor;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.ProjectileSpawned;
import net.runelite.rs.api.RSNPC;
import net.runelite.rs.api.RSPlayer;
import net.runelite.rs.api.RSProjectile;

public final class Projectile
extends Renderable
implements RSProjectile {
    private static final double UNIT_ANGLE = 0.02454369;
    private static final int LOCAL_TILE_SIZE = 128;
    private static final int REGION_SIZE_TILES = 104;
    boolean isMoving;
    public double y;
    double speedX;
    public double x;
    public double z;
    double speedY;
    double speed;
    double speedZ;
    double accelerationZ;
    int sourceZ;
    int sourceX;
    int pitch;
    int frameCycle = 0;
    public int yaw;
    public int cycleEnd;
    public int endHeight;
    int startHeight;
    public int targetIndex;
    int slope;
    public int cycleStart;
    int sourceY;
    int id;
    int frame = 0;
    public int plane;
    private GraphicsDefinition graphics;
    private int flow;
    private int duration;

    public Projectile(int slope_start, int endHeight, int cycleStart, int cycleEnd, int startHeight, int plane, int start_z, int start_y, int start_x, int target_id, int id) {
        this.id = id;
        this.graphics = id >= 0 && id < GraphicsDefinition.cache.length ? GraphicsDefinition.cache[id] : null;
        this.plane = plane;
        this.sourceX = start_x;
        this.sourceY = start_y;
        this.sourceZ = start_z;
        this.cycleStart = cycleStart;
        this.cycleEnd = cycleEnd;
        this.slope = Projectile.clampSlope(slope_start);
        this.startHeight = startHeight;
        this.targetIndex = target_id;
        this.endHeight = endHeight;
        this.isMoving = false;
        ProjectileSpawned spawned = new ProjectileSpawned();
        spawned.setProjectile(this);
        Client.instance.getCallbacks().post(spawned);
    }

    private int worldToLocalX(int worldTileX) {
        int baseX = Client.instance.getBaseX();
        int regionTileX = worldTileX - baseX;
        if (regionTileX < 0) {
            regionTileX = 0;
        }
        if (regionTileX > 104) {
            regionTileX = 104;
        }
        return regionTileX * 128 + 64;
    }

    private int worldToLocalY(int worldTileY) {
        int baseY = Client.instance.getBaseY();
        int regionTileY = worldTileY - baseY;
        if (regionTileY < 0) {
            regionTileY = 0;
        }
        if (regionTileY > 104) {
            regionTileY = 104;
        }
        return regionTileY * 128 + 64;
    }

    private static int tileToLocal(int tile) {
        return tile * 128 + 64;
    }

    private static int clampSlope(int s2) {
        if (s2 < 0) {
            return 0;
        }
        if (s2 > 255) {
            return 255;
        }
        return s2;
    }

    public final void setDestinationLocal(int dstLocalX, int dstLocalY, int dstZ, int nowCycle) {
        this.setDestinationSafe(dstLocalX, dstLocalY, dstZ, nowCycle);
    }

    public final void setDestinationTile(int tileX, int tileY, int dstZ, int nowCycle) {
        this.setDestinationSafe(Projectile.tileToLocal(tileX), Projectile.tileToLocal(tileY), dstZ, nowCycle);
    }

    public final void setDestinationWorldTile(int worldTileX, int worldTileY, int dstZ, int nowCycle) {
        int lx = this.worldToLocalX(worldTileX);
        int ly = this.worldToLocalY(worldTileY);
        this.setDestinationSafe(lx, ly, dstZ, nowCycle);
    }

    public void retargetToActor(Actor actor, int nowCycle) {
        if (actor == null) {
            return;
        }
        LocalPoint lp = actor.getLocalLocation();
        if (lp == null) {
            return;
        }
        this.setDestinationSafe(lp.getX(), lp.getY(), this.endHeight, nowCycle);
    }

    private void setDestinationSafe(int dstLocalX, int dstLocalY, int dstZ, int nowCycle) {
        double t = 1 + this.cycleEnd - nowCycle;
        if (t <= 0.0) {
            t = 1.0;
        }
        if (!this.isMoving) {
            double dx0 = dstLocalX - this.sourceX;
            double dy0 = dstLocalY - this.sourceY;
            double horiz0 = Math.sqrt(dx0 * dx0 + dy0 * dy0);
            if (horiz0 < 1.0E-6) {
                horiz0 = 1.0E-6;
            }
            this.x = (double)this.sourceX + dx0 * ((double)this.startHeight / horiz0);
            this.y = (double)this.sourceY + dy0 * ((double)this.startHeight / horiz0);
            this.z = this.sourceZ;
        }
        this.speedX = ((double)dstLocalX - this.x) / t;
        this.speedY = ((double)dstLocalY - this.y) / t;
        this.speed = Math.sqrt(this.speedX * this.speedX + this.speedY * this.speedY);
        if (!this.isMoving) {
            this.speedZ = -this.speed * Math.tan((double)this.slope * 0.02454369);
        }
        this.accelerationZ = ((double)dstZ - this.z - this.speedZ * t) * 2.0 / (t * t);
        ProjectileMoved pm = new ProjectileMoved();
        pm.setProjectile(this);
        pm.setPosition(new LocalPoint(dstLocalX, dstLocalY));
        pm.setZ(dstZ);
        Client.instance.getCallbacks().post(pm);
    }

    public final void setDestination(int arg0, int arg1, int arg2, int arg3) {
        int dstX = arg0;
        int dstY = arg1;
        if (dstX >= 0 && dstX < 104 && dstY >= 0 && dstY < 104 && (this.sourceX >= 104 || this.sourceY >= 104)) {
            dstX = dstX * 128 + 64;
            dstY = dstY * 128 + 64;
        }
        this.setDestinationSafe(dstX, dstY, arg2, arg3);
    }

    public void travel(int step) {
        if (step <= 0) {
            return;
        }
        this.isMoving = true;
        this.x += this.speedX * (double)step;
        this.y += this.speedY * (double)step;
        this.z += this.speedZ * (double)step + 0.5 * this.accelerationZ * (double)step * (double)step;
        this.speedZ += this.accelerationZ * (double)step;
        this.speed = Math.sqrt(this.speedX * this.speedX + this.speedY * this.speedY);
        this.yaw = (int)(Math.atan2(this.speedX, this.speedY) * 325.949) + 1024 & 0x7FF;
        this.pitch = (int)(Math.atan2(this.speedZ, Math.max(1.0E-9, this.speed)) * 325.949) & 0x7FF;
        if (this.graphics != null && this.graphics.animationSequence != null) {
            int frameLen;
            this.duration += step;
            while (this.duration > (frameLen = this.graphics.animationSequence.method258(this.flow))) {
                this.duration -= frameLen + 1;
                ++this.flow;
                if (this.flow < this.graphics.animationSequence.primaryFrames.length) continue;
                int loop = this.graphics.animationSequence.frameCount;
                this.flow = loop > 0 ? this.flow - loop : 0;
            }
        }
    }

    @Override
    public Model getRotatedModel() {
        if (this.graphics == null) {
            return null;
        }
        Model model = this.graphics.getModel();
        if (model == null) {
            return null;
        }
        int seqFrame = -1;
        if (this.graphics.animationSequence != null && this.flow >= 0 && this.flow < this.graphics.animationSequence.primaryFrames.length) {
            seqFrame = this.graphics.animationSequence.primaryFrames[this.flow];
        }
        Model animated_model = new Model(true, Frame.noAnimationInProgress(seqFrame), false, model);
        if (seqFrame != -1) {
            animated_model.generateBones();
            animated_model.animate(seqFrame);
            animated_model.faceGroups = null;
            animated_model.vertexGroups = null;
        }
        if (this.graphics.resizeXY != 128 || this.graphics.resizeZ != 128) {
            animated_model.scale(this.graphics.resizeXY, this.graphics.resizeXY, this.graphics.resizeZ);
        }
        animated_model.rotateZ(this.pitch);
        animated_model.light(64 + this.graphics.modelBrightness, 850 + this.graphics.modelShadow, -30, -50, -30, true);
        return animated_model;
    }

    @Override
    public Actor getInteracting() {
        int interactingIndex = this.getRsInteracting();
        if (interactingIndex == 0) {
            return null;
        }
        if (interactingIndex > 0) {
            int idx = interactingIndex - 1;
            RSNPC[] npcs = Client.instance.getCachedNPCs();
            return idx >= 0 && idx < npcs.length ? npcs[idx] : null;
        }
        int idx = -interactingIndex - 1;
        if (idx == Client.instance.getLocalPlayerIndex()) {
            return Client.instance.getLocalPlayer();
        }
        RSPlayer[] players = Client.instance.getCachedPlayers();
        return idx >= 0 && idx < players.length ? players[idx] : null;
    }

    @Override
    public int getRemainingCycles() {
        int currentGameCycle = Client.instance.getGameCycle();
        int remaining = this.getEndCycle() - currentGameCycle;
        return Math.max(0, remaining);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRsInteracting() {
        return this.targetIndex;
    }

    @Override
    public int getHeight() {
        return this.sourceZ;
    }

    @Override
    public int getEndHeight() {
        return this.endHeight;
    }

    @Override
    public int getX1() {
        return this.sourceX;
    }

    @Override
    public int getY1() {
        return this.sourceY;
    }

    @Override
    public int getFloor() {
        return this.plane;
    }

    @Override
    public int getStartMovementCycle() {
        return this.cycleStart;
    }

    @Override
    public int getEndCycle() {
        return this.cycleEnd;
    }

    @Override
    public int getSlope() {
        return this.slope;
    }

    @Override
    public int getStartHeight() {
        return this.startHeight;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getScalar() {
        return this.speed;
    }

    @Override
    public double getVelocityX() {
        return this.speedX;
    }

    @Override
    public double getVelocityY() {
        return this.speedY;
    }

    @Override
    public double getVelocityZ() {
        return this.speedZ;
    }
}

