/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer1;
import com.client.FileArchive;
import com.client.IndexedImage;
import com.client.Rasterizer2D;
import com.client.engine.impl.MouseHandler;
import com.client.sign.Signlink;
import com.client.utilities.FileUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.runelite.rs.api.RSSpritePixels;

public final class Sprite
extends Rasterizer2D
implements RSSpritePixels {
    public static final Sprite EMPTY_SPRITE = new Sprite();
    public static String location = null;
    public int xPosition;
    int yPosition;
    public int[] myPixels;
    public int myWidth;
    public int myHeight;
    public int drawOffsetX;
    public int drawOffsetY;
    public int maxWidth;
    public int maxHeight;

    public Sprite(int i, int j) {
        this.myPixels = new int[i * j];
        this.myWidth = this.maxWidth = i;
        this.myHeight = this.maxHeight = j;
        this.drawOffsetY = 0;
        this.drawOffsetX = 0;
    }

    public Sprite(byte[] data2, int file) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data2);
            BufferedImage image = ImageIO.read(is);
            this.myWidth = image.getWidth();
            this.myHeight = image.getHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            Color color = Color.MAGENTA;
            this.setTransparency(color.getRed(), color.getGreen(), color.getBlue());
        }
        catch (Exception _ex) {
            System.out.println("Could not load Image: " + file);
            _ex.printStackTrace();
        }
    }

    public Sprite(int width, int height, int offsetX, int offsetY, int[] pixels) {
        this.myWidth = width;
        this.myHeight = height;
        this.drawOffsetX = offsetX;
        this.drawOffsetY = offsetY;
        this.myPixels = pixels;
        Color color = Color.MAGENTA;
        this.setTransparency(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Sprite(int[] pixels, int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
        this.myPixels = pixels;
        Color color = Color.MAGENTA;
        this.setTransparency(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Sprite(URL url) {
        try {
            if (url == null) {
                return;
            }
            BufferedImage image = ImageIO.read(url.openStream());
            this.myWidth = image.getWidth();
            this.myHeight = image.getHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            this.setTransparency(255, 0, 255);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    Sprite() {
    }

    public void highlight(int color) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int[] raster = new int[this.myWidth * this.myHeight];
        int start = 0;
        for (int y = 0; y < this.myHeight; ++y) {
            for (int x = 0; x < this.myWidth; ++x) {
                int outline = this.myPixels[start];
                if (outline == 0) {
                    if (x > 0 && this.myPixels[start - 1] != 0) {
                        outline = color;
                    } else if (y > 0 && this.myPixels[start - this.myWidth] != 0) {
                        outline = color;
                    } else if (x < this.myWidth - 1 && this.myPixels[start + 1] != 0) {
                        outline = color;
                    } else if (y < this.myHeight - 1 && this.myPixels[start + this.myWidth] != 0) {
                        outline = color;
                    }
                }
                raster[start++] = outline;
            }
        }
        this.myPixels = raster;
    }

    public static void start() {
        location = Signlink.getCacheDirectory() + "sprites/";
    }

    public void outline(int color) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int[] raster = new int[this.myWidth * this.myHeight];
        int start = 0;
        for (int y = 0; y < this.myHeight; ++y) {
            for (int x = 0; x < this.myWidth; ++x) {
                int outline = this.myPixels[start];
                if (outline == 0) {
                    if (x > 0 && this.myPixels[start - 1] != 0) {
                        outline = color;
                    } else if (y > 0 && this.myPixels[start - this.myWidth] != 0) {
                        outline = color;
                    } else if (x < this.myWidth - 1 && this.myPixels[start + 1] != 0) {
                        outline = color;
                    } else if (y < this.myHeight - 1 && this.myPixels[start + this.myWidth] != 0) {
                        outline = color;
                    }
                }
                raster[start++] = outline;
            }
        }
        this.myPixels = raster;
    }

    public static BufferedImage crop(BufferedImage image) {
        int minY = 0;
        int maxY = 0;
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        boolean minYIsDefined = false;
        WritableRaster raster = image.getRaster();
        for (int y = 0; y < image.getHeight(); ++y) {
            boolean isBlank = true;
            for (int x = 0; x < image.getWidth(); ++x) {
                if (raster.getPixel(x, y, (int[])null)[3] == 0) continue;
                isBlank = false;
                if (x < minX) {
                    minX = x;
                }
                if (x <= maxX) continue;
                maxX = x;
            }
            if (isBlank) continue;
            if (!minYIsDefined) {
                minY = y;
                minYIsDefined = true;
                continue;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        return image.getSubimage(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    public void crop() {
        int y;
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        boolean foundMinX = false;
        block0: for (int x = 0; x < this.myWidth && !foundMinX; ++x) {
            for (int y2 = 0; y2 < this.myHeight; ++y2) {
                if (this.myPixels[y2 * this.myWidth + x] == 0) continue;
                minX = x;
                foundMinX = true;
                continue block0;
            }
        }
        boolean foundMaxX = false;
        block2: for (int x = this.myWidth - 1; x >= 0 && !foundMaxX; --x) {
            for (y = 0; y < this.myHeight; ++y) {
                if (this.myPixels[y * this.myWidth + x] == 0) continue;
                maxX = x;
                foundMaxX = true;
                continue block2;
            }
        }
        boolean foundMinY = false;
        block4: for (y = 0; y < this.myHeight && !foundMinY; ++y) {
            for (int x = 0; x < this.myWidth; ++x) {
                if (this.myPixels[y * this.myWidth + x] == 0) continue;
                minY = y;
                foundMinY = true;
                continue block4;
            }
        }
        boolean foundMaxY = false;
        block6: for (int y3 = this.myHeight - 1; y3 >= 0 && !foundMaxY; --y3) {
            for (int x = 0; x < this.myWidth; ++x) {
                if (this.myPixels[y3 * this.myWidth + x] == 0) continue;
                maxY = y3 + 1;
                foundMaxY = true;
                continue block6;
            }
        }
        int width = maxX - minX;
        int height = maxY - minY;
        int[] newPixels = new int[(maxX - minX) * (maxY - minY)];
        for (int x = minX; x < maxX; ++x) {
            for (int y4 = minY; y4 < maxY; ++y4) {
                newPixels[x - minX + (y4 - minY) * width] = this.myPixels[x + y4 * this.myWidth];
            }
        }
        this.myWidth = width;
        this.myHeight = height;
        this.myPixels = newPixels;
    }

    public void shadow(int color) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int y = this.myHeight - 1; y > 0; --y) {
            int pos = y * this.myWidth;
            for (int x = this.myWidth - 1; x > 0; --x) {
                if (this.myPixels[x + pos] != 0 || this.myPixels[x + pos - 1 - this.myWidth] == 0) continue;
                this.myPixels[x + pos] = color;
            }
        }
    }

    public Sprite(byte[] data2, Component component) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(data2);
            MediaTracker mediatracker = new MediaTracker(component);
            mediatracker.addImage(image, 0);
            mediatracker.waitForAll();
            this.myWidth = image.getWidth(component);
            this.myHeight = image.getHeight(component);
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
        }
        catch (Exception _ex) {
            System.out.println("Error converting jpg");
        }
    }

    public boolean isMousedOver(int spriteX, int spriteY, int mouseX, int mouseY) {
        return mouseX >= spriteX && mouseY >= spriteY && mouseX <= spriteX + this.myWidth && mouseY <= spriteY + this.myHeight;
    }

    public Sprite(String img, int width, int height) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(FileUtils.readFile(img));
            this.myWidth = width;
            this.myHeight = height;
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public Sprite(Sprite sprite, int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
        this.maxWidth = width;
        this.maxHeight = height;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
        this.myPixels = new int[width * height];
        System.arraycopy(sprite.myPixels, 0, this.myPixels, 0, this.myPixels.length);
    }

    public Sprite(String img) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(Signlink.getCacheDirectory() + "Sprites/" + img + ".png");
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public Sprite(Image image) {
        ImageIcon imageicon = new ImageIcon(image);
        imageicon.getIconHeight();
        imageicon.getIconWidth();
        try {
            this.myWidth = imageicon.getIconWidth();
            this.myHeight = imageicon.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public void drawHoverSprite(int x, int y, int offsetX, int offsetY, Sprite hover) {
        this.drawSprite(x, y);
        if (MouseHandler.mouseX >= offsetX + x && MouseHandler.mouseX <= offsetX + x + this.myWidth && MouseHandler.mouseY >= offsetY + y && MouseHandler.mouseY <= offsetY + y + this.myHeight) {
            hover.drawSprite(x, y);
        }
    }

    public void draw24BitSprite(int x, int y) {
        int alpha = 256;
        int destOffset = (x += this.drawOffsetX) + (y += this.drawOffsetY) * Rasterizer2D.width;
        int srcOffset = 0;
        int height = this.myHeight;
        int width = this.myWidth;
        int destStep = Rasterizer2D.width - width;
        int srcStep = 0;
        if (y < Rasterizer2D.topY) {
            int trimHeight = Rasterizer2D.topY - y;
            height -= trimHeight;
            y = Rasterizer2D.topY;
            srcOffset += trimHeight * width;
            destOffset += trimHeight * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int trimLeft = Rasterizer2D.leftX - x;
            width -= trimLeft;
            x = Rasterizer2D.leftX;
            srcOffset += trimLeft;
            destOffset += trimLeft;
            srcStep += trimLeft;
            destStep += trimLeft;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int trimRight = x + width - Rasterizer2D.bottomX;
            width -= trimRight;
            srcStep += trimRight;
            destStep += trimRight;
        }
        if (width > 0 && height > 0) {
            this.set24BitPixels(width, height, Rasterizer2D.pixels, this.myPixels, alpha, destOffset, srcOffset, destStep, srcStep);
        }
    }

    public void drawTransparentSprite(int x, int y, int opacity) {
        int k = opacity;
        int i1 = (x += this.drawOffsetX) + (y += this.drawOffsetY) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (y < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - y;
            k1 -= k2;
            y = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (y + k1 > Rasterizer2D.bottomY) {
            k1 -= y + k1 - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - x;
            l1 -= l2;
            x = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (x + l1 > Rasterizer2D.bottomX) {
            int i3 = x + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void set24BitPixels(int width, int height, int[] destPixels, int[] srcPixels, int srcAlpha, int destOffset, int srcOffset, int destStep, int srcStep) {
        for (int loop = -height; loop < 0; ++loop) {
            for (int loop2 = -width; loop2 < 0; ++loop2) {
                int srcColor;
                srcAlpha = this.myPixels[srcOffset] >> 24 & 0xFF;
                int destAlpha = 256 - srcAlpha;
                if ((srcColor = srcPixels[srcOffset++]) != 0 && srcColor != 0xFFFFFF) {
                    int destColor = destPixels[destOffset];
                    destPixels[destOffset++] = ((srcColor & 0xFF00FF) * srcAlpha + (destColor & 0xFF00FF) * destAlpha & 0xFF00FF00) + ((srcColor & 0xFF00) * srcAlpha + (destColor & 0xFF00) * destAlpha & 0xFF0000) >> 8;
                    continue;
                }
                ++destOffset;
            }
            destOffset += destStep;
            srcOffset += srcStep;
        }
    }

    public void setTransparency(int transRed, int transGreen, int transBlue) {
        for (int index = 0; index < this.myPixels.length; ++index) {
            if ((this.myPixels[index] >> 16 & 0xFF) != transRed || (this.myPixels[index] >> 8 & 0xFF) != transGreen || (this.myPixels[index] & 0xFF) != transBlue) continue;
            this.myPixels[index] = 0;
        }
    }

    public Sprite(FileArchive archive, String name, int i) {
        Buffer1 dataBuffer = new Buffer1(archive.readFile(name + ".dat"));
        Buffer1 indexBuffer = new Buffer1(archive.readFile("index.dat"));
        indexBuffer.currentPosition = dataBuffer.readUShort();
        this.maxWidth = indexBuffer.readUShort();
        this.maxHeight = indexBuffer.readUShort();
        int pixelCount = indexBuffer.readUnsignedByte();
        int[] raster = new int[pixelCount];
        for (int pixel = 0; pixel < pixelCount - 1; ++pixel) {
            raster[pixel + 1] = indexBuffer.readTriByte();
            if (raster[pixel + 1] != 0) continue;
            raster[pixel + 1] = 1;
        }
        for (int index = 0; index < i; ++index) {
            indexBuffer.currentPosition += 2;
            dataBuffer.currentPosition += indexBuffer.readUShort() * indexBuffer.readUShort();
            ++indexBuffer.currentPosition;
        }
        this.drawOffsetX = indexBuffer.readUnsignedByte();
        this.drawOffsetY = indexBuffer.readUnsignedByte();
        this.myWidth = indexBuffer.readUShort();
        this.myHeight = indexBuffer.readUShort();
        int type2 = indexBuffer.readUnsignedByte();
        int spriteSize = this.myWidth * this.myHeight;
        this.myPixels = new int[spriteSize];
        if (type2 == 0) {
            for (int pixel = 0; pixel < spriteSize; ++pixel) {
                this.myPixels[pixel] = raster[dataBuffer.readUnsignedByte()];
            }
            this.setTransparency(255, 0, 255);
            return;
        }
        if (type2 == 1) {
            for (int x = 0; x < this.myWidth; ++x) {
                for (int y = 0; y < this.myHeight; ++y) {
                    this.myPixels[x + y * this.myWidth] = raster[dataBuffer.readUnsignedByte()];
                }
            }
        }
        this.setTransparency(255, 0, 255);
    }

    public void init() {
        Rasterizer2D.initDrawingArea(this.myHeight, this.myWidth, this.myPixels);
    }

    public void method344(int i, int j, int k) {
        for (int i1 = 0; i1 < this.myPixels.length; ++i1) {
            int j1 = this.myPixels[i1];
            if (j1 == 0) continue;
            int k1 = j1 >> 16 & 0xFF;
            if ((k1 += i) < 1) {
                k1 = 1;
            } else if (k1 > 255) {
                k1 = 255;
            }
            int l1 = j1 >> 8 & 0xFF;
            if ((l1 += j) < 1) {
                l1 = 1;
            } else if (l1 > 255) {
                l1 = 255;
            }
            int i2 = j1 & 0xFF;
            if ((i2 += k) < 1) {
                i2 = 1;
            } else if (i2 > 255) {
                i2 = 255;
            }
            this.myPixels[i1] = (k1 << 16) + (l1 << 8) + i2;
        }
    }

    public void method345() {
        int[] ai = new int[this.maxWidth * this.maxHeight];
        for (int j = 0; j < this.myHeight; ++j) {
            System.arraycopy(this.myPixels, j * this.myWidth, ai, j + this.drawOffsetY * this.maxWidth + this.drawOffsetX, this.myWidth);
        }
        this.myPixels = ai;
        this.myWidth = this.maxWidth;
        this.myHeight = this.maxHeight;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
    }

    public void method346(int x, int y) {
        int l = (x += this.drawOffsetX) + (y += this.drawOffsetY) * Rasterizer2D.width;
        int i1 = 0;
        int height = this.myHeight;
        int width = this.myWidth;
        int l1 = Rasterizer2D.width - width;
        int i2 = 0;
        if (y < Rasterizer2D.topY) {
            int j2 = Rasterizer2D.topY - y;
            height -= j2;
            y = Rasterizer2D.topY;
            i1 += j2 * width;
            l += j2 * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int k2 = Rasterizer2D.leftX - x;
            width -= k2;
            x = Rasterizer2D.leftX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int l2 = x + width - Rasterizer2D.bottomX;
            width -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (width > 0 && height > 0) {
            this.method347(l, width, height, i2, i1, l1, this.myPixels, Rasterizer2D.pixels);
        }
    }

    private void method347(int i, int j, int k, int l, int i1, int k1, int[] ai, int[] ai1) {
        int l1 = -(j >> 2);
        j = -(j & 3);
        for (int i2 = -k; i2 < 0; ++i2) {
            int val;
            for (int j2 = l1; j2 < 0; ++j2) {
                val = ai[i1++];
                Sprite.drawAlpha(ai1, i++, val, 255);
                val = ai[i1++];
                Sprite.drawAlpha(ai1, i++, val, 255);
                val = ai[i1++];
                Sprite.drawAlpha(ai1, i++, val, 255);
                val = ai[i1++];
                Sprite.drawAlpha(ai1, i++, val, 255);
            }
            for (int k2 = j; k2 < 0; ++k2) {
                val = ai[i1++];
                Sprite.drawAlpha(ai1, i++, val, 255);
            }
            i += k1;
            i1 += l;
        }
    }

    public void drawSprite1(int i, int j) {
        this.drawSprite1(i, j, 128);
    }

    public void drawSprite1(int i, int j, int k, boolean overrideCanvas) {
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (!(overrideCanvas && j > 0 || j >= Rasterizer2D.topY)) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (!overrideCanvas && i < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - i;
            l1 -= l2;
            i = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSprite1(int i, int j, int k) {
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (j < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - i;
            l1 -= l2;
            i = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawCenteredSprite(int x, int y) {
        this.drawSprite(x - this.myWidth / 2, y - this.myHeight / 2);
    }

    public void drawAdvancedSpriteCentered(int i, int j) {
        this.drawAdvancedSprite(i - this.myWidth / 2, j - this.myHeight / 2);
    }

    public void drawSprite(int x, int y) {
        int dx;
        int rasterClip = (x += this.drawOffsetX) + (y += this.drawOffsetY) * Rasterizer2D.width;
        int imageClip = 0;
        int height = this.myHeight;
        int width = this.myWidth;
        int rasterOffset = Rasterizer2D.width - width;
        int imageOffset = 0;
        if (y < Rasterizer2D.topY) {
            int dy = Rasterizer2D.topY - y;
            height -= dy;
            y = Rasterizer2D.topY;
            imageClip += dy * width;
            rasterClip += dy * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            dx = Rasterizer2D.leftX - x;
            width -= dx;
            x = Rasterizer2D.leftX;
            imageClip += dx;
            rasterClip += dx;
            imageOffset += dx;
            rasterOffset += dx;
        }
        if (x + width > Rasterizer2D.bottomX) {
            dx = x + width - Rasterizer2D.bottomX;
            width -= dx;
            imageOffset += dx;
            rasterOffset += dx;
        }
        if (width > 0 && height > 0) {
            this.method349(Rasterizer2D.pixels, this.myPixels, imageClip, rasterClip, width, height, rasterOffset, imageOffset);
        }
    }

    public void drawSprite(int i, int k, int color) {
        int y;
        int x;
        int tempWidth = this.myWidth + 2;
        int tempHeight = this.myHeight + 2;
        int[] tempArray = new int[tempWidth * tempHeight];
        for (x = 0; x < this.myWidth; ++x) {
            for (y = 0; y < this.myHeight; ++y) {
                if (this.myPixels[x + y * this.myWidth] == 0) continue;
                tempArray[x + 1 + (y + 1) * tempWidth] = this.myPixels[x + y * this.myWidth];
            }
        }
        for (x = 0; x < tempWidth; ++x) {
            for (y = 0; y < tempHeight; ++y) {
                if (tempArray[x + y * tempWidth] != 0) continue;
                if (x < tempWidth - 1 && tempArray[x + 1 + y * tempWidth] > 0 && tempArray[x + 1 + y * tempWidth] != 0xFFFFFF) {
                    Sprite.drawAlpha(tempArray, x + y * tempWidth, color, 255);
                }
                if (x > 0 && tempArray[x - 1 + y * tempWidth] > 0 && tempArray[x - 1 + y * tempWidth] != 0xFFFFFF) {
                    Sprite.drawAlpha(tempArray, x + y * tempWidth, color, 255);
                }
                if (y < tempHeight - 1 && tempArray[x + (y + 1) * tempWidth] > 0 && tempArray[x + (y + 1) * tempWidth] != 0xFFFFFF) {
                    Sprite.drawAlpha(tempArray, x + y * tempWidth, color, 255);
                }
                if (y <= 0 || tempArray[x + (y - 1) * tempWidth] <= 0 || tempArray[x + (y - 1) * tempWidth] == 0xFFFFFF) continue;
                Sprite.drawAlpha(tempArray, x + y * tempWidth, color, 255);
            }
        }
        --i;
        --k;
        int l = (i += this.drawOffsetX) + (k += this.drawOffsetY) * Rasterizer2D.width;
        int i1 = 0;
        int j1 = tempHeight;
        int k1 = tempWidth;
        int l1 = Rasterizer2D.width - k1;
        int i2 = 0;
        if (k < Rasterizer2D.topY) {
            int j2 = Rasterizer2D.topY - k;
            j1 -= j2;
            k = Rasterizer2D.topY;
            i1 += j2 * k1;
            l += j2 * Rasterizer2D.width;
        }
        if (k + j1 > Rasterizer2D.bottomY) {
            j1 -= k + j1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.leftX) {
            int k2 = Rasterizer2D.leftX - i;
            k1 -= k2;
            i = Rasterizer2D.leftX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > Rasterizer2D.bottomX) {
            int l2 = i + k1 - Rasterizer2D.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.method349(Rasterizer2D.pixels, tempArray, i1, l, k1, j1, l1, i2);
        }
    }

    public void drawSprite2(int i, int j) {
        int k = 225;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (j < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - i;
            l1 -= l2;
            i = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void method349(int[] ai, int[] ai1, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = -(l >> 2);
        l = -(l & 3);
        for (int i2 = -i1; i2 < 0; ++i2) {
            int i;
            for (int j2 = l1; j2 < 0; ++j2) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    Sprite.drawAlpha(ai, k++, i, 255);
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    Sprite.drawAlpha(ai, k++, i, 255);
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    Sprite.drawAlpha(ai, k++, i, 255);
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    Sprite.drawAlpha(ai, k++, i, 255);
                    continue;
                }
                ++k;
            }
            for (int k2 = l; k2 < 0; ++k2) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    Sprite.drawAlpha(ai, k++, i, 255);
                    continue;
                }
                ++k;
            }
            k += j1;
            j += k1;
        }
    }

    private void method351(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int j2 = 256 - k1;
        for (int k2 = -i1; k2 < 0; ++k2) {
            for (int l2 = -j; l2 < 0; ++l2) {
                int k;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    Sprite.drawAlpha(ai, l1++, ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8, k1);
                    continue;
                }
                ++l1;
            }
            l1 += j1;
            i += l;
        }
    }

    public void rotate(int i, int j, int[] ai, int k, int[] ai1, int i1, int j1, int k1, int l1, int i2) {
        try {
            int j2 = -l1 / 2;
            int k2 = -i / 2;
            int l2 = (int)(Math.sin((double)j / 326.11) * 65536.0);
            int i3 = (int)(Math.cos((double)j / 326.11) * 65536.0);
            l2 = l2 * k >> 8;
            i3 = i3 * k >> 8;
            int j3 = (i2 << 16) + (k2 * l2 + j2 * i3);
            int k3 = (i1 << 16) + (k2 * i3 - j2 * l2);
            int l3 = k1 + j1 * Rasterizer2D.width;
            for (j1 = 0; j1 < i; ++j1) {
                int i4 = ai1[j1];
                int j4 = l3 + i4;
                int k4 = j3 + i3 * i4;
                int l4 = k3 - l2 * i4;
                for (k1 = -ai[j1]; k1 < 0; ++k1) {
                    int x1 = k4 >> 16;
                    int y1 = l4 >> 16;
                    int x2 = x1 + 1;
                    int y2 = y1 + 1;
                    int c1 = this.myPixels[x1 + y1 * this.myWidth];
                    int c2 = this.myPixels[x2 + y1 * this.myWidth];
                    int c3 = this.myPixels[x1 + y2 * this.myWidth];
                    int c4 = this.myPixels[x2 + y2 * this.myWidth];
                    int u1 = (k4 >> 8) - (x1 << 8);
                    int v1 = (l4 >> 8) - (y1 << 8);
                    int u2 = (x2 << 8) - (k4 >> 8);
                    int v2 = (y2 << 8) - (l4 >> 8);
                    int a1 = u2 * v2;
                    int a2 = u1 * v2;
                    int a3 = u2 * v1;
                    int a4 = u1 * v1;
                    int r = (c1 >> 16 & 0xFF) * a1 + (c2 >> 16 & 0xFF) * a2 + (c3 >> 16 & 0xFF) * a3 + (c4 >> 16 & 0xFF) * a4 & 0xFF0000;
                    int g2 = (c1 >> 8 & 0xFF) * a1 + (c2 >> 8 & 0xFF) * a2 + (c3 >> 8 & 0xFF) * a3 + (c4 >> 8 & 0xFF) * a4 >> 8 & 0xFF00;
                    int b = (c1 & 0xFF) * a1 + (c2 & 0xFF) * a2 + (c3 & 0xFF) * a3 + (c4 & 0xFF) * a4 >> 16;
                    Sprite.drawAlpha(Rasterizer2D.pixels, j4++, r | g2 | b, 255);
                    k4 += i3;
                    l4 -= l2;
                }
                j3 += l2;
                k3 += i3;
                l3 += Rasterizer2D.width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method353(int i, double d, int l1) {
        int j = 15;
        int k = 20;
        int l = 15;
        int j1 = 256;
        int k1 = 20;
        try {
            int i2 = -k / 2;
            int j2 = -k1 / 2;
            int k2 = (int)(Math.sin(d) * 65536.0);
            int l2 = (int)(Math.cos(d) * 65536.0);
            k2 = k2 * j1 >> 8;
            l2 = l2 * j1 >> 8;
            int i3 = (l << 16) + (j2 * k2 + i2 * l2);
            int j3 = (j << 16) + (j2 * l2 - i2 * k2);
            int k3 = l1 + i * Rasterizer2D.width;
            for (i = 0; i < k1; ++i) {
                int l3 = k3;
                int i4 = i3;
                int j4 = j3;
                for (l1 = -k; l1 < 0; ++l1) {
                    int k4 = this.myPixels[(i4 >> 16) + (j4 >> 16) * this.myWidth];
                    if (k4 != 0) {
                        Sprite.drawAlpha(Rasterizer2D.pixels, l3++, k4, 255);
                    } else {
                        ++l3;
                    }
                    i4 += l2;
                    j4 -= k2;
                }
                i3 += k2;
                j3 += l2;
                k3 += Rasterizer2D.width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Sprite(byte[] spriteData) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public static Image create(byte[] spriteData) {
        return Toolkit.getDefaultToolkit().createImage(spriteData);
    }

    public void method354(IndexedImage background2, int i, int j) {
        int k = (j += this.drawOffsetX) + (i += this.drawOffsetY) * Rasterizer2D.width;
        int l = 0;
        int i1 = this.myHeight;
        int j1 = this.myWidth;
        int k1 = Rasterizer2D.width - j1;
        int l1 = 0;
        if (i < Rasterizer2D.topY) {
            int i2 = Rasterizer2D.topY - i;
            i1 -= i2;
            i = Rasterizer2D.topY;
            l += i2 * j1;
            k += i2 * Rasterizer2D.width;
        }
        if (i + i1 > Rasterizer2D.bottomY) {
            i1 -= i + i1 - Rasterizer2D.bottomY;
        }
        if (j < Rasterizer2D.leftX) {
            int j2 = Rasterizer2D.leftX - j;
            j1 -= j2;
            j = Rasterizer2D.leftX;
            l += j2;
            k += j2;
            l1 += j2;
            k1 += j2;
        }
        if (j + j1 > Rasterizer2D.bottomX) {
            int k2 = j + j1 - Rasterizer2D.bottomX;
            j1 -= k2;
            l1 += k2;
            k1 += k2;
        }
        if (j1 > 0 && i1 > 0) {
            this.method355(this.myPixels, j1, background2.palettePixels, i1, Rasterizer2D.pixels, 0, k1, k, l1, l);
        }
    }

    public void drawAdvancedSprite(int xPos, int yPos) {
        this.drawAdvancedSprite(xPos, yPos, 256);
    }

    public void drawAdvancedSprite(int xPos, int yPos, int alpha) {
        int alphaValue = alpha;
        this.xPosition = xPos += this.drawOffsetX;
        this.yPosition = yPos += this.drawOffsetY;
        int i1 = xPos + yPos * Rasterizer2D.width;
        int j1 = 0;
        int spriteHeight = this.myHeight;
        int spriteWidth = this.myWidth;
        int i2 = Rasterizer2D.width - spriteWidth;
        int j2 = 0;
        if (yPos < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - yPos;
            spriteHeight -= k2;
            yPos = Rasterizer2D.topY;
            j1 += k2 * spriteWidth;
            i1 += k2 * Rasterizer2D.width;
        }
        if (yPos + spriteHeight > Rasterizer2D.bottomY) {
            spriteHeight -= yPos + spriteHeight - Rasterizer2D.bottomY;
        }
        if (xPos < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - xPos;
            spriteWidth -= l2;
            xPos = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > Rasterizer2D.bottomX) {
            int i3 = xPos + spriteWidth - Rasterizer2D.bottomX;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderARGBPixels(spriteWidth, spriteHeight, this.myPixels, Rasterizer2D.pixels, i1, alphaValue, j1, j2, i2);
        }
    }

    private void renderARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        int alpha = alphaValue;
        for (int height = -spriteHeight; height < 0; ++height) {
            for (int width = -spriteWidth; width < 0; ++width) {
                int pixelColor;
                alphaValue = this.myPixels[i] >> 24 & alpha - 1;
                int alphaLevel = 256 - alphaValue;
                if (alphaLevel > 256) {
                    alphaValue = 0;
                }
                if (alpha == 0) {
                    alphaLevel = 256;
                    alphaValue = 0;
                }
                if ((pixelColor = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    Sprite.drawAlpha(renderAreaPixels, pixel++, ((pixelColor & 0xFF00FF) * alphaValue + (pixelValue & 0xFF00FF) * alphaLevel & 0xFF00FF00) + ((pixelColor & 0xFF00) * alphaValue + (pixelValue & 0xFF00) * alphaLevel & 0xFF0000) >> 8, alphaValue);
                    continue;
                }
                ++pixel;
            }
            pixel += j1;
            i += l;
        }
    }

    private void method355(int[] ai, int i, byte[] abyte0, int j, int[] ai1, int k, int l, int i1, int j1, int k1) {
        int l1 = -(i >> 2);
        i = -(i & 3);
        for (int j2 = -j; j2 < 0; ++j2) {
            for (int k2 = l1; k2 < 0; ++k2) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    Sprite.drawAlpha(ai1, i1++, k, 255);
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    Sprite.drawAlpha(ai1, i1++, k, 255);
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    Sprite.drawAlpha(ai1, i1++, k, 255);
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    Sprite.drawAlpha(ai1, i1++, k, 255);
                    continue;
                }
                ++i1;
            }
            for (int l2 = i; l2 < 0; ++l2) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    Sprite.drawAlpha(ai1, i1++, k, 255);
                    continue;
                }
                ++i1;
            }
            i1 += l;
            k1 += j1;
        }
    }

    public void cutR(int neww) {
        for (int k = 0; k < this.myHeight; ++k) {
            int dd;
            if (this.myWidth * (k + 1) < this.myPixels.length) {
                for (dd = 0; dd < neww; ++dd) {
                    if (this.myWidth * (k + 1) - dd < 0) continue;
                    this.myPixels[this.myWidth * (k + 1) - dd] = 0;
                }
                continue;
            }
            for (dd = 1; dd < neww; ++dd) {
                if (this.myWidth * (k + 1) - dd < 0) continue;
                this.myPixels[this.myWidth * (k + 1) - dd] = 0;
            }
        }
    }

    public void cutL(int neww) {
        for (int k = 0; k < this.myHeight; ++k) {
            int dd;
            if (k * (this.myHeight * this.myWidth) + neww < this.myPixels.length) {
                for (dd = 0; dd < neww; ++dd) {
                    if (k * this.myWidth + dd < 0) continue;
                    this.myPixels[k * this.myWidth + dd] = 0;
                }
                continue;
            }
            for (dd = 0; dd < neww - 1; ++dd) {
                if (k * this.myWidth + dd < 0) continue;
                this.myPixels[k * this.myWidth + dd] = 0;
            }
        }
    }

    @Override
    public void drawAt(int x, int y) {
        this.drawSprite(x, y);
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getOffsetX() {
        return this.drawOffsetX;
    }

    @Override
    public int getOffsetY() {
        return this.drawOffsetY;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public void setOffsetX(int offsetX) {
        this.drawOffsetX = offsetX;
    }

    @Override
    public void setOffsetY(int offsetY) {
        this.drawOffsetY = offsetY;
    }

    @Override
    public int[] getPixels() {
        return this.myPixels;
    }

    @Override
    public void setRaster() {
        this.init();
    }

    @Override
    public BufferedImage toBufferedImage() {
        BufferedImage image = new BufferedImage(this.myWidth, this.myHeight, 2);
        this.toBufferedImage(image);
        return image;
    }

    @Override
    public void toBufferedImage(BufferedImage img) throws IllegalArgumentException {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] pixels = this.getPixels();
        int[] palette = new int[pixels.length];
        for (int pixel = 0; pixel < pixels.length; ++pixel) {
            if (pixels[pixel] == 0) continue;
            palette[pixel] = pixels[pixel] | 0xFF000000;
        }
        img.setRGB(0, 0, width, height, palette, 0, width);
    }

    @Override
    public BufferedImage toBufferedOutline(Color color) {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.toBufferedOutline(img, color.getRGB());
        return img;
    }

    @Override
    public void toBufferedOutline(BufferedImage img, int color) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (img.getWidth() != width || img.getHeight() != height) {
            throw new IllegalArgumentException("Image bounds do not match Sprite");
        }
        int[] pixels = this.getPixels();
        int[] newPixels = new int[width * height];
        int pixelIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[pixelIndex];
                if (pixel == 0xFFFFFF || pixel == 0) {
                    if (x > 0 && pixels[pixelIndex - 1] != 0) {
                        pixel = color;
                    } else if (y > 0 && pixels[pixelIndex - width] != 0) {
                        pixel = color;
                    } else if (x < width - 1 && pixels[pixelIndex + 1] != 0) {
                        pixel = color;
                    } else if (y < height - 1 && pixels[pixelIndex + width] != 0) {
                        pixel = color;
                    }
                    newPixels[pixelIndex] = pixel;
                }
                ++pixelIndex;
            }
        }
        img.setRGB(0, 0, width, height, newPixels, 0, width);
    }
}

