/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.Buffer1;
import com.client.Configuration;
import com.client.FileArchive;
import com.client.Frame;
import com.client.definitions.custom.AnimationDefinitionCustom;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class AnimationDefinition {
    public static AnimationDefinition[] anims;
    public int id;
    public int frameCount;
    public int[] primaryFrames;
    public int[] secondaryFrames;
    public int[] frameSounds;
    public int[] durations;
    public int loopOffset = -1;
    public int[] interleaveOrder;
    public boolean stretches = false;
    public int forcedPriority = 5;
    public int playerOffhand = -1;
    public int playerMainhand = -1;
    public int maximumLoops = 99;
    public int animatingPrecedence = -1;
    public int priority = -1;
    public int replayMode = 2;
    public int[] chatFrameIds;
    private int skeletalRangeBegin = -1;
    private int skeletalRangeEnd = -1;
    private int skeletalId = -1;
    private boolean[] masks;
    public Map<Integer, Integer> skeletalSounds;

    public static void unpackConfig(FileArchive streamLoader) {
        Buffer1 stream = new Buffer1(streamLoader.readFile("seq.dat"));
        int length = stream.readUShort();
        if (anims == null) {
            anims = new AnimationDefinition[length];
        }
        for (int j = 0; j < length; ++j) {
            if (anims[j] == null) {
                AnimationDefinition.anims[j] = new AnimationDefinition();
            }
            AnimationDefinition.anims[j].id = j;
            anims[j].decode(stream);
            AnimationDefinitionCustom.custom(j, anims);
            if (!Configuration.dumpAnimationData || AnimationDefinition.anims[j].durations == null || AnimationDefinition.anims[j].durations.length <= 0) continue;
            int sum = 0;
            for (int i = 0; i < AnimationDefinition.anims[j].durations.length; ++i) {
                if (AnimationDefinition.anims[j].durations[i] >= 100) continue;
                sum += AnimationDefinition.anims[j].durations[i];
            }
            System.out.println(j + ":" + sum);
        }
        if (Configuration.dumpAnimationData) {
            System.out.println("Dumping animation lengths..");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter("./temp/animation_lengths.cfg"));){
                for (int j = 0; j < length; ++j) {
                    if (AnimationDefinition.anims[j].durations == null || AnimationDefinition.anims[j].durations.length <= 0) continue;
                    int sum = 0;
                    for (int i = 0; i < AnimationDefinition.anims[j].durations.length; ++i) {
                        if (AnimationDefinition.anims[j].durations[i] >= 100) continue;
                        sum += AnimationDefinition.anims[j].durations[i];
                    }
                    writer.write(j + ":" + sum);
                    writer.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Dumping animation sounds..");
            for (int j = 0; j < length; ++j) {
                if (AnimationDefinition.anims[j].frameSounds == null) continue;
                System.out.println(j + ":" + Arrays.toString(AnimationDefinition.anims[j].frameSounds));
            }
            System.out.println("Dumping animation fields to /temp/animation_dump.txt");
            AnimationDefinition.dump();
        }
    }

    public int getFrameSound(int frameIndex) {
        if (this.frameSounds != null && frameIndex < this.frameSounds.length && this.frameSounds[frameIndex] != 0) {
            return this.frameSounds[frameIndex];
        }
        return -1;
    }

    public int method258(int i) {
        try {
            Frame class36;
            int j = this.durations[i];
            if (j == 0 && (class36 = Frame.method531(this.primaryFrames[i])) != null) {
                j = this.durations[i] = class36.anInt636;
            }
            if (j == 0) {
                j = 1;
            }
            return j;
        }
        catch (Exception e) {
            System.err.println("Error in animation id: " + this.id);
            e.printStackTrace();
            return 0;
        }
    }

    private void decode(Buffer1 buffer) {
        int opcode;
        while ((opcode = buffer.readUnsignedByte()) != 0) {
            int index;
            int count;
            int i;
            int len;
            if (opcode == 1) {
                int i2;
                this.frameCount = buffer.readUShort();
                this.primaryFrames = new int[this.frameCount];
                this.secondaryFrames = new int[this.frameCount];
                this.durations = new int[this.frameCount];
                for (i2 = 0; i2 < this.frameCount; ++i2) {
                    this.durations[i2] = buffer.readUShort();
                }
                for (i2 = 0; i2 < this.frameCount; ++i2) {
                    this.primaryFrames[i2] = buffer.readUShort();
                    this.secondaryFrames[i2] = -1;
                }
                i2 = 0;
                while (i2 < this.frameCount) {
                    int n = i2++;
                    this.primaryFrames[n] = this.primaryFrames[n] + (buffer.readUShort() << 16);
                }
                continue;
            }
            if (opcode == 2) {
                this.loopOffset = buffer.readUShort();
                continue;
            }
            if (opcode == 3) {
                len = buffer.readUnsignedByte();
                this.interleaveOrder = new int[len + 1];
                for (i = 0; i < len; ++i) {
                    this.interleaveOrder[i] = buffer.readUnsignedByte();
                }
                this.interleaveOrder[len] = 9999999;
                continue;
            }
            if (opcode == 4) {
                this.stretches = true;
                continue;
            }
            if (opcode == 5) {
                this.forcedPriority = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 6) {
                this.playerOffhand = buffer.readUShort();
                continue;
            }
            if (opcode == 7) {
                this.playerMainhand = buffer.readUShort();
                continue;
            }
            if (opcode == 8) {
                this.maximumLoops = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 9) {
                this.animatingPrecedence = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 10) {
                this.priority = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 11) {
                this.replayMode = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 12) {
                len = buffer.readUnsignedByte();
                this.chatFrameIds = new int[len];
                for (i = 0; i < len; ++i) {
                    this.chatFrameIds[i] = buffer.readUShort();
                }
                for (i = 0; i < len; ++i) {
                    this.chatFrameIds[i] = buffer.readUShort() << 16;
                }
                continue;
            }
            if (opcode == 13) {
                len = buffer.readUnsignedByte();
                this.frameSounds = new int[len];
                for (i = 0; i < len; ++i) {
                    this.frameSounds[i] = buffer.read24Int();
                }
                continue;
            }
            if (opcode == 14) {
                this.skeletalId = buffer.readInt();
                continue;
            }
            if (opcode == 15) {
                this.skeletalSounds = new HashMap<Integer, Integer>();
                count = buffer.readUShort();
                for (index = 0; index < count; ++index) {
                    this.skeletalSounds.put(buffer.readUShort(), buffer.read24Int());
                }
                continue;
            }
            if (opcode == 16) {
                this.skeletalRangeBegin = buffer.readUShort();
                this.skeletalRangeEnd = buffer.readUShort();
                continue;
            }
            if (opcode != 17) continue;
            this.masks = new boolean[256];
            Arrays.fill(this.masks, false);
            count = buffer.readUnsignedByte();
            for (index = 0; index < count; ++index) {
                this.masks[buffer.readUnsignedByte()] = true;
            }
        }
        if (this.frameCount == 0) {
            this.frameCount = 1;
            this.primaryFrames = new int[1];
            this.primaryFrames[0] = -1;
            this.secondaryFrames = new int[1];
            this.secondaryFrames[0] = -1;
            this.durations = new int[1];
            this.durations[0] = -1;
        }
        if (this.animatingPrecedence == -1) {
            int n = this.animatingPrecedence = this.interleaveOrder == null ? 0 : 2;
        }
        if (this.priority == -1) {
            this.priority = this.interleaveOrder == null ? 0 : 2;
        }
    }

    public boolean hasSkeletalID() {
        return this.skeletalId >= 0;
    }

    public int skeletalStart() {
        return this.skeletalRangeEnd - this.skeletalRangeBegin;
    }

    public static void dump() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("./temp/animation_dump.txt"));){
            for (int index = 0; index < anims.length; ++index) {
                AnimationDefinition anim = anims[index];
                if (anim == null) continue;
                writer.write("\tcase " + index + ":");
                writer.newLine();
                writer.write("\t\tanim.anInt352 = " + anim.frameCount + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt356 = " + anim.loopOffset + ";");
                writer.newLine();
                writer.write("\t\tanim.aBoolean358 = " + anim.stretches + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt359 = " + anim.forcedPriority + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt360 = " + anim.playerOffhand + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt361 = " + anim.playerMainhand + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt362 = " + anim.maximumLoops + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt363 = " + anim.animatingPrecedence + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt364 = " + anim.priority + ";");
                writer.newLine();
                writer.write("\t\tanim.anInt352 = " + anim.frameCount + ";");
                writer.newLine();
                AnimationDefinition.writeArray(writer, "anIntArray353", anim.primaryFrames);
                AnimationDefinition.writeArray(writer, "anIntArray354", anim.secondaryFrames);
                AnimationDefinition.writeArray(writer, "frameLengths", anim.durations);
                AnimationDefinition.writeArray(writer, "anIntArray357", anim.interleaveOrder);
                AnimationDefinition.writeArray(writer, "class36Ids", anim.getClass36Ids());
                writer.write("\t\tbreak;");
                writer.newLine();
                writer.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int[] getClass36Ids() {
        ArrayList<Integer> ids = Lists.newArrayList();
        for (int frameId : this.primaryFrames) {
            if (ids.contains(Frame.getClass36Id(frameId))) continue;
            ids.add(Frame.getClass36Id(frameId));
        }
        int[] idsArray = new int[ids.size()];
        for (int index = 0; index < idsArray.length; ++index) {
            idsArray[index] = (Integer)ids.get(index);
        }
        return idsArray;
    }

    private static void writeArray(BufferedWriter writer, String name, int[] array) throws IOException {
        writer.write("\t\tanim." + name + " = ");
        if (array == null) {
            writer.write("null;");
        } else {
            writer.write("new int[] {");
            for (int value : array) {
                writer.write(value + ", ");
            }
            writer.write("};");
        }
        writer.newLine();
    }
}

