/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.Buffer;
import com.client.FileArchive;
import com.client.sign.Signlink;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public final class AreaDefinition {
    public static int totalAreas;
    public static AreaDefinition[] cache;
    private static int cacheIndex;
    private static Buffer area_data;
    private static int[] streamIndices;
    public int id = -1;
    public int spriteId = -1;
    public int field3294 = -1;
    public String name = "";
    public int field3296 = -1;
    public int field3297 = -1;
    public String[] actions;
    public int field3310 = -1;

    private AreaDefinition() {
    }

    public static void clear() {
        streamIndices = null;
        cache = null;
        area_data = null;
    }

    public static void init(FileArchive archive) {
        int _ctr;
        area_data = new Buffer(archive.readFile("areas.dat"));
        Buffer stream = new Buffer(archive.readFile("areas.idx"));
        totalAreas = stream.readUShort();
        streamIndices = new int[totalAreas];
        int offset = 2;
        for (_ctr = 0; _ctr < totalAreas; ++_ctr) {
            AreaDefinition.streamIndices[_ctr] = offset;
            offset += stream.readUShort();
        }
        cache = new AreaDefinition[10];
        for (_ctr = 0; _ctr < 10; ++_ctr) {
            AreaDefinition.cache[_ctr] = new AreaDefinition();
        }
        System.out.println("Loaded: " + totalAreas + " Areas");
    }

    public static void dumpObjectList() {
        for (int i = 0; i < totalAreas; ++i) {
            AreaDefinition class5 = AreaDefinition.lookup(i);
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(Signlink.getCacheDirectory() + "/dumps/area.txt", true));
                if (class5.name == null) continue;
                bw.write("case " + i + ";");
                bw.newLine();
                bw.write("type.spriteId " + class5.spriteId + ";");
                bw.newLine();
                bw.write("type.field3294 " + class5.field3294 + ";");
                bw.newLine();
                bw.write("type.name " + class5.name + ";");
                bw.newLine();
                bw.flush();
                bw.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static AreaDefinition lookup(int itemId) {
        for (int count = 0; count < 10; ++count) {
            if (AreaDefinition.cache[count].id != itemId) continue;
            return cache[count];
        }
        cacheIndex = (cacheIndex + 1) % 10;
        AreaDefinition itemDef = cache[cacheIndex];
        if (itemId > 0) {
            AreaDefinition.area_data.currentPosition = streamIndices[itemId];
        }
        itemDef.id = itemId;
        itemDef.readValues(area_data);
        switch (itemId) {
            case 0: {
                itemDef.spriteId = 0;
                itemDef.field3294 = -1;
                break;
            }
            case 13: {
                itemDef.spriteId = 13;
                itemDef.field3294 = -1;
            }
        }
        return itemDef;
    }

    public void readValues(Buffer buffer) {
        int opCode;
        while ((opCode = buffer.readUnsignedByte()) != 0) {
            if (opCode == 1) {
                this.spriteId = buffer.readInt();
                continue;
            }
            if (opCode == 2) {
                this.field3294 = buffer.readInt();
                continue;
            }
            if (opCode == 3) {
                this.name = buffer.readNewString();
                continue;
            }
            if (opCode == 4) {
                this.field3296 = buffer.readInt();
                continue;
            }
            if (opCode == 5) {
                this.field3297 = buffer.readInt();
                continue;
            }
            if (opCode == 6) {
                this.field3296 = buffer.readInt();
                continue;
            }
            if (opCode >= 6 && opCode < 11) {
                if (this.actions == null) {
                    this.actions = new String[5];
                }
                this.actions[opCode - 6] = buffer.readNewString();
                continue;
            }
            if (opCode != 12) continue;
            this.field3310 = buffer.readInt();
        }
        return;
    }
}

