/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.Buffer;
import com.client.Client;
import com.client.Configuration;
import com.client.FileArchive;
import com.client.Frame;
import com.client.Model;
import com.client.ReferenceCache;
import com.client.definitions.NpcDefinitionDumper;
import com.client.definitions.VarBit;
import com.client.utilities.FieldGenerator;
import com.client.utilities.TempWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.runelite.api.HeadIcon;
import net.runelite.api.IterableHashTable;
import net.runelite.rs.api.RSIterableNodeHashTable;
import net.runelite.rs.api.RSNPCComposition;

public final class NpcDefinition
implements RSNPCComposition {
    public int[] headIconArchiveIds;
    public short[] headIconSpriteIndex;
    public int runRotate180Animation = -1;
    public int runRotateLeftAnimation = -1;
    public int runRotateRightAnimation = -1;
    public int crawlAnimation = -1;
    public int crawlRotate180Animation = -1;
    public int runAnimation = -1;
    public int crawlRotateLeftAnimation = -1;
    public int crawlRotateRightAnimation = -1;
    public static int totalAmount;
    public int category;
    public int rotate90CCWAnimIndex = -1;
    public static int anInt56;
    public int varbitId = this.walkingAnimation;
    public int rotate180AnimIndex = this.walkingAnimation;
    public int varpIndex = this.walkingAnimation;
    public static Buffer stream;
    public int combatLevel = -1;
    public final int anInt64;
    public String name;
    public String[] actions;
    public int walkingAnimation = -1;
    public byte size = 1;
    public int[] newColors;
    public static int[] streamIndices;
    public int[] chatheadModels;
    public int anInt75 = -1;
    public int[] originalColors;
    public short[] originalTextures;
    public short[] newTextures;
    public int standingAnimation = -1;
    public long npcId = -1L;
    public int rotationSpeed = 32;
    public static NpcDefinition[] cache;
    public static Client clientInstance;
    public int rotate90CWAnimIndex = -1;
    public boolean clickable = true;
    public int ambient;
    public int npcWidth = 128;
    public boolean onMinimap = true;
    public int[] configs;
    public String description;
    public int npcHeight = 128;
    public int contrast;
    public boolean aBoolean93 = false;
    public int[] models;
    public static ReferenceCache mruNodes;
    public int[] anIntArray76;

    public static NpcDefinition lookup(int i) {
        for (int j = 0; j < 20; ++j) {
            if (NpcDefinition.cache[j].npcId != (long)i) continue;
            return cache[j];
        }
        anInt56 = (anInt56 + 1) % 20;
        NpcDefinition entityDef = NpcDefinition.cache[NpcDefinition.anInt56] = new NpcDefinition();
        NpcDefinition.stream.currentPosition = streamIndices[i];
        entityDef.npcId = i;
        entityDef.readValues(stream);
        if (i == 5449) {
            entityDef.actions = new String[]{"Talk-to", "Prices", "Decant", "Clean", null};
        }
        if (i == 4753) {
            entityDef.actions[0] = "Trade";
        }
        if (i == 4423) {
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Talk-to";
            entityDef.actions[2] = "Trade";
        }
        if (i == 9460 || i == 1150 || i == 2912 || i == 2911 || i == 2910 || i == 6481 || i == 3500 || i == 9459 || i == 9457 || i == 9458) {
            entityDef.combatLevel = 0;
        }
        if (i == 7456) {
            entityDef.actions = new String[]{"Talk-to", null, "Reclaim-lost", null, null};
        }
        if (i == 2549) {
            entityDef.name = "Mortaled Imp";
            entityDef.models = new int[]{34156};
            entityDef.walkingAnimation = 168;
            entityDef.standingAnimation = 171;
            entityDef.combatLevel = 28;
            entityDef.clickable = true;
            entityDef.size = 1;
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.newColors = new int[]{6073, 6093};
            entityDef.originalColors = new int[]{45, 43100};
        }
        if (i == 2550) {
            entityDef.name = "Mortaled Pyrefiend";
            entityDef.models = new int[]{34142};
            entityDef.walkingAnimation = 1579;
            entityDef.standingAnimation = 1578;
            entityDef.combatLevel = 78;
            entityDef.clickable = true;
            entityDef.size = (byte)2;
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.newColors = new int[]{6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093};
            entityDef.originalColors = new int[]{0, 24, 43043, 43055, 43074, 43078, 43086, 404};
        }
        if (i == 2551) {
            entityDef.name = "Mortaled Hellhound";
            entityDef.models = new int[]{34143};
            entityDef.walkingAnimation = 6583;
            entityDef.standingAnimation = 6580;
            entityDef.combatLevel = 165;
            entityDef.clickable = true;
            entityDef.size = (byte)3;
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.newColors = new int[]{6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073};
            entityDef.originalColors = new int[]{0, 8, 16, 43034, 43047, 43053, 43065, 43069, 78, 43086, 960};
        }
        if (i == 2552) {
            entityDef.name = "Mortaled Ork";
            entityDef.models = new int[]{34154};
            entityDef.walkingAnimation = 4319;
            entityDef.standingAnimation = 4318;
            entityDef.combatLevel = 225;
            entityDef.clickable = true;
            entityDef.size = (byte)3;
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.newColors = new int[]{6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093};
            entityDef.originalColors = new int[]{16, 24, 28, 33, 37, 45, 43086, 43100, 8286, 43109};
        }
        if (i == 2553) {
            entityDef.name = "Mortaled Knight";
            entityDef.models = new int[]{34145};
            entityDef.walkingAnimation = 1205;
            entityDef.standingAnimation = 813;
            entityDef.combatLevel = 305;
            entityDef.clickable = true;
            entityDef.size = 1;
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.newColors = new int[]{6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073};
            entityDef.originalColors = new int[]{0, 20, 30, 43045, 39, 43053, 47, 43057, 43061, 43072, 43080, 43086, 43100, 272, 4626};
        }
        if (i == 2554) {
            entityDef.name = "Mortaled Dragon";
            entityDef.models = new int[]{34163};
            entityDef.walkingAnimation = 79;
            entityDef.standingAnimation = 90;
            entityDef.combatLevel = 425;
            entityDef.clickable = true;
            entityDef.size = (byte)5;
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.newColors = new int[]{6073, 6093, 6073, 6093, 6073, 6093, 6073, 6093, 6073};
            entityDef.originalColors = new int[]{0, 163, 5219, 38119, 43086, 43090, 43098, 43105, 43107};
        }
        if (i == 6785) {
            entityDef.name = "Boss Challenge Master";
        }
        if (i == 8184) {
            entityDef.name = "Theatre Of Blood Wizard";
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Teleport";
        }
        if (i == 4589) {
            entityDef.name = "Mortal Shop";
            entityDef.actions[0] = "Open Shop";
        }
        if (i == 7599) {
            entityDef.name = "Mortal Guide";
        }
        if (i == 4305) {
            entityDef.name = "Drunken cannoneer";
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Pickpocket";
        }
        if (i == 3247) {
            entityDef.name = "Wizard";
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Teleport";
        }
        if (i == 3925) {
            entityDef.name = "Mortal Membership";
        }
        if (i == 943) {
            entityDef.name = "Slayer Extender";
        }
        if (i == 777) {
            entityDef.name = "Collection Logger";
        }
        if (i == 6517) {
            entityDef.name = "Daily-reward wizard";
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Talk-to";
            entityDef.actions[2] = "View rewards";
        }
        if (i == 3428 || i == 3429) {
            entityDef.name = "Elf warrior";
        }
        if (i == 5044) {
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Decant-potions";
        }
        if (i == 8026) {
            entityDef.combatLevel = 392;
        }
        if (i == 7913) {
            entityDef.combatLevel = 0;
            entityDef.name = "Ironman shop keeper";
            entityDef.description = "A shop specifically for iron men.";
        }
        if (i == 8906) {
            entityDef.combatLevel = 0;
            entityDef.name = "Santa's little elf";
            entityDef.description = "A helper sent from santa himself.";
            entityDef.actions = new String[]{"Talk-To", null, "Christmas Shop", "Return-Items", null};
        }
        if (i == 3308) {
            entityDef.name = "Leaderboard Manager";
            entityDef.actions = new String[]{"Open Leaderboard", null, null, null, null};
        }
        if (i == 954) {
            entityDef.combatLevel = 0;
            entityDef.name = "Crystal Seed Trader";
            entityDef.description = "Use a seed on me to get a Crystal Bow.";
        }
        if (i == 9026) {
            entityDef.name = "Earthy Rat";
            entityDef.newColors = new int[]{0, 0};
            entityDef.originalColors = new int[]{7467, 7479};
        }
        if (i == 6970) {
            entityDef.combatLevel = 0;
            entityDef.name = "Theif";
            entityDef.actions = new String[]{null, null, "Pickpocket", null, null};
        }
        if (i == 8761) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Assignment", "Trade", "Rewards"};
        }
        if (i == 9400) {
            entityDef.name = "Ted O'bombr";
        }
        if (i == 8026 || i == 8027 || i == 8028) {
            entityDef.size = (byte)9;
        }
        if (i == 7954) {
            entityDef.combatLevel = 0;
            entityDef.name = "Achievement Master";
            entityDef.actions = new String[]{"Trade", null, "Open Achievements", null, null};
        }
        if (i == 5870) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Assignment", "Trade", "Rewards"};
        }
        if (i == 3400) {
            entityDef.combatLevel = 0;
            entityDef.name = "Giveaway Manager";
            entityDef.actions = new String[]{"Open-manager", null, null, null, null};
        }
        if (i == 1013) {
            entityDef.combatLevel = 0;
            entityDef.name = "Gambler Shop";
            entityDef.description = "A shop specifically for gamblers.";
        }
        if (i == 308) {
            entityDef.combatLevel = 0;
            entityDef.name = "PKP Manager";
        }
        if (i == 13) {
            entityDef.combatLevel = 0;
            entityDef.name = "Referral Tutor";
            entityDef.description = "He manages referrals.";
        }
        if (i == 5293) {
            entityDef.combatLevel = 0;
            entityDef.name = "Elven Keeper";
        }
        if (i == 6477) {
            entityDef.combatLevel = 625;
        }
        if (i == 2989) {
            entityDef.combatLevel = 0;
            entityDef.name = "Prestige Manager";
            entityDef.actions = new String[]{"Prestige", null, "Shop", null, null};
        }
        if (i == 3218 || i == 3217) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 2897) {
            entityDef.combatLevel = 0;
            entityDef.name = "Trading Post Manager";
            entityDef.actions = new String[]{"Open", null, "Collect", null, null};
        }
        if (i == 1306) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Make-over", null, null, null, null};
        }
        if (i == 3257) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 1011) {
            entityDef.combatLevel = 0;
            entityDef.name = "Item Gambler";
            entityDef.actions = new String[]{"Info", null, "Gamble", null, null};
        }
        if (i == 11246) {
            entityDef.name = "Maledictus";
            entityDef.newColors = new int[]{675, 695, 675, 695, 675, 695, 675, 695, 675, 695, 675, 695, 675, 695, 675, 695, 675, 695};
            entityDef.originalColors = new int[]{28, 39, 47, 53, 57, 706, 33604, 898, 953, 43092, 43100, 43107, 43109, 43111, 43117, 20416, 37999, 38123};
        }
        if (i == 3248) {
            entityDef.combatLevel = 0;
            entityDef.name = "Valoria Wizard";
            entityDef.actions = new String[]{"Teleport", null, "Previous Location", null, null};
        }
        if (i == 1520) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Small Net", null, "Harpoon", null, null};
        }
        if (i == 8920) {
            entityDef.actions = new String[]{null, "Attack", null, null, null};
        }
        if (i == 8921) {
            entityDef.name = "Crystal Whirlwind";
        }
        if (i == 9120) {
            entityDef.combatLevel = 0;
            entityDef.name = "Donator Shop";
            entityDef.actions = new String[]{"Trade", null, "Rewards", "Rank Benefits", null};
        }
        if (i == 2662) {
            entityDef.combatLevel = 0;
            entityDef.name = "Tournament Manager";
            entityDef.actions = new String[]{"Open-Shop", null, null, null, null};
        }
        if (i == 603) {
            entityDef.combatLevel = 0;
            entityDef.name = "Captain Kraken";
            entityDef.actions = new String[]{"Talk-to", null, null, null, null};
        }
        if (i == 7041) {
            entityDef.combatLevel = 0;
            entityDef.name = "Ticket Exchange";
            entityDef.actions = new String[]{"Exchange", null, null, null, null};
        }
        if (i == 3894) {
            entityDef.combatLevel = 0;
            entityDef.name = "Sigmund The Merchant";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 7413) {
            entityDef.name = "Max Dummy";
            entityDef.actions[0] = null;
        }
        if (i == 7310) {
            entityDef.npcWidth = 175;
            entityDef.npcHeight = 175;
            entityDef.name = "Brassican";
            entityDef.combatLevel = 480;
        }
        if (i == 4500) {
            entityDef.npcWidth = 175;
            entityDef.npcHeight = 175;
            entityDef.combatLevel = 480;
        }
        if (i == 9011) {
            entityDef.combatLevel = 0;
            entityDef.name = "Vote Shop";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 1933) {
            entityDef.combatLevel = 0;
            entityDef.name = "Mills";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 8819) {
            entityDef.combatLevel = 0;
            entityDef.name = "Boss point shop";
            entityDef.actions = new String[]{null, null, "Trade", null, null};
        }
        if (i == 8688) {
            entityDef.combatLevel = 0;
            entityDef.name = "Fat Tony";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 7769) {
            entityDef.combatLevel = 0;
            entityDef.name = "Shop Keeper";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 6987) {
            entityDef.combatLevel = 0;
            entityDef.name = "Man";
            entityDef.actions = new String[]{"Talk", null, "Pickpocket", null, null};
        }
        if (i == 5730) {
            entityDef.combatLevel = 0;
            entityDef.name = "Master Farmer";
            entityDef.actions = new String[]{"Pickpocket", null, "Trade", null, null};
        }
        if (i == 1501) {
            entityDef.combatLevel = 0;
            entityDef.name = "Hunter Store";
            entityDef.actions = new String[]{null, null, null, null, "Trade"};
        }
        if (i == 2913) {
            entityDef.combatLevel = 0;
            entityDef.name = "Fishing Store";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 5809) {
            entityDef.combatLevel = 0;
            entityDef.name = "Crafting and Tanner";
            entityDef.actions = new String[]{"Tan", null, "Trade", null, null};
        }
        if (i == 555) {
            entityDef.combatLevel = 0;
            entityDef.name = "Sell Me Store";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 9168) {
            entityDef.combatLevel = 0;
            entityDef.name = "Flex";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 8208) {
            entityDef.combatLevel = 0;
            entityDef.name = "Pet Collector";
            entityDef.actions = new String[]{"Talk-to", null, null, null, null};
        }
        if (i == 8202) {
            entityDef.actions = new String[]{"Talk-to", "Pick-Up", null, null, null};
        }
        if (i == 4921) {
            entityDef.combatLevel = 0;
            entityDef.name = "Supplies";
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 5314) {
            entityDef.combatLevel = 0;
            entityDef.name = "Mystical Wizard";
            entityDef.actions = new String[]{"Teleport", "Previous Location", null, null, null};
            entityDef.description = "This wizard has the power to teleport you to many locations.";
        }
        if (i == 8781) {
            entityDef.name = "@red@Queen Latsyrc";
            entityDef.combatLevel = 982;
            entityDef.onMinimap = true;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{null, "Attack", null, null, null};
        }
        if (i == 1577) {
            entityDef.combatLevel = 0;
            entityDef.name = "Melee Shop";
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 1576) {
            entityDef.combatLevel = 0;
            entityDef.name = "Range Shop";
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 1578) {
            entityDef.combatLevel = 0;
            entityDef.name = "Mage Shop";
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Trade", null, null, null, null};
        }
        if (i == 8026) {
            entityDef.name = "Vorkath";
            entityDef.models = new int[]{35023};
            entityDef.standingAnimation = 7946;
            entityDef.onMinimap = true;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Poke", null, null, null, null};
            entityDef.npcWidth = 100;
            entityDef.npcHeight = 100;
        }
        if (i == 7852 || i == 7853 || i == 7884) {
            entityDef.standingAnimation = 7775;
            entityDef.walkingAnimation = 7775;
        }
        if (i == 5518) {
            entityDef.standingAnimation = 185;
        }
        if (i == 8019) {
            entityDef.standingAnimation = 185;
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Talk-to";
            entityDef.actions[2] = "Trade";
        }
        if (i == 308) {
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Talk-to";
            entityDef.actions[2] = "Trade";
            entityDef.actions[3] = "Disable Interface";
            entityDef.actions[4] = "Skull";
        }
        if (i == 6088) {
            entityDef.standingAnimation = 185;
            entityDef.actions = new String[5];
            entityDef.actions[0] = "Talk-to";
            entityDef.actions[2] = "Travel";
        }
        if (i == 1434 || i == 876 || i == 1612) {
            entityDef.standingAnimation = 185;
        }
        if (i == 7674 || i == 8009 || i == 388 || i == 8010) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 8492 || i == 8493 || i == 8494 || i == 8495) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 8737 || i == 8738 || i == 8009 || i == 7674) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 326 || i == 327) {
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
            entityDef.name = "Vote Pet";
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i >= 7354 && i <= 7367) {
            entityDef.combatLevel = 0;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 5559 || i == 5560) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 2149 || i == 2150 || i == 2151 || i == 2148) {
            entityDef.name = "Trading Clerk";
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Bank", null, "Trading Post", null, null};
        }
        if (i == 6473) {
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 50;
            entityDef.npcHeight = 50;
        }
        if (i == 9704) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Pickpocket", null, null, null, null};
        }
        if (i == 500) {
            entityDef.name = "Exchange Shop";
            entityDef.actions = new String[]{"Open", null, null, null, null};
        }
        if (i == 7414) {
            entityDef.name = "Vote Boss";
            entityDef.combatLevel = 2350;
            entityDef.size = (byte)3;
            entityDef.standingAnimation = 7845;
            entityDef.walkingAnimation = 7847;
            entityDef.npcWidth = 128;
            entityDef.npcHeight = 128;
            entityDef.onMinimap = true;
            entityDef.actions = new String[5];
            entityDef.actions[0] = null;
            entityDef.actions[1] = "Attack";
            entityDef.actions[2] = null;
            entityDef.actions[3] = null;
            entityDef.actions[4] = null;
            entityDef.models = new int[1];
            entityDef.models[0] = 34517;
            entityDef.newColors = new int[]{34770, 34770, 34770, 34770, 34770, 34770, 34770, 34770};
            entityDef.originalColors = new int[]{16320, 16307, 19121, 19001, 15296, 18869, 20399, 17331};
        }
        if (i == 3510) {
            entityDef.name = "Trader";
            entityDef.combatLevel = 0;
            entityDef.onMinimap = true;
            entityDef.npcWidth = 150;
            entityDef.npcHeight = 150;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Open-Shop", null, null, null, null};
        }
        if (i == 488) {
            entityDef.combatLevel = 0;
            entityDef.size = 1;
            entityDef.onMinimap = true;
            entityDef.npcWidth = 150;
            entityDef.npcHeight = 150;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 7668) {
            entityDef.name = "Kratos";
            entityDef.size = (byte)2;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 90;
            entityDef.npcHeight = 90;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 1377) {
            entityDef.size = (byte)3;
            entityDef.npcWidth = 300;
            entityDef.npcHeight = 300;
            entityDef.actions[0] = null;
        }
        if (i == 2105) {
            entityDef.size = (byte)4;
            entityDef.npcWidth = 600;
            entityDef.npcHeight = 600;
        }
        if (i == 2107) {
            entityDef.size = (byte)4;
            entityDef.npcWidth = 600;
            entityDef.npcHeight = 600;
        }
        if (i == 2850) {
            entityDef.name = "GIM Tracker";
            entityDef.actions = new String[]{"Open", null, null, null, null};
        }
        if (i == 6119) {
            entityDef.size = 1;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 30;
            entityDef.npcHeight = 30;
        }
        if (i == 763) {
            entityDef.size = 1;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 30;
            entityDef.npcHeight = 30;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 762) {
            entityDef.size = 1;
            entityDef.combatLevel = 0;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", "Metamorphosis", null};
        }
        if (i == 4987 || i == 6292 || i == 6354) {
            entityDef.size = 1;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 45;
            entityDef.npcHeight = 45;
        }
        if (i == 8709) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.name = "Corrupt Beast";
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 60;
            entityDef.npcHeight = 60;
            entityDef.size = 1;
        }
        if (i == 7025) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
        }
        if (i == 6716) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 65;
            entityDef.npcHeight = 65;
            entityDef.combatLevel = 0;
        }
        if (i == 6723) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 65;
            entityDef.npcHeight = 65;
            entityDef.combatLevel = 0;
        }
        if (i == 1088) {
            entityDef.name = "Seren";
            entityDef.models = new int[]{38605};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 65;
            entityDef.npcHeight = 65;
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8372;
            entityDef.walkingAnimation = 8372;
            entityDef.models = new int[]{38605};
        }
        if (i == 1089) {
            entityDef.name = "Lil mimic";
            entityDef.models = new int[]{37142};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 25;
            entityDef.npcHeight = 25;
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8307;
            entityDef.walkingAnimation = 8306;
            entityDef.models = new int[]{37142};
        }
        if (i == 2120) {
            entityDef.name = "Shadow Ranger";
            entityDef.models = new int[]{29267};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8526;
            entityDef.walkingAnimation = 8527;
            entityDef.models = new int[]{29267};
        }
        if (i == 2121) {
            entityDef.name = "Shadow Wizard";
            entityDef.models = new int[]{29268};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8526;
            entityDef.walkingAnimation = 8527;
            entityDef.models = new int[]{29268};
        }
        if (i == 2122) {
            entityDef.name = "Shadow Warrior";
            entityDef.models = new int[]{29266};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8526;
            entityDef.walkingAnimation = 8527;
            entityDef.models = new int[]{29266};
        }
        if (i == 7216 || i == 6473) {
            entityDef.actions = new String[5];
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 6723 || i == 6716 || i == 8709) {
            entityDef.actions = new String[5];
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 3291) {
            entityDef.actions = new String[5];
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 5738) {
            entityDef.actions = new String[5];
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 5240) {
            entityDef.actions = new String[5];
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 834) {
            entityDef.name = "King penguin";
            entityDef.actions = new String[5];
            entityDef.combatLevel = 0;
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
        }
        if (i == 1873) {
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.standingAnimation = 3345;
            entityDef.walkingAnimation = 3346;
        }
        if (i == 2300) {
            entityDef.models = new int[1];
            entityDef.name = "Dark postie pete";
            entityDef.models = new int[]{46600};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 3948;
            entityDef.walkingAnimation = 3947;
        }
        if (i == 2301) {
            entityDef.name = "Dark imp";
            entityDef.models = new int[]{46700};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 171;
            entityDef.walkingAnimation = 168;
        }
        if (i == 2302) {
            entityDef.name = "Dark toucan";
            entityDef.models = new int[]{46800, 46801};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 6772;
            entityDef.walkingAnimation = 6774;
        }
        if (i == 2303) {
            entityDef.name = "Dark king penguin";
            entityDef.models = new int[]{46200};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 5668;
            entityDef.walkingAnimation = 5666;
        }
        if (i == 2304) {
            entityDef.name = "Dark k'klik";
            entityDef.models = new int[]{46300, 46301, 46302};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 3346;
            entityDef.walkingAnimation = -1;
        }
        if (i == 2305) {
            entityDef.name = "Dark shadow warrior";
            entityDef.models = new int[]{46100};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8526;
            entityDef.walkingAnimation = 8527;
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
        }
        if (i == 2306) {
            entityDef.name = "Dark shadow archer";
            entityDef.models = new int[]{56800};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8526;
            entityDef.walkingAnimation = 8527;
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
        }
        if (i == 2307) {
            entityDef.name = "Dark shadow wizard";
            entityDef.models = new int[]{45900};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8526;
            entityDef.walkingAnimation = 8527;
            entityDef.npcWidth = 85;
            entityDef.npcHeight = 85;
        }
        if (i == 2308) {
            entityDef.name = "Dark healer death spawn";
            entityDef.models = new int[]{46500, 46501, 46502, 46503, 46504, 46505, 46506};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.npcWidth = 65;
            entityDef.npcHeight = 65;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 1539;
            entityDef.walkingAnimation = 1539;
        }
        if (i == 2309) {
            entityDef.name = "Dark holy death spawn";
            entityDef.models = new int[]{46406, 46405, 46404, 46403, 46402, 46401, 46400};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.npcWidth = 65;
            entityDef.npcHeight = 65;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 1539;
            entityDef.walkingAnimation = 1539;
        }
        if (i == 2310) {
            entityDef.name = "Dark seren";
            entityDef.models = new int[]{46900};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.standingAnimation = 8372;
            entityDef.walkingAnimation = 8372;
            entityDef.npcWidth = 65;
            entityDef.npcHeight = 65;
        }
        if (i == 2311) {
            entityDef.name = "Dark corrupt beast";
            entityDef.models = new int[]{45710};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 60;
            entityDef.npcHeight = 60;
            entityDef.size = 1;
            entityDef.standingAnimation = 5616;
            entityDef.walkingAnimation = 5615;
        }
        if (i == 2312) {
            entityDef.name = "Dark roc";
            entityDef.models = new int[]{45600, 45601};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.standingAnimation = 5021;
            entityDef.walkingAnimation = 5022;
            entityDef.size = 1;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 30;
            entityDef.npcHeight = 30;
        }
        if (i == 2313) {
            entityDef.name = "Dark kratos";
            entityDef.models = new int[]{45500, 45501, 45502};
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{"Talk-to", null, "Pick-Up", null, null};
            entityDef.originalColors = null;
            entityDef.newColors = null;
            entityDef.standingAnimation = 7017;
            entityDef.walkingAnimation = 7016;
            entityDef.size = (byte)2;
            entityDef.combatLevel = 0;
            entityDef.npcWidth = 90;
            entityDef.npcHeight = 90;
        }
        if (i == 8027) {
            entityDef.name = "Vorkath";
            entityDef.combatLevel = 732;
            entityDef.models = new int[]{35023};
            entityDef.standingAnimation = 7950;
            entityDef.onMinimap = true;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{null, null, null, null, null};
            entityDef.npcWidth = 100;
            entityDef.npcHeight = 100;
        }
        if (i == 8028) {
            entityDef.name = "Vorkath";
            entityDef.combatLevel = 732;
            entityDef.models = new int[]{35023};
            entityDef.standingAnimation = 7948;
            entityDef.onMinimap = true;
            entityDef.actions = new String[5];
            entityDef.actions = new String[]{null, "Attack", null, null, null};
            entityDef.npcWidth = 100;
            entityDef.npcHeight = 100;
        }
        if (i == 3225) {
            entityDef.name = "Upgrade Craftsman";
        }
        if (i == 315) {
            entityDef.name = "Sigil Tutor";
            entityDef.actions = new String[]{"Talk-to", null, null, "Sigil of Mortal", null};
        }
        if (i == 3310) {
            entityDef.name = "Perks Tutor";
            entityDef.actions = new String[]{"Talk-to", null, null, null, null};
        }
        if (i == 8761) {
            entityDef.name = "Corrupted Slayer Master";
        }
        if (i == 9125) {
            entityDef.name = "Upgrade Token Shop";
            entityDef.actions = new String[]{"Open", null, null, null, null};
        }
        if (i == 7144) {
            entityDef.anInt75 = 0;
        }
        if (i == 963) {
            entityDef.anInt75 = 6;
        }
        if (i == 7145) {
            entityDef.anInt75 = 1;
        }
        if (i == 7146) {
            entityDef.anInt75 = 2;
        }
        if (entityDef.name != null && entityDef.name.toLowerCase().contains("chinchompa") && !entityDef.name.toLowerCase().contains("baby")) {
            entityDef.actions = new String[5];
        }
        return entityDef;
    }

    public static void dump() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("./npc_defs.txt"));){
            for (int i = 0; i < 70000; ++i) {
                try {
                    NpcDefinition def = NpcDefinition.lookup(i);
                    if (def == null) continue;
                    writer.write("Npc=" + i);
                    writer.newLine();
                    writer.write("Stand animation=" + def.standingAnimation);
                    writer.newLine();
                    writer.write("Walk animation=" + def.walkingAnimation);
                    writer.newLine();
                    writer.newLine();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unpackConfig(FileArchive streamLoader) {
        stream = new Buffer(streamLoader.readFile("npc.dat"));
        Buffer stream = new Buffer(streamLoader.readFile("npc.idx"));
        totalAmount = stream.readUShort();
        streamIndices = new int[totalAmount];
        int i = 2;
        for (int j = 0; j < totalAmount; ++j) {
            NpcDefinition.streamIndices[j] = i;
            i += stream.readUShort();
        }
        cache = new NpcDefinition[20];
        for (int k = 0; k < 20; ++k) {
            NpcDefinition.cache[k] = new NpcDefinition();
        }
        for (int index = 0; index < totalAmount; ++index) {
            NpcDefinition ed = NpcDefinition.lookup(index);
            if (ed != null && ed.name != null) continue;
        }
        if (Configuration.dumpDataLists) {
            NpcDefinitionDumper.dump();
            TempWriter writer2 = new TempWriter("npc_fields");
            FieldGenerator generator = new FieldGenerator(writer2::writeLine);
            IntStream.range(0, 100000).forEach(id -> {
                try {
                    NpcDefinition definition = NpcDefinition.lookup(id);
                    generator.add(definition.name, id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            writer2.close();
        }
    }

    private void readValues(Buffer buffer) {
        int opcode;
        block0: while ((opcode = buffer.readUnsignedByte()) != 0) {
            int k1;
            int k;
            if (opcode == 1) {
                int j = buffer.readUnsignedByte();
                this.models = new int[j];
                int j1 = 0;
                while (true) {
                    if (j1 >= j) continue block0;
                    this.models[j1] = buffer.readUShort();
                    ++j1;
                }
            }
            if (opcode == 2) {
                this.name = buffer.readString();
                continue;
            }
            if (opcode == 12) {
                this.size = buffer.readSignedByte();
                continue;
            }
            if (opcode == 13) {
                this.standingAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 14) {
                this.walkingAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 17) {
                this.walkingAnimation = buffer.readUShort();
                this.rotate180AnimIndex = buffer.readUShort();
                this.rotate90CWAnimIndex = buffer.readUShort();
                this.rotate90CCWAnimIndex = buffer.readUShort();
                if (this.rotate180AnimIndex == 65535) {
                    this.rotate180AnimIndex = -1;
                }
                if (this.rotate90CWAnimIndex == 65535) {
                    this.rotate90CWAnimIndex = -1;
                }
                if (this.rotate90CCWAnimIndex != 65535) continue;
                this.rotate90CCWAnimIndex = -1;
                continue;
            }
            if (opcode == 18) {
                this.category = buffer.readUShort();
                continue;
            }
            if (opcode >= 30 && opcode < 40) {
                if (this.actions == null) {
                    this.actions = new String[10];
                }
                this.actions[opcode - 30] = buffer.readString();
                if (!this.actions[opcode - 30].equalsIgnoreCase("hidden")) continue;
                this.actions[opcode - 30] = null;
                continue;
            }
            if (opcode == 40) {
                k = buffer.readUnsignedByte();
                this.originalColors = new int[k];
                this.newColors = new int[k];
                k1 = 0;
                while (true) {
                    if (k1 >= k) continue block0;
                    this.originalColors[k1] = buffer.readUShort();
                    this.newColors[k1] = buffer.readUShort();
                    ++k1;
                }
            }
            if (opcode == 41) {
                k = buffer.readUnsignedByte();
                this.originalTextures = new short[k];
                this.newTextures = new short[k];
                k1 = 0;
                while (true) {
                    if (k1 >= k) continue block0;
                    this.originalTextures[k1] = (short)buffer.readUShort();
                    this.newTextures[k1] = (short)buffer.readUShort();
                    ++k1;
                }
            }
            if (opcode == 60) {
                int l = buffer.readUnsignedByte();
                this.chatheadModels = new int[l];
                int l1 = 0;
                while (true) {
                    if (l1 >= l) continue block0;
                    this.chatheadModels[l1] = buffer.readUShort();
                    ++l1;
                }
            }
            if (opcode == 93) {
                this.onMinimap = false;
                continue;
            }
            if (opcode == 95) {
                this.combatLevel = buffer.readUShort();
                continue;
            }
            if (opcode == 97) {
                this.npcHeight = buffer.readUShort();
                continue;
            }
            if (opcode == 98) {
                this.npcWidth = buffer.readUShort();
                continue;
            }
            if (opcode == 99) {
                this.aBoolean93 = true;
                continue;
            }
            if (opcode == 100) {
                this.ambient = buffer.readSignedByte();
                continue;
            }
            if (opcode == 101) {
                this.contrast = buffer.readSignedByte();
                continue;
            }
            if (opcode == 102) {
                this.anInt75 = buffer.readUShort();
                continue;
            }
            if (opcode == 103) {
                this.rotationSpeed = buffer.readUShort();
                continue;
            }
            if (opcode == 114) {
                this.runAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 115) {
                this.runAnimation = buffer.readUShort();
                this.runRotate180Animation = buffer.readUShort();
                this.runRotateLeftAnimation = buffer.readUShort();
                this.runRotateRightAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 116) {
                this.crawlAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 117) {
                this.crawlAnimation = buffer.readUShort();
                this.crawlRotate180Animation = buffer.readUShort();
                this.crawlRotateLeftAnimation = buffer.readUShort();
                this.crawlRotateRightAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 106 || opcode == 118) {
                this.varbitId = buffer.readUShort();
                if (this.varbitId == 65535) {
                    this.varbitId = -1;
                }
                this.varpIndex = buffer.readUShort();
                if (this.varpIndex == 65535) {
                    this.varpIndex = -1;
                }
                int var3 = -1;
                if (opcode == 118) {
                    var3 = buffer.readUShort();
                }
                int i1 = buffer.readUnsignedByte();
                this.configs = new int[i1 + 2];
                for (int i2 = 0; i2 <= i1; ++i2) {
                    this.configs[i2] = buffer.readUShort();
                    if (this.configs[i2] != 65535) continue;
                    this.configs[i2] = -1;
                }
                this.configs[i1 + 1] = var3;
                continue;
            }
            if (opcode != 107) continue;
            this.clickable = false;
        }
        return;
    }

    public Model method160() {
        int k;
        if (this.configs != null) {
            NpcDefinition entityDef = this.method161();
            if (entityDef == null) {
                return null;
            }
            return entityDef.method160();
        }
        if (this.chatheadModels == null) {
            return null;
        }
        boolean flag1 = false;
        for (int i = 0; i < this.chatheadModels.length; ++i) {
            if (Model.isCached(this.chatheadModels[i])) continue;
            flag1 = true;
        }
        if (flag1) {
            return null;
        }
        Model[] aclass30_sub2_sub4_sub6s = new Model[this.chatheadModels.length];
        for (int j = 0; j < this.chatheadModels.length; ++j) {
            aclass30_sub2_sub4_sub6s[j] = Model.getModel(this.chatheadModels[j]);
        }
        Model model = aclass30_sub2_sub4_sub6s.length == 1 ? aclass30_sub2_sub4_sub6s[0] : new Model(aclass30_sub2_sub4_sub6s.length, aclass30_sub2_sub4_sub6s);
        if (this.originalColors != null) {
            for (k = 0; k < this.originalColors.length; ++k) {
                model.recolor(this.originalColors[k], this.newColors[k]);
            }
        }
        if (this.originalTextures != null) {
            for (k = 0; k < this.originalTextures.length; ++k) {
                model.retexture(this.originalTextures[k], this.newTextures[k]);
            }
        }
        return model;
    }

    public NpcDefinition method161() {
        int j = -1;
        if (this.varbitId != -1 && this.varbitId <= 2113) {
            VarBit varBit = VarBit.cache[this.varbitId];
            int k = varBit.anInt648;
            int l = varBit.anInt649;
            int i1 = varBit.anInt650;
            int j1 = Client.anIntArray1232[i1 - l];
            j = NpcDefinition.clientInstance.variousSettings[k] >> l & j1;
        } else if (this.varpIndex != -1) {
            j = NpcDefinition.clientInstance.variousSettings[this.varpIndex];
        }
        int var3 = j >= 0 && j < this.configs.length ? this.configs[j] : this.configs[this.configs.length - 1];
        return var3 == -1 ? null : NpcDefinition.lookup(var3);
    }

    public Model method164(int j, int k, int[] ai) {
        if (this.configs != null) {
            NpcDefinition entityDef = this.method161();
            if (entityDef == null) {
                return null;
            }
            return entityDef.method164(j, k, ai);
        }
        Model model = (Model)mruNodes.get(this.npcId);
        if (model == null) {
            boolean flag = false;
            for (int i1 = 0; i1 < this.models.length; ++i1) {
                if (Model.isCached(this.models[i1])) continue;
                flag = true;
            }
            if (flag) {
                return null;
            }
            Model[] aclass30_sub2_sub4_sub6s = new Model[this.models.length];
            for (int j1 = 0; j1 < this.models.length; ++j1) {
                aclass30_sub2_sub4_sub6s[j1] = Model.getModel(this.models[j1]);
            }
            model = aclass30_sub2_sub4_sub6s.length == 1 ? aclass30_sub2_sub4_sub6s[0] : new Model(aclass30_sub2_sub4_sub6s.length, aclass30_sub2_sub4_sub6s);
            if (this.originalColors != null) {
                for (int k1 = 0; k1 < this.originalColors.length; ++k1) {
                    model.recolor(this.originalColors[k1], this.newColors[k1]);
                }
            }
            if (this.originalTextures != null) {
                for (int i1 = 0; i1 < this.originalTextures.length; ++i1) {
                    model.retexture(this.originalTextures[i1], this.newTextures[i1]);
                }
            }
            model.generateBones();
            model.light(64 + this.ambient, 850 + this.contrast, -30, -50, -30, true);
            mruNodes.put(model, this.npcId);
        }
        Model model_1 = Model.emptyModel;
        model_1.replaceModel(model, Frame.noAnimationInProgress(k) & Frame.noAnimationInProgress(j));
        if (k != -1 && j != -1) {
            model_1.animate2(ai, j, k);
        } else if (k != -1) {
            model_1.animate(k);
        }
        if (this.npcHeight != 128 || this.npcWidth != 128) {
            model_1.scale(this.npcHeight, this.npcHeight, this.npcWidth);
        }
        model_1.calculateBoundsCylinder();
        model_1.faceGroups = null;
        model_1.vertexGroups = null;
        if (this.size == 1) {
            model_1.singleTile = true;
        }
        return model_1;
    }

    private NpcDefinition() {
        this.anInt64 = 1834;
    }

    public String toString() {
        return "NpcDefinition{npcId=" + this.npcId + ", combatLevel=" + this.combatLevel + ", name='" + this.name + "', actions=" + Arrays.toString(this.actions) + ", walkAnim=" + this.walkingAnimation + ", size=" + this.size + ", standAnim=" + this.standingAnimation + ", childrenIDs=" + Arrays.toString(this.configs) + ", models=" + Arrays.toString(this.models) + "}";
    }

    public static void nullLoader() {
        mruNodes = null;
        streamIndices = null;
        cache = null;
        stream = null;
    }

    public static void dumpList() {
        try {
            File file = new File("./temp/npc_list.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (int i = 0; i < totalAmount; ++i) {
                    NpcDefinition definition = NpcDefinition.lookup(i);
                    if (definition == null) continue;
                    writer.write("npc = " + i + "\t" + definition.name + "\t" + definition.combatLevel + "\t" + definition.standingAnimation + "\t" + definition.walkingAnimation + "\t");
                    writer.newLine();
                }
            }
            System.out.println("Finished dumping npc definitions.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpSizes() {
        try {
            File file = new File(System.getProperty("user.home") + "/Desktop/npcSizes 143.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (int i = 0; i < totalAmount; ++i) {
                    NpcDefinition definition = NpcDefinition.lookup(i);
                    if (definition == null) continue;
                    writer.write(i + "\t" + definition.size);
                    writer.newLine();
                }
            }
            System.out.println("Finished dumping npc definitions.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public HeadIcon getOverheadIcon() {
        return null;
    }

    @Override
    public int getIntValue(int paramID) {
        return 0;
    }

    @Override
    public void setValue(int paramID, int value) {
    }

    @Override
    public String getStringValue(int paramID) {
        return null;
    }

    @Override
    public void setValue(int paramID, String value) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int[] getModels() {
        return new int[0];
    }

    @Override
    public String[] getActions() {
        return new String[0];
    }

    @Override
    public boolean isClickable() {
        return false;
    }

    @Override
    public boolean isFollower() {
        return false;
    }

    @Override
    public boolean isInteractible() {
        return false;
    }

    @Override
    public boolean isMinimapVisible() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getCombatLevel() {
        return 0;
    }

    @Override
    public int[] getConfigs() {
        return new int[0];
    }

    @Override
    public RSNPCComposition transform() {
        return null;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public int getRsOverheadIcon() {
        return 0;
    }

    @Override
    public RSIterableNodeHashTable getParams() {
        return null;
    }

    @Override
    public void setParams(IterableHashTable params) {
    }

    @Override
    public void setParams(RSIterableNodeHashTable params) {
    }

    static {
        mruNodes = new ReferenceCache(70);
    }
}

