/*
 * Decompiled with CFR 0.152.
 */
package com.client.draw;

import com.client.Sprite;
import com.client.sign.Signlink;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import javax.imageio.ImageIO;

public final class ImageCache {
    private static Sprite[] cache;
    private static FileChannel dataChannel;
    private static FileChannel metaChannel;

    public static void init() throws IOException {
        File dataFile = new File(Signlink.getCacheDirectory() + "main_file_sprites.dat");
        File metaFile = new File(Signlink.getCacheDirectory() + "main_file_sprites.idx");
        if (!dataFile.exists()) {
            throw new IOException(String.format("Could not find data file=%s", dataFile.getName()));
        }
        if (!metaFile.exists()) {
            throw new IOException(String.format("Could not find meta file=%s", metaFile.getName()));
        }
        dataChannel = FileChannel.open(dataFile.toPath(), StandardOpenOption.READ);
        metaChannel = FileChannel.open(metaFile.toPath(), StandardOpenOption.READ);
        int spriteCount = Math.toIntExact(metaChannel.size() / 10L);
        cache = new Sprite[spriteCount];
        System.out.println(String.format("Sprite cache size1=%d", cache.length));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Sprite get(int id) {
        try {
            if (ImageCache.contains(id)) {
                return cache[id];
            }
            if (!dataChannel.isOpen() || !metaChannel.isOpen()) {
                System.out.println("Sprite channels are closed!");
                return Sprite.EMPTY_SPRITE;
            }
            int entries = Math.toIntExact(metaChannel.size() / 10L);
            if (id > entries) {
                System.out.println(String.format("id=%d > size=%d", id, entries));
                return Sprite.EMPTY_SPRITE;
            }
            metaChannel.position(id * 10);
            ByteBuffer metaBuf = ByteBuffer.allocate(10);
            metaChannel.read(metaBuf);
            metaBuf.flip();
            int pos = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int len = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int offsetX = metaBuf.getShort() & 0xFF;
            int offsetY = metaBuf.getShort() & 0xFF;
            ByteBuffer dataBuf = ByteBuffer.allocate(len);
            dataChannel.position(pos);
            dataChannel.read(dataBuf);
            dataBuf.flip();
            try (ByteArrayInputStream is = new ByteArrayInputStream(dataBuf.array());){
                Sprite sprite;
                BufferedImage bimage = ImageIO.read(is);
                if (bimage == null) {
                    System.out.println(String.format("Could not read image at %d", id));
                    Sprite sprite2 = Sprite.EMPTY_SPRITE;
                    return sprite2;
                }
                if (bimage.getType() != 2) {
                    bimage = ImageCache.convert(bimage, 2);
                }
                int[] pixels = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
                ImageCache.cache[id] = sprite = new Sprite(bimage.getWidth(), bimage.getHeight(), offsetX, offsetY, pixels);
                Sprite sprite3 = sprite;
                return sprite3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(String.format("No sprite found for id=%d", id));
            return Sprite.EMPTY_SPRITE;
        }
    }

    public static boolean contains(int id) {
        return id < cache.length && cache[id] != null;
    }

    public void set(int id, Sprite sprite) {
        if (!ImageCache.contains(id)) {
            return;
        }
        ImageCache.cache[id] = sprite;
    }

    private static BufferedImage convert(BufferedImage bimage, int type2) {
        BufferedImage converted = new BufferedImage(bimage.getWidth(), bimage.getHeight(), type2);
        converted.getGraphics().drawImage(bimage, 0, 0, null);
        return converted;
    }

    public void close() throws IOException {
        dataChannel.close();
        metaChannel.close();
    }

    public static int getWidth(int id) {
        return ImageCache.get((int)id).myWidth;
    }

    public static int getHeight(int id) {
        return ImageCache.get((int)id).myHeight;
    }
}

