/*
 * Decompiled with CFR 0.152.
 */
package com.client.engine;

import com.client.Bounds;
import com.client.Client;
import com.client.ProducingGraphicsBuffer;
import com.client.engine.Canvas;
import com.client.engine.impl.KeyHandler;
import com.client.engine.impl.MouseHandler;
import com.client.engine.impl.MouseWheelHandler;
import com.client.engine.task.Clock;
import com.client.engine.task.TaskHandler;
import com.client.engine.task.TaskUtils;
import com.client.engine.task.impl.MilliClock;
import com.client.engine.task.impl.NanoClock;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import net.runelite.api.events.CanvasSizeChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.rs.api.RSGameEngine;

public abstract class GameEngine
extends Applet
implements Runnable,
WindowListener,
RSGameEngine,
FocusListener {
    MouseWheelHandler mouseWheelHandler;
    public static TaskHandler taskHandler;
    static GameEngine gameEngine;
    public static int canvasWidth;
    public static int canvasHeight;
    static int threadCount;
    static long stopTimeMs;
    static boolean isKilled;
    static int cycleDurationMillis;
    private Thread thread;
    static int fiveOrOne;
    protected static int fps;
    static long[] graphicsTickTimes;
    static long[] clientTickTimes;
    static int field209;
    static int field199;
    static volatile boolean volatileFocus;
    static long garbageCollectorTime;
    static long lastGarbageCollect;
    boolean hasErrored = false;
    protected int contentWidth;
    protected int contentHeight;
    int canvasX = 0;
    int canvasY = 0;
    int maxCanvasWidth;
    int maxCanvasHeight;
    Frame frame;
    public Canvas canvas;
    volatile boolean fullRedraw = true;
    boolean resizeCanvasNextFrame = false;
    volatile boolean isCanvasInvalid = false;
    volatile long field185 = 0L;
    final EventQueue eventQueue;
    private static final long serialVersionUID = 1L;
    private static int viewportColor;
    public int keyPressed;
    static int field4319;
    static Font fontHelvetica;
    static FontMetrics loginScreenFontMetrics;
    static Image image;
    static int gameCyclesToDo;
    static Clock clock;
    public Clipboard clipboard;
    static long field3170;
    static long field4425;

    @Override
    public Thread getClientThread() {
        return this.thread;
    }

    @Override
    public boolean isClientThread() {
        return this.thread == Thread.currentThread();
    }

    protected GameEngine() {
        EventQueue queue = null;
        try {
            queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.eventQueue = queue;
    }

    protected final void setMaxCanvasSize(int width, int height) {
        if (Client.instance.isStretchedEnabled() && Client.instance.isResized()) {
            return;
        }
        if (this.maxCanvasWidth != width || height != this.maxCanvasHeight) {
            this.flagResize();
        }
        this.maxCanvasWidth = width;
        this.maxCanvasHeight = height;
    }

    @Override
    public final void post(Object var1) {
        if (!Client.instance.isGpu()) {
            if (this.eventQueue != null) {
                for (int var2 = 0; var2 < 50 && this.eventQueue.peekEvent() != null; ++var2) {
                    TaskUtils.sleep(1L);
                }
                if (var1 != null) {
                    this.eventQueue.postEvent(new ActionEvent(var1, 1001, "dummy"));
                }
            }
        } else {
            DrawCallbacks drawCallbacks = Client.instance.getDrawCallbacks();
            if (drawCallbacks != null) {
                drawCallbacks.draw(viewportColor);
            }
        }
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public final void resizeCanvas() {
        Container container;
        if (Client.instance.isStretchedEnabled()) {
            Client.instance.invalidateStretching(false);
            if (Client.instance.isResized()) {
                Dimension realDimensions = Client.instance.getRealDimensions();
                this.setMaxCanvasWidth(realDimensions.width);
                this.setMaxCanvasHeight(realDimensions.height);
            }
        }
        if ((container = this.container()) != null) {
            Bounds contentBounds = this.getFrameContentBounds();
            this.contentWidth = Math.max(contentBounds.highX, 0);
            this.contentHeight = Math.max(contentBounds.highY, 0);
            if (this.contentWidth <= 0) {
                this.contentWidth = 1;
            }
            if (this.contentHeight <= 0) {
                this.contentHeight = 1;
            }
            if (Client.instance.isResized()) {
                this.setMaxCanvasSize(this.contentWidth, this.contentHeight);
            }
            canvasWidth = Math.min(this.contentWidth, this.maxCanvasWidth);
            canvasHeight = Math.min(this.contentHeight, this.maxCanvasHeight);
            Client.instance.getCallbacks().post(CanvasSizeChanged.INSTANCE);
            this.canvasX = (this.contentWidth - canvasWidth) / 2;
            this.canvasY = 0;
            this.canvas.setSize(canvasWidth, canvasHeight);
            Client.rasterProvider = new ProducingGraphicsBuffer(canvasWidth, canvasHeight, this.canvas);
            if (container == this.frame) {
                Insets insets = this.frame.getInsets();
                this.canvas.setLocation(this.canvasX + insets.left, insets.top + this.canvasY);
            } else {
                this.canvas.setLocation(this.canvasX, this.canvasY);
            }
            this.fullRedraw = true;
            this.resizeGame();
        }
    }

    protected abstract void resizeGame();

    void clearBackground() {
        int canvasX = this.canvasX;
        int canvasY = this.canvasY;
        int width = this.contentWidth - canvasWidth - canvasX;
        int height = this.contentHeight - canvasHeight - canvasY;
        if (canvasX > 0 || width > 0 || canvasY > 0 || height > 0) {
            try {
                Container container = this.container();
                int left = 0;
                int top = 0;
                if (container == this.frame) {
                    Insets var8 = this.frame.getInsets();
                    left = var8.left;
                    top = var8.top;
                }
                Graphics graphics = container.getGraphics();
                graphics.setColor(Color.black);
                if (canvasX > 0) {
                    graphics.fillRect(left, top, canvasX, this.contentHeight);
                }
                if (canvasY > 0) {
                    graphics.fillRect(left, top, this.contentWidth, canvasY);
                }
                if (width > 0) {
                    graphics.fillRect(left + this.contentWidth - width, top, width, this.contentHeight);
                }
                if (height > 0) {
                    graphics.fillRect(left, top + this.contentHeight - height, this.contentWidth, height);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean isResizeCanvasNextFrame() {
        return this.resizeCanvasNextFrame;
    }

    @Override
    public void setResizeCanvasNextFrame(boolean resize) {
        this.resizeCanvasNextFrame = resize;
    }

    @Override
    public boolean isReplaceCanvasNextFrame() {
        return this.isCanvasInvalid;
    }

    @Override
    public void setReplaceCanvasNextFrame(boolean replace) {
        this.isCanvasInvalid = replace;
    }

    @Override
    public void setMaxCanvasWidth(int width) {
        this.maxCanvasWidth = width;
    }

    @Override
    public void setMaxCanvasHeight(int height) {
        this.maxCanvasHeight = height;
    }

    @Override
    public void setFullRedraw(boolean fullRedraw) {
        this.fullRedraw = fullRedraw;
    }

    final void replaceCanvas() {
        if (Client.instance != null && Client.instance.isGpu()) {
            this.setFullRedraw(false);
            return;
        }
        this.canvas.removeMouseListener(MouseHandler.instance);
        this.canvas.removeMouseMotionListener(MouseHandler.instance);
        this.canvas.removeFocusListener(MouseHandler.instance);
        MouseHandler.currentButton = 0;
        if (this.mouseWheelHandler != null) {
            this.mouseWheelHandler.removeFrom(this.canvas);
        }
        this.addCanvas();
        this.addMouseListener(MouseHandler.instance);
        this.addMouseMotionListener(MouseHandler.instance);
        this.addFocusListener(MouseHandler.instance);
        if (this.mouseWheelHandler != null) {
            this.mouseWheelHandler.addTo(this.canvas);
        }
        this.flagResize();
    }

    protected final void startThread(int var1, int var2, int var3, int var4) {
        try {
            if (gameEngine != null) {
                if (++threadCount >= 3) {
                    this.error("alreadyloaded");
                    return;
                }
                this.getAppletContext().showDocument(this.getDocumentBase(), "_self");
                return;
            }
            gameEngine = this;
            canvasWidth = var1;
            canvasHeight = var2;
            Client.instance.getCallbacks().post(CanvasSizeChanged.INSTANCE);
            if (taskHandler == null) {
                taskHandler = new TaskHandler();
            }
            taskHandler.newThreadTask(this, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.error("crash");
        }
    }

    final synchronized void addCanvas() {
        Insets insets;
        Container container = this.container();
        if (this.canvas != null) {
            this.canvas.removeFocusListener(this);
            container.remove(this.canvas);
        }
        canvasWidth = Math.max(container.getWidth(), 0);
        canvasHeight = Math.max(container.getHeight(), 0);
        Client.instance.getCallbacks().post(CanvasSizeChanged.INSTANCE);
        if (this.frame != null) {
            insets = this.frame.getInsets();
            canvasWidth -= insets.left + insets.right;
            canvasHeight -= insets.bottom + insets.top;
        }
        this.canvas = new Canvas(this);
        this.setupMouse();
        this.setupKeys();
        this.setupMouseWheel();
        container.setBackground(Color.BLACK);
        container.setLayout(null);
        container.add(this.canvas);
        this.canvas.setSize(canvasWidth, canvasHeight);
        this.canvas.setVisible(true);
        this.canvas.setBackground(Color.BLACK);
        if (container == this.frame) {
            insets = this.frame.getInsets();
            this.canvas.setLocation(insets.left + this.canvasX, this.canvasY + insets.top);
        } else {
            this.canvas.setLocation(this.canvasX, this.canvasY);
        }
        this.canvas.addFocusListener(this);
        this.canvas.requestFocus();
        this.fullRedraw = true;
        if (Client.rasterProvider != null && canvasWidth == Client.rasterProvider.width && canvasHeight == Client.rasterProvider.height) {
            ((ProducingGraphicsBuffer)Client.rasterProvider).setComponent(this.canvas);
            Client.rasterProvider.drawFull(0, 0);
        } else {
            Client.rasterProvider = new ProducingGraphicsBuffer(canvasWidth, canvasHeight, this.canvas);
        }
        this.isCanvasInvalid = false;
        this.field185 = GameEngine.method2692();
    }

    void clientTick() {
        long var1;
        GameEngine.clientTickTimes[GameEngine.field209] = var1 = GameEngine.method2692();
        field209 = field209 + 1 & 0x1F;
        MouseHandler.clickMode3 = MouseHandler.instance.clickMode1;
        MouseHandler.instance.clickMode1 = 0;
        this.processGameLoop();
    }

    void graphicsTick() {
        Container var1 = this.container();
        long var2 = GameEngine.method2692();
        long var4 = graphicsTickTimes[field4319];
        GameEngine.graphicsTickTimes[GameEngine.field4319] = var2;
        field4319 = field4319 + 1 & 0x1F;
        if (var4 != 0L && var2 > var4) {
            int var6 = (int)(var2 - var4);
            fps = ((var6 >> 1) + 32000) / var6;
        }
        if (++field199 - 1 > 50) {
            field199 -= 50;
            this.fullRedraw = true;
            this.canvas.setSize(canvasWidth, canvasHeight);
            this.canvas.setVisible(true);
            if (var1 == this.frame) {
                Insets var7 = this.frame.getInsets();
                this.canvas.setLocation(var7.left + this.canvasX, this.canvasY + var7.top);
            } else {
                this.canvas.setLocation(this.canvasX, this.canvasY);
            }
        }
        if (this.isCanvasInvalid) {
            this.replaceCanvas();
        }
        this.doResize();
        this.draw(this.fullRedraw);
        if (this.fullRedraw) {
            this.clearBackground();
        }
        this.fullRedraw = false;
    }

    final void doResize() {
        Bounds bounds = this.getFrameContentBounds();
        if (this.contentWidth != bounds.highX || bounds.highY != this.contentHeight || this.resizeCanvasNextFrame) {
            this.resizeCanvas();
            this.resizeCanvasNextFrame = false;
        }
    }

    final void flagResize() {
        this.resizeCanvasNextFrame = true;
    }

    final synchronized void kill() {
        if (!isKilled) {
            isKilled = true;
            try {
                this.canvas.removeFocusListener(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                this.cleanUpForQuit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.frame != null) {
                try {
                    System.exit(0);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            if (taskHandler != null) {
                try {
                    taskHandler.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.vmethod1099();
        }
    }

    protected abstract void startUp();

    protected abstract void processGameLoop();

    public Thread startRunnable(Runnable runnable2, int i) {
        Thread thread2 = new Thread(runnable2);
        thread2.start();
        thread2.setPriority(i);
        return thread2;
    }

    protected abstract void draw(boolean var1);

    protected abstract void cleanUpForQuit();

    protected final void drawInitial(int var1, String var2, boolean clear) {
        try {
            Graphics graphics = this.canvas.getGraphics();
            if (fontHelvetica == null) {
                fontHelvetica = new Font("Helvetica", 1, 13);
                loginScreenFontMetrics = this.canvas.getFontMetrics(fontHelvetica);
            }
            if (clear) {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, canvasWidth, canvasHeight);
            }
            Color color = new Color(117, 68, 33);
            try {
                if (image == null) {
                    image = this.canvas.createImage(304, 34);
                }
                Graphics imageGraphics = image.getGraphics();
                imageGraphics.setColor(color);
                imageGraphics.drawRect(0, 0, 303, 33);
                imageGraphics.fillRect(2, 2, var1 * 3, 30);
                imageGraphics.setColor(Color.black);
                imageGraphics.drawRect(1, 1, 301, 31);
                imageGraphics.fillRect(var1 * 3 + 2, 2, 300 - var1 * 3, 30);
                imageGraphics.setFont(fontHelvetica);
                imageGraphics.setColor(Color.white);
                imageGraphics.drawString(var2, (304 - loginScreenFontMetrics.stringWidth(var2)) / 2, 22);
                graphics.drawImage(image, canvasWidth / 2 - 152, canvasHeight / 2 - 18, null);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            this.canvas.repaint();
            exception.printStackTrace();
        }
    }

    protected void error(String var1) {
        if (!this.hasErrored) {
            this.hasErrored = true;
            System.out.println("error_game_" + var1);
            try {
                this.getAppletContext().showDocument(new URL(this.getCodeBase(), "error_game_" + var1 + ".ws"), "_self");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    Container container() {
        return this.frame != null ? this.frame : this;
    }

    protected Bounds getFrameContentBounds() {
        Container container = this.container();
        int boundsX = Math.max(container.getWidth(), 0);
        int boundsY = Math.max(container.getHeight(), 0);
        if (this.frame != null) {
            Insets var4 = this.frame.getInsets();
            boundsX -= var4.left + var4.right;
            boundsY -= var4.top + var4.bottom;
        }
        return new Bounds(boundsX, boundsY);
    }

    protected final boolean hasFrame() {
        return this.frame != null;
    }

    protected abstract void vmethod1099();

    @Override
    public final void destroy() {
        if (this == gameEngine && !isKilled) {
            stopTimeMs = GameEngine.method2692();
            TaskUtils.sleep(5000L);
            this.kill();
        }
    }

    @Override
    public final synchronized void paint(Graphics var1) {
        if (this == gameEngine && !isKilled) {
            Rectangle var2;
            this.fullRedraw = true;
            if (GameEngine.method2692() - this.field185 > 1000L && ((var2 = var1.getClipBounds()) == null || var2.width >= canvasWidth && var2.height >= canvasHeight)) {
                this.isCanvasInvalid = true;
            }
        }
    }

    public void onReplaceCanvasNextFrameChanged(int idx) {
        if (Client.instance != null && Client.instance.isGpu() && this.isReplaceCanvasNextFrame()) {
            this.setReplaceCanvasNextFrame(false);
            this.setResizeCanvasNextFrame(true);
        }
    }

    public static Clock getClock() {
        try {
            return new NanoClock();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new MilliClock();
        }
    }

    @Override
    public void run() {
        try {
            this.thread = Thread.currentThread();
            this.thread.setName("Client");
            this.setFocusCycleRoot(true);
            this.addCanvas();
            this.startUp();
            clock = GameEngine.getClock();
            while (0L == stopTimeMs || GameEngine.method2692() < stopTimeMs) {
                gameCyclesToDo = clock.wait(cycleDurationMillis, fiveOrOne);
                for (int cycles = 0; cycles < gameCyclesToDo; ++cycles) {
                    this.clientTick();
                }
                this.graphicsTick();
                this.post(this.canvas);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.error("crash");
        }
        this.kill();
    }

    @Override
    public final void start() {
        if (this == gameEngine && !isKilled) {
            stopTimeMs = 0L;
        }
    }

    @Override
    public final void focusGained(FocusEvent var1) {
        volatileFocus = true;
        this.fullRedraw = true;
        FocusChanged focusChanged = new FocusChanged();
        focusChanged.setFocused(true);
        Client.instance.getCallbacks().post(focusChanged);
    }

    @Override
    public final void focusLost(FocusEvent var1) {
        volatileFocus = false;
    }

    @Override
    public final void windowActivated(WindowEvent var1) {
    }

    @Override
    public final void windowDeactivated(WindowEvent var1) {
    }

    @Override
    public final void windowDeiconified(WindowEvent var1) {
    }

    @Override
    public final void windowOpened(WindowEvent var1) {
    }

    @Override
    public final void stop() {
        if (this == gameEngine && !isKilled) {
            stopTimeMs = GameEngine.method2692() + 4000L;
        }
    }

    public static synchronized long method2692() {
        long var0 = System.currentTimeMillis();
        if (var0 < field3170) {
            field4425 += field3170 - var0;
        }
        field3170 = var0;
        return field4425 + var0;
    }

    public final void setupMouse() {
        this.canvas.addMouseListener(MouseHandler.instance);
        this.canvas.addMouseMotionListener(MouseHandler.instance);
        this.canvas.addFocusListener(MouseHandler.instance);
    }

    public final void setupMouseWheel() {
        if (this.mouseWheelHandler == null) {
            this.mouseWheelHandler = new MouseWheelHandler();
            this.mouseWheelHandler.addTo(this.canvas);
        }
    }

    public final void setupKeys() {
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.canvas.addKeyListener(KeyHandler.instance);
        this.canvas.addFocusListener(KeyHandler.instance);
        this.setUpClipboard();
    }

    protected void setUpClipboard() {
        this.clipboard = this.getToolkit().getSystemClipboard();
    }

    protected void setClipboardText(String text) {
        this.clipboard.setContents(new StringSelection(text), null);
    }

    @Override
    public final void windowIconified(WindowEvent var1) {
    }

    @Override
    public final void windowClosed(WindowEvent var1) {
    }

    @Override
    public final void windowClosing(WindowEvent var1) {
        this.destroy();
    }

    @Override
    public final void update(Graphics var1) {
        this.paint(var1);
    }

    static {
        gameEngine = null;
        threadCount = 0;
        stopTimeMs = 0L;
        isKilled = false;
        cycleDurationMillis = 20;
        fiveOrOne = 1;
        fps = 0;
        graphicsTickTimes = new long[32];
        clientTickTimes = new long[32];
        field199 = 500;
        volatileFocus = true;
        garbageCollectorTime = -1L;
        lastGarbageCollect = -1L;
    }
}

