/*
 * Decompiled with CFR 0.152.
 */
package com.client.engine.impl;

import com.client.Client;
import com.client.engine.GameEngine;
import com.client.engine.impl.MouseWheelHandler;
import com.client.graphics.interfaces.impl.Slider;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import net.runelite.rs.api.RSMouseHandler;

public class MouseHandler
implements MouseListener,
MouseMotionListener,
FocusListener,
RSMouseHandler {
    public int clickType;
    public final int LEFT = 0;
    public final int RIGHT = 1;
    public final int DRAG = 2;
    public final int RELEASED = 3;
    public final int MOVE = 4;
    public static MouseHandler instance = new MouseHandler();
    public static volatile int idleCycles = 0;
    public static volatile int currentButton = 0;
    public static volatile long lastMoved;
    public static int mouseX;
    public static int mouseY;
    public static volatile int clickMode3;
    public static volatile int saveClickX;
    public static volatile int saveClickY;
    public static volatile long lastPressed;
    public static int lastButton;
    private int isInEvent;
    public int clickMode2;
    public int clickMode1;

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (instance != null) {
            currentButton = 0;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MouseEvent event = Client.instance.getCallbacks().mouseClicked(e);
        if (!event.isConsumed() && event.isPopupTrigger()) {
            event.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        MouseEvent mouseEvent = e;
        if (instance != null) {
            if (this.isInEvent == 0) {
                mouseEvent = Client.instance.getCallbacks().mousePressed(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                ++this.isInEvent;
                try {
                    idleCycles = 0;
                    saveClickX = mouseEvent.getX();
                    saveClickY = mouseEvent.getY();
                    lastPressed = GameEngine.method2692();
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        MouseWheelHandler.mouseWheelDown = true;
                        MouseWheelHandler.mouseWheelX = mouseEvent.getX();
                        MouseWheelHandler.mouseWheelY = mouseEvent.getY();
                        return;
                    }
                    if (SwingUtilities.isRightMouseButton(e)) {
                        this.clickType = 1;
                        this.clickMode1 = 2;
                        this.clickMode2 = 2;
                    } else if (SwingUtilities.isLeftMouseButton(e)) {
                        this.clickType = 0;
                        this.clickMode1 = 1;
                        this.clickMode2 = 1;
                    }
                    try {
                        Slider.handleSlider(mouseX, mouseY);
                    }
                    catch (Exception g2) {
                        System.out.println(g2);
                    }
                    if (mouseEvent.isPopupTrigger()) {
                        mouseEvent.consume();
                    }
                }
                finally {
                    --this.isInEvent;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MouseEvent mouseEvent = e;
        if (instance != null) {
            idleCycles = 0;
            currentButton = 0;
            if (this.isInEvent == 0) {
                mouseEvent = Client.instance.getCallbacks().mouseReleased(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                ++this.isInEvent;
                try {
                    MouseWheelHandler.mouseWheelDown = false;
                    this.clickMode2 = 0;
                    this.clickType = 3;
                    if (mouseEvent.isPopupTrigger()) {
                        mouseEvent.consume();
                    }
                }
                finally {
                    --this.isInEvent;
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        MouseEvent mouseEvent = e;
        if (this.isInEvent == 0) {
            mouseEvent = Client.instance.getCallbacks().mouseEntered(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            ++this.isInEvent;
            try {
                this.mouseMoved(mouseEvent);
            }
            finally {
                --this.isInEvent;
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (instance != null) {
            MouseEvent mouseEvent = e;
            if (this.isInEvent == 0) {
                mouseEvent = Client.instance.getCallbacks().mouseExited(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                ++this.isInEvent;
                try {
                    idleCycles = 0;
                    mouseX = -1;
                    mouseY = -1;
                    lastMoved = mouseEvent.getWhen();
                }
                finally {
                    --this.isInEvent;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        MouseEvent mouseEvent = e;
        if (this.isInEvent == 0) {
            mouseEvent = Client.instance.getCallbacks().mouseDragged(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            ++this.isInEvent;
            try {
                if (MouseWheelHandler.mouseWheelDown) {
                    int y = MouseWheelHandler.mouseWheelX - mouseEvent.getX();
                    int k = MouseWheelHandler.mouseWheelY - mouseEvent.getY();
                    Client.instance.mouseWheelDragged(y, -k);
                    MouseWheelHandler.mouseWheelX = mouseEvent.getX();
                    MouseWheelHandler.mouseWheelY = mouseEvent.getY();
                    return;
                }
                mouseX = mouseEvent.getX();
                mouseY = mouseEvent.getY();
                this.clickType = 2;
            }
            finally {
                --this.isInEvent;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseEvent mouseEvent = e;
        if (this.isInEvent == 0) {
            mouseEvent = Client.instance.getCallbacks().mouseMoved(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            ++this.isInEvent;
            try {
                mouseX = mouseEvent.getX();
                mouseY = mouseEvent.getY();
                this.clickType = 4;
            }
            finally {
                --this.isInEvent;
            }
        }
    }

    static {
        mouseX = -1;
        mouseY = -1;
        lastMoved = -1L;
        clickMode3 = 0;
        lastPressed = 0L;
        lastButton = 0;
        saveClickX = 0;
        saveClickY = 0;
    }
}

