/*
 * Decompiled with CFR 0.152.
 */
package com.client.engine.impl;

import com.client.Client;
import com.client.engine.impl.MouseHandler;
import com.client.graphics.interfaces.RSInterface;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import net.runelite.rs.api.RSMouseWheelHandler;

public class MouseWheelHandler
implements MouseWheelListener,
RSMouseWheelHandler {
    int rotation;
    public static boolean mouseWheelDown;
    public static int mouseWheelX;
    public static int mouseWheelY;
    public boolean canZoom = true;

    public synchronized int useRotation() {
        int rotation = this.rotation;
        this.rotation = 0;
        return rotation;
    }

    public void addTo(Component component) {
        component.addMouseWheelListener(this);
    }

    public void removeFrom(Component component) {
        component.removeMouseWheelListener(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation = e.getWheelRotation();
        try {
            if (!this.handleInterfaceScrolling(e)) {
                if (MouseHandler.mouseX > 0 && MouseHandler.mouseX < 512 && MouseHandler.mouseY > Client.canvasHeight - 165 && MouseHandler.mouseY < Client.canvasHeight - 25) {
                    int scrollPos = Client.anInt1089;
                    if ((scrollPos -= rotation * 30) < 0) {
                        scrollPos = 0;
                    }
                    if (Client.anInt1089 != scrollPos) {
                        Client.anInt1089 = scrollPos;
                    }
                } else if (Client.loggedIn) {
                    boolean zoom;
                    boolean bl = !Client.instance.isResized() ? MouseHandler.mouseX < 512 : (zoom = MouseHandler.mouseX < Client.canvasWidth - 200);
                    if (zoom && Client.openInterfaceID == -1) {
                        int zoom_out;
                        int zoom_in = !Client.instance.isResized() ? 195 : 240;
                        int n = zoom_out = !Client.instance.isResized() ? 1105 : 1220;
                        if (rotation != -1) {
                            if (Client.cameraZoom > zoom_in) {
                                Client.cameraZoom -= 45;
                            }
                        } else if (Client.cameraZoom < zoom_out) {
                            Client.cameraZoom += 45;
                        }
                    }
                    Client.inputTaken = true;
                    if (Client.openInterfaceID == -1 && zoom) {
                        RSInterface.interfaceCache[44151].active = true;
                        RSInterface.interfaceCache[42525].slider.setValue(Client.cameraZoom);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.printf("Issue with Widget MouseWheel: " + e, new Object[0]);
        }
    }

    public boolean handleInterfaceScrolling(MouseWheelEvent event) {
        int offsetY;
        int offsetX;
        int rotation = event.getWheelRotation();
        int tabInterfaceID = Client.tabInterfaceIDs[Client.tabID];
        if (tabInterfaceID != -1 && Client.openInterfaceID == -1) {
            int n = offsetX = !Client.instance.isResized() ? 547 : Client.canvasWidth - 197;
            offsetY = !Client.instance.isResized() ? 205 : Client.canvasHeight - (Client.canvasWidth >= 960 ? 37 : 74) - 267;
            try {
                this.handleTabInterfaceScrolling(RSInterface.get(tabInterfaceID), rotation, offsetX, offsetY);
            }
            catch (Exception v) {
                System.out.println(v);
            }
        }
        if (Client.openInterfaceID != -1) {
            offsetX = !Client.instance.isResized() ? 4 : Client.canvasWidth / 2 - 356;
            offsetY = !Client.instance.isResized() ? 4 : Client.canvasHeight / 2 - 230;
            return this.handleMainInterfaceScrolling(Client.openInterfaceID, offsetX, offsetY, rotation);
        }
        return false;
    }

    private void handleTabInterfaceScrolling(RSInterface tab, int rotation, int offsetX, int offsetY) {
        int positionX = 0;
        int positionY = 0;
        int width = 0;
        int height = 0;
        int childID = 0;
        if (tab.children != null) {
            for (int index = 0; index < tab.children.length; ++index) {
                RSInterface child = RSInterface.interfaceCache[tab.children[index]];
                this.handleTabInterfaceScrolling(child, rotation, offsetX + tab.childX[index], offsetY + tab.childY[index]);
                if (child.scrollMax <= 0) continue;
                childID = index;
                positionX = tab.childX[index];
                positionY = tab.childY[index];
                width = child.width + 16;
                height = child.height;
                break;
            }
        }
        if (MouseHandler.mouseX > offsetX + positionX && MouseHandler.mouseY > offsetY + positionY && MouseHandler.mouseX < offsetX + positionX + width && MouseHandler.mouseY < offsetY + positionY + height) {
            RSInterface rsInterface = RSInterface.interfaceCache[tab.children[childID]];
            rsInterface.scrollPosition += rotation * 30;
            if (rsInterface.scrollPosition < 0) {
                rsInterface.scrollPosition = 0;
            }
            if (rsInterface.scrollPosition > rsInterface.scrollMax - rsInterface.height) {
                rsInterface.scrollPosition = rsInterface.scrollMax - rsInterface.height;
            }
            Client.tabAreaAltered = true;
            Client.needDrawTabArea = true;
            return;
        }
    }

    private boolean handleMainInterfaceScrolling(int interfaceId, int offsetX, int offsetY, int rotation) {
        try {
            RSInterface rsi = RSInterface.interfaceCache[interfaceId];
            if (rsi.children != null) {
                for (int index = 0; index < rsi.children.length; ++index) {
                    this.handleMainInterfaceScrolling(rsi.children[index], offsetX + rsi.childX[index], offsetY + rsi.childY[index], rotation);
                    if (RSInterface.interfaceCache[rsi.children[index]].scrollMax <= 0 || MouseHandler.mouseX <= offsetX + rsi.childX[index] || MouseHandler.mouseY <= offsetY + rsi.childY[index] || MouseHandler.mouseX >= offsetX + rsi.childX[index] + RSInterface.interfaceCache[rsi.children[index]].width + 16 || MouseHandler.mouseY >= offsetY + rsi.childY[index] + RSInterface.interfaceCache[rsi.children[index]].height) continue;
                    RSInterface rsInterface = RSInterface.interfaceCache[rsi.children[index]];
                    rsInterface.scrollPosition += rotation * 30;
                    if (rsInterface.scrollPosition < 0) {
                        rsInterface.scrollPosition = 0;
                    }
                    if (rsInterface.scrollPosition > rsInterface.scrollMax - rsInterface.height) {
                        rsInterface.scrollPosition = rsInterface.scrollMax - rsInterface.height;
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

