/*
 * Decompiled with CFR 0.152.
 */
package com.client.features;

import com.client.Client;
import com.client.Configuration;
import com.client.Entity;
import com.client.Npc;
import com.client.Player;
import com.client.RSFont;
import com.client.Rasterizer2D;

public class EntityTarget {
    private byte state;
    private final Client client = Client.getInstance();
    private Entity target;

    public EntityTarget(byte state, short entityIndex, short currentHealth, short maximumHealth, RSFont rsFont) {
        this.state = state;
        if (state > 0 && state < 3) {
            try {
                if (state == 1) {
                    this.target = this.client.npcs[entityIndex];
                } else if (state == 2) {
                    this.target = this.client.players[entityIndex];
                }
            }
            catch (Exception e) {
                System.err.println("Error when setting target index: " + entityIndex);
                e.printStackTrace();
                return;
            }
            if (this.target != null) {
                this.target.currentHealth = currentHealth;
                this.target.maxHealth = maximumHealth;
            }
        }
    }

    public void draw() {
        if (this.state <= 0 || this.state > 2 || this.target == null) {
            return;
        }
        int x = Client.instance.getLocalPlayerX();
        int y = Client.instance.getLocalPlayerY();
        if (x >= 3862 && y >= 9940 && x <= 3883 && y <= 9961) {
            return;
        }
        String name = "Unknown";
        if (this.state == 1) {
            Npc npc = (Npc)this.target;
            if (npc.desc != null) {
                name = npc.desc.name;
            }
        } else if (this.state == 2) {
            name = ((Player)this.target).displayName;
        } else {
            this.state = 0;
            return;
        }
        int offset = 4;
        if (Client.counterOn && Configuration.xpPosition == 2) {
            offset = 31;
        }
        int width = 134;
        int xPos = 6;
        int yPos = 22 + offset;
        Rasterizer2D.drawBoxOutline(xPos, yPos, width - 3, 34, 3747874);
        Rasterizer2D.drawAlphaBox(xPos, yPos, width - 3, 33, 6313806, 110);
        Client.latoBold.drawCenteredString(name, xPos + width / 2 - 2, yPos + 18, 0xFFFFFF, 0);
        int barWidth = 124;
        int fillPercentage = this.target.currentHealth * barWidth / this.target.maxHealth;
        Rasterizer2D.drawAlphaBox(xPos + 3, yPos + 18, width - 9, 13, 11740160, 160);
        Rasterizer2D.drawAlphaBox(xPos + 3, yPos + 18, fillPercentage, 13, 43264, 160);
        Client.latoBold.drawCenteredString(this.target.currentHealth + " / " + this.target.maxHealth, xPos + width / 2 - 2, yPos + 33, 0xFFFFFF, 0);
    }

    public void stop() {
        this.state = 0;
    }
}

