/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.builder.impl.tasks;

import com.client.Sprite;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.builder.InterfaceBuilder;
import com.client.graphics.interfaces.builder.impl.tasks.TaskAchievementsSubInterface;
import com.client.graphics.interfaces.builder.impl.tasks.TaskDiariesSubInterface;
import com.client.graphics.interfaces.builder.impl.tasks.TaskInterfaceActions;
import com.client.graphics.interfaces.builder.impl.tasks.TaskInterfaceSub;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskDifficulty;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntry;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntryType;
import com.client.model.GameItem;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.RandomUtils;

public class TaskInterface
extends InterfaceBuilder {
    private final Sprite longTab = TaskInterface.getSprite("long tab 0");
    private final Sprite longTabSelected = TaskInterface.getSprite("long tab 1");
    private final Sprite shortTab = TaskInterface.getSprite("short tab 0");
    private final Sprite shortTabSelected = TaskInterface.getSprite("short tab 1");
    public TaskInterfaceActions actions = new TaskInterfaceActions(this);
    public TaskInterfaceSub[] subs;
    public int containerInterfaceId;
    public TaskEntryType state = TaskEntryType.ACHIEVEMENTS;
    public static boolean TEST_MODE = false;

    public static Sprite getSprite(String sprite) {
        return new Sprite("achievements_v2/" + sprite);
    }

    public TaskInterface() {
        super(24500);
    }

    @Override
    public void build() {
        this.init();
        this.subs = new TaskInterfaceSub[]{new TaskInterfaceSub(TaskEntryType.DIARIES, "Diaries", this.shortTab, this.shortTabSelected, this.getBaseInterfaceId() + 100), new TaskInterfaceSub(TaskEntryType.ACHIEVEMENTS, "Achievements", this.longTab, this.longTabSelected, this.getBaseInterfaceId() + 400)};
        int x = 5;
        int y = 3;
        for (TaskInterfaceSub state : this.subs) {
            boolean selected = this.state == state.getType();
            Sprite sprite = selected ? state.getSelected() : state.getUnselected();
            state.setButtonInterfaceId(this.getCurrentInterfaceId());
            TaskInterface.addButton(this.nextInterface(), sprite, state.getName(), 4);
            this.child(x, y);
            TaskInterface.addText(this.nextInterface(), 0, 0xFF9933, true, state.getName());
            this.child(x + sprite.myWidth / 2, y + 3);
            x += sprite.myWidth - 1;
        }
        this.containerInterfaceId = this.getCurrentInterfaceId();
        RSInterface baseContainer = RSInterface.addInterfaceContainer(this.nextInterface(), 255, 255, 0);
        RSInterface.setChildren(1, baseContainer);
        this.child(10, 24);
        TaskInterfaceSub achievements = this.byType(TaskEntryType.ACHIEVEMENTS);
        achievements.setInterfaceId(this.getCurrentInterfaceId());
        TaskAchievementsSubInterface achievementsInterface = new TaskAchievementsSubInterface(this.nextInterface(), achievements);
        achievementsInterface.build();
        this.setNextInterfaceId(achievementsInterface.getCurrentInterfaceId());
        TaskInterfaceSub diaries = this.byType(TaskEntryType.DIARIES);
        diaries.setInterfaceId(this.getCurrentInterfaceId());
        TaskDiariesSubInterface diariesInterface = new TaskDiariesSubInterface(this.nextInterface(), diaries);
        diariesInterface.build();
        this.setNextInterfaceId(diariesInterface.getCurrentInterfaceId());
        this.actions.setOpen(TaskEntryType.ACHIEVEMENTS);
        this.getRoot().setNewButtonClicking();
        if (TEST_MODE) {
            ArrayList<TaskEntry> diariesList = Lists.newArrayList();
            ArrayList<TaskEntry> achievementsList = Lists.newArrayList();
            for (int index = 0; index <= 200; index += 20) {
                String title = "Test Task Entry " + index / 20;
                StringJoiner description2 = new StringJoiner("\\n");
                StringJoiner extraRewards = new StringJoiner("\\n");
                ArrayList<GameItem> items = Lists.newArrayList();
                description2.add("Test description");
                extraRewards.add("Extra rewards");
                for (int i = 0; i < index / 20 && i < 8; ++i) {
                    description2.add("Description extension");
                    extraRewards.add("Extra rewards extension");
                    items.add(new GameItem(4151 + i * 2, 1));
                }
                int progress = Math.min(index, 100);
                boolean skipItems = items.size() >= 4 && index / 20 % 2 == 0;
                achievementsList.add(new TaskEntry(title, description2.toString(), false, TaskDifficulty.values()[RandomUtils.nextInt(1, TaskDifficulty.values().length)], skipItems ? null : items, extraRewards.toString(), Lists.newArrayList(progress + "/100")));
                diariesList.add(new TaskEntry(title, description2.toString(), skipItems ? null : items, extraRewards.toString(), Lists.newArrayList(progress + "/100", progress + "/100", progress + "/100", progress + "/100")));
            }
            this.actions.setAchievements(achievementsList);
            this.actions.setDiaries(diariesList);
        }
    }

    public TaskInterfaceSub byType(TaskEntryType type2) {
        Optional<TaskInterfaceSub> state = Arrays.stream(this.subs).filter(it -> it.getType() == type2).findFirst();
        if (!state.isPresent()) {
            throw new IllegalStateException("No type found: " + type2);
        }
        return state.get();
    }
}

