/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.builder.impl.tasks.model;

import com.client.StringUtils;
import com.client.graphics.interfaces.builder.impl.tasks.AchievementFilter;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskDifficulty;
import com.client.model.GameItem;
import com.client.utilities.Misc;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.stream.Collectors;

public class TaskEntry {
    private static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("#0.0");
    private final String title;
    private final String description;
    private boolean claimed;
    private final TaskDifficulty taskDifficulty;
    private final List<GameItem> rewards;
    private final String extraRewards;
    private List<String> progress;

    public TaskEntry(String title, String description2, List<GameItem> rewards, String extraRewards, List<String> progress) {
        this(title, description2, false, TaskDifficulty.NONE, rewards, extraRewards, progress);
    }

    public TaskEntry(String title, String description2, boolean claimed, TaskDifficulty taskDifficulty, List<GameItem> rewards, String extraRewards, List<String> progress) {
        this.title = title;
        this.description = description2;
        this.claimed = claimed;
        this.taskDifficulty = taskDifficulty;
        this.rewards = rewards;
        this.extraRewards = extraRewards;
        this.progress = progress;
    }

    public String toString() {
        return "TaskEntry{title='" + this.title + "', description='" + this.description + "', claimed=" + this.claimed + ", taskDifficulty=" + this.taskDifficulty + ", rewards=" + this.rewards + ", extraRewards='" + this.extraRewards + "', progress=" + this.progress + "}";
    }

    public boolean isFiltered(AchievementFilter filter) {
        switch (filter) {
            case STARTER: {
                return this.taskDifficulty != TaskDifficulty.STARTER;
            }
            case BEGINNER: {
                return this.taskDifficulty != TaskDifficulty.BEGINNER;
            }
            case INTERMEDIATE: {
                return this.taskDifficulty != TaskDifficulty.INTERMEDIATE;
            }
            case EXPERT: {
                return this.taskDifficulty != TaskDifficulty.EXPERT;
            }
            case LEGENDARY: {
                return this.taskDifficulty != TaskDifficulty.LEGENDARY;
            }
            case ALL: {
                return false;
            }
            case COMPLETE: {
                return this.getCurrentTicks() != this.getTicksForCompletion();
            }
            case INCOMPLETE: {
                return this.getCurrentTicks() == this.getTicksForCompletion();
            }
            case CLAIMABLE: {
                return !this.isClaimable();
            }
        }
        throw new IllegalStateException("No option for filter: " + filter);
    }

    private List<String[]> getCompletionPercentages() {
        return this.getProgress().stream().map(it -> it.split("/")).collect(Collectors.toList());
    }

    public int getCurrentTicks() {
        return this.getCompletionPercentages().stream().mapToInt(it -> Integer.parseInt(it[0])).sum();
    }

    public int getTicksForCompletion() {
        return this.getCompletionPercentages().stream().mapToInt(it -> Integer.parseInt(it[1])).sum();
    }

    public String getProgressSlash(boolean abbrev) {
        if (abbrev) {
            return Misc.format(this.getCurrentTicks()) + "/" + Misc.format(this.getTicksForCompletion());
        }
        return StringUtils.insertCommas(this.getCurrentTicks()) + "/" + StringUtils.insertCommas(this.getTicksForCompletion());
    }

    public boolean isClaimable() {
        return !this.isClaimed() && this.getProgress().size() == 1 && this.getCompletionPercentage() == 1.0;
    }

    public double getCompletionPercentage() {
        return (double)this.getCurrentTicks() / (double)this.getTicksForCompletion();
    }

    public double getCompletionPercentage(int index) {
        String[] data2 = this.getProgress().get(index).split("/");
        return (double)Integer.parseInt(data2[0]) / (double)Integer.parseInt(data2[1]);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    public TaskDifficulty getTaskDifficulty() {
        return this.taskDifficulty;
    }

    public List<GameItem> getRewards() {
        return this.rewards;
    }

    public String getExtraRewards() {
        return this.extraRewards;
    }

    public List<String> getProgress() {
        return this.progress;
    }

    public void setProgress(List<String> progress) {
        this.progress = progress;
    }
}

