/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.eventcalendar;

import com.client.Client;
import com.client.Sprite;
import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.eventcalendar.EventCalendarDay;
import com.google.common.base.Preconditions;

public class EventCalendar
extends RSInterface {
    public static final int INTERFACE_ID = 23332;
    private static final int CHALLENGE_SPRITE_COUNT = 30;
    private static final String REWARD_STRING_COLOUR = "<col=27C60D>";
    private static final String DESCRIPTION_COLOUR = "<col=C18C28>";
    private static final String HEADER_COLOUR = "<col=F6AB1E>";
    private static final String SPRITES_LOCATION = "Interfaces/Giveaway/";
    private static final String CHALLENGE_SPRITE_NAME = "DAY";
    private static final EventCalendar EVENT_CALENDAR = new EventCalendar();
    private Sprite[] challengeSprites;
    private final Sprite backgroundSprite = new Sprite("Interfaces/Giveaway/BACKGROUND 1");
    private final Sprite buttonSprite = new Sprite("Interfaces/Giveaway/BUTTON 1");
    private final Sprite rectangle = new Sprite("Interfaces/Giveaway/RECTANGLE 1");
    private int headerStringInterfaceId;
    private int challengeDescriptionInterfaceId;
    private int challengeSpriteInterfaceId;
    private int challengeSpriteChildId;
    private int challengeRewardInterfaceId;
    private int winnerNumbersContainerInterfaceId;
    private int winnerNamesContainerInterfaceId;
    private int participantsNumbersContainerInterfaceId;
    private int participantsNamesContainerInterfaceId;

    public static EventCalendar getCalendar() {
        return EVENT_CALENDAR;
    }

    private EventCalendar() {
    }

    public void onStringContainerUpdated(int containerId) {
        if (containerId == this.participantsNamesContainerInterfaceId) {
            EventCalendar.get((int)this.participantsNumbersContainerInterfaceId).stringContainer.clear();
            for (int index = 0; index < EventCalendar.get((int)containerId).stringContainer.size(); ++index) {
                EventCalendar.get((int)this.participantsNumbersContainerInterfaceId).stringContainer.add(index + 1 + ".");
            }
        }
    }

    public void onConfigReceived(int config, int value) {
        int dayIndex;
        if (config == 1358 && (dayIndex = value - 1) >= 0 && dayIndex < this.challengeSprites.length) {
            EventCalendarDay eventCalendarDay = EventCalendarDay.forDayOfTheMonth(value);
            int[] reward = eventCalendarDay.getReward();
            this.setChallengeSprite(this.challengeSpriteInterfaceId, this.challengeSpriteChildId, dayIndex);
            EventCalendar.get((int)this.challengeDescriptionInterfaceId).message = eventCalendarDay.getChallenge().getWrappedString(Client.instance.newSmallFont, DESCRIPTION_COLOUR);
            EventCalendar.get((int)this.challengeRewardInterfaceId).message = REWARD_STRING_COLOUR + reward[0] + "m OSRS GP or \\n<col=27C60D>$" + reward[1] + " Donator Scroll ";
            EventCalendar.get((int)this.headerStringInterfaceId).message = "September Giveaway (Day " + value + ")";
        }
    }

    private void setChallengeSprite(int interfaceId, int childId, int challengeSpriteIndex) {
        RSInterface inter = EventCalendar.get(23332);
        Sprite sprite = this.challengeSprites[challengeSpriteIndex];
        EventCalendar.addSprite(interfaceId, this.challengeSprites[challengeSpriteIndex]);
        inter.child(childId, interfaceId, 97 - sprite.myWidth / 2, 166 - sprite.myHeight / 2);
    }

    public void load(TextDrawingArea[] tda) {
        this.challengeSprites = new Sprite[30];
        for (int sprite = 0; sprite < 30; ++sprite) {
            this.challengeSprites[sprite] = new Sprite("Interfaces/Giveaway/DAY " + (sprite + 1));
            Preconditions.checkState(this.challengeSprites[sprite] != null && this.challengeSprites[sprite].myWidth != 0);
        }
        Preconditions.checkState(this.backgroundSprite.myWidth != 0);
        RSInterface inter = EventCalendar.addInterface(23332);
        inter.totalChildren(17);
        int interfaceId = 23333;
        int childId = 0;
        int x = 14;
        int y = 26;
        EventCalendar.addSprite(interfaceId, this.backgroundSprite);
        inter.child(childId++, interfaceId++, x, y);
        inter.child(childId++, 37302, x + 462, y + 10);
        inter.child(childId++, 37303, x + 462, y + 10);
        this.headerStringInterfaceId = interfaceId;
        EventCalendar.addText(this.headerStringInterfaceId, "Valoria' June Giveaway", tda, 2, 16750623, true);
        inter.child(childId++, interfaceId++, 247, 36);
        String[] headers = new String[]{"Active Challenges", "Past Winners", "Current Participants"};
        for (int index = 0; index < headers.length; ++index) {
            EventCalendar.addText(interfaceId, HEADER_COLOUR + headers[index], tda, 1, 16750623, true);
            inter.child(childId++, interfaceId++, 94 + index * 161, 62);
        }
        int textCenterX = 97;
        this.challengeDescriptionInterfaceId = interfaceId;
        EventCalendar.addText(interfaceId, "Obtain 5 Wildy\\nEvent Keys", tda, 0, 16750623, true);
        inter.child(childId++, interfaceId++, textCenterX, 90);
        this.challengeSpriteInterfaceId = interfaceId;
        this.challengeSpriteChildId = childId;
        this.setChallengeSprite(interfaceId, childId, 0);
        int statusY = 212;
        EventCalendar.addText(++interfaceId, "<col=F6AB1E>Status:", tda, 2, 16750623, true);
        int n = ++childId;
        inter.child(n, interfaceId++, textCenterX, statusY);
        EventCalendar.addText(interfaceId, "@red@Incomplete", tda, 0, 16750623, true);
        int n2 = ++childId;
        inter.child(n2, interfaceId++, textCenterX, statusY + 14);
        int rewardOptionsY = 250;
        EventCalendar.addText(interfaceId, "<col=F6AB1E>Reward Options:", tda, 2, 16750623, true);
        int n3 = ++childId;
        inter.child(n3, interfaceId++, textCenterX, rewardOptionsY);
        this.challengeRewardInterfaceId = interfaceId;
        EventCalendar.addText(interfaceId, "", tda, 0, 16750623, true);
        int n4 = ++childId;
        inter.child(n4, interfaceId++, textCenterX, rewardOptionsY + 18);
        EventCalendar.addButton(interfaceId, this.buttonSprite, "Open Rules", 1);
        int button = interfaceId;
        int n5 = ++childId;
        inter.child(n5, interfaceId++, 21, 296);
        EventCalendar.addText(interfaceId, "Rules", tda, 2, 16750623, true);
        int n6 = ++childId;
        inter.child(n6, interfaceId++, textCenterX, 302);
        int n7 = ++childId;
        inter.child(n7, interfaceId, 177, 84);
        interfaceId = this.getStringContainer(interfaceId, 0);
        int n8 = ++childId;
        ++childId;
        inter.child(n8, interfaceId, 336, 84);
        interfaceId = this.getStringContainer(interfaceId, 1);
        this.onConfigReceived(1358, 1);
        EventCalendar.get(23332).setNewButtonClicking();
        Preconditions.checkState(EventCalendar.get((int)button).newButtonClicking);
    }

    public int getStringContainer(int interfaceId, int containerIndex) {
        int containerInterfaceId = interfaceId;
        RSInterface container = this.sectionContainer(interfaceId);
        interfaceId += 2;
        RSInterface names = EventCalendar.addStringContainer(interfaceId++, containerInterfaceId, Client.instance.newSmallFont, true, -1, true, 17, "Testing");
        RSInterface numbers = EventCalendar.addStringContainer(interfaceId++, containerInterfaceId, Client.instance.newSmallFont, true, -1, true, 17, null);
        container.child(100, names.id, 76, 12);
        container.child(101, numbers.id, 10, 12);
        for (int index = 0; index < 100; ++index) {
            numbers.stringContainer.add(index + 1 + ".");
        }
        if (containerIndex == 0) {
            this.winnerNumbersContainerInterfaceId = numbers.id;
            this.winnerNamesContainerInterfaceId = names.id;
        } else {
            this.participantsNumbersContainerInterfaceId = numbers.id;
            this.participantsNamesContainerInterfaceId = names.id;
        }
        return interfaceId;
    }

    private RSInterface sectionContainer(int interfaceId) {
        RSInterface rsInterface = EventCalendar.addInterface(interfaceId);
        rsInterface.width = 139;
        rsInterface.height = 242;
        rsInterface.scrollMax = 243;
        rsInterface.totalChildren(102);
        EventCalendar.addSprite(interfaceId + 1, this.rectangle);
        for (int index = 0; index < 100; ++index) {
            rsInterface.child(index, interfaceId + 1, 0, index * 34);
        }
        return rsInterface;
    }
}

