/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Rasterizer2D;
import com.client.Sprite;
import com.client.TextDrawingArea;
import com.client.definitions.ItemDefinition;
import com.client.graphics.interfaces.RSInterface;
import java.util.Arrays;

public class Bank
extends RSInterface {
    public static final int EMPTY_CHILD = 41582;
    public static final int BANK_INTERFACE_ID = 5292;
    public static final int SEARCH_CONTAINER = 41583;
    public static final int SEARCH_BUTTON = 18937;
    public static final int TITLE_INTERFACE_ID = 58064;
    public static final int BANK_CONTAINER_HEIGHT = 130;
    public static final int OLD_CONTAINER_INTERFACE_ID = 5382;
    public static final int ITEM_COUNT_INTERFACE_ID = 58061;
    public static final int[] ITEM_CONTAINERS = new int[]{41573, 41574, 41575, 41576, 41577, 41578, 41579, 41580, 41581};
    public static final int[] BANK_TAB_ITEM_DISPLAYS = new int[]{58040, 58041, 58042, 58043, 58044, 58045, 58046, 58047, 58048};
    public static final int[] TAB_INTERFACE_IDS = new int[]{58050, 58051, 58052, 58053, 58054, 58055, 58056, 58057, 58058};
    public static final int[] COLLAPSE_BUTTONS = new int[]{-1, 58053, 58064, 58075, 58086, 58097, 58108, 58119, 58130};
    public static final int[] OPEN_TAB_BUTTONS = new int[]{58042, 58054, 58065, 58076, 58087, 58098, 58109, 58120, 58131};
    public static final int[] TAB_SPRITE_DISPLAYS = new int[]{58031, 58032, 58033, 58034, 58035, 58036, 58037, 58038, 58039};
    public static final Sprite TAB_WITH_PLUS = new Sprite("BankTab/TAB 4");
    public static final Sprite TAB_WITHOUT_PLUS = new Sprite("BankTab/TAB 3");
    public static int[] mainTabChildren = new int[ITEM_CONTAINERS.length];
    public static RSInterface bankScrollable = null;
    public static String searchingBankString = "";

    public static int getCurrentBankTab() {
        return Client.instance.variousSettings[1357];
    }

    public static boolean isBankContainer(RSInterface rsInterface) {
        return rsInterface.id == 41583 || Arrays.stream(ITEM_CONTAINERS).anyMatch(id -> rsInterface.id == id);
    }

    private static boolean moreTabsBelow(int index) {
        return index + 1 < ITEM_CONTAINERS.length && interfaceCache[ITEM_CONTAINERS[index + 1]].getItemContainerRows() > 0;
    }

    public static boolean isSearchingBank() {
        return Client.inputDialogState == 9;
    }

    public static void openBankSearch() {
        Bank.bankScrollable.children[Bank.mainTabChildren[0]] = 41583;
        Client.inputDialogState = 9;
        interfaceCache[41583].resetItems();
    }

    public static void closeBankSearch() {
        interfaceCache[41583].resetItems();
        Client.inputDialogState = 0;
        searchingBankString = "";
    }

    public static void handleButton(int buttonId) {
        for (int index = 1; index < COLLAPSE_BUTTONS.length; ++index) {
            if (buttonId != COLLAPSE_BUTTONS[index]) continue;
            RSInterface tab = interfaceCache[ITEM_CONTAINERS[index]];
            RSInterface main2 = interfaceCache[ITEM_CONTAINERS[0]];
            if (main2.getInventoryContainerFreeSlots() < (long)tab.inventoryItemId.length - tab.getInventoryContainerFreeSlots()) continue;
            RSInterface.addAllItems(tab, main2);
            Bank.shiftTabs();
            Bank.openBankTab(0);
        }
        for (int buttonIndex = 0; buttonIndex < OPEN_TAB_BUTTONS.length; ++buttonIndex) {
            if (buttonId != OPEN_TAB_BUTTONS[buttonIndex]) continue;
            Bank.openBankTab(buttonIndex);
        }
        if (buttonId == 18937) {
            if (Bank.bankScrollable.children[mainTabChildren[0]] == 41583) {
                Bank.closeBankSearch();
                Bank.openBankTab(Bank.getCurrentBankTab());
            } else {
                Bank.openBankSearch();
            }
        }
    }

    public static void shiftTabs() {
        for (int tabIndex = 1; tabIndex < ITEM_CONTAINERS.length; ++tabIndex) {
            RSInterface container = interfaceCache[ITEM_CONTAINERS[tabIndex]];
            container.shiftItems();
            if (container.getItemContainerRows() != 0) continue;
            for (int shiftTabIndex = tabIndex; shiftTabIndex < ITEM_CONTAINERS.length; ++shiftTabIndex) {
                if (shiftTabIndex + 1 >= ITEM_CONTAINERS.length) continue;
                container = interfaceCache[ITEM_CONTAINERS[shiftTabIndex]];
                RSInterface shiftLeft = interfaceCache[ITEM_CONTAINERS[shiftTabIndex + 1]];
                container.inventoryItemId = (int[])shiftLeft.inventoryItemId.clone();
                container.inventoryAmounts = (int[])shiftLeft.inventoryAmounts.clone();
            }
        }
    }

    public static void bankUpdates() {
        Bank.shiftTabs();
        boolean newTabDisplayed = false;
        for (int tabIndex = 1; tabIndex < TAB_INTERFACE_IDS.length; ++tabIndex) {
            if (interfaceCache[ITEM_CONTAINERS[tabIndex]].getInventoryContainerFreeSlots() != (long)Bank.interfaceCache[Bank.ITEM_CONTAINERS[tabIndex]].inventoryItemId.length) {
                RSInterface.interfaceCache[Bank.TAB_INTERFACE_IDS[tabIndex]].isMouseoverTriggered = false;
                RSInterface.interfaceCache[Bank.TAB_SPRITE_DISPLAYS[tabIndex]].sprite1 = TAB_WITHOUT_PLUS;
                continue;
            }
            if (!newTabDisplayed) {
                RSInterface.interfaceCache[Bank.TAB_INTERFACE_IDS[tabIndex]].isMouseoverTriggered = false;
                RSInterface.interfaceCache[Bank.TAB_SPRITE_DISPLAYS[tabIndex]].sprite1 = TAB_WITH_PLUS;
                newTabDisplayed = true;
                continue;
            }
            RSInterface.interfaceCache[Bank.TAB_INTERFACE_IDS[tabIndex]].isMouseoverTriggered = true;
        }
        for (int index = 1; index < BANK_TAB_ITEM_DISPLAYS.length; ++index) {
            Bank.interfaceCache[Bank.BANK_TAB_ITEM_DISPLAYS[index]].inventoryItemId[0] = Bank.interfaceCache[Bank.ITEM_CONTAINERS[index]].inventoryItemId[0];
            Bank.interfaceCache[Bank.BANK_TAB_ITEM_DISPLAYS[index]].inventoryAmounts[0] = Bank.interfaceCache[Bank.ITEM_CONTAINERS[index]].inventoryAmounts[0];
        }
    }

    public static void drawOnBank(RSInterface rsInterface, int x, int y) {
        if (rsInterface.id == 5292) {
            Rasterizer2D.drawPixels(1, 20, 29, 15108608, 16);
        }
    }

    public static void setupMainTab(RSInterface rsInterface, int x, int y) {
        if (rsInterface.id == 41583) {
            Bank.bankUpdates();
            for (int child : mainTabChildren) {
                Bank.bankScrollable.children[child] = 41582;
            }
            Bank.bankScrollable.children[Bank.mainTabChildren[0]] = 41583;
            Bank.interfaceCache[58064].message = "Results for '" + searchingBankString + "'";
            RSInterface searchContainer = interfaceCache[41583];
            searchContainer.resetItems();
            if (searchingBankString.length() > 0) {
                for (int index = 0; index < ITEM_CONTAINERS.length; ++index) {
                    RSInterface container = interfaceCache[ITEM_CONTAINERS[index]];
                    for (int itemIndex = 0; itemIndex < container.inventoryItemId.length; ++itemIndex) {
                        ItemDefinition definition;
                        if (container.inventoryItemId[itemIndex] <= 0 || (definition = ItemDefinition.lookup(container.inventoryItemId[itemIndex] - 1)) == null || definition.name == null || !definition.name.toLowerCase().contains(searchingBankString.toLowerCase())) continue;
                        searchContainer.addItem(container.inventoryItemId[itemIndex], container.inventoryAmounts[itemIndex]);
                    }
                }
            }
        } else if (rsInterface.id == ITEM_CONTAINERS[Bank.getCurrentBankTab()]) {
            Bank.bankUpdates();
            Bank.interfaceCache[58064].message = "The Bank of Valoria";
            if (Bank.getCurrentBankTab() == 0) {
                for (int index = 0; index < mainTabChildren.length; ++index) {
                    Bank.bankScrollable.children[Bank.mainTabChildren[index]] = 41582;
                }
                int itemContainerIndex = 0;
                for (int index = 0; index < mainTabChildren.length; ++index) {
                    RSInterface container = interfaceCache[ITEM_CONTAINERS[index]];
                    if (index != 0 && container.getInventoryContainerFreeSlots() == (long)container.inventoryItemId.length) continue;
                    Bank.bankScrollable.children[Bank.mainTabChildren[itemContainerIndex++]] = ITEM_CONTAINERS[index];
                }
            } else if (interfaceCache[ITEM_CONTAINERS[Bank.getCurrentBankTab()]].getInventoryContainerFreeSlots() == (long)Bank.interfaceCache[Bank.ITEM_CONTAINERS[Bank.getCurrentBankTab()]].inventoryItemId.length) {
                Bank.openBankTab(0);
            }
            int size = 0;
            for (int container : ITEM_CONTAINERS) {
                size = (int)((long)size + ((long)Bank.interfaceCache[container].inventoryItemId.length - interfaceCache[container].getInventoryContainerFreeSlots()));
            }
            Bank.interfaceCache[58061].message = "<ul>" + size + "</ul>";
            if (Bank.getCurrentBankTab() == 0) {
                int height = 4;
                for (int index = 0; index < ITEM_CONTAINERS.length; ++index) {
                    RSInterface container = interfaceCache[ITEM_CONTAINERS[index]];
                    if (index != 0 && Bank.moreTabsBelow(index - 1)) {
                        Client.instance.bankDivider.drawSprite(x, height + y);
                        height += 10;
                    }
                    Bank.bankScrollable.childY[Bank.mainTabChildren[index]] = height;
                    height += container.getItemContainerHeight();
                }
                Bank.bankScrollable.scrollMax = height > Bank.bankScrollable.height + 1 ? height : Bank.bankScrollable.height + 1;
            } else {
                int height = rsInterface.getItemContainerHeight();
                Bank.bankScrollable.scrollMax = height > Bank.bankScrollable.height + 1 ? height : Bank.bankScrollable.height + 1;
            }
        }
    }

    public static void openBankTab(int tab) {
        if (interfaceCache[ITEM_CONTAINERS[tab]].getInventoryContainerFreeSlots() == (long)Bank.interfaceCache[Bank.ITEM_CONTAINERS[tab]].inventoryItemId.length && tab != 0) {
            return;
        }
        Bank.closeBankSearch();
        Client.instance.variousSettings[1357] = tab;
        for (int tabIndex = 0; tabIndex < ITEM_CONTAINERS.length; ++tabIndex) {
            Client.instance.variousSettings[34 + tabIndex] = tabIndex == 0 ? 1 : 0;
        }
        Client.instance.variousSettings[34 + tab] = tab == 0 ? 0 : 1;
        Bank.bankScrollable.scrollPosition = 0;
        if (tab != 0) {
            for (int child : mainTabChildren) {
                Bank.bankScrollable.children[child] = 41582;
            }
        }
        Bank.bankScrollable.children[Bank.mainTabChildren[0]] = ITEM_CONTAINERS[tab];
    }

    public static void onConfigChanged(int config, int value) {
        if (config == 1357) {
            Bank.closeBankSearch();
            Bank.openBankTab(value);
        }
    }

    private void editBank(TextDrawingArea[] tda) {
        bankScrollable = interfaceCache[5385];
        Bank.bankScrollable.height -= 2;
        RSInterface bank = interfaceCache[5292];
        for (int index = 0; index < bank.children.length; ++index) {
            if (bank.children[index] != Bank.bankScrollable.id) continue;
            int n = index;
            bank.childY[n] = bank.childY[n] + 2;
        }
        if (!RSInterface.deleteChild(5382, bankScrollable)) {
            System.out.println("Skipping bank reload.");
            return;
        }
        Bank.addText(41582, "", tda, 1, 15108608, true, true);
        int newContainersStartIndex = Bank.expandChildren(ITEM_CONTAINERS.length, bankScrollable);
        for (int index = 0; index < ITEM_CONTAINERS.length; ++index) {
            RSInterface container = Bank.addInventoryContainer(ITEM_CONTAINERS[index], 10, 130, 12, 0, true, new String[0]);
            container.actions = new String[]{"Withdraw 1", "Withdraw 5", "Withdraw 10", "Withdraw All", "Withdraw X", "Withdraw All but one"};
            container.contentType = 206;
            Bank.mainTabChildren[index] = newContainersStartIndex;
            bankScrollable.child(newContainersStartIndex++, ITEM_CONTAINERS[index], 38, 0);
        }
        for (int container : ITEM_CONTAINERS) {
            Bank.interfaceCache[container].allowInvDraggingToOtherContainers = true;
        }
        RSInterface container = Bank.addInventoryContainer(41583, 10, 130, 12, 0, true, new String[0]);
        container.actions = new String[]{"Withdraw 1", "Withdraw 5", "Withdraw 10", "Withdraw All", "Withdraw X", "Withdraw All but one"};
    }

    public void bank(TextDrawingArea[] tda) {
        RSInterface rs = Bank.addInterface(5292);
        rs.message = "";
        Bank.setChildren(47, rs);
        Bank.addSprite(58001, 0, "BankTab/07/BANK");
        Bank.addHoverButton(5384, "BankTab/updated/CLOSE", 97, 21, 21, "Close Window", 250, 5380, 3);
        Bank.addHoveredButton(5380, "BankTab/updated/CLOSE", 98, 21, 21, 5379);
        Bank.addHoverButton(5294, "BankTab/07/BANK", 7, 37, 29, "Set/Edit Your Account-Pin", 250, 5295, 4);
        Bank.addHoveredButton(5295, "BankTab/BANK", 4, 100, 33, 5296);
        Bank.addBankHover(58002, 4, 58003, 0, 1, "BankTab/updated/FLOW", 50, 22, 304, 1, "Swap Item Movement Mode", 58004, 7, 6, "BankTab/BANK", 58005, "Switch to insert items \nmode", "Switch to swap items \nmode.", 12, 20);
        Bank.addBankHover(58010, 4, 58011, 0, 1, "BankTab/updated/FLOW", 50, 22, 116, 1, "Enable/Disable Noted Withdrawal", 58012, 10, 12, "BankTab/BANK", 58013, "Switch to note withdrawal \nmode", "Switch to item withdrawal \nmode", 12, 20);
        Bank.addBankHover1(58018, 5, 58019, 1, "BankTab/07/BANK", 37, 29, "Deposit carried items", 58020, 2, "BankTab/07/BANK", 58021, "Empty your backpack into\nyour bank", 0, 20);
        Bank.addBankHover1(58026, 5, 58027, 3, "BankTab/07/BANK", 35, 25, "Deposit worn items", 58028, 4, "BankTab/07/BANK", 58029, "Empty the items your are\nwearing into your bank", 0, 20);
        for (int i = 0; i < 9; ++i) {
            Bank.addInterface(58050 + i);
            if (i == 0) {
                Bank.addConfigButton(58031, 5292, 0, 1, "BankTab/TAB", 48, 38, new String[]{"Price Check", "View"}, 1, 34);
                RSInterface.interfaceCache[58031].ignoreConfigClicking = true;
            } else {
                Bank.addConfigButton(58031 + i, 5292, 4, 2, "BankTab/TAB", 48, 38, new String[]{"Price Check", "Collapse", "View"}, 1, 34 + i);
                RSInterface.interfaceCache[58031 + i].ignoreConfigClicking = true;
            }
            Bank.addToItemGroup(58040 + i, 1, 1, 0, 0, false, "", "", "");
        }
        Bank.addText(58061, "0", tda, 0, 15108608, true, true);
        Bank.addText(58062, "350", tda, 0, 15108608, true, true);
        Bank.addInputField(58063, 50, 15108608, "Search", 235, 23, false, true);
        Bank.addText(58064, "The Bank of Valoria", tda, 2, 15108608, true, true);
        Bank.addBankHover(18929, 4, 18930, 0, 1, "BankTab/updated/FLOW", 50, 22, 305, 1, "Swap Item Movement Mode", 18931, 7, 6, "BankTab/BANK", 18932, "Switch to insert items \nmode", "Switch to swap items \nmode.", 12, 20);
        Bank.addBankHover(18933, 4, 18934, 0, 1, "BankTab/updated/FLOW", 50, 22, 117, 1, "Enable/Disable Noted Withdrawal", 18935, 10, 12, "BankTab/BANK", 18936, "Switch to note withdrawal \nmode", "Switch to item withdrawal \nmode", 12, 20);
        Bank.addBankHover1(18937, 5, 18938, 0, "BankTab/updated/SEARCH", 36, 36, "Search items", 18939, 4, "BankTab/updated/SEARCH", 18940, "Empty the items your are\nwearing into your bank", 0, 1);
        Bank.addClickableSprites(58014, "Enable/Disable Always Placeholders", "BankTab/07/BANK", 5, 6, 5);
        Bank.addText(18941, "Rearrange mode:", tda, 1, 15108608, false, true);
        Bank.addText(18942, "Withdraw as:", tda, 1, 15108608, true, true);
        Bank.addText(18943, "Swap", tda, 1, 15108608, true, true);
        Bank.addText(18944, "Insert", tda, 1, 15108608, true, true);
        Bank.addText(18945, "Item", tda, 1, 15108608, true, true);
        Bank.addText(18946, "Note", tda, 1, 15108608, true, true);
        Bank.addSprite(58999, 15, "BankTab/07/BANK");
        int id = 59000;
        for (int i = 0; i < 5; ++i) {
            Bank.addConfigButton(id, id, 21, 16 + i, "BankTab/07/BANK", 25, 22, "Select", i, 5, 275);
            Bank.setBounds(id, 223 + i * 25, 308, 42 + i, rs);
            ++id;
        }
        Bank.addBankHover1(18947, 5, 18948, 0, "Presets/OPEN", 36, 36, "Open Preset Interface", 18949, 4, "Presets/OPEN", 18950, "Open Preset Interface", 0, 1);
        RSInterface Interface2 = interfaceCache[5385];
        Interface2.height = 202;
        Interface2.width = 481;
        Bank.setBounds(58001, 16, 5, 0, rs);
        Bank.setBounds(5384, 476, 12, 1, rs);
        Bank.setBounds(5380, 476, 12, 2, rs);
        Bank.setBounds(58002, 22, 308, 3, rs);
        Bank.setBounds(58003, 22, 308, 4, rs);
        Bank.setBounds(58010, 122, 308, 5, rs);
        Bank.setBounds(58011, 122, 308, 6, rs);
        Bank.setBounds(58018, 425, 294, 7, rs);
        Bank.setBounds(58019, 425, 294, 8, rs);
        Bank.setBounds(58026, 462, 294, 9, rs);
        Bank.setBounds(58027, 462, 294, 10, rs);
        Bank.setBounds(5385, -1, 78, 11, rs);
        RSInterface.interfaceCache[5385].height = 216;
        int x = 59;
        for (int i = 0; i < 9; ++i) {
            Bank.setBounds(58050 + i, 0, 0, 15 + i, rs);
            RSInterface rsi = interfaceCache[58050 + i];
            Bank.setChildren(2, rsi);
            Bank.setBounds(58031 + i, x, 38, 0, rsi);
            Bank.setBounds(58040 + i, x + 5, 42, 1, rsi);
            x += 41;
        }
        Bank.setBounds(58061, 38, 11, 22, rs);
        Bank.setBounds(58062, 38, 23, 23, rs);
        Bank.setBounds(58064, 252, 15, 24, rs);
        Bank.setBounds(18929, 72, 308, 25, rs);
        Bank.setBounds(18930, 72, 308, 26, rs);
        Bank.setBounds(18933, 172, 308, 27, rs);
        Bank.setBounds(18934, 172, 308, 28, rs);
        Bank.setBounds(18937, 388, 294, 29, rs);
        Bank.setBounds(18938, 388, 294, 30, rs);
        Bank.setBounds(58014, 351, 294, 33, rs);
        Bank.setBounds(18941, 24, 293, 34, rs);
        Bank.setBounds(18942, 172, 293, 35, rs);
        Bank.setBounds(18943, 47, 311, 36, rs);
        Bank.setBounds(18944, 97, 311, 37, rs);
        Bank.setBounds(18945, 147, 311, 38, rs);
        Bank.setBounds(18946, 197, 311, 39, rs);
        Bank.setBounds(18947, 28, 47, 40, rs);
        Bank.setBounds(58999, 223, 295, 41, rs);
        this.editBank(tda);
    }
}

