/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Sprite;
import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;

public class LootViewer
extends RSInterface {
    private static final int ID = 44942;
    private static final int BUTTONS = 45010;
    private static final int TABLE_ONE = 45140;
    private static final int TABLE_TWO = 45180;
    private static final boolean PRINT_IDS = false;

    public void load(TextDrawingArea[] tda) {
        RSInterface inter = LootViewer.addInterface(44942);
        int childInterfaceId = 44943;
        LootViewer.addSprite(childInterfaceId++, 0, "Interfaces/Generic/IMAGE");
        LootViewer.addText(childInterfaceId++, "Loot Table", tda, 2, 16748608, true, true);
        int childIndex = 0;
        int children = childInterfaceId - 44943;
        children += 2;
        ++children;
        LootViewer.setChildren(children += 2, inter);
        this.getButtons(tda, 45010);
        this.getTable(tda, 45140, "Common - Uncommon");
        this.getTable(tda, 45180, "Rare");
        childInterfaceId = 44943;
        int x = 0;
        int y = 4;
        inter.child(childIndex++, childInterfaceId++, 16 + x, 20 + y);
        inter.child(childIndex++, childInterfaceId++, 264 + x, 30 + y);
        inter.child(childIndex++, 47902, 473 + x, 27 + y);
        inter.child(childIndex++, 47903, 473 + x, 27 + y);
        inter.child(childIndex++, 45010, 22 + x, 54 + y);
        inter.child(childIndex++, 45140, 214 + x, 56 + y);
        inter.child(childIndex++, 45180, 214 + x, 188 + y);
    }

    public int getTable(TextDrawingArea[] tda, int id, String header) {
        boolean bottom = !header.equals("Rare");
        RSInterface inter = LootViewer.addInterface(id++);
        LootViewer.setChildren(bottom ? 4 : 3, inter);
        int childIndex = 0;
        inter.child(childIndex++, id, 141, 2);
        LootViewer.addText(id++, header, tda, 2, Integer.MAX_VALUE, true, true);
        inter.child(childIndex++, id, 0, 18);
        if (bottom) {
            inter.child(childIndex++, id, 0, 130);
        }
        LootViewer.addSprite(id++, new Sprite("border"));
        inter.child(childIndex++, id, 0, 20);
        int scrollInterface = id;
        RSInterface scrollable = LootViewer.addInterface(id++);
        LootViewer.setChildren(1, scrollable);
        scrollable.width = 265;
        scrollable.height = 110;
        scrollable.scrollMax = scrollable.height + 1;
        scrollable.child(0, id, 4, 4);
        LootViewer.addItemContainerAutoScrollable(id++, 5, 36, 22, 4, true, scrollInterface, new String[0]);
        return id;
    }

    public int getButtons(TextDrawingArea[] tda, int id) {
        int parent = id;
        RSInterface inter = LootViewer.addInterface(id++);
        inter.height = 263;
        inter.width = 176;
        inter.scrollMax = inter.height + 215;
        LootViewer.setChildren(Button.values().length * 3, inter);
        int childIndex = 0;
        for (int index = 0; index < Button.values().length; ++index) {
            Button button = Button.values()[index];
            int x = 0;
            int y = index * 28;
            inter.child(childIndex++, id, x, y);
            LootViewer.addConfigButton(id, parent, 1, 0, "Interfaces/Generic/BUTTON", 176, 28, button.name, index, 4, 1354);
            RSInterface.interfaceCache[id].ignoreConfigClicking = true;
            inter.child(childIndex++, ++id, x + 80, y + 5);
            LootViewer.addText(id++, button.name, tda, 2, 16748608, true, true);
            inter.child(childIndex++, id, x + 140, y + 5);
            LootViewer.addItemView(id++, button.itemId + 1, false, true);
        }
        return id;
    }

    private static enum Button {
        VOTE_KEY("Vote key", 22093),
        PORAZDIRS_KEY("Wilderness Key", 4185),
        CHEST_KEY("Chest Key", 432),
        CORRUPTED_SLAYER_CHEST("Corrupted Chest", 3460),
        MYSTERY_BOX("Mystery Box", 6199),
        SUPER_MYSTERY_BOX("Super M. Box", 6828),
        ULTRA_MYSTERY_BOX("Ultra M. Box", 13346),
        PVP_MYSTERY_BOX("PVP M. Box", 10560),
        RARES_MYSTERY_BOX("Rares M. Box", 10561),
        Godwars_MYSTERY_BOX("Godwars M. Box", 10563),
        SLAYER_MYSTERY_CHEST("Master M. Chest", 8167),
        BRIMSTONE_KEY("Brimstone Key", 23083),
        XERIC_CHESTS("Xeric Chest", 3464),
        TOB_CHEST("Theatre of Blood", 8151),
        PVM_CASKET("PvM Casket", 405),
        LARRANS_CHEST("Larran's Chest", 23490),
        HUNNLEFS_KEY("Hunnlef's Chest", 23776);

        private final String name;
        private final int itemId;

        private Button(String name, int itemId) {
            this.name = name;
            this.itemId = itemId;
        }
    }
}

