/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Sprite;
import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.impl.Interfaces;
import java.awt.Point;
import java.text.NumberFormat;

public class Nightmare
extends RSInterface {
    public static final Nightmare instance = new Nightmare();
    private static final String SPRITE_FOLDER = "/Interfaces/nightmare/";
    private static final Sprite NIGHTMARE_HEALTH_BACKGROUND = new Sprite("/Interfaces/nightmare/0");
    private static final Sprite TOTEM_CHARGE_BACKGROUND = new Sprite("/Interfaces/nightmare/1");
    private static final int HEALTH_REMAINING_COLOUR = 51200;
    private static final int HEALTH_BACKGROUND_COLOUR = 0xC80000;
    private static final int SHIELD_REMAINING_COLOUR = 53416;
    private static final int SHIELD_BACKGROUND_COLOUR = 8224;
    private static final int TOTEM_CHARGE_COLOUR = 14406400;
    private static final int TOTEM_FULLY_CHARGED_COLOUR = 10592397;
    public static final int NIGHTMARE_HEALTH_INTERFACE_ID = 47302;
    public static final int TOTEM_CHARGE_INTERFACE_ID = 47352;
    private static final Point NIGHTMARE_HEALTH_SIZE = new Point(190, 17);
    private static final Point TOTEM_HEALTH_SIZE = new Point(61, 9);
    private int healthFillBackgroundId;
    private int healthFillId;
    private int nightmareHealthTextId;
    private int[] shieldProgressBarIds = new int[4];
    private int[][] totemHealth = new int[][]{{500, 1000}, {100, 1000}, {0, 1000}, {900, 1000}};
    private int nightmareHealth = 2000;
    private int nightmareMaxHealth = 2000;
    private boolean nightmareOnHealth = false;

    private Nightmare() {
    }

    public void load(TextDrawingArea[] tda) {
        this.nightmareHealth(tda);
        this.totemCharge(tda);
    }

    private void nightmareHealth(TextDrawingArea[] tda) {
        int id = 47302;
        int child = 0;
        RSInterface inter = Nightmare.addInterface(id++);
        inter.totalChildren(4);
        int x = 162;
        int y = 28;
        Nightmare.addSprite(id, NIGHTMARE_HEALTH_BACKGROUND);
        inter.child(child++, id++, x, y);
        this.healthFillBackgroundId = id;
        inter.child(child++, id++, x + 4, y + 19);
        this.healthFillId = id;
        inter.child(child++, id++, x + 4, y + 19);
        this.nightmareHealthTextId = id;
        inter.child(child++, id++, x + 98, y + 22);
        this.buildNightmareHealthInter();
    }

    private void buildNightmareHealthInter() {
        double percentage = (double)this.nightmareHealth / (double)this.nightmareMaxHealth;
        Nightmare.addProgressBarReal(this.healthFillBackgroundId, Nightmare.NIGHTMARE_HEALTH_SIZE.x, Nightmare.NIGHTMARE_HEALTH_SIZE.y, !this.nightmareOnHealth ? 8224 : 0xC80000);
        Nightmare.addProgressBarReal(this.healthFillId, (int)((double)Nightmare.NIGHTMARE_HEALTH_SIZE.x * percentage), Nightmare.NIGHTMARE_HEALTH_SIZE.y, !this.nightmareOnHealth ? 53416 : 51200);
        NumberFormat myFormat = NumberFormat.getInstance();
        myFormat.setGroupingUsed(true);
        Nightmare.addText(this.nightmareHealthTextId, myFormat.format(this.nightmareHealth) + " / " + myFormat.format(this.nightmareMaxHealth), Interfaces.defaultTextDrawingAreas, 0, -1, true);
    }

    private void totemCharge(TextDrawingArea[] tda) {
        int id = 47352;
        int child = 0;
        RSInterface inter = Nightmare.addInterface(id++);
        inter.totalChildren(5);
        int x = 8;
        int y = 28;
        Nightmare.addSprite(id, TOTEM_CHARGE_BACKGROUND);
        inter.child(child++, id++, x, y);
        for (int index = 0; index < this.shieldProgressBarIds.length; ++index) {
            this.shieldProgressBarIds[index] = id;
            inter.child(child++, id++, x + 5 + index % 2 * 66, y + 18 + index / 2 * 30);
        }
        this.buildTotemChargeInter();
    }

    private void buildTotemChargeInter() {
        for (int index = 0; index < this.shieldProgressBarIds.length; ++index) {
            double percentage = (double)this.totemHealth[index][0] / (double)this.totemHealth[index][1];
            Nightmare.addProgressBarReal(this.shieldProgressBarIds[index], (int)((double)Nightmare.TOTEM_HEALTH_SIZE.x * (1.0 - percentage)), Nightmare.TOTEM_HEALTH_SIZE.y, this.totemHealth[index][0] == 0 ? 10592397 : 14406400);
        }
    }

    public boolean drawNightmareInterfaces(int interfaceId) {
        if (interfaceId == 47302) {
            int x = 0;
            int y = 0;
            if (Client.instance.isResized()) {
                x = Client.canvasWidth / 2 - 261;
            }
            Client.instance.drawInterface(0, x, RSInterface.get(47302), y);
            if (this.nightmareOnHealth) {
                x = 0;
                y = 0;
                Client.instance.drawInterface(0, x, RSInterface.get(47352), y);
            }
            return true;
        }
        return false;
    }

    public void handleConfig(int configId, int configValue) {
        switch (configId) {
            case 1361: {
                this.nightmareHealth = configValue;
                break;
            }
            case 1362: {
                this.nightmareMaxHealth = configValue;
                break;
            }
            case 1360: {
                this.nightmareOnHealth = configValue == 1;
                this.buildNightmareHealthInter();
                break;
            }
            case 1368: {
                for (int index = 0; index < this.totemHealth.length; ++index) {
                    this.totemHealth[index][1] = configValue;
                }
                break;
            }
            case 1363: {
                this.totemHealth[0][0] = configValue;
                break;
            }
            case 1364: {
                this.totemHealth[1][0] = configValue;
                break;
            }
            case 1365: {
                this.totemHealth[2][0] = configValue;
                break;
            }
            case 1366: {
                this.totemHealth[3][0] = configValue;
                this.buildTotemChargeInter();
            }
        }
    }
}

