/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Rasterizer3D;
import com.client.Sprite;
import com.client.features.settings.Preferences;
import com.client.graphics.interfaces.RSInterface;

public class Slider {
    private int position = 86;
    private double value;
    private int x;
    private int y;
    private final double minValue;
    private final double maxValue;
    private final double length;
    private final Sprite[] images = new Sprite[2];
    public static final int ZOOM = 1;
    public static final int BRIGHTNESS = 2;
    public static final int MUSIC = 3;
    public static final int SOUND = 4;
    public static final int AREA_SOUND = 5;

    public Slider(Sprite icon, Sprite background2, double minimumValue, double maximumValue) {
        this.images[0] = icon;
        this.images[1] = background2;
        this.minValue = this.value = minimumValue;
        this.maxValue = maximumValue;
        this.length = this.images[1].myWidth;
    }

    public void draw(int x, int y, int alpha) {
        this.x = x;
        this.y = y;
        this.images[1].drawSprite(x, y);
        this.images[0].drawAdvancedSprite(x + this.position - (int)((double)this.position / this.length * (double)this.images[0].myWidth), y - this.images[0].myHeight / 2 + this.images[1].myHeight / 2, alpha);
    }

    public void handleClick(int mouseX, int mouseY, int offsetX, int offsetY, int contentType) {
        int mX = Client.instance.getMouseX();
        int mY = Client.instance.getMouseY();
        if (mX - offsetX >= this.x && (double)(mX - offsetX) <= (double)this.x + this.length && mY - offsetY >= this.y + this.images[1].myHeight / 2 - this.images[0].myHeight / 2 && mY - offsetY <= this.y + this.images[1].myHeight / 2 + this.images[0].myHeight / 2) {
            this.position = mouseX - this.x - offsetX;
            if ((double)this.position >= this.length) {
                this.position = (int)this.length;
            }
            if (this.position <= 0) {
                this.position = 0;
            }
            this.value = this.minValue + (double)(mouseX - this.x - offsetX) / this.length * (this.maxValue - this.minValue);
            if (this.value < this.minValue) {
                this.value = this.minValue;
            }
            if (this.value > this.maxValue) {
                this.value = this.maxValue;
            }
            int xxx = 525;
            this.handleContent(contentType);
        }
    }

    public void handleClickSlide(int mouseX, int mouseY, int offsetX, int offsetY, int contentType) {
        int mX = Client.instance.getMouseX();
        int mY = Client.instance.getMouseY();
        if (mX - offsetX >= this.x && (double)(mX - offsetX) <= (double)this.x + this.length && mY - offsetY >= this.y + this.images[1].myHeight / 2 - this.images[0].myHeight / 2 && mY - offsetY <= this.y + this.images[1].myHeight / 2 + this.images[0].myHeight / 2) {
            this.position = mouseX - this.x - offsetX;
            if ((double)this.position >= this.length) {
                this.position = (int)this.length;
            }
            if (this.position <= 0) {
                this.position = 0;
            }
            this.value = this.minValue + (double)(mouseX - this.x - offsetX) / this.length * (this.maxValue - this.minValue);
            if (this.value < this.minValue) {
                this.value = this.minValue;
            }
            if (this.value > this.maxValue) {
                this.value = this.maxValue;
            }
        } else {
            return;
        }
        this.handleContent(contentType);
    }

    private void handleContent(int contentType) {
        switch (contentType) {
            case 1: {
                int value1 = (int)(this.minValue + this.maxValue - this.value);
                int zoom_in = !Client.instance.isResized() ? 195 : 240;
                int zoom_out = !Client.instance.isResized() ? 1105 : 1220;
                Client.cameraZoom = value1;
                if (value1 > 1105) break;
                Client.cameraZoom = 1105;
                break;
            }
            case 2: {
                Preferences.getPreferences().brightness = this.minValue + this.maxValue - this.value;
                Rasterizer3D.setBrightness(Preferences.getPreferences().brightness);
                break;
            }
            case 3: {
                Preferences.getPreferences().musicVolume = this.value;
                break;
            }
            case 4: {
                Preferences.getPreferences().soundVolume = this.value;
                break;
            }
            case 5: {
                Preferences.getPreferences().areaSoundVolume = this.value;
            }
        }
    }

    public double getPercentage() {
        return (double)this.position / this.length * 100.0;
    }

    public static void handleSlider(int mX, int mY) {
        try {
            int interfaceId;
            int tabInterfaceId = Client.tabInterfaceIDs[Client.tabID];
            if (tabInterfaceId != -1) {
                if (tabInterfaceId == 42500) {
                    tabInterfaceId = RSInterface.interfaceCache[42500].children[9];
                }
                RSInterface widget = RSInterface.interfaceCache[tabInterfaceId];
                if (widget.children == null) {
                    return;
                }
                for (int childId : widget.children) {
                    RSInterface child = RSInterface.interfaceCache[childId];
                    if (child == null || child.slider == null) continue;
                    child.slider.handleClick(mX, mY, 0, 0, child.contentType);
                    child.slider.handleClickSlide(mX, mY, 0, 0, child.contentType);
                }
                Client.tabAreaAltered = true;
            }
            if ((interfaceId = Client.openInterfaceID) != -1) {
                RSInterface widget = RSInterface.interfaceCache[interfaceId];
                for (int childId : widget.children) {
                    RSInterface child = RSInterface.interfaceCache[childId];
                    if (child == null || child.slider == null) continue;
                    child.slider.handleClick(mX, mY, 4, 4, child.contentType);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(double value) {
        if (value < this.minValue) {
            value = this.minValue;
        } else if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.value = value;
        double shift = 1.0 - (value - this.minValue) / (this.maxValue - this.minValue);
        this.position = (int)(this.length * shift);
    }
}

