/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Sprite;
import com.client.definitions.ItemDefinition;
import com.client.graphics.interfaces.RSInterface;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class SpawnContainer
extends RSInterface {
    private static final SpawnContainer INSTANCE = new SpawnContainer();
    public static final int INTERFACE_ID = 43214;
    private static final Sprite BG = new Sprite("spawner/bg");
    private int containerInterfaceId;
    private int containerWidth = 132;
    private int containerHeight = 23;
    private int containerCount = this.containerWidth * this.containerHeight;

    public static SpawnContainer get() {
        return INSTANCE;
    }

    private SpawnContainer() {
    }

    public void load() {
        int interfaceId = 43214;
        int childId = 0;
        RSInterface inter = SpawnContainer.addInterface(interfaceId++);
        inter.totalChildren(5);
        SpawnContainer.addSprite(interfaceId, BG);
        inter.child(childId++, interfaceId++, 12, 18);
        SpawnContainer.addInputField(interfaceId, 50, 15108608, "Search", 132, 23, false, true);
        SpawnContainer.get((int)interfaceId).inputFieldSendPacket = false;
        inter.child(childId++, interfaceId++, 17, 24);
        RSInterface scrollable = SpawnContainer.addInterface(interfaceId++);
        scrollable.scrollMax = 6000;
        scrollable.width = 470;
        scrollable.height = 260;
        scrollable.invAutoScrollHeightOffset = 0;
        scrollable.totalChildren(1);
        this.containerInterfaceId = interfaceId;
        SpawnContainer.addItemContainerAutoScrollable(interfaceId, 14, 400, 1, 0, true, scrollable.id, "Spawn", "Spawn 5,000", "Spawn X");
        SpawnContainer.get((int)this.containerInterfaceId).hideInvStackSizes = true;
        scrollable.child(0, interfaceId++, 4, 4);
        inter.child(childId++, scrollable.id, 20, 58);
        inter.child(childId++, 37302, 484, 28);
        inter.child(childId++, 37303, 484, 28);
        this.update("");
    }

    public void update(String message) {
        int index;
        RSInterface container = SpawnContainer.get(this.containerInterfaceId);
        ArrayList<Integer> matches = Lists.newArrayList();
        try {
            for (int i = 0; i < ItemDefinition.totalItems; ++i) {
                ItemDefinition def = ItemDefinition.lookup(i);
                if (def == null || def.name == null || def.name.length() <= 0 || def.name.contains("Dwarf remains") || message.length() != 0 && !def.name.toLowerCase().contains(message)) continue;
                matches.add(i + 1);
                if (matches.size() < this.containerCount - 1) {
                    continue;
                }
                break;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        for (index = 0; index < matches.size(); ++index) {
            container.inventoryItemId[index] = (Integer)matches.get(index);
            container.inventoryAmounts[index] = 1;
        }
        for (index = container.inventoryItemId.length - 1; index >= matches.size(); --index) {
            container.inventoryItemId[index] = 0;
            container.inventoryAmounts[index] = 0;
        }
    }
}

