/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Sprite;
import com.client.graphics.interfaces.RSInterface;

public class StarterInterface
extends RSInterface {
    private static final StarterInterface INSTANCE = new StarterInterface();
    private static final int INTERFACE_ID = 24303;
    private Sprite bg = new Sprite("starter_interface/BACKGROUND");
    private Sprite line = new Sprite("starter_interface/LINE");
    private Sprite thumb = new Sprite("starter_interface/THUMB");
    private Sprite button = new Sprite("starter_interface/button");
    private Sprite buttonSelected = new Sprite("starter_interface/button_selected");
    private Sprite mode1 = new Sprite("player/player");
    private Sprite mode2 = new Sprite("player/modicons 24");
    private Sprite mode3 = new Sprite("player/modicons 12");
    private Sprite mode4 = new Sprite("player/modicons 13");
    private Sprite mode5 = new Sprite("player/modicons 9");
    private Sprite mode6 = new Sprite("player/modicons 30");
    private Sprite mode7 = new Sprite("player/modicons 25");
    private static final String MODE_HEADER_COLOUR = "<col=-1>";
    private static final String MODE_DESC_COLOUR = " <col=16750899>";
    private String[] GAME_MODES = new String[]{"Standard mode\\nThe standard Valoria experience.\\n50x combat experience rate.", "Rogue mode\\nStandard mode with a 5x experience rate.\\nReceives 10% drop rate boost.", "Ironman mode\\nAn Iron Man cannot trade, stake, receive PK loot, \\nor scavenge dropped items.\\nShares the standard experience rate.", "Hardcore ironman\\nIn addition to the standard Iron Man rules, Hardcore\\nhas 1 life. A dangerous death will result in being\\ndowngraded to a standard Iron Man.", "Ultimate ironman\\nIn addition to the standard Iron Man rules, an\\nUltimate Iron Man cannot use banks.", "Rogue hardcore ironman\\nA hardcore variant of the standard ironman mode\\nwith a 5x experience rate and 10% drop rate boost.\\nConverts to Rogue ironman on death.", "Group ironman\\nYou'll be taken to a closed area where you can\\nSelect a group to play with in Ironman mode.\\nYou'll be able to trade and share resources."};

    public static StarterInterface get() {
        return INSTANCE;
    }

    private StarterInterface() {
    }

    public void load() {
        int interfaceId = 24303;
        int childId = 0;
        RSInterface inter = StarterInterface.addInterface(interfaceId++);
        inter.totalChildren(7);
        StarterInterface.addSprite(interfaceId, this.bg);
        inter.child(childId++, interfaceId++, 20, 29);
        StarterInterface.addText(interfaceId, 2, 0xFF9933, true, "Game mode selection");
        inter.child(childId++, interfaceId++, 256, 39);
        int buttonX = 194;
        int buttonY = 283;
        StarterInterface.addClickableText(interfaceId, "Confirm selection", "Choose", RSInterface.defaultTextDrawingAreas, 1, 16750623, false, false, 60, 21);
        inter.child(childId++, interfaceId++, buttonX, buttonY);
        StarterInterface.addSprite(interfaceId, this.thumb);
        inter.child(childId++, interfaceId++, buttonX - 22, buttonY - 4 + 1);
        inter.child(childId++, interfaceId, 49, 92);
        interfaceId = this.loadContainer(interfaceId);
        StarterInterface.addText(interfaceId, 0, 0xFFFFFF, true, "Selecting a game mode is final and cannot be reverted or changed afterwards.");
        inter.child(childId++, interfaceId++, 256, 71);
        StarterInterface.addChar(interfaceId);
        inter.child(childId++, interfaceId++, 370, 190);
    }

    private int loadContainer(int interfaceId) {
        RSInterface inter = StarterInterface.addInterface(interfaceId++);
        inter.width = 297;
        inter.height = 183;
        inter.scrollMax = inter.height + 1 + (this.GAME_MODES.length > 4 ? (this.GAME_MODES.length - 4) * 57 + 45 : 0);
        inter.totalChildren(this.GAME_MODES.length * 3 + 7);
        int childId = 0;
        for (int index = 0; index < this.GAME_MODES.length; ++index) {
            int y = index * 57;
            StarterInterface.addConfigButton(interfaceId, this.button, this.buttonSelected, "Select mode", index, 1372, 4);
            StarterInterface.get((int)interfaceId).ignoreConfigClicking = true;
            inter.child(childId++, interfaceId++, 12, y + 12 + 10 + 11);
            StarterInterface.addSprite(interfaceId, this.line);
            inter.child(childId++, interfaceId++, 0, y + 46 + 10);
            StarterInterface.addText(interfaceId, 0, 0xFF9933, false, this.format(this.GAME_MODES[index]));
            inter.child(childId++, interfaceId++, 36, y + 4 + 5);
        }
        StarterInterface.addSprite(interfaceId, this.mode1);
        inter.child(childId++, interfaceId++, 14, 11);
        StarterInterface.addSprite(interfaceId, this.mode2);
        inter.child(childId++, interfaceId++, 13, 68);
        StarterInterface.addSprite(interfaceId, this.mode3);
        inter.child(childId++, interfaceId++, 13, 125);
        StarterInterface.addSprite(interfaceId, this.mode4);
        inter.child(childId++, interfaceId++, 13, 182);
        StarterInterface.addSprite(interfaceId, this.mode5);
        inter.child(childId++, interfaceId++, 13, 239);
        StarterInterface.addSprite(interfaceId, this.mode6);
        inter.child(childId++, interfaceId++, 13, 296);
        StarterInterface.addSprite(interfaceId, this.mode7);
        inter.child(childId++, interfaceId++, 13, 353);
        return interfaceId;
    }

    private String format(String gameModeString) {
        String[] split = gameModeString.split("\\n");
        StringBuilder formattedString = new StringBuilder();
        for (int index = 0; index < split.length; ++index) {
            if (index == 0) {
                formattedString.append(MODE_HEADER_COLOUR).append(split[0]).append("\\n");
                continue;
            }
            formattedString.append(MODE_DESC_COLOUR).append(split[index]).append("\\n");
        }
        return formattedString.toString();
    }
}

