/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.textures;

import com.client.Buffer1;
import com.client.Deque;
import com.client.FileArchive;
import com.client.graphics.textures.Texture;
import com.client.graphics.textures.TextureLoader;
import net.runelite.rs.api.RSTexture;
import net.runelite.rs.api.RSTextureProvider;

public class TextureProvider
implements RSTextureProvider,
TextureLoader {
    private final Texture[] textures;
    private Deque deque = new Deque();
    private int capacity;
    private int remaining;
    private double brightness;
    private int textureSize;
    private final FileArchive archive;

    public TextureProvider(FileArchive textureArchive, FileArchive configArchive, int capacity, int textureSize) {
        this.archive = textureArchive;
        this.remaining = this.capacity = capacity;
        this.textureSize = textureSize;
        Buffer1 stream = new Buffer1(configArchive.readFile("textures.dat"));
        int textureCount = stream.readUShort();
        this.textures = new Texture[textureCount + 1];
        for (int var9 = 0; var9 < textureCount; ++var9) {
            Texture text;
            this.textures[text.id] = text = new Texture(stream);
        }
        this.setMaxSize(128);
        this.setSize(128);
    }

    @Override
    public double getBrightness() {
        return this.brightness;
    }

    @Override
    public void setBrightness(double brightness) {
        this.brightness = brightness;
        this.clear();
    }

    public void setTextureSize(int textureSize) {
        this.textureSize = textureSize;
        this.clear();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.capacity = maxSize;
    }

    @Override
    public void setSize(int size) {
        this.remaining = size;
    }

    @Override
    public RSTexture[] getTextures() {
        return this.textures;
    }

    @Override
    public int[] load(int textureId) {
        return this.getTexturePixels(textureId);
    }

    @Override
    public int[] getTexturePixels(int textureID) {
        Texture texture = this.textures[textureID];
        if (texture != null) {
            if (texture.pixels != null) {
                this.deque.insertTail(texture);
                texture.isLoaded = true;
                return texture.pixels;
            }
            boolean hasLoaded = texture.load(this.brightness, this.textureSize, this.archive);
            if (hasLoaded) {
                if (this.remaining == 0) {
                    Texture currentTexture = (Texture)this.deque.popHead();
                    currentTexture.reset();
                } else {
                    --this.remaining;
                }
                this.deque.insertTail(texture);
                texture.isLoaded = true;
                return texture.pixels;
            }
        }
        return null;
    }

    @Override
    public int getAverageTextureRGB(int textureID) {
        return this.textures[textureID] != null ? this.textures[textureID].averageRGB : 0;
    }

    @Override
    public boolean isTransparent(int textureID) {
        return this.textures[textureID].isTransparent;
    }

    @Override
    public boolean isLowDetail(int textureID) {
        return this.textureSize == 64;
    }

    public void clear() {
        for (Texture texture : this.textures) {
            if (texture == null) continue;
            texture.reset();
        }
        this.deque = new Deque();
        this.remaining = this.capacity;
    }

    public void animate(int textureID) {
        for (Texture texture : this.textures) {
            if (texture == null || texture.animationDirection == 0 || !texture.isLoaded) continue;
            texture.animate(textureID);
            texture.isLoaded = false;
        }
    }
}

