/*
 * Decompiled with CFR 0.152.
 */
package com.client.itembonus;

import com.client.itembonus.ItemBonusDefinition;
import com.client.sign.Signlink;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemBonusDefinitionLoader {
    private static final Map<Integer, ItemBonusDefinition> itemBonusDefinitions = new HashMap<Integer, ItemBonusDefinition>();
    private static final XStream xStream = new XStream(new Sun14ReflectionProvider());

    public static ItemBonusDefinition getItemBonusDefinition(int i) {
        return itemBonusDefinitions.get(i);
    }

    public static short[] getItemBonuses(int id) {
        ItemBonusDefinition def = ItemBonusDefinitionLoader.getItemBonusDefinition(id);
        if (def != null) {
            return def.getBonuses();
        }
        return null;
    }

    public static void loadItemBonusDefinitions() throws IOException {
        xStream.alias("ItemBonusDefinition", ItemBonusDefinition.class);
        List list = (List)xStream.fromXML(new FileInputStream(Signlink.getCacheDirectory() + "ItemBonusDefinitions.xml"));
        for (ItemBonusDefinition definition : list) {
            itemBonusDefinitions.put(definition.getId(), definition);
        }
        System.out.println("Loaded " + list.size() + " item bonus definitions.");
    }
}

