/*
 * Decompiled with CFR 0.152.
 */
package com.client.sound;

import com.client.sign.Signlink;
import com.client.sound.SoundType;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class Sound {
    private static final Sound SINGLETON = new Sound();
    private static final ExecutorService executor = Executors.newFixedThreadPool(14);

    public static Sound getSound() {
        return SINGLETON;
    }

    private static File getSound(int id) {
        return new File(Signlink.getCacheDirectory() + "sounds/" + id + ".wav");
    }

    public void playSound(int id, SoundType soundType, double distanceFromOrigin) {
    }

    public float calculateVolume(SoundType soundType, double distanceFromOrigin) {
        double distanceVolume = (12.0 - distanceFromOrigin) / 12.0;
        double soundVolume = soundType.getVolume() / 10.0;
        return (float)(soundVolume * distanceVolume);
    }

    private void sound(File soundFile, SoundType soundType, double distanceFromOrigin) throws Exception {
        AudioInputStream in = AudioSystem.getAudioInputStream(soundFile);
        AudioFormat outFormat = Sound.getOutFormat(in.getFormat());
        DataLine.Info info2 = new DataLine.Info(SourceDataLine.class, outFormat);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info2);
        if (line != null) {
            line.open(outFormat, 2200);
            if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                int volume = (int)(30.0 * (double)this.calculateVolume(soundType, distanceFromOrigin));
                FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                BooleanControl muteControl = (BooleanControl)line.getControl(BooleanControl.Type.MUTE);
                System.out.println("Volume at playtime: " + volume + ", factor: " + this.calculateVolume(soundType, distanceFromOrigin));
                if (volume < 5) {
                    muteControl.setValue(true);
                } else {
                    muteControl.setValue(false);
                    gainControl.setValue((float)(Math.log((double)volume / 100.0) / Math.log(10.0) * 20.0));
                }
            }
            line.start();
            this.stream(AudioSystem.getAudioInputStream(outFormat, in), line);
            line.drain();
            line.stop();
        }
    }

    private static AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, rate, 8, ch, ch, rate, false);
    }

    private void stream(AudioInputStream in, SourceDataLine line) throws IOException {
        byte[] buffer = new byte[2200];
        int n = 0;
        while (n != -1) {
            line.write(buffer, 0, n);
            n = in.read(buffer, 0, buffer.length);
        }
    }
}

