/*
 * Decompiled with CFR 0.152.
 */
package com.client.ui;

import com.client.Client;
import com.client.RSFont;
import com.client.Rasterizer2D;
import java.text.DateFormat;
import java.util.Date;

public class DevConsole {
    public int message_id = 1;
    public String console_input = "";
    public final String[] console_print = new String[500];
    public boolean console_open = false;
    public final String default_message;
    public boolean scroller = false;
    public int scroller_index;
    public int scroller_pos;
    public int scroller_offset;

    public static String currentTime() {
        DateFormat date = DateFormat.getTimeInstance();
        return date.format(new Date());
    }

    public String time_stamp() {
        return DevConsole.currentTime().replaceAll("AM", "").replaceAll("PM", "");
    }

    public void open_console(int key) {
        if (key == 96) {
            this.console_open = !this.console_open;
        }
    }

    public void print_message(String message, int id) {
        DevConsole.client();
        if (Client.backDialogID == -1) {
            DevConsole.client();
            Client.inputTaken = true;
        }
        for (int line = 499; line > 0; --line) {
            this.console_print[line] = this.console_print[line - 1];
        }
        ++this.message_id;
        this.console_print[0] = this.time_stamp() + ": " + (id == 0 ? "--> " : "") + message;
    }

    public void command_input(int j) {
        if (j == 8 && this.console_input.length() > 0 && this.console_input.length() <= 40) {
            this.console_input = this.console_input.substring(0, this.console_input.length() - 1);
        }
        if (j >= 32 && j <= 122 && this.console_input.length() < 40) {
            this.console_input = this.console_input + (char)j;
        }
        if ((j == 13 || j == 10) && this.console_input.length() > 0 && this.console_input.length() <= 40) {
            this.print_message(this.console_input, 0);
            this.send_command_packet(this.console_input);
            this.console_input = "";
            DevConsole.client();
            Client.inputTaken = true;
        }
    }

    public void send_command_packet(String command) {
        if (command.equalsIgnoreCase("cls")) {
            for (int line = 0; line < 500; ++line) {
                this.console_print[line] = null;
            }
        }
        this.handleCommands();
    }

    public void draw_console() {
        if (this.console_open) {
            Rasterizer2D.drawPixelsWithOpacity2(4, 4, 512, 334, 5320850, 80);
            Rasterizer2D.drawPixels(1, 315, 4, 0xFFFFFF, 512);
            RSFont rSFont = DevConsole.client().newBoldFont;
            DevConsole.client();
            rSFont.drawBasicString("--> " + this.console_input + (Client.loopCycle % 20 < 10 ? "|" : ""), 11, 330, 0xFFFFFF, 0);
            DevConsole.client().newSmallFont.drawString("Valoria", 4, 12, 0xFFFFFF, 0, 256);
        }
        this.draw_console_messages();
    }

    public void draw_console_messages() {
        if (this.console_open) {
            if (this.message_id == 1) {
                this.print_message(this.default_message, 1);
                return;
            }
            int output_y = -3;
            int y_pos = 0;
            this.scroller_offset = 0;
            this.scroller_pos = DevConsole.client().scrollbar_position;
            Rasterizer2D.setDrawingArea(315, 0, 510, 21);
            for (int line = 0; line < 500; ++line) {
                y_pos = 257 - output_y * 16 + this.scroller_pos;
                if (this.console_print[line] == null) continue;
                this.scroller_index = line - 1;
                this.scroller = this.scroller_index - 1 > 14;
                DevConsole.client().newRegularFont.drawBasicString(this.console_print[line], 9, y_pos, 0xFFFFFF, 0);
                ++this.scroller_offset;
                ++output_y;
            }
            if (this.scroller) {
                DevConsole.client().draw_scrollbar(494, 22, 0, 270, this.scroller_offset, 18, 17, 0);
            }
            Client.rasterProvider.setRaster();
        }
    }

    public static Client client() {
        return Client.instance;
    }

    public DevConsole() {
        this.default_message = "This is the developer console. To close, press the ` key on your keyboard.";
    }

    public void handleCommands() {
    }
}

