/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;

public final class FovHVHalves {
    public final float left;
    public final float right;
    public final float top;
    public final float bottom;
    public final boolean inTangents;

    public FovHVHalves(float f, float f2, float f3, float f4, boolean bl) {
        this.left = f;
        this.right = f2;
        this.top = f3;
        this.bottom = f4;
        this.inTangents = bl;
    }

    public static FovHVHalves byRadians(float f, float f2) {
        float f3 = FloatUtil.tan(f / 2.0f);
        float f4 = FloatUtil.tan(f2 / 2.0f);
        return new FovHVHalves(f3, f3, f4, f4, true);
    }

    public static FovHVHalves byFovyRadianAndAspect(float f, float f2) {
        float f3 = FloatUtil.tan(f / 2.0f);
        float f4 = f2 * f3;
        return new FovHVHalves(f4, f4, f3, f3, true);
    }

    public static FovHVHalves byRadians(float f, float f2, float f3, float f4) {
        return new FovHVHalves(FloatUtil.tan(f * f2), FloatUtil.tan(f * (1.0f - f2)), FloatUtil.tan(f3 * f4), FloatUtil.tan(f3 * (1.0f - f4)), true);
    }

    public static FovHVHalves byFovyRadianAndAspect(float f, float f2, float f3, float f4) {
        float f5 = FloatUtil.tan(f / 2.0f);
        float f6 = f3 * f5;
        float f7 = FloatUtil.atan(f6) * 2.0f;
        return FovHVHalves.byRadians(f7, f4, f, f2);
    }

    public final FovHVHalves toTangents() {
        if (this.inTangents) {
            return this;
        }
        return new FovHVHalves(FloatUtil.tan(this.left), FloatUtil.tan(this.right), FloatUtil.tan(this.top), FloatUtil.tan(this.bottom), true);
    }

    public final float horzFov() {
        return this.left + this.right;
    }

    public final float vertFov() {
        return this.top + this.bottom;
    }

    public final String toString() {
        return "FovHVH[" + (this.inTangents ? "tangents" : "radians") + ": " + this.left + " l, " + this.right + " r, " + this.top + " t, " + this.bottom + " b]";
    }

    public final String toStringInDegrees() {
        String string2;
        String string3 = string2 = this.inTangents ? "tangents" : "radians";
        if (this.inTangents) {
            float f = FloatUtil.atan(this.left);
            float f2 = FloatUtil.atan(this.right);
            float f3 = FloatUtil.atan(this.top);
            float f4 = FloatUtil.atan(this.bottom);
            return "FovHVH[degrees: " + f * 57.295776f + " l, " + f2 * 57.295776f + " r, " + f3 * 57.295776f + " t, " + f4 * 57.295776f + " b, stored-as: " + string2 + "]";
        }
        return "FovHVH[degrees: " + this.left * 57.295776f + " l, " + this.right * 57.295776f + " r, " + this.top * 57.295776f + " t, " + this.bottom * 57.295776f + " b, stored-as: " + string2 + "]";
    }
}

