/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.FloatStack;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.geom.Frustum;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jogamp.common.os.PlatformPropsImpl;

public final class PMVMatrix
implements GLMatrixFunc {
    public static final int MODIFIED_PROJECTION = 1;
    public static final int MODIFIED_MODELVIEW = 2;
    public static final int MODIFIED_TEXTURE = 4;
    public static final int MODIFIED_ALL = 7;
    public static final int DIRTY_INVERSE_MODELVIEW = 1;
    public static final int DIRTY_INVERSE_TRANSPOSED_MODELVIEW = 2;
    public static final int DIRTY_FRUSTUM = 4;
    public static final int DIRTY_ALL = 7;
    private static final String msgCantComputeInverse = "Invalid source Mv matrix, can't compute inverse";
    private final float[] matrixArray = new float[80];
    private final int mP_offset;
    private final int mMv_offset;
    private final int mTex_offset;
    private final FloatBuffer matrixPMvMvit = Buffers.slice2Float(this.matrixArray, 0, 64);
    private final FloatBuffer matrixPMvMvi = Buffers.slice2Float(this.matrixArray, 0, 48);
    private final FloatBuffer matrixPMv = Buffers.slice2Float(this.matrixArray, 0, 32);
    private final FloatBuffer matrixP = Buffers.slice2Float(this.matrixArray, 0, 16);
    private final FloatBuffer matrixTex;
    private final FloatBuffer matrixMv = Buffers.slice2Float(this.matrixArray, 16, 16);
    private final FloatBuffer matrixMvi = Buffers.slice2Float(this.matrixArray, 32, 16);
    private final FloatBuffer matrixMvit = Buffers.slice2Float(this.matrixArray, 48, 16);
    private final float[] matrixTxSx;
    private final float[] mat4Tmp1;
    private final float[] mat4Tmp2;
    private final float[] mat4Tmp3;
    private final FloatStack matrixTStack;
    private final FloatStack matrixPStack;
    private final FloatStack matrixMvStack;
    private int matrixMode = 5888;
    private int modifiedBits = 7;
    private int dirtyBits = 7;
    private int requestMask = 0;
    private Frustum frustum;

    public static final boolean isMatrixModeName(int n) {
        switch (n) {
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixModeName2MatrixGetName(int n) {
        switch (n) {
            case 5888: {
                return 2982;
            }
            case 5889: {
                return 2983;
            }
            case 5890: {
                return 2984;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public static final boolean isMatrixGetName(int n) {
        switch (n) {
            case 2976: 
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixGetName2MatrixModeName(int n) {
        switch (n) {
            case 2982: {
                return 5888;
            }
            case 2983: {
                return 5889;
            }
            case 2984: {
                return 5890;
            }
        }
        throw new GLException("unsupported matrixGetName: " + n);
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string2, FloatBuffer floatBuffer) {
        return FloatUtil.matrixToString(stringBuilder, null, string2, floatBuffer, 0, 4, 4, false);
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        return FloatUtil.matrixToString(stringBuilder, null, string2, floatBuffer, 0, floatBuffer2, 0, 4, 4, false);
    }

    public PMVMatrix() {
        this.mP_offset = 0;
        this.mMv_offset = 16;
        this.mTex_offset = 64;
        this.matrixTex = Buffers.slice2Float(this.matrixArray, 64, 16);
        this.mat4Tmp1 = new float[16];
        this.mat4Tmp2 = new float[16];
        this.mat4Tmp3 = new float[16];
        this.matrixTxSx = new float[16];
        FloatUtil.makeIdentity(this.matrixTxSx);
        this.matrixTStack = new FloatStack(0, 32);
        this.matrixPStack = new FloatStack(0, 32);
        this.matrixMvStack = new FloatStack(0, 256);
        this.reset();
        this.frustum = null;
    }

    public final void reset() {
        FloatUtil.makeIdentity(this.matrixArray, this.mMv_offset);
        FloatUtil.makeIdentity(this.matrixArray, this.mP_offset);
        FloatUtil.makeIdentity(this.matrixArray, this.mTex_offset);
        this.modifiedBits = 7;
        this.dirtyBits = 7;
        this.requestMask = 0;
        this.matrixMode = 5888;
    }

    public final int glGetMatrixMode() {
        return this.matrixMode;
    }

    public final FloatBuffer glGetTMatrixf() {
        return this.matrixTex;
    }

    public final FloatBuffer glGetPMatrixf() {
        return this.matrixP;
    }

    public final FloatBuffer glGetMvMatrixf() {
        return this.matrixMv;
    }

    public final FloatBuffer glGetMviMatrixf() {
        this.requestMask |= 1;
        this.updateImpl(false);
        return this.matrixMvi;
    }

    public final FloatBuffer glGetMvitMatrixf() {
        this.requestMask |= 2;
        this.updateImpl(false);
        return this.matrixMvit;
    }

    public final FloatBuffer glGetPMvMatrixf() {
        return this.matrixPMv;
    }

    public final FloatBuffer glGetPMvMviMatrixf() {
        this.requestMask |= 1;
        this.updateImpl(false);
        return this.matrixPMvMvi;
    }

    public final FloatBuffer glGetPMvMvitMatrixf() {
        this.requestMask |= 3;
        this.updateImpl(false);
        return this.matrixPMvMvit;
    }

    public final Frustum glGetFrustum() {
        this.requestMask |= 4;
        this.updateImpl(false);
        return this.frustum;
    }

    public final FloatBuffer glGetMatrixf() {
        return this.glGetMatrixf(this.matrixMode);
    }

    public final FloatBuffer glGetMatrixf(int n) {
        switch (n) {
            case 2982: 
            case 5888: {
                return this.matrixMv;
            }
            case 2983: 
            case 5889: {
                return this.matrixP;
            }
            case 2984: 
            case 5890: {
                return this.matrixTex;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public final float[] multPMvMatrixf(float[] fArray, int n) {
        FloatUtil.multMatrix(this.matrixArray, this.mP_offset, this.matrixArray, this.mMv_offset, fArray, n);
        return fArray;
    }

    public final float[] multMvPMatrixf(float[] fArray, int n) {
        FloatUtil.multMatrix(this.matrixArray, this.mMv_offset, this.matrixArray, this.mP_offset, fArray, n);
        return fArray;
    }

    @Override
    public final void glMatrixMode(int n) {
        switch (n) {
            case 5888: 
            case 5889: 
            case 5890: {
                break;
            }
            default: {
                throw new GLException("unsupported matrixName: " + n);
            }
        }
        this.matrixMode = n;
    }

    @Override
    public final void glGetFloatv(int n, FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        if (n == 2976) {
            floatBuffer.put(this.matrixMode);
        } else {
            FloatBuffer floatBuffer2 = this.glGetMatrixf(n);
            floatBuffer.put(floatBuffer2);
            floatBuffer2.reset();
        }
        floatBuffer.position(n2);
    }

    @Override
    public final void glGetFloatv(int n, float[] fArray, int n2) {
        if (n == 2976) {
            fArray[n2] = this.matrixMode;
        } else {
            FloatBuffer floatBuffer = this.glGetMatrixf(n);
            floatBuffer.get(fArray, n2, 16);
            floatBuffer.reset();
        }
    }

    @Override
    public final void glGetIntegerv(int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        intBuffer.put(this.matrixMode);
        intBuffer.position(n2);
    }

    @Override
    public final void glGetIntegerv(int n, int[] nArray, int n2) {
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        nArray[n2] = this.matrixMode;
    }

    @Override
    public final void glLoadMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            this.matrixMv.put(fArray, n, 16);
            this.matrixMv.reset();
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(fArray, n, 16);
            this.matrixP.reset();
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(fArray, n, 16);
            this.matrixTex.reset();
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glLoadMatrixf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        if (this.matrixMode == 5888) {
            this.matrixMv.put(floatBuffer);
            this.matrixMv.reset();
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(floatBuffer);
            this.matrixP.reset();
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(floatBuffer);
            this.matrixTex.reset();
            this.modifiedBits |= 4;
        }
        floatBuffer.position(n);
    }

    public final void glLoadMatrix(Quaternion quaternion) {
        if (this.matrixMode == 5888) {
            quaternion.toMatrix(this.matrixArray, this.mMv_offset);
            this.matrixMv.reset();
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            quaternion.toMatrix(this.matrixArray, this.mP_offset);
            this.matrixP.reset();
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            quaternion.toMatrix(this.matrixArray, this.mTex_offset);
            this.matrixTex.reset();
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glPopMatrix() {
        FloatStack floatStack;
        if (this.matrixMode == 5888) {
            floatStack = this.matrixMvStack;
        } else if (this.matrixMode == 5889) {
            floatStack = this.matrixPStack;
        } else if (this.matrixMode == 5890) {
            floatStack = this.matrixTStack;
        } else {
            throw new InternalError("XXX: mode " + this.matrixMode);
        }
        floatStack.position(floatStack.position() - 16);
        this.glLoadMatrixf(floatStack.buffer(), floatStack.position());
    }

    @Override
    public final void glPushMatrix() {
        if (this.matrixMode == 5888) {
            this.matrixMvStack.putOnTop(this.matrixMv, 16);
            this.matrixMv.reset();
        } else if (this.matrixMode == 5889) {
            this.matrixPStack.putOnTop(this.matrixP, 16);
            this.matrixP.reset();
        } else if (this.matrixMode == 5890) {
            this.matrixTStack.putOnTop(this.matrixTex, 16);
            this.matrixTex.reset();
        }
    }

    @Override
    public final void glLoadIdentity() {
        if (this.matrixMode == 5888) {
            FloatUtil.makeIdentity(this.matrixArray, this.mMv_offset);
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            FloatUtil.makeIdentity(this.matrixArray, this.mP_offset);
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            FloatUtil.makeIdentity(this.matrixArray, this.mTex_offset);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glMultMatrixf(FloatBuffer floatBuffer) {
        if (this.matrixMode == 5888) {
            FloatUtil.multMatrix(this.matrixMv, floatBuffer);
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            FloatUtil.multMatrix(this.matrixP, floatBuffer);
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            FloatUtil.multMatrix(this.matrixTex, floatBuffer);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glMultMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            FloatUtil.multMatrix(this.matrixArray, this.mMv_offset, fArray, n);
            this.dirtyBits |= 7;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            FloatUtil.multMatrix(this.matrixArray, this.mP_offset, fArray, n);
            this.dirtyBits |= 4;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            FloatUtil.multMatrix(this.matrixArray, this.mTex_offset, fArray, n);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glTranslatef(float f, float f2, float f3) {
        this.glMultMatrixf(FloatUtil.makeTranslation(this.matrixTxSx, false, f, f2, f3), 0);
    }

    @Override
    public final void glScalef(float f, float f2, float f3) {
        this.glMultMatrixf(FloatUtil.makeScale(this.matrixTxSx, false, f, f2, f3), 0);
    }

    @Override
    public final void glRotatef(float f, float f2, float f3, float f4) {
        this.glMultMatrixf(FloatUtil.makeRotationAxis(this.mat4Tmp1, 0, f * (float)Math.PI / 180.0f, f2, f3, f4, this.mat4Tmp2), 0);
    }

    public final void glRotate(Quaternion quaternion) {
        this.glMultMatrixf(quaternion.toMatrix(this.mat4Tmp1, 0), 0);
    }

    @Override
    public final void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        this.glMultMatrixf(FloatUtil.makeOrtho(this.mat4Tmp1, 0, true, f, f2, f3, f4, f5, f6), 0);
    }

    @Override
    public final void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) throws GLException {
        this.glMultMatrixf(FloatUtil.makeFrustum(this.mat4Tmp1, 0, true, f, f2, f3, f4, f5, f6), 0);
    }

    public final void gluPerspective(float f, float f2, float f3, float f4) throws GLException {
        this.glMultMatrixf(FloatUtil.makePerspective(this.mat4Tmp1, 0, true, f * (float)Math.PI / 180.0f, f2, f3, f4), 0);
    }

    public final void gluLookAt(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.mat4Tmp2[0] = f;
        this.mat4Tmp2[1] = f2;
        this.mat4Tmp2[2] = f3;
        this.mat4Tmp2[4] = f4;
        this.mat4Tmp2[5] = f5;
        this.mat4Tmp2[6] = f6;
        this.mat4Tmp2[8] = f7;
        this.mat4Tmp2[9] = f8;
        this.mat4Tmp2[10] = f9;
        this.glMultMatrixf(FloatUtil.makeLookAt(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4, this.mat4Tmp2, 8, this.mat4Tmp3), 0);
    }

    public final boolean gluProject(float f, float f2, float f3, int[] nArray, int n, float[] fArray, int n2) {
        return FloatUtil.mapObjToWinCoords(f, f2, f3, this.matrixArray, this.mMv_offset, this.matrixArray, this.mP_offset, nArray, n, fArray, n2, this.mat4Tmp1, this.mat4Tmp2);
    }

    public final boolean gluUnProject(float f, float f2, float f3, int[] nArray, int n, float[] fArray, int n2) {
        return FloatUtil.mapWinToObjCoords(f, f2, f3, this.matrixArray, this.mMv_offset, this.matrixArray, this.mP_offset, nArray, n, fArray, n2, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, int[] nArray, int n, float f5, float f6, float[] fArray, int n2) {
        return FloatUtil.mapWinToObjCoords(f, f2, f3, f4, this.matrixArray, this.mMv_offset, this.matrixArray, this.mP_offset, nArray, n, f5, f6, fArray, n2, this.mat4Tmp1, this.mat4Tmp2);
    }

    public final void gluPickMatrix(float f, float f2, float f3, float f4, int[] nArray, int n) {
        if (null != FloatUtil.makePick(this.mat4Tmp1, 0, f, f2, f3, f4, nArray, n, this.mat4Tmp2)) {
            this.glMultMatrixf(this.mat4Tmp1, 0);
        }
    }

    public final boolean gluUnProjectRay(float f, float f2, float f3, float f4, int[] nArray, int n, Ray ray) {
        return FloatUtil.mapWinToRay(f, f2, f3, f4, this.matrixArray, this.mMv_offset, this.matrixArray, this.mP_offset, nArray, n, ray, this.mat4Tmp1, this.mat4Tmp2, this.mat4Tmp3);
    }

    public StringBuilder toString(StringBuilder stringBuilder, String string2) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = 0 != (1 & this.dirtyBits);
        boolean bl2 = 0 != (2 & this.dirtyBits);
        boolean bl3 = 0 != (4 & this.dirtyBits);
        boolean bl4 = 0 != (1 & this.requestMask);
        boolean bl5 = 0 != (2 & this.requestMask);
        boolean bl6 = 0 != (4 & this.requestMask);
        boolean bl7 = 0 != (1 & this.modifiedBits);
        boolean bl8 = 0 != (2 & this.modifiedBits);
        boolean bl9 = 0 != (4 & this.modifiedBits);
        stringBuilder.append("PMVMatrix[modified[P ").append(bl7).append(", Mv ").append(bl8).append(", T ").append(bl9);
        stringBuilder.append("], dirty/req[Mvi ").append(bl).append("/").append(bl4).append(", Mvit ").append(bl2).append("/").append(bl5).append(", Frustum ").append(bl3).append("/").append(bl6).append("]").append(PlatformPropsImpl.NEWLINE);
        stringBuilder.append(", Projection").append(PlatformPropsImpl.NEWLINE);
        PMVMatrix.matrixToString(stringBuilder, string2, this.matrixP);
        stringBuilder.append(", Modelview").append(PlatformPropsImpl.NEWLINE);
        PMVMatrix.matrixToString(stringBuilder, string2, this.matrixMv);
        stringBuilder.append(", Texture").append(PlatformPropsImpl.NEWLINE);
        PMVMatrix.matrixToString(stringBuilder, string2, this.matrixTex);
        if (0 != (this.requestMask & 1)) {
            stringBuilder.append(", Inverse Modelview").append(PlatformPropsImpl.NEWLINE);
            PMVMatrix.matrixToString(stringBuilder, string2, this.matrixMvi);
        }
        if (0 != (this.requestMask & 2)) {
            stringBuilder.append(", Inverse Transposed Modelview").append(PlatformPropsImpl.NEWLINE);
            PMVMatrix.matrixToString(stringBuilder, string2, this.matrixMvit);
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null, "%10.5f").toString();
    }

    public final int getModifiedBits(boolean bl) {
        int n = this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        return n;
    }

    public final int getDirtyBits() {
        return this.dirtyBits;
    }

    public final int getRequestMask() {
        return this.requestMask;
    }

    public final void clearAllUpdateRequests() {
        this.requestMask &= 0xFFFFFFF8;
    }

    public final boolean update() {
        return this.updateImpl(true);
    }

    private final boolean updateImpl(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = 0 != this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        if (0 != (this.dirtyBits & (4 & this.requestMask))) {
            if (null == this.frustum) {
                this.frustum = new Frustum();
            }
            FloatUtil.multMatrix(this.matrixArray, this.mP_offset, this.matrixArray, this.mMv_offset, this.mat4Tmp1, 0);
            this.frustum.updateByPMV(this.mat4Tmp1, 0);
            this.dirtyBits &= 0xFFFFFFFB;
            bl2 = true;
        }
        if (0 == (this.dirtyBits & this.requestMask)) {
            return bl2;
        }
        return this.setMviMvit() || bl2;
    }

    private final boolean setMviMvit() {
        float[] fArray = this.matrixMvi.array();
        int n = this.matrixMvi.position();
        boolean bl = false;
        if (0 != (this.dirtyBits & 1)) {
            if (null == FloatUtil.invertMatrix(this.matrixArray, this.mMv_offset, fArray, n)) {
                throw new GLException(msgCantComputeInverse);
            }
            this.dirtyBits &= 0xFFFFFFFE;
            bl = true;
        }
        if (0 != (this.requestMask & (this.dirtyBits & 2))) {
            FloatUtil.transposeMatrix(fArray, n, this.matrixMvit.array(), this.matrixMvit.position());
            this.dirtyBits &= 0xFFFFFFFD;
            bl = true;
        }
        return bl;
    }
}

