/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.core.util.Fields;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.EnumMap;

public class EnumMapConverter
extends MapConverter {
    public EnumMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type2) {
        return type2 == EnumMap.class && Reflections.typeField != null;
    }

    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class type2 = (Class)Fields.read(Reflections.typeField, source2);
        String attributeName = this.mapper().aliasForSystemAttribute("enum-type");
        if (attributeName != null) {
            writer.addAttribute(attributeName, this.mapper().serializedClass(type2));
        }
        super.marshal(source2, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attributeName = this.mapper().aliasForSystemAttribute("enum-type");
        if (attributeName == null) {
            throw new ConversionException("No EnumType specified for EnumMap");
        }
        Class type2 = this.mapper().realClass(reader.getAttribute(attributeName));
        EnumMap map = new EnumMap(type2);
        this.populateMap(reader, context, map);
        return map;
    }

    private static class Reflections {
        private static final Field typeField = Fields.locate(EnumMap.class, Class.class, false);

        private Reflections() {
        }
    }
}

