/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Optional;

public class OptionalConverter
implements Converter {
    private Mapper mapper;

    public OptionalConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class type2) {
        return type2 != null && type2 == Optional.class;
    }

    @Override
    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        Optional optional = (Optional)source2;
        if (optional.isPresent()) {
            writer.startNode(this.mapper.serializedMember(Optional.class, "value"));
            Object object = optional.get();
            String name = this.mapper.serializedClass(object != null ? object.getClass() : null);
            writer.addAttribute(this.mapper.aliasForSystemAttribute("class"), name);
            context.convertAnother(optional.get());
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            Class type2 = HierarchicalStreams.readClassType(reader, this.mapper);
            Object value = context.convertAnother(context, type2);
            reader.moveUp();
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

