/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassAliasingMapper
extends MapperWrapper {
    private final Map typeToName = new HashMap();
    private final Map classToName = new HashMap();
    private transient Map nameToType = new HashMap();

    public ClassAliasingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public void addClassAlias(String name, Class type2) {
        this.nameToType.put(name, type2.getName());
        this.classToName.put(type2.getName(), name);
    }

    public void addClassAttributeAlias(String name, Class type2) {
        this.addClassAlias(name, type2);
    }

    public void addTypeAlias(String name, Class type2) {
        this.nameToType.put(name, type2.getName());
        this.typeToName.put(type2, name);
    }

    public String serializedClass(Class type2) {
        String alias = (String)this.classToName.get(type2.getName());
        if (alias != null) {
            return alias;
        }
        Iterator iter = this.typeToName.keySet().iterator();
        while (iter.hasNext()) {
            Class compatibleType = (Class)iter.next();
            if (!compatibleType.isAssignableFrom(type2)) continue;
            return (String)this.typeToName.get(compatibleType);
        }
        return super.serializedClass(type2);
    }

    public Class realClass(String elementName) {
        String mappedName = (String)this.nameToType.get(elementName);
        if (mappedName != null) {
            Class type2 = Primitives.primitiveType(mappedName);
            if (type2 != null) {
                return type2;
            }
            elementName = mappedName;
        }
        return super.realClass(elementName);
    }

    public boolean itemTypeAsAttribute(Class clazz) {
        return this.classToName.containsKey(clazz.getName());
    }

    public boolean aliasIsAttribute(String name) {
        return this.nameToType.containsKey(name);
    }

    private Object readResolve() {
        Object type2;
        this.nameToType = new HashMap();
        Iterator iter = this.classToName.keySet().iterator();
        while (iter.hasNext()) {
            type2 = iter.next();
            this.nameToType.put(this.classToName.get(type2), type2);
        }
        iter = this.typeToName.keySet().iterator();
        while (iter.hasNext()) {
            type2 = (Class)iter.next();
            this.nameToType.put(this.typeToName.get(type2), ((Class)type2).getName());
        }
        return this;
    }
}

