/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.enums.EnumSingleValueConverter;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class EnumMapper
extends MapperWrapper
implements Caching {
    private transient AttributeMapper attributeMapper;
    private transient Map<Class, SingleValueConverter> enumConverterMap;

    @Deprecated
    public EnumMapper(Mapper wrapped, ConverterLookup lookup) {
        super(wrapped);
        this.readResolve();
    }

    public EnumMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public String serializedClass(Class type2) {
        if (type2 == null) {
            return super.serializedClass(type2);
        }
        if (Enum.class.isAssignableFrom(type2) && type2.getSuperclass() != Enum.class) {
            return super.serializedClass(type2.getSuperclass());
        }
        if (EnumSet.class.isAssignableFrom(type2)) {
            return super.serializedClass(EnumSet.class);
        }
        return super.serializedClass(type2);
    }

    public boolean isImmutableValueType(Class type2) {
        return Enum.class.isAssignableFrom(type2) || super.isImmutableValueType(type2);
    }

    public boolean isReferenceable(Class type2) {
        if (type2 != null && Enum.class.isAssignableFrom(type2)) {
            return false;
        }
        return super.isReferenceable(type2);
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type2, Class definedIn) {
        SingleValueConverter converter = this.getLocalConverter(fieldName, type2, definedIn);
        return converter == null ? super.getConverterFromItemType(fieldName, type2, definedIn) : converter;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type2) {
        SingleValueConverter converter = this.getLocalConverter(attribute, type2, definedIn);
        return converter == null ? super.getConverterFromAttribute(definedIn, attribute, type2) : converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleValueConverter getLocalConverter(String fieldName, Class type2, Class definedIn) {
        if (this.attributeMapper != null && Enum.class.isAssignableFrom(type2) && this.attributeMapper.shouldLookForSingleValueConverter(fieldName, type2, definedIn)) {
            Map<Class, SingleValueConverter> map = this.enumConverterMap;
            synchronized (map) {
                SingleValueConverter singleValueConverter = this.enumConverterMap.get(type2);
                if (singleValueConverter == null) {
                    singleValueConverter = super.getConverterFromItemType(fieldName, type2, definedIn);
                    if (singleValueConverter == null) {
                        Class enumType = type2;
                        singleValueConverter = new EnumSingleValueConverter(enumType);
                    }
                    this.enumConverterMap.put(type2, singleValueConverter);
                }
                return singleValueConverter;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        if (this.enumConverterMap.size() > 0) {
            Map<Class, SingleValueConverter> map = this.enumConverterMap;
            synchronized (map) {
                this.enumConverterMap.clear();
            }
        }
    }

    private Object readResolve() {
        this.enumConverterMap = new HashMap<Class, SingleValueConverter>();
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        return this;
    }
}

