/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.tweenEngine;

import dorkbox.tweenEngine.BaseTween;
import dorkbox.tweenEngine.EngineBuilder;
import dorkbox.tweenEngine.EngineUtils;
import dorkbox.tweenEngine.Timeline;
import dorkbox.tweenEngine.Tween;
import dorkbox.tweenEngine.TweenAccessor;
import dorkbox.tweenEngine.TweenCallback;
import dorkbox.tweenEngine.TweenEquations;
import dorkbox.tweenEngine.TweenPaths;
import dorkbox.tweenEngine.UpdateAction;
import dorkbox.tweenEngine.pool.ObjectPool;
import dorkbox.tweenEngine.pool.PoolableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TweenEngine {
    private static final BaseTween[] BASE_TWEENS = new BaseTween[0];
    public static final UpdateAction<?> NULL_ACTION = new UpdateAction<Object>(){

        @Override
        public void onEvent(Object tween) {
        }
    };
    private final Map<Class<?>, TweenAccessor<?>> registeredAccessors = new HashMap();
    private final ObjectPool<Timeline> poolTimeline;
    private final ObjectPool<Tween> poolTween;
    private final int combinedAttrsLimit;
    private final int waypointsLimit;
    private final ArrayList<BaseTween<?>> newTweens = new ArrayList(20);
    private final ArrayList<BaseTween<?>> tweenArrayList = new ArrayList(20);
    private boolean isPaused = false;
    private UpdateAction startEventCallback = NULL_ACTION;
    private UpdateAction endEventCallback = NULL_ACTION;
    private long lastTime = 0L;
    private static volatile long lightSyncObject = EngineUtils.nanoTime();

    public static EngineBuilder create() {
        return new EngineBuilder();
    }

    public static TweenEngine build() {
        return new TweenEngine(true, 3, 0, new HashMap());
    }

    public static String getVersion() {
        return "8.2";
    }

    TweenEngine(boolean threadSafe, int combinedAttrsLimit, int waypointsLimit, Map<Class<?>, TweenAccessor<?>> registeredAccessors) {
        this.combinedAttrsLimit = combinedAttrsLimit;
        this.waypointsLimit = waypointsLimit;
        this.registeredAccessors.putAll(registeredAccessors);
        PoolableObject<Timeline> timelinePoolableObject = new PoolableObject<Timeline>(){

            @Override
            public void onReturn(Timeline object) {
                object.destroy();
            }

            @Override
            public Timeline create() {
                return new Timeline(TweenEngine.this);
            }
        };
        PoolableObject<Tween> tweenPoolableObject = new PoolableObject<Tween>(){

            @Override
            public void onReturn(Tween object) {
                object.destroy();
            }

            @Override
            public Tween create() {
                return new Tween(TweenEngine.this, TweenEngine.this.combinedAttrsLimit, TweenEngine.this.waypointsLimit);
            }
        };
        this.poolTimeline = EngineUtils.getPool(threadSafe, timelinePoolableObject);
        this.poolTween = EngineUtils.getPool(threadSafe, tweenPoolableObject);
    }

    long flushRead() {
        return lightSyncObject;
    }

    void flushWrite() {
        lightSyncObject = EngineUtils.nanoTime();
    }

    public TweenAccessor<?> getRegisteredAccessor(Class<?> someClass) {
        this.flushRead();
        return this.registeredAccessors.get(someClass);
    }

    public TweenEngine setStartCallback(UpdateAction<TweenEngine> startCallback) {
        this.startEventCallback = startCallback == null ? NULL_ACTION : startCallback;
        this.flushWrite();
        return this;
    }

    public TweenEngine setEndCallback(UpdateAction<TweenEngine> endCallback) {
        this.endEventCallback = endCallback == null ? NULL_ACTION : endCallback;
        this.flushWrite();
        return this;
    }

    public TweenEngine add(BaseTween<?> tween) {
        this.flushRead();
        this.add__(tween);
        this.flushWrite();
        return this;
    }

    void add__(BaseTween<?> tween) {
        this.newTweens.add(tween);
        if (tween.isAutoStartEnabled) {
            tween.startUnmanaged__();
        }
    }

    public boolean containsTarget(Object target) {
        this.flushRead();
        for (BaseTween<?> tween : this.tweenArrayList) {
            if (!tween.containsTarget(target)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTarget(Object target, int tweenType) {
        this.flushRead();
        for (BaseTween<?> tween : this.tweenArrayList) {
            if (!tween.containsTarget(target, tweenType)) continue;
            return true;
        }
        return false;
    }

    public void cancelAll() {
        this.flushRead();
        boolean wasCanceled = false;
        for (BaseTween<?> tween : this.tweenArrayList) {
            tween.cancel();
        }
        this.flushWrite();
    }

    public boolean cancelTarget(Object target) {
        this.flushRead();
        boolean wasCanceled = false;
        for (BaseTween<?> tween : this.tweenArrayList) {
            if (!tween.cancelTarget(target)) continue;
            wasCanceled = true;
        }
        this.flushWrite();
        return wasCanceled;
    }

    public boolean cancelTarget(Object target, int tweenType) {
        this.flushRead();
        boolean wasCanceled = false;
        for (BaseTween<?> tween : this.tweenArrayList) {
            if (!tween.cancelTarget(target, tweenType)) continue;
            wasCanceled = true;
        }
        this.flushWrite();
        return wasCanceled;
    }

    public void ensureCapacity(int minCapacity) {
        this.flushRead();
        this.tweenArrayList.ensureCapacity(minCapacity);
        this.flushWrite();
    }

    public void pause() {
        this.isPaused = true;
        this.flushWrite();
    }

    public void resume() {
        this.isPaused = false;
        this.flushWrite();
    }

    public void resetUpdateTime() {
        this.lastTime = EngineUtils.nanoTime();
        this.flushWrite();
    }

    public void update() {
        this.flushRead();
        long newTime = EngineUtils.nanoTime();
        float deltaTime = (float)(newTime - this.lastTime) / 1.0E9f;
        this.lastTime = newTime;
        this.update__(deltaTime);
        this.flushWrite();
    }

    public void update(long deltaTimeInNanos) {
        this.flushRead();
        float deltaTimeInSec = (float)deltaTimeInNanos / 1.0E9f;
        this.update__(deltaTimeInSec);
        this.flushWrite();
    }

    public final void update(float delta) {
        this.flushRead();
        this.update__(delta);
        this.flushWrite();
    }

    private void update__(float delta) {
        if (!this.isPaused) {
            this.startEventCallback.onEvent(this);
            int size = this.newTweens.size();
            if (size > 0) {
                this.tweenArrayList.addAll(this.newTweens);
                this.newTweens.clear();
            }
            for (BaseTween<?> tween : this.tweenArrayList) {
                tween.update__(delta);
            }
            Iterator<BaseTween<?>> iterator2 = this.tweenArrayList.iterator();
            while (iterator2.hasNext()) {
                BaseTween<?> tween;
                tween = iterator2.next();
                if (!tween.isAutoRemoveEnabled) continue;
                if (tween.state == 3) {
                    tween.setValues(true, false);
                    iterator2.remove();
                    tween.free();
                    continue;
                }
                if (!tween.isCanceled) continue;
                iterator2.remove();
                tween.free();
            }
            this.endEventCallback.onEvent(this);
        }
    }

    public int size() {
        this.flushRead();
        return this.tweenArrayList.size();
    }

    public int getRunningTweensCount() {
        this.flushRead();
        return TweenEngine.getTweensCount(this.tweenArrayList);
    }

    public int getRunningTimelinesCount() {
        this.flushRead();
        return TweenEngine.getTimelinesCount(this.tweenArrayList);
    }

    public List<BaseTween<?>> getObjects() {
        this.flushRead();
        return Collections.unmodifiableList(this.tweenArrayList);
    }

    public Timeline createSequential() {
        Timeline timeline = this.poolTimeline.take();
        this.flushRead();
        timeline.setup__(Timeline.Mode.SEQUENTIAL);
        this.flushWrite();
        return timeline;
    }

    public Timeline createParallel() {
        Timeline timeline = this.poolTimeline.take();
        this.flushRead();
        timeline.setup__(Timeline.Mode.PARALLEL);
        this.flushWrite();
        return timeline;
    }

    public Tween to(Object target, int tweenType, float duration) {
        return this.to(target, tweenType, null, duration);
    }

    public <T> Tween to(T target, int tweenType, TweenAccessor<T> targetAccessor, float duration) {
        Tween tween = this.takeTween();
        this.flushRead();
        tween.setup__(target, tweenType, targetAccessor, duration);
        tween.ease__(TweenEquations.Quad_InOut);
        tween.path__(TweenPaths.CatmullRom);
        this.flushWrite();
        return tween;
    }

    public <T> Tween from(T target, int tweenType, float duration) {
        return this.from(target, tweenType, null, duration);
    }

    public <T> Tween from(T target, int tweenType, TweenAccessor<T> targetAccessor, float duration) {
        Tween tween = this.takeTween();
        this.flushRead();
        tween.setup__(target, tweenType, targetAccessor, duration);
        tween.ease__(TweenEquations.Quad_InOut);
        tween.path__(TweenPaths.CatmullRom);
        tween.isFrom = true;
        this.flushWrite();
        return tween;
    }

    public <T> Tween set(T target, int tweenType) {
        return this.set(target, tweenType, null);
    }

    public <T> Tween set(T target, int tweenType, TweenAccessor<T> targetAccessor) {
        Tween tween = this.takeTween();
        this.flushRead();
        tween.setup__(target, tweenType, targetAccessor, 0.0f);
        tween.ease__(TweenEquations.Quad_In);
        this.flushWrite();
        return tween;
    }

    public Tween call(TweenCallback callback) {
        Tween tween = this.takeTween();
        this.flushRead();
        tween.setup__(null, -1, null, 0.0f);
        callback.triggers = 2;
        tween.addCallback(callback);
        this.flushWrite();
        return tween;
    }

    public Tween mark() {
        Tween tween = this.takeTween();
        tween.setup__(null, -1, null, 0.0f);
        this.flushWrite();
        return tween;
    }

    Tween mark__() {
        Tween tween = this.takeTween__();
        tween.setup__(null, -1, null, 0.0f);
        return tween;
    }

    Timeline takeTimeline() {
        Timeline take = this.poolTimeline.take();
        this.flushRead();
        return take;
    }

    Tween takeTween() {
        Tween take = this.poolTween.take();
        this.flushRead();
        return take;
    }

    Tween takeTween__() {
        return this.poolTween.take();
    }

    void free(Timeline timeline) {
        this.poolTimeline.put(timeline);
    }

    void free(Tween tween) {
        this.poolTween.put(tween);
    }

    boolean containsAccessor(Class<?> accessorClass) {
        return this.registeredAccessors.containsKey(accessorClass);
    }

    TweenAccessor getAccessor(Class<?> accessorClass) {
        return this.registeredAccessors.get(accessorClass);
    }

    private static int getTweensCount(List<BaseTween<?>> objs) {
        int count = 0;
        int n = objs.size();
        for (int i = 0; i < n; ++i) {
            BaseTween<?> obj2 = objs.get(i);
            if (obj2 instanceof Tween) {
                ++count;
                continue;
            }
            count += TweenEngine.getTweensCount(((Timeline)obj2).getChildren());
        }
        return count;
    }

    private static int getTimelinesCount(List<BaseTween<?>> objs) {
        int count = 0;
        int n = objs.size();
        for (int i = 0; i < n; ++i) {
            BaseTween<?> obj2 = objs.get(i);
            if (!(obj2 instanceof Timeline)) continue;
            count += 1 + TweenEngine.getTimelinesCount(((Timeline)obj2).getChildren());
        }
        return count;
    }
}

