/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.tweenEngine;

import dorkbox.tweenEngine.TweenEquation;

public enum TweenEquations {
    Linear(new TweenEquation(){

        @Override
        public float compute(float time) {
            return time;
        }

        public String toString() {
            return "Linear.INOUT";
        }
    }),
    Quad_In(new TweenEquation(){

        @Override
        public final float compute(float time) {
            return time * time;
        }

        public String toString() {
            return "Quad.IN";
        }
    }),
    Quad_Out(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float m3 = time - 1.0f;
            return 1.0f - m3 * m3;
        }

        public String toString() {
            return "Quad.OUT";
        }
    }),
    Quad_InOut(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                return time * t;
            }
            float m3 = time - 1.0f;
            return 1.0f - m3 * m3 * 2.0f;
        }

        public String toString() {
            return "Quad.INOUT";
        }
    }),
    Cubic_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            return time * time * time;
        }

        public String toString() {
            return "Cubic.IN";
        }
    }),
    Cubic_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            return 1.0f + m3 * m3 * m3;
        }

        public String toString() {
            return "Cubic.OUT";
        }
    }),
    Cubic_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                return time * t * t;
            }
            float m3 = time - 1.0f;
            return 1.0f + m3 * m3 * m3 * 4.0f;
        }

        public String toString() {
            return "Cubic.INOUT";
        }
    }),
    Quart_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * time;
            return t * t;
        }

        public String toString() {
            return "Quart.IN";
        }
    }),
    Quart_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f - m22 * m22;
        }

        public String toString() {
            return "Quart.OUT";
        }
    }),
    Quart_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                return time * t * t * t;
            }
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f - m22 * m22 * 8.0f;
        }

        public String toString() {
            return "Quart.INOUT";
        }
    }),
    Quint_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * time;
            return t * t * time;
        }

        public String toString() {
            return "Quint.IN";
        }
    }),
    Quint_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f + m22 * m22 * m3;
        }

        public String toString() {
            return "Quint.OUT";
        }
    }),
    Quint_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                float t2 = t * t;
                return time * t2 * t2;
            }
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f + m22 * m22 * m3 * 16.0f;
        }

        public String toString() {
            return "Quint.INOUT";
        }
    }),
    Sextic_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * time;
            return t * t * t;
        }

        public String toString() {
            return "Sextic.IN";
        }
    }),
    Sextic_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f - m22 * m22 * m22;
        }

        public String toString() {
            return "Sextic.OUT";
        }
    }),
    Sextic_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                float t2 = t * t;
                return time * t2 * t2 * t;
            }
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f - m22 * m22 * m22 * 32.0f;
        }

        public String toString() {
            return "Sextic.INOUT";
        }
    }),
    Septic_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * time;
            return t * t * t * time;
        }

        public String toString() {
            return "Septic.IN";
        }
    }),
    Septic_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f + m22 * m22 * m22 * m3;
        }

        public String toString() {
            return "Septic.OUT";
        }
    }),
    Septic_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                float t2 = t * t;
                return time * t2 * t2 * t2;
            }
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            return 1.0f + m22 * m22 * m22 * m3 * 64.0f;
        }

        public String toString() {
            return "Septic.INOUT";
        }
    }),
    Octic_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * time;
            float t2 = t * t;
            return t2 * t2;
        }

        public String toString() {
            return "Octic.IN";
        }
    }),
    Octic_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            float m4 = m22 * m22;
            return 1.0f - m4 * m4;
        }

        public String toString() {
            return "Octic.OUT";
        }
    }),
    Octic_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                float t2 = t * t;
                return time * t2 * t2 * t2 * t;
            }
            float m3 = time - 1.0f;
            float m22 = m3 * m3;
            float m4 = m22 * m22;
            return 1.0f - m4 * m4 * 128.0f;
        }

        public String toString() {
            return "Octic.INOUT";
        }
    }),
    Circle_In(new TweenEquation(){

        @Override
        public final float compute(float time) {
            return (float)(1.0 - Math.sqrt(1.0f - time * time));
        }

        public String toString() {
            return "Circle.IN";
        }
    }),
    Circle_Out(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float m3 = time - 1.0f;
            return (float)Math.sqrt(1.0f - m3 * m3);
        }

        public String toString() {
            return "Circle.OUT";
        }
    }),
    Circle_InOut(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float m3 = time - 1.0f;
            float t = time * 2.0f;
            if (t < 1.0f) {
                return (float)((1.0 - Math.sqrt(1.0f - t * t)) * 0.5);
            }
            return (float)((Math.sqrt(1.0f - 4.0f * m3 * m3) + 1.0) * 0.5);
        }

        public String toString() {
            return "Circle.INOUT";
        }
    }),
    Sine_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            return (float)(1.0 - Math.cos(time * 1.5707964f));
        }

        public String toString() {
            return "Sine.IN";
        }
    }),
    Sine_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            return (float)Math.sin(time * 1.5707964f);
        }

        public String toString() {
            return "Sine.OUT";
        }
    }),
    Sine_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            return (float)(0.5 * (1.0 - Math.cos(time * (float)Math.PI)));
        }

        public String toString() {
            return "Sine.INOUT";
        }
    }),
    Expo_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            return (float)Math.pow(2.0, 10.0f * (time - 1.0f));
        }

        public String toString() {
            return "Expo.IN";
        }
    }),
    Expo_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            return (float)(1.0 - Math.pow(2.0, -10.0f * time));
        }

        public String toString() {
            return "Expo.OUT";
        }
    }),
    Expo_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            if (time < 0.5f) {
                return (float)Math.pow(2.0, 10.0f * (2.0f * time - 1.0f) - 1.0f);
            }
            return (float)(1.0 - Math.pow(2.0, -10.0f * (2.0f * time - 1.0f) - 1.0f));
        }

        public String toString() {
            return "Expo.INOUT";
        }
    }),
    Back_In(new TweenEquation(){

        @Override
        public final float compute(float time) {
            return time * time * (time * 2.70158f - 1.70158f);
        }

        public String toString() {
            return "Back.IN";
        }
    }),
    Back_Out(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float m3 = time - 1.0f;
            return 1.0f + m3 * m3 * (m3 * 2.70158f + 1.70158f);
        }

        public String toString() {
            return "Back.OUT";
        }
    }),
    Back_InOut(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float m3 = time - 1.0f;
            float t = time * 2.0f;
            if (time < 0.5f) {
                return time * t * (t * 3.5949094f - 2.5949094f);
            }
            return 1.0f + 2.0f * m3 * m3 * (2.0f * m3 * 3.5949094f + 2.5949094f);
        }

        public String toString() {
            return "Back.INOUT";
        }
    }),
    Bounce_In(new TweenEquation(){

        @Override
        public final float compute(float time) {
            return 1.0f - Bounce_Out.equation.compute(1.0f - time);
        }

        public String toString() {
            return "Bounce.IN";
        }
    }),
    Bounce_Out(new TweenEquation(){

        @Override
        public final float compute(float time) {
            if (time < 0.36363637f) {
                return 7.5625f * time * time;
            }
            if (time < 0.72727275f) {
                float t = time - 0.54545456f;
                return 7.5625f * t * t + 0.75f;
            }
            if (time < 0.90909094f) {
                float t = time - 0.8181819f;
                return 7.5625f * t * t + 0.9375f;
            }
            float t = time - 0.9545455f;
            return 7.5625f * t * t + 0.984375f;
        }

        public String toString() {
            return "Bounce.OUT";
        }
    }),
    Bounce_InOut(new TweenEquation(){

        @Override
        public final float compute(float time) {
            float t = time * 2.0f;
            if (t < 1.0f) {
                return 0.5f - 0.5f * Bounce_Out.equation.compute(1.0f - t);
            }
            return 0.5f + 0.5f * Bounce_Out.equation.compute(t - 1.0f);
        }

        public String toString() {
            return "Bounce.INOUT";
        }
    }),
    Elastic_In(new TweenEquation(){

        @Override
        public float compute(float time) {
            float m3 = time - 1.0f;
            return (float)(-Math.pow(2.0, 10.0f * m3) * Math.sin((m3 * 40.0f - 3.0f) * 0.5235988f));
        }

        public String toString() {
            return "Elastic.IN";
        }
    }),
    Elastic_Out(new TweenEquation(){

        @Override
        public float compute(float time) {
            return (float)(1.0 + Math.pow(2.0, 10.0f * -time) * Math.sin((-time * 40.0f - 3.0f) * 0.5235988f));
        }

        public String toString() {
            return "Elastic.OUT";
        }
    }),
    Elastic_InOut(new TweenEquation(){

        @Override
        public float compute(float time) {
            time *= 2.0f;
            float k = (80.0f * (time -= 1.0f) - 9.0f) * 0.17453292f;
            if (time < 0.0f) {
                return (float)(-0.5 * Math.pow(2.0, 10.0f * time) * Math.sin(k));
            }
            return (float)(1.0 + 0.5 * Math.pow(2.0, -10.0f * time) * Math.sin(k));
        }

        public String toString() {
            return "Elastic.INOUT";
        }
    });

    private static final float PI = (float)Math.PI;
    private static final float PI_DIV_2 = 1.5707964f;
    private static final float PI_DIV_6 = 0.5235988f;
    private static final float PI_DIV_18 = 0.17453292f;
    private static final float K = 1.70158f;
    private static final float K2 = 2.5949094f;
    private static final float bounce_r = 0.36363637f;
    private static final float bounce_k0 = 7.5625f;
    private static final float bounce_k1 = 0.36363637f;
    private static final float bounce_k2 = 0.72727275f;
    private static final float bounce_k3 = 0.54545456f;
    private static final float bounce_k4 = 0.90909094f;
    private static final float bounce_k5 = 0.8181819f;
    private static final float bounce_k6 = 0.9545455f;
    private final transient TweenEquation equation;

    public static TweenEquation parse(String name) {
        TweenEquations[] values2 = TweenEquations.values();
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            if (!name.equals(values2[i].toString())) continue;
            return values2[i].equation;
        }
        return null;
    }

    private TweenEquations(TweenEquation equation) {
        this.equation = equation;
    }

    public TweenEquation getEquation() {
        return this.equation;
    }

    public float compute(float time) {
        return this.equation.compute(time);
    }

    public String toString() {
        return this.equation.toString();
    }
}

