/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.tweenEngine.pool;

import dorkbox.tweenEngine.pool.ObjectPool;
import dorkbox.tweenEngine.pool.PoolableObject;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPoolSoft<T>
extends ObjectPool<T> {
    ObjectPoolSoft(PoolableObject<T> poolableObject) {
        this(poolableObject, new ConcurrentLinkedQueue<SoftReference<T>>());
    }

    public ObjectPoolSoft(PoolableObject<T> poolableObject, Queue<SoftReference<T>> queue) {
        super(poolableObject, queue);
    }

    @Override
    public T take() {
        SoftReference ref;
        while ((ref = (SoftReference)this.queue.poll()) != null) {
            Object obj2 = ref.get();
            if (obj2 == null) continue;
            return obj2;
        }
        Object take = this.poolableObject.create();
        return take;
    }

    @Override
    public void put(T object) {
        this.poolableObject.onReturn(object);
        this.queue.offer(new SoftReference<T>(object));
    }
}

