/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelaySubscriptionOther<T, U>
extends Flowable<T> {
    final Publisher<? extends T> main;
    final Publisher<U> other;

    public FlowableDelaySubscriptionOther(Publisher<? extends T> main2, Publisher<U> other) {
        this.main = main2;
        this.other = other;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> child) {
        MainSubscriber<? extends T> parent = new MainSubscriber<T>(child, this.main);
        child.onSubscribe(parent);
        this.other.subscribe(parent.other);
    }

    static final class MainSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2259811067697317255L;
        final Subscriber<? super T> downstream;
        final Publisher<? extends T> main;
        final OtherSubscriber other;
        final AtomicReference<Subscription> upstream;

        MainSubscriber(Subscriber<? super T> downstream, Publisher<? extends T> main2) {
            this.downstream = downstream;
            this.main = main2;
            this.other = new OtherSubscriber();
            this.upstream = new AtomicReference();
        }

        void next() {
            this.main.subscribe(this);
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                SubscriptionHelper.deferredRequest(this.upstream, this, n);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            SubscriptionHelper.cancel(this.upstream);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this, s2);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Object> {
            private static final long serialVersionUID = -3892798459447644106L;

            OtherSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription s2) {
                if (SubscriptionHelper.setOnce(this, s2)) {
                    s2.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(Object t) {
                Subscription s2 = (Subscription)this.get();
                if (s2 != SubscriptionHelper.CANCELLED) {
                    this.lazySet(SubscriptionHelper.CANCELLED);
                    s2.cancel();
                    MainSubscriber.this.next();
                }
            }

            @Override
            public void onError(Throwable t) {
                Subscription s2 = (Subscription)this.get();
                if (s2 != SubscriptionHelper.CANCELLED) {
                    MainSubscriber.this.downstream.onError(t);
                } else {
                    RxJavaPlugins.onError(t);
                }
            }

            @Override
            public void onComplete() {
                Subscription s2 = (Subscription)this.get();
                if (s2 != SubscriptionHelper.CANCELLED) {
                    MainSubscriber.this.next();
                }
            }
        }
    }
}

