/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorKindFilter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<DescriptorKindExclude> excludes;
    private final int kindMask;
    private static int nextMaskValue;
    private static final int NON_SINGLETON_CLASSIFIERS_MASK;
    private static final int SINGLETON_CLASSIFIERS_MASK;
    private static final int TYPE_ALIASES_MASK;
    private static final int PACKAGES_MASK;
    private static final int FUNCTIONS_MASK;
    private static final int VARIABLES_MASK;
    private static final int ALL_KINDS_MASK;
    private static final int CLASSIFIERS_MASK;
    private static final int VALUES_MASK;
    private static final int CALLABLES_MASK;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter ALL;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter CALLABLES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter NON_SINGLETON_CLASSIFIERS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter SINGLETON_CLASSIFIERS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter TYPE_ALIASES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter CLASSIFIERS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter PACKAGES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter FUNCTIONS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter VARIABLES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter VALUES;
    @NotNull
    private static final List<Companion.MaskToName> DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
    @NotNull
    private static final List<Companion.MaskToName> DEBUG_MASK_BIT_NAMES;

    public DescriptorKindFilter(int kindMask, @NotNull List<? extends DescriptorKindExclude> excludes) {
        Intrinsics.checkNotNullParameter(excludes, "excludes");
        this.excludes = excludes;
        int mask = 0;
        mask = kindMask;
        Iterable $this$forEach$iv = this.excludes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DescriptorKindExclude it = (DescriptorKindExclude)element$iv;
            boolean bl = false;
            mask &= ~it.getFullyExcludedDescriptorKinds();
        }
        this.kindMask = mask;
    }

    public /* synthetic */ DescriptorKindFilter(int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        this(n, list);
    }

    @NotNull
    public final List<DescriptorKindExclude> getExcludes() {
        return this.excludes;
    }

    public final int getKindMask() {
        return this.kindMask;
    }

    public final boolean acceptsKinds(int kinds) {
        return (this.kindMask & kinds) != 0;
    }

    @Nullable
    public final DescriptorKindFilter restrictedToKindsOrNull(int kinds) {
        int mask = this.kindMask & kinds;
        if (mask == 0) {
            return null;
        }
        return new DescriptorKindFilter(mask, this.excludes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string2;
        String predefinedFilterName;
        Object v0;
        block4: {
            Iterable $this$firstOrNull$iv = DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Companion.MaskToName it = (Companion.MaskToName)element$iv;
                boolean bl = false;
                if (!(it.getMask() == this.getKindMask())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Companion.MaskToName maskToName = v0;
        String string3 = predefinedFilterName = maskToName == null ? null : maskToName.getName();
        if (string3 == null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object element$iv;
            Iterable $i$f$firstOrNull = DEBUG_MASK_BIT_NAMES;
            boolean $i$f$mapNotNull = false;
            element$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string4;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Companion.MaskToName it = (Companion.MaskToName)element$iv$iv;
                boolean bl2 = false;
                if ((this.acceptsKinds(it.getMask()) ? it.getName() : null) == null) continue;
                string4 = string4;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string4;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            string2 = CollectionsKt.joinToString$default((List)destination$iv$iv, " | ", null, null, 0, null, null, 62, null);
        } else {
            string2 = string3;
        }
        String kindString = string2;
        return "DescriptorKindFilter(" + kindString + ", " + this.excludes + ')';
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_6;
        Iterable $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv$iv;
        boolean bl;
        Object object;
        Field field;
        Field[] $this$mapNotNullTo$iv$iv;
        boolean bl2;
        Field it$iv;
        void $this$filterTo$iv$iv$iv2;
        Companion = new Companion(null);
        nextMaskValue = 1;
        NON_SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        TYPE_ALIASES_MASK = DescriptorKindFilter.Companion.nextMask();
        PACKAGES_MASK = DescriptorKindFilter.Companion.nextMask();
        FUNCTIONS_MASK = DescriptorKindFilter.Companion.nextMask();
        VARIABLES_MASK = DescriptorKindFilter.Companion.nextMask();
        ALL_KINDS_MASK = DescriptorKindFilter.Companion.nextMask() - 1;
        CLASSIFIERS_MASK = Companion.getNON_SINGLETON_CLASSIFIERS_MASK() | Companion.getSINGLETON_CLASSIFIERS_MASK() | Companion.getTYPE_ALIASES_MASK();
        VALUES_MASK = Companion.getSINGLETON_CLASSIFIERS_MASK() | Companion.getFUNCTIONS_MASK() | Companion.getVARIABLES_MASK();
        CALLABLES_MASK = Companion.getFUNCTIONS_MASK() | Companion.getVARIABLES_MASK();
        ALL = new DescriptorKindFilter(Companion.getALL_KINDS_MASK(), null, 2, null);
        CALLABLES = new DescriptorKindFilter(Companion.getCALLABLES_MASK(), null, 2, null);
        NON_SINGLETON_CLASSIFIERS = new DescriptorKindFilter(Companion.getNON_SINGLETON_CLASSIFIERS_MASK(), null, 2, null);
        SINGLETON_CLASSIFIERS = new DescriptorKindFilter(Companion.getSINGLETON_CLASSIFIERS_MASK(), null, 2, null);
        TYPE_ALIASES = new DescriptorKindFilter(Companion.getTYPE_ALIASES_MASK(), null, 2, null);
        CLASSIFIERS = new DescriptorKindFilter(Companion.getCLASSIFIERS_MASK(), null, 2, null);
        PACKAGES = new DescriptorKindFilter(Companion.getPACKAGES_MASK(), null, 2, null);
        FUNCTIONS = new DescriptorKindFilter(Companion.getFUNCTIONS_MASK(), null, 2, null);
        VARIABLES = new DescriptorKindFilter(Companion.getVARIABLES_MASK(), null, 2, null);
        VALUES = new DescriptorKindFilter(Companion.getVALUES_MASK(), null, 2, null);
        Companion this_$iv = Companion;
        boolean $i$f$staticFields = false;
        Field[] fieldArray = DescriptorKindFilter.class.getFields();
        Intrinsics.checkNotNullExpressionValue(fieldArray, "T::class.java.fields");
        Object $this$filter$iv$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv$iv;
        Object destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv$iv : $this$filterTo$iv$iv$iv2) {
            it$iv = (Field)element$iv$iv$iv;
            bl2 = false;
            if (!Modifier.isStatic(it$iv.getModifiers())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filter$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        Field[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.MaskToName maskToName;
            DescriptorKindFilter filter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            field = (Field)element$iv$iv;
            boolean bl4 = false;
            Object object2 = field.get(null);
            DescriptorKindFilter descriptorKindFilter = filter = object2 instanceof DescriptorKindFilter ? (DescriptorKindFilter)object2 : null;
            if (filter != null) {
                int n = filter.getKindMask();
                object2 = field.getName();
                Intrinsics.checkNotNullExpressionValue(object2, "field.name");
                Companion.MaskToName maskToName2 = new Companion.MaskToName(n, (String)object2);
                maskToName = maskToName2;
            } else {
                maskToName = null;
            }
            if (maskToName == null) continue;
            object = maskToName;
            boolean bl5 = false;
            bl = false;
            Companion.MaskToName it$iv$iv = object;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        DEBUG_PREDEFINED_FILTERS_MASK_NAMES = (List)destination$iv$iv;
        this_$iv = Companion;
        $i$f$staticFields = false;
        $this$mapNotNullTo$iv$iv = DescriptorKindFilter.class.getFields();
        Intrinsics.checkNotNullExpressionValue($this$mapNotNullTo$iv$iv, "T::class.java.fields");
        $this$filter$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$filter = false;
        Object $i$f$mapNotNullTo22 = $this$filter$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Iterator element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            it$iv = (Field)((Object)element$iv$iv$iv);
            bl2 = false;
            if (!Modifier.isStatic(it$iv.getModifiers())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv$iv;
        boolean $i$f$filter2 = false;
        $this$filter$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Field it = (Field)element$iv$iv;
            boolean bl7 = false;
            if (!Intrinsics.areEqual(it.getType(), Integer.TYPE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.MaskToName maskToName;
            boolean isOneBitMask;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl8 = false;
            field = (Field)element$iv$iv;
            boolean bl9 = false;
            Object object3 = field.get(null);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            int mask = (Integer)object3;
            boolean bl10 = isOneBitMask = mask == (mask & -mask);
            if (isOneBitMask) {
                object = field.getName();
                Intrinsics.checkNotNullExpressionValue(object, "field.name");
                maskToName = new Companion.MaskToName(mask, (String)object);
            } else {
                maskToName = null;
            }
            if (maskToName == null) continue;
            Companion.MaskToName maskToName3 = maskToName;
            bl = false;
            boolean bl11 = false;
            Companion.MaskToName it$iv$iv = maskToName3;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        DEBUG_MASK_BIT_NAMES = (List)var3_6;
    }

    public static final class Companion {
        private Companion() {
        }

        private final int nextMask() {
            int n = nextMaskValue;
            boolean bl = false;
            boolean bl2 = false;
            int $this$nextMask_u24lambda_u2d0 = n;
            boolean bl3 = false;
            nextMaskValue = nextMaskValue << 1;
            return n;
        }

        public final int getNON_SINGLETON_CLASSIFIERS_MASK() {
            return NON_SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getSINGLETON_CLASSIFIERS_MASK() {
            return SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getTYPE_ALIASES_MASK() {
            return TYPE_ALIASES_MASK;
        }

        public final int getPACKAGES_MASK() {
            return PACKAGES_MASK;
        }

        public final int getFUNCTIONS_MASK() {
            return FUNCTIONS_MASK;
        }

        public final int getVARIABLES_MASK() {
            return VARIABLES_MASK;
        }

        public final int getALL_KINDS_MASK() {
            return ALL_KINDS_MASK;
        }

        public final int getCLASSIFIERS_MASK() {
            return CLASSIFIERS_MASK;
        }

        public final int getVALUES_MASK() {
            return VALUES_MASK;
        }

        public final int getCALLABLES_MASK() {
            return CALLABLES_MASK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static final class MaskToName {
            private final int mask;
            @NotNull
            private final String name;

            public MaskToName(int mask, @NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                this.mask = mask;
                this.name = name;
            }

            public final int getMask() {
                return this.mask;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }
        }
    }
}

