/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.ui.FatalErrorDialog;
import net.runelite.client.util.LinkBrowser;

public class RuntimeConfig {
    private Map<String, ?> props = Collections.emptyMap();
    private Map<String, String> sysProps = Collections.emptyMap();
    private String outageMessage;
    private Map<String, String> outageLinks;

    public boolean showOutageMessage() {
        if (Strings.isNullOrEmpty(this.getOutageMessage())) {
            return false;
        }
        SwingUtilities.invokeLater(() -> {
            FatalErrorDialog fed = new FatalErrorDialog(this.getOutageMessage());
            if (this.getOutageLinks() != null) {
                for (Map.Entry<String, String> e : this.getOutageLinks().entrySet()) {
                    fed.addButton(e.getKey(), () -> LinkBrowser.browse((String)e.getValue()));
                }
            } else {
                fed.addButton("OSRS Twitter", () -> LinkBrowser.browse(RuneLiteProperties.getOSRSTwitterLink()));
            }
            fed.open();
        });
        return true;
    }

    public Map<String, ?> getProps() {
        return this.props;
    }

    public Map<String, String> getSysProps() {
        return this.sysProps;
    }

    public String getOutageMessage() {
        return this.outageMessage;
    }

    public Map<String, String> getOutageLinks() {
        return this.outageLinks;
    }

    public void setProps(Map<String, ?> props) {
        this.props = props;
    }

    public void setSysProps(Map<String, String> sysProps) {
        this.sysProps = sysProps;
    }

    public void setOutageMessage(String outageMessage) {
        this.outageMessage = outageMessage;
    }

    public void setOutageLinks(Map<String, String> outageLinks) {
        this.outageLinks = outageLinks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeConfig)) {
            return false;
        }
        RuntimeConfig other = (RuntimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ?> this$props = this.getProps();
        Map<String, ?> other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        Map<String, String> this$sysProps = this.getSysProps();
        Map<String, String> other$sysProps = other.getSysProps();
        if (this$sysProps == null ? other$sysProps != null : !((Object)this$sysProps).equals(other$sysProps)) {
            return false;
        }
        String this$outageMessage = this.getOutageMessage();
        String other$outageMessage = other.getOutageMessage();
        if (this$outageMessage == null ? other$outageMessage != null : !this$outageMessage.equals(other$outageMessage)) {
            return false;
        }
        Map<String, String> this$outageLinks = this.getOutageLinks();
        Map<String, String> other$outageLinks = other.getOutageLinks();
        return !(this$outageLinks == null ? other$outageLinks != null : !((Object)this$outageLinks).equals(other$outageLinks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuntimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Map<String, ?> $props = this.getProps();
        result2 = result2 * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        Map<String, String> $sysProps = this.getSysProps();
        result2 = result2 * 59 + ($sysProps == null ? 43 : ((Object)$sysProps).hashCode());
        String $outageMessage = this.getOutageMessage();
        result2 = result2 * 59 + ($outageMessage == null ? 43 : $outageMessage.hashCode());
        Map<String, String> $outageLinks = this.getOutageLinks();
        result2 = result2 * 59 + ($outageLinks == null ? 43 : ((Object)$outageLinks).hashCode());
        return result2;
    }

    public String toString() {
        return "RuntimeConfig(props=" + this.getProps() + ", sysProps=" + this.getSysProps() + ", outageMessage=" + this.getOutageMessage() + ", outageLinks=" + this.getOutageLinks() + ")";
    }
}

