/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.WorldChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.account.AccountSession;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigClient;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigInvocationHandler;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigItemDescriptor;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.ConfigSectionDescriptor;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.ModifierlessKeybind;
import net.runelite.client.config.Range;
import net.runelite.client.config.RuneScapeProfile;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.config.Units;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.util.ColorUtil;
import net.runelite.http.api.config.ConfigEntry;
import net.runelite.http.api.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    public static final String RSPROFILE_GROUP = "rsprofile";
    private static final String RSPROFILE_DISPLAY_NAME = "displayName";
    private static final String RSPROFILE_TYPE = "type";
    private static final String RSPROFILE_LOGIN_HASH = "loginHash";
    private static final String RSPROFILE_LOGIN_SALT = "loginSalt";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private static final int KEY_SPLITTER_GROUP = 0;
    private static final int KEY_SPLITTER_PROFILE = 1;
    private static final int KEY_SPLITTER_KEY = 2;
    private final File settingsFileInput;
    private final EventBus eventBus;
    private final Gson gson;
    @Nonnull
    private final ConfigClient configClient;
    private AccountSession session;
    private File propertiesFile;
    @Nullable
    private final Client client;
    private final ConfigInvocationHandler handler = new ConfigInvocationHandler(this);
    private final Map<String, String> pendingChanges = new HashMap<String, String>();
    private Properties properties = new Properties();
    @Nullable
    private String rsProfileKey;

    @Inject
    public ConfigManager(@Named(value="config") File config, ScheduledExecutorService scheduledExecutorService, EventBus eventBus, @Nullable Client client, Gson gson, ConfigClient configClient) {
        this.settingsFileInput = config;
        this.eventBus = eventBus;
        this.client = client;
        this.propertiesFile = this.getPropertiesFile();
        this.gson = gson;
        this.configClient = configClient;
        scheduledExecutorService.scheduleWithFixedDelay(this::sendConfig, 30L, 300L, TimeUnit.SECONDS);
    }

    public String getRSProfileKey() {
        return this.rsProfileKey;
    }

    public final void switchSession(AccountSession session) {
        this.sendConfig();
        if (session == null) {
            this.session = null;
            this.configClient.setUuid(null);
        } else {
            this.session = session;
            this.configClient.setUuid(session.getUuid());
        }
        this.propertiesFile = this.getPropertiesFile();
        this.load();
    }

    private File getLocalPropertiesFile() {
        return this.settingsFileInput;
    }

    private File getPropertiesFile() {
        if (this.session == null || this.session.getUsername() == null) {
            return this.getLocalPropertiesFile();
        }
        File profileDir = new File(RuneLite.PROFILES_DIR, this.session.getUsername().toLowerCase());
        return new File(profileDir, RuneLite.DEFAULT_CONFIG_FILE.getName());
    }

    public void load() {
        Configuration configuration;
        if (this.session == null) {
            this.loadFromFile();
            return;
        }
        try {
            configuration = this.configClient.get();
        }
        catch (IOException ex) {
            log.debug("Unable to load configuration from client, using saved configuration from disk", ex);
            this.loadFromFile();
            return;
        }
        if (configuration.getConfig() == null || configuration.getConfig().isEmpty()) {
            log.debug("No configuration from client, using saved configuration on disk");
            this.loadFromFile();
            return;
        }
        Properties newProperties = new Properties();
        for (ConfigEntry entry : configuration.getConfig()) {
            newProperties.setProperty(entry.getKey(), entry.getValue());
        }
        log.debug("Loading in config from server");
        this.swapProperties(newProperties, false);
        try {
            this.saveToFile(this.propertiesFile);
            log.debug("Updated configuration on disk with the latest version");
        }
        catch (IOException ex) {
            log.warn("Unable to update configuration on disk", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapProperties(Properties newProperties, boolean saveToServer) {
        Properties oldProperties;
        HashSet<Object> allKeys = new HashSet<Object>(newProperties.keySet());
        ConfigManager configManager = this;
        synchronized (configManager) {
            this.handler.invalidate();
            oldProperties = this.properties;
            this.properties = newProperties;
        }
        this.updateRSProfile();
        allKeys.addAll(oldProperties.keySet());
        for (Object e : allKeys) {
            String newValue;
            String[] split = ConfigManager.splitKey((String)e);
            if (split == null) continue;
            String groupName = split[0];
            String profile = split[1];
            String key = split[2];
            String oldValue = (String)oldProperties.get(e);
            if (Objects.equals(oldValue, newValue = (String)newProperties.get(e))) continue;
            log.debug("Loading configuration value {}: {}", e, (Object)newValue);
            ConfigChanged configChanged = new ConfigChanged();
            configChanged.setGroup(groupName);
            configChanged.setProfile(profile);
            configChanged.setKey(key);
            configChanged.setOldValue(oldValue);
            configChanged.setNewValue(newValue);
            this.eventBus.post(configChanged);
            if (!saveToServer) continue;
            Map<String, String> map = this.pendingChanges;
            synchronized (map) {
                this.pendingChanges.put((String)e, newValue);
            }
        }
    }

    private void syncPropertiesFromFile(File propertiesFile) {
        Properties properties2 = new Properties();
        try (FileInputStream in = new FileInputStream(propertiesFile);){
            properties2.load(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("Malformed properties, skipping update");
            return;
        }
        log.debug("Loading in config from disk for upload");
        this.swapProperties(properties2, true);
    }

    public Future<Void> importLocal() {
        if (this.session == null) {
            return null;
        }
        File file = new File(this.propertiesFile.getParent(), this.propertiesFile.getName() + "." + TIME_FORMAT.format(new Date()));
        try {
            this.saveToFile(file);
        }
        catch (IOException e) {
            log.warn("Backup failed, skipping import", e);
            return null;
        }
        this.syncPropertiesFromFile(this.getLocalPropertiesFile());
        return this.sendConfig();
    }

    private synchronized void loadFromFile() {
        Properties newProperties = new Properties();
        try (FileInputStream in = new FileInputStream(this.propertiesFile);){
            newProperties.load(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException ex) {
            log.debug("Unable to load settings - no such file");
        }
        catch (IOException | IllegalArgumentException ex) {
            log.warn("Unable to load settings", ex);
        }
        log.debug("Loading in config from disk");
        this.swapProperties(newProperties, false);
    }

    private void saveToFile(File propertiesFile) throws IOException {
        File parent = propertiesFile.getParentFile();
        parent.mkdirs();
        File tempFile = File.createTempFile("runelite", null, parent);
        try (FileOutputStream out = new FileOutputStream(tempFile);
             FileChannel channel = out.getChannel();
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            channel.lock();
            this.properties.store(writer, "RuneLite configuration");
            channel.force(true);
        }
        try {
            Files.move(tempFile.toPath(), propertiesFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException ex) {
            log.debug("atomic move not supported", ex);
            Files.move(tempFile.toPath(), propertiesFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public <T extends Config> T getConfig(Class<T> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new RuntimeException("Non-public configuration classes can't have default methods invoked");
        }
        Config t = (Config)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.handler);
        return (T)t;
    }

    public List<String> getConfigurationKeys(String prefix) {
        return this.properties.keySet().stream().filter(v -> ((String)v).startsWith(prefix)).map(String.class::cast).collect(Collectors.toList());
    }

    public static String getWholeKey(String groupName, String profile, String key) {
        if (profile == null) {
            return groupName + "." + key;
        }
        return groupName + "." + profile + "." + key;
    }

    public String getConfiguration(String groupName, String key) {
        return this.getConfiguration(groupName, null, key);
    }

    public String getRSProfileConfiguration(String groupName, String key) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            return null;
        }
        return this.getConfiguration(groupName, rsProfileKey, key);
    }

    public String getConfiguration(String groupName, String profile, String key) {
        return this.properties.getProperty(ConfigManager.getWholeKey(groupName, profile, key));
    }

    public <T> T getConfiguration(String groupName, String key, Type clazz) {
        return this.getConfiguration(groupName, null, key, clazz);
    }

    public <T> T getRSProfileConfiguration(String groupName, String key, Type clazz) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            return null;
        }
        return this.getConfiguration(groupName, rsProfileKey, key, clazz);
    }

    public <T> T getConfiguration(String groupName, String profile, String key, Type type2) {
        String value = this.getConfiguration(groupName, profile, key);
        if (!Strings.isNullOrEmpty(value)) {
            try {
                return (T)this.stringToObject(value, type2);
            }
            catch (Exception e) {
                log.warn("Unable to unmarshal {} ", (Object)ConfigManager.getWholeKey(groupName, profile, key), (Object)e);
            }
        }
        return null;
    }

    public void setConfiguration(String groupName, String key, String value) {
        this.setConfiguration(groupName, (String)null, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(String groupName, String profile, String key, @NonNull String value) {
        String oldValue;
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty(groupName) || Strings.isNullOrEmpty(key) || key.indexOf(58) != -1) {
            throw new IllegalArgumentException();
        }
        assert (!key.startsWith("rsprofile."));
        String wholeKey = ConfigManager.getWholeKey(groupName, profile, key);
        Object object = this;
        synchronized (object) {
            oldValue = (String)this.properties.setProperty(wholeKey, value);
        }
        if (Objects.equals(oldValue, value)) {
            return;
        }
        log.debug("Setting configuration value for {} to {}", (Object)wholeKey, (Object)value);
        this.handler.invalidate();
        object = this.pendingChanges;
        synchronized (object) {
            this.pendingChanges.put(wholeKey, value);
        }
        ConfigChanged configChanged = new ConfigChanged();
        configChanged.setGroup(groupName);
        configChanged.setProfile(profile);
        configChanged.setKey(key);
        configChanged.setOldValue(oldValue);
        configChanged.setNewValue(value);
        this.eventBus.post(configChanged);
    }

    public <T> void setConfiguration(String groupName, String profile, String key, T value) {
        this.setConfiguration(groupName, profile, key, this.objectToString(value));
    }

    public <T> void setConfiguration(String groupName, String key, T value) {
        this.setConfiguration(groupName, null, key, value);
    }

    public <T> void setRSProfileConfiguration(String groupName, String key, T value) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            if (this.client == null) {
                log.warn("trying to use profile without injected client");
                return;
            }
            String displayName = null;
            Player p = this.client.getLocalPlayer();
            if (p == null) {
                log.warn("trying to create profile without display name");
            } else {
                displayName = p.getName();
            }
            String username = this.client.getUsername();
            if (Strings.isNullOrEmpty(username)) {
                log.warn("trying to create profile without a set username");
                return;
            }
            RuneScapeProfile prof = this.findRSProfile(this.getRSProfiles(), username, RuneScapeProfileType.getCurrent(this.client), displayName, true);
            this.rsProfileKey = rsProfileKey = prof.getKey();
        }
        this.setConfiguration(groupName, rsProfileKey, key, value);
    }

    public void unsetConfiguration(String groupName, String key) {
        this.unsetConfiguration(groupName, null, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetConfiguration(String groupName, String profile, String key) {
        String oldValue;
        assert (!key.startsWith("rsprofile."));
        String wholeKey = ConfigManager.getWholeKey(groupName, profile, key);
        Object object = this;
        synchronized (object) {
            oldValue = (String)this.properties.remove(wholeKey);
        }
        if (oldValue == null) {
            return;
        }
        log.debug("Unsetting configuration value for {}", (Object)wholeKey);
        this.handler.invalidate();
        object = this.pendingChanges;
        synchronized (object) {
            this.pendingChanges.put(wholeKey, null);
        }
        ConfigChanged configChanged = new ConfigChanged();
        configChanged.setGroup(groupName);
        configChanged.setProfile(profile);
        configChanged.setKey(key);
        configChanged.setOldValue(oldValue);
        this.eventBus.post(configChanged);
    }

    public void unsetRSProfileConfiguration(String groupName, String key) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            return;
        }
        this.unsetConfiguration(groupName, rsProfileKey, key);
    }

    public ConfigDescriptor getConfigDescriptor(Config configurationProxy) {
        Class<?> inter = configurationProxy.getClass().getInterfaces()[0];
        ConfigGroup group = inter.getAnnotation(ConfigGroup.class);
        if (group == null) {
            throw new IllegalArgumentException("Not a config group");
        }
        List<ConfigSectionDescriptor> sections = Arrays.stream(inter.getDeclaredFields()).filter(m3 -> m3.isAnnotationPresent(ConfigSection.class) && m3.getType() == String.class).map(m3 -> {
            try {
                return new ConfigSectionDescriptor(String.valueOf(m3.get(inter)), m3.getDeclaredAnnotation(ConfigSection.class));
            }
            catch (IllegalAccessException e) {
                log.warn("Unable to load section {}::{}", (Object)inter.getSimpleName(), (Object)m3.getName());
                return null;
            }
        }).filter(Objects::nonNull).sorted((a, b) -> ComparisonChain.start().compare(a.getSection().position(), b.getSection().position()).compare((Comparable<?>)((Object)a.getSection().name()), (Comparable<?>)((Object)b.getSection().name())).result()).collect(Collectors.toList());
        List<ConfigItemDescriptor> items = Arrays.stream(inter.getMethods()).filter(m3 -> m3.getParameterCount() == 0 && m3.isAnnotationPresent(ConfigItem.class)).map(m3 -> new ConfigItemDescriptor(m3.getDeclaredAnnotation(ConfigItem.class), m3.getGenericReturnType(), m3.getDeclaredAnnotation(Range.class), m3.getDeclaredAnnotation(Alpha.class), m3.getDeclaredAnnotation(Units.class))).sorted((a, b) -> ComparisonChain.start().compare(a.getItem().position(), b.getItem().position()).compare((Comparable<?>)((Object)a.getItem().name()), (Comparable<?>)((Object)b.getItem().name())).result()).collect(Collectors.toList());
        return new ConfigDescriptor(group, sections, items);
    }

    public void setDefaultConfiguration(Object proxy, boolean override) {
        Class<?> clazz = proxy.getClass().getInterfaces()[0];
        ConfigGroup group = clazz.getAnnotation(ConfigGroup.class);
        if (group == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Object defaultValue;
            String current;
            ConfigItem item = method.getAnnotation(ConfigItem.class);
            if (item == null || method.getParameterCount() != 0) continue;
            if (!method.isDefault()) {
                if (!override || (current = this.getConfiguration(group.value(), item.keyName())) == null) continue;
                this.unsetConfiguration(group.value(), item.keyName());
                continue;
            }
            if (!override && (current = this.getConfiguration(group.value(), item.keyName(), method.getGenericReturnType())) != null) continue;
            try {
                defaultValue = ConfigInvocationHandler.callDefaultMethod(proxy, method, null);
            }
            catch (Throwable ex) {
                log.warn(null, ex);
                continue;
            }
            String current2 = this.getConfiguration(group.value(), item.keyName());
            String valueString = this.objectToString(defaultValue);
            if (Objects.equals(current2, valueString) || Strings.isNullOrEmpty(current2) && Strings.isNullOrEmpty(valueString)) continue;
            log.debug("Setting default configuration value for {}.{} to {}", group.value(), item.keyName(), defaultValue);
            this.setConfiguration(group.value(), item.keyName(), valueString);
        }
    }

    Object stringToObject(String str, Type type2) {
        ParameterizedType parameterizedType;
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return Boolean.parseBoolean(str);
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return Integer.parseInt(str);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return Double.parseDouble(str);
        }
        if (type2 == Color.class) {
            return ColorUtil.fromString(str);
        }
        if (type2 == Dimension.class) {
            String[] splitStr = str.split("x");
            int width = Integer.parseInt(splitStr[0]);
            int height = Integer.parseInt(splitStr[1]);
            return new Dimension(width, height);
        }
        if (type2 == Point.class) {
            String[] splitStr = str.split(":");
            int width = Integer.parseInt(splitStr[0]);
            int height = Integer.parseInt(splitStr[1]);
            return new Point(width, height);
        }
        if (type2 == Rectangle.class) {
            String[] splitStr = str.split(":");
            int x = Integer.parseInt(splitStr[0]);
            int y = Integer.parseInt(splitStr[1]);
            int width = Integer.parseInt(splitStr[2]);
            int height = Integer.parseInt(splitStr[3]);
            return new Rectangle(x, y, width, height);
        }
        if (type2 instanceof Class && ((Class)type2).isEnum()) {
            return Enum.valueOf((Class)type2, str);
        }
        if (type2 == Instant.class) {
            return Instant.parse(str);
        }
        if (type2 == Keybind.class || type2 == ModifierlessKeybind.class) {
            String[] splitStr = str.split(":");
            int code = Integer.parseInt(splitStr[0]);
            int mods = Integer.parseInt(splitStr[1]);
            if (type2 == ModifierlessKeybind.class) {
                return new ModifierlessKeybind(code, mods);
            }
            return new Keybind(code, mods);
        }
        if (type2 == WorldPoint.class) {
            String[] splitStr = str.split(":");
            int x = Integer.parseInt(splitStr[0]);
            int y = Integer.parseInt(splitStr[1]);
            int plane = Integer.parseInt(splitStr[2]);
            return new WorldPoint(x, y, plane);
        }
        if (type2 == Duration.class) {
            return Duration.ofMillis(Long.parseLong(str));
        }
        if (type2 == byte[].class) {
            return Base64.getUrlDecoder().decode(str);
        }
        if (type2 instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type2).getRawType() == Set.class) {
            return this.gson.fromJson(str, (Type)parameterizedType);
        }
        return str;
    }

    @Nullable
    String objectToString(Object object) {
        if (object instanceof Color) {
            return String.valueOf(((Color)object).getRGB());
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (object instanceof Dimension) {
            Dimension d = (Dimension)object;
            return d.width + "x" + d.height;
        }
        if (object instanceof Point) {
            Point p = (Point)object;
            return p.x + ":" + p.y;
        }
        if (object instanceof Rectangle) {
            Rectangle r = (Rectangle)object;
            return r.x + ":" + r.y + ":" + r.width + ":" + r.height;
        }
        if (object instanceof Instant) {
            return ((Instant)object).toString();
        }
        if (object instanceof Keybind) {
            Keybind k = (Keybind)object;
            return k.getKeyCode() + ":" + k.getModifiers();
        }
        if (object instanceof WorldPoint) {
            WorldPoint wp = (WorldPoint)object;
            return wp.getX() + ":" + wp.getY() + ":" + wp.getPlane();
        }
        if (object instanceof Duration) {
            return Long.toString(((Duration)object).toMillis());
        }
        if (object instanceof byte[]) {
            return Base64.getUrlEncoder().encodeToString((byte[])object);
        }
        if (object instanceof Set) {
            return this.gson.toJson(object, (Type)((Object)Set.class));
        }
        return object == null ? null : object.toString();
    }

    @Subscribe(priority=-100.0f)
    private void onClientShutdown(ClientShutdown e) {
        CompletableFuture<Void> f = this.sendConfig();
        if (f != null) {
            e.waitFor(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CompletableFuture<Void> sendConfig() {
        CompletableFuture<Void> future = null;
        Map<String, String> map = this.pendingChanges;
        synchronized (map) {
            if (this.pendingChanges.isEmpty()) {
                return null;
            }
            if (this.session != null) {
                Configuration patch = new Configuration(this.pendingChanges.entrySet().stream().map(e -> new ConfigEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
                future = this.configClient.patch(patch);
            }
            this.pendingChanges.clear();
        }
        try {
            this.saveToFile(this.propertiesFile);
        }
        catch (IOException ex) {
            log.warn("unable to save configuration file", ex);
        }
        return future;
    }

    public List<RuneScapeProfile> getRSProfiles() {
        String prefix = "rsprofile.rsprofile.";
        HashSet<String> profileKeys = new HashSet<String>();
        for (Object oKey : this.properties.keySet()) {
            String[] split;
            String key2 = (String)oKey;
            if (!key2.startsWith(prefix) || (split = ConfigManager.splitKey(key2)) == null) continue;
            profileKeys.add(split[1]);
        }
        return profileKeys.stream().map(key -> {
            RuneScapeProfile prof = new RuneScapeProfile(this.getConfiguration(RSPROFILE_GROUP, (String)key, RSPROFILE_DISPLAY_NAME), (RuneScapeProfileType)((Object)((Object)this.getConfiguration(RSPROFILE_GROUP, (String)key, RSPROFILE_TYPE, (Type)((Object)RuneScapeProfileType.class)))), (byte[])this.getConfiguration(RSPROFILE_GROUP, (String)key, RSPROFILE_LOGIN_HASH, (Type)((Object)byte[].class)), (String)key);
            return prof;
        }).collect(Collectors.toList());
    }

    private synchronized RuneScapeProfile findRSProfile(List<RuneScapeProfile> profiles, String username, RuneScapeProfileType type2, String displayName, boolean create) {
        byte[] salt = (byte[])this.getConfiguration(RSPROFILE_GROUP, RSPROFILE_LOGIN_SALT, (Type)((Object)byte[].class));
        if (salt == null) {
            salt = new byte[15];
            new SecureRandom().nextBytes(salt);
            log.info("creating new salt as there is no existing one {}", (Object)Base64.getUrlEncoder().encodeToString(salt));
            this.setConfiguration(RSPROFILE_GROUP, RSPROFILE_LOGIN_SALT, salt);
        }
        Hasher h2 = Hashing.sha512().newHasher();
        h2.putBytes(salt);
        h2.putString(username.toLowerCase(Locale.US), StandardCharsets.UTF_8);
        byte[] loginHash = h2.hash().asBytes();
        Set matches = profiles.stream().filter(p -> Arrays.equals(p.getLoginHash(), loginHash) && p.getType() == type2).collect(Collectors.toSet());
        if (matches.size() > 1) {
            log.warn("multiple matching profiles");
        }
        if (matches.size() >= 1) {
            return (RuneScapeProfile)matches.iterator().next();
        }
        if (!create) {
            return null;
        }
        Set keys2 = profiles.stream().map(RuneScapeProfile::getKey).collect(Collectors.toSet());
        byte[] key = Arrays.copyOf(loginHash, 6);
        key[0] = (byte)(key[0] + type2.ordinal());
        for (int i = 0; i < 255; ++i) {
            String keyStr = "rsprofile." + Base64.getUrlEncoder().encodeToString(key);
            if (!keys2.contains(keyStr)) {
                log.info("creating new profile {} for user {} ({}) salt {}", new Object[]{keyStr, username, type2, Base64.getUrlEncoder().encodeToString(salt)});
                this.setConfiguration(RSPROFILE_GROUP, keyStr, RSPROFILE_LOGIN_HASH, loginHash);
                this.setConfiguration(RSPROFILE_GROUP, keyStr, RSPROFILE_TYPE, type2);
                if (displayName != null) {
                    this.setConfiguration(RSPROFILE_GROUP, keyStr, RSPROFILE_DISPLAY_NAME, displayName);
                }
                return new RuneScapeProfile(displayName, type2, loginHash, keyStr);
            }
            key[1] = (byte)(key[1] + 1);
        }
        throw new RuntimeException("too many rs profiles");
    }

    private void updateRSProfile() {
        String key;
        if (this.client == null) {
            return;
        }
        List<RuneScapeProfile> profiles = this.getRSProfiles();
        RuneScapeProfile prof = this.findRSProfile(profiles, this.client.getUsername(), RuneScapeProfileType.getCurrent(this.client), null, false);
        String string2 = key = prof == null ? null : prof.getKey();
        if (Objects.equals(key, this.rsProfileKey)) {
            return;
        }
        this.rsProfileKey = key;
        this.eventBus.post(new RuneScapeProfileChanged());
    }

    @Subscribe
    private void onUsernameChanged(UsernameChanged ev) {
        this.updateRSProfile();
    }

    @Subscribe
    private void onWorldChanged(WorldChanged ev) {
        this.updateRSProfile();
    }

    @Subscribe
    private void onPlayerChanged(PlayerChanged ev) {
        if (ev.getPlayer() == this.client.getLocalPlayer()) {
            String name = ev.getPlayer().getName();
            this.setRSProfileConfiguration(RSPROFILE_GROUP, RSPROFILE_DISPLAY_NAME, name);
        }
    }

    @Nullable
    @VisibleForTesting
    static String[] splitKey(String key) {
        int i = key.indexOf(46);
        if (i == -1) {
            return null;
        }
        String group = key.substring(0, i);
        String profile = null;
        if ((key = key.substring(i + 1)).startsWith("rsprofile.")) {
            i = key.indexOf(46, RSPROFILE_GROUP.length() + 2);
            profile = key.substring(0, i);
            key = key.substring(i + 1);
        }
        return new String[]{group, profile, key};
    }
}

