/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.calculator.ui;

import javax.swing.JTextField;

public class DisplayField
extends JTextField {
    private Integer num1;
    private Integer num2;
    private Action calculatorAction;
    private Integer result;
    private Integer previousResult;
    private String text;
    private boolean finished = true;

    protected void calculateResult() {
        if (this.num1 == null || this.num2 == null || this.calculatorAction == null) {
            return;
        }
        switch (this.calculatorAction) {
            case ADDITION: {
                this.result = this.num1 + this.num2;
                break;
            }
            case SUBTRACTION: {
                this.result = this.num1 - this.num2;
                break;
            }
            case MULTIPLICATION: {
                this.result = this.num1 * this.num2;
                break;
            }
            case DIVISION: {
                if (this.num2 == 0) {
                    this.reset();
                    super.setText("Error: Cannot divide by 0!");
                    this.finished = true;
                    break;
                }
                this.result = this.num1 / this.num2;
            }
        }
        this.previousResult = this.result;
        this.finished = true;
    }

    protected void reset() {
        this.num1 = null;
        this.num2 = null;
        this.calculatorAction = null;
        this.result = null;
        this.text = null;
        this.update();
    }

    protected void clear() {
        this.reset();
        this.finished = true;
        this.previousResult = null;
    }

    protected void update() {
        this.text = this.num1 == null ? "" : (this.calculatorAction == null ? this.num1.toString() : (this.num2 == null ? String.join((CharSequence)" ", this.num1.toString(), this.calculatorAction.getCharacter()) : (this.result == null ? String.join((CharSequence)" ", this.num1.toString(), this.calculatorAction.getCharacter(), this.num2.toString()) : String.join((CharSequence)" ", this.num1.toString(), this.calculatorAction.getCharacter(), this.num2.toString(), "=", this.result.toString()))));
        super.setText(this.text);
        this.repaint();
    }

    protected boolean num1IsNegativeZero() {
        return this.num1 == 0 && this.num1.toString().length() == 2;
    }

    protected boolean num2IsNegativeZero() {
        if (this.num2 == null) {
            return false;
        }
        return this.num2 == 0 && this.num2.toString().length() == 2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayField)) {
            return false;
        }
        DisplayField other = (DisplayField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isFinished() != other.isFinished()) {
            return false;
        }
        Integer this$num1 = this.getNum1();
        Integer other$num1 = other.getNum1();
        if (this$num1 == null ? other$num1 != null : !((Object)this$num1).equals(other$num1)) {
            return false;
        }
        Integer this$num2 = this.getNum2();
        Integer other$num2 = other.getNum2();
        if (this$num2 == null ? other$num2 != null : !((Object)this$num2).equals(other$num2)) {
            return false;
        }
        Integer this$result = this.getResult();
        Integer other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        Integer this$previousResult = this.getPreviousResult();
        Integer other$previousResult = other.getPreviousResult();
        if (this$previousResult == null ? other$previousResult != null : !((Object)this$previousResult).equals(other$previousResult)) {
            return false;
        }
        Action this$calculatorAction = this.getCalculatorAction();
        Action other$calculatorAction = other.getCalculatorAction();
        if (this$calculatorAction == null ? other$calculatorAction != null : !((Object)((Object)this$calculatorAction)).equals((Object)other$calculatorAction)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DisplayField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        result2 = result2 * 59 + (this.isFinished() ? 79 : 97);
        Integer $num1 = this.getNum1();
        result2 = result2 * 59 + ($num1 == null ? 43 : ((Object)$num1).hashCode());
        Integer $num2 = this.getNum2();
        result2 = result2 * 59 + ($num2 == null ? 43 : ((Object)$num2).hashCode());
        Integer $result = this.getResult();
        result2 = result2 * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        Integer $previousResult = this.getPreviousResult();
        result2 = result2 * 59 + ($previousResult == null ? 43 : ((Object)$previousResult).hashCode());
        Action $calculatorAction = this.getCalculatorAction();
        result2 = result2 * 59 + ($calculatorAction == null ? 43 : ((Object)((Object)$calculatorAction)).hashCode());
        String $text = this.getText();
        result2 = result2 * 59 + ($text == null ? 43 : $text.hashCode());
        return result2;
    }

    public Integer getNum1() {
        return this.num1;
    }

    public Integer getNum2() {
        return this.num2;
    }

    public Action getCalculatorAction() {
        return this.calculatorAction;
    }

    public Integer getResult() {
        return this.result;
    }

    public Integer getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setNum1(Integer num1) {
        this.num1 = num1;
    }

    public void setNum2(Integer num2) {
        this.num2 = num2;
    }

    public void setCalculatorAction(Action calculatorAction) {
        this.calculatorAction = calculatorAction;
    }

    public void setResult(Integer result2) {
        this.result = result2;
    }

    public void setPreviousResult(Integer previousResult) {
        this.previousResult = previousResult;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public String toString() {
        return "DisplayField(num1=" + this.getNum1() + ", num2=" + this.getNum2() + ", calculatorAction=" + this.getCalculatorAction() + ", result=" + this.getResult() + ", previousResult=" + this.getPreviousResult() + ", text=" + this.getText() + ", finished=" + this.isFinished() + ")";
    }

    protected static enum Action {
        ADDITION("+"),
        SUBTRACTION("-"),
        MULTIPLICATION("*"),
        DIVISION("/");

        private final String character;

        private Action(String character) {
            this.character = character;
        }

        public String getCharacter() {
            return this.character;
        }
    }
}

