/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.data.materials;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.data.WaterType;
import net.runelite.client.plugins.hd.data.environments.Area;
import net.runelite.client.plugins.hd.data.materials.GroundMaterial;

class TileOverrideBuilder<T> {
    public Integer[] ids = null;
    public Area area = Area.ALL;
    public GroundMaterial groundMaterial = GroundMaterial.NONE;
    public WaterType waterType = WaterType.NONE;
    public boolean blended = true;
    public boolean blendedAsOpposite = false;
    public int hue = -1;
    public int shiftHue = 0;
    public int saturation = -1;
    public int shiftSaturation = 0;
    public int lightness = -1;
    public int shiftLightness = 0;
    public T replacement;
    public Function<HdPlugin, Boolean> replacementCondition = c -> false;

    TileOverrideBuilder() {
    }

    TileOverrideBuilder<T> apply(Consumer<TileOverrideBuilder<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    TileOverrideBuilder<T> ids(Integer ... ids) {
        if (this.ids != null && this.ids.length > 0) {
            throw new IllegalStateException("Attempted to overwrite IDs " + Arrays.toString((Object[])this.ids) + " with IDs " + Arrays.toString((Object[])ids) + " in " + TileOverrideBuilder.class.getSimpleName() + ".This is likely a mistake.");
        }
        this.ids = ids;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] >= 0) continue;
            Integer[] integerArray = ids;
            int n = i;
            Integer.valueOf(integerArray[n] & 0xFF);
        }
        return this;
    }

    TileOverrideBuilder<T> waterType(WaterType waterType) {
        this.waterType = waterType;
        this.groundMaterial = GroundMaterial.NONE;
        return this;
    }

    TileOverrideBuilder<T> replaceWithIf(@NonNull T replacement, @NonNull Function<HdPlugin, Boolean> condition) {
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.replacement = replacement;
        this.replacementCondition = condition;
        return this;
    }

    public TileOverrideBuilder<T> area(Area area) {
        this.area = area;
        return this;
    }

    public TileOverrideBuilder<T> groundMaterial(GroundMaterial groundMaterial) {
        this.groundMaterial = groundMaterial;
        return this;
    }

    public TileOverrideBuilder<T> blended(boolean blended) {
        this.blended = blended;
        return this;
    }

    public TileOverrideBuilder<T> blendedAsOpposite(boolean blendedAsOpposite) {
        this.blendedAsOpposite = blendedAsOpposite;
        return this;
    }

    public TileOverrideBuilder<T> hue(int hue) {
        this.hue = hue;
        return this;
    }

    public TileOverrideBuilder<T> shiftHue(int shiftHue) {
        this.shiftHue = shiftHue;
        return this;
    }

    public TileOverrideBuilder<T> saturation(int saturation) {
        this.saturation = saturation;
        return this;
    }

    public TileOverrideBuilder<T> shiftSaturation(int shiftSaturation) {
        this.shiftSaturation = shiftSaturation;
        return this;
    }

    public TileOverrideBuilder<T> lightness(int lightness) {
        this.lightness = lightness;
        return this;
    }

    public TileOverrideBuilder<T> shiftLightness(int shiftLightness) {
        this.shiftLightness = shiftLightness;
        return this;
    }

    public TileOverrideBuilder<T> replacement(T replacement) {
        this.replacement = replacement;
        return this;
    }

    public TileOverrideBuilder<T> replacementCondition(Function<HdPlugin, Boolean> replacementCondition) {
        this.replacementCondition = replacementCondition;
        return this;
    }
}

