/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.model;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.runelite.client.plugins.hd.model.BufferPool;
import net.runelite.client.plugins.hd.model.FloatBufferCache;
import net.runelite.client.plugins.hd.model.IntBufferCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCache {
    private static final Logger log = LoggerFactory.getLogger(ModelCache.class);
    public static final long KiB = 1024L;
    public static final long MiB = 0x100000L;
    public static final long GiB = 0x40000000L;
    private final BufferPool bufferPool;
    private final IntBufferCache vertexDataCache;
    private final FloatBufferCache normalDataCache;
    private final FloatBufferCache uvDataCache;

    public ModelCache(int modelCacheSizeMiB) {
        if (modelCacheSizeMiB > 512 && !"64".equals(System.getProperty("sun.arch.data.model"))) {
            log.warn("Defaulting model cache to 512MiB due to non 64-bit client");
            modelCacheSizeMiB = 512;
        }
        try {
            int totalPhysicalMemoryMiB = (int)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 0x100000L);
            if (modelCacheSizeMiB > totalPhysicalMemoryMiB / 2) {
                log.warn("Limiting cache size to {} since the selected amount ({}) exceeds half of the total physical memory for the system ({} / 2).", totalPhysicalMemoryMiB / 2, modelCacheSizeMiB, totalPhysicalMemoryMiB);
                modelCacheSizeMiB = totalPhysicalMemoryMiB / 2;
            }
        }
        catch (Throwable e) {
            log.warn("Unable to check physical memory size: " + e);
        }
        this.bufferPool = new BufferPool((long)modelCacheSizeMiB * 0x100000L);
        this.vertexDataCache = new IntBufferCache(this.bufferPool);
        this.normalDataCache = new FloatBufferCache(this.bufferPool);
        this.uvDataCache = new FloatBufferCache(this.bufferPool);
    }

    public void destroy() {
        this.clear();
        if (this.bufferPool != null) {
            this.bufferPool.freeAllocations();
        }
    }

    public IntBuffer getVertexData(int hash) {
        return (IntBuffer)this.vertexDataCache.get(hash);
    }

    public void putVertexData(int hash, IntBuffer data2) {
        this.vertexDataCache.put(hash, data2);
    }

    public FloatBuffer getNormalData(int hash) {
        return (FloatBuffer)this.normalDataCache.get(hash);
    }

    public void putNormalData(int hash, FloatBuffer data2) {
        this.normalDataCache.put(hash, data2);
    }

    public FloatBuffer getUvData(int hash) {
        return (FloatBuffer)this.uvDataCache.get(hash);
    }

    public void putUvData(int hash, FloatBuffer data2) {
        this.uvDataCache.put(hash, data2);
    }

    public IntBuffer takeIntBuffer(int capacity) {
        if (this.bufferPool.isEmpty() && !this.makeRoom()) {
            log.error("failed to make room for int buffer");
        }
        return this.bufferPool.takeIntBuffer(capacity);
    }

    public FloatBuffer takeFloatBuffer(int capacity) {
        if (this.bufferPool.isEmpty() && !this.makeRoom()) {
            log.error("failed to make room for float buffer");
        }
        return this.bufferPool.takeFloatBuffer(capacity);
    }

    public boolean makeRoom() {
        if (this.uvDataCache.size() * 16 > this.normalDataCache.size() && this.normalDataCache.size() > 0) {
            return this.uvDataCache.makeRoom();
        }
        if (this.normalDataCache.size() * 2 > this.vertexDataCache.size()) {
            return this.normalDataCache.makeRoom();
        }
        return this.vertexDataCache.makeRoom();
    }

    public void clear() {
        if (this.vertexDataCache != null) {
            this.vertexDataCache.clear();
        }
        if (this.normalDataCache != null) {
            this.normalDataCache.clear();
        }
        if (this.uvDataCache != null) {
            this.uvDataCache.clear();
        }
    }
}

