/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.opengl.shader;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import net.runelite.client.plugins.hd.utils.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private final List<Function<String, String>> resourceLoaders = new ArrayList<Function<String, String>>();
    private final Stack<Integer> includeStack = new Stack();
    IncludeType includeType = IncludeType.UNKNOWN;
    final ArrayList<String> includeList = new ArrayList();

    public String process(String str) {
        StringBuilder sb = new StringBuilder();
        int lineCount = 0;
        for (String line : str.split("\r?\n")) {
            int currentIndex;
            ++lineCount;
            String trimmed = line.trim();
            if (trimmed.startsWith("#include ")) {
                currentIndex = this.includeStack.peek();
                String currentFile = this.includeList.get(currentIndex);
                String includeFile = trimmed.substring(9);
                int includeIndex = this.includeList.size();
                this.includeList.add(includeFile);
                this.includeStack.push(includeIndex);
                String includeContents = this.loadInternal(includeFile);
                this.includeStack.pop();
                switch (this.includeType) {
                    case GLSL: {
                        if (includeContents.trim().startsWith("#version ")) {
                            sb.append(includeContents);
                            break;
                        }
                        sb.append("#line 1 ").append(includeIndex).append("\n").append(includeContents).append("#line ").append(lineCount + 1).append(" ").append(currentIndex).append("\n");
                        break;
                    }
                    case C: {
                        sb.append("#line 1 \"").append(includeFile).append("\"\n").append(includeContents).append("#line ").append(lineCount + 1).append(" \"").append(currentFile).append("\"\n");
                        break;
                    }
                    default: {
                        sb.append(includeContents);
                        break;
                    }
                }
                continue;
            }
            if (trimmed.startsWith("#pragma once")) {
                currentIndex = this.includeList.size() - 1;
                String currentInclude = this.includeList.get(currentIndex);
                if (this.includeList.indexOf(currentInclude) == currentIndex) continue;
                sb.append("// Already included\n");
                break;
            }
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private String loadInternal(String filename) {
        for (Function<String, String> loader : this.resourceLoaders) {
            String value = loader.apply(filename);
            if (value == null) continue;
            return this.process(value);
        }
        return "";
    }

    public String load(String filename) {
        this.includeList.clear();
        this.includeList.add(filename);
        this.includeStack.add(0);
        switch (ResourcePath.path(filename).getExtension().toLowerCase()) {
            case "glsl": {
                this.includeType = IncludeType.GLSL;
                break;
            }
            case "c": 
            case "h": 
            case "cl": {
                this.includeType = IncludeType.C;
                break;
            }
            default: {
                this.includeType = IncludeType.UNKNOWN;
            }
        }
        return this.loadInternal(filename);
    }

    public Template add(Function<String, String> fn) {
        this.resourceLoaders.add(fn);
        return this;
    }

    public Template addInclude(Class<?> clazz) {
        return this.add(f -> {
            try (InputStream is = clazz.getResourceAsStream((String)f);){
                if (is == null) return null;
                String string2 = Template.inputStreamToString(is);
                return string2;
            }
            catch (IOException ex) {
                log.warn(null, ex);
            }
            return null;
        });
    }

    public static String inputStreamToString(InputStream in) {
        try {
            return CharStreams.toString(new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static enum IncludeType {
        GLSL,
        C,
        UNKNOWN;

    }
}

