/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.config.DefaultSkyColor;
import net.runelite.client.plugins.hd.data.environments.Area;
import net.runelite.client.plugins.hd.data.environments.Environment;
import net.runelite.client.plugins.hd.scene.SceneContext;
import net.runelite.client.plugins.hd.utils.AABB;
import net.runelite.client.plugins.hd.utils.HDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnvironmentManager {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentManager.class);
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    private final Environment defaultEnvironment;
    private Environment currentEnvironment;
    private static final int TRANSITION_DURATION = 3000;
    private static final int SKIP_TRANSITION_DISTANCE = 41;
    private long startTime;
    private long transitionCompleteTime;
    long lastFrameTime;
    private WorldPoint previousPosition;
    public static final float[] BLACK_COLOR = new float[]{0.0f, 0.0f, 0.0f};
    private float[] startFogColor;
    public float[] currentFogColor;
    private float[] targetFogColor;
    private float[] startWaterColor;
    public float[] currentWaterColor;
    private float[] targetWaterColor;
    private int startFogDepth;
    public int currentFogDepth;
    private int targetFogDepth;
    private float startAmbientStrength;
    public float currentAmbientStrength;
    private float targetAmbientStrength;
    private float[] startAmbientColor;
    public float[] currentAmbientColor;
    private float[] targetAmbientColor;
    private float startDirectionalStrength;
    public float currentDirectionalStrength;
    private float targetDirectionalStrength;
    private float[] startUnderwaterCausticsColor;
    public float[] currentUnderwaterCausticsColor;
    private float[] targetUnderwaterCausticsColor;
    private float startUnderwaterCausticsStrength;
    public float currentUnderwaterCausticsStrength;
    private float targetUnderwaterCausticsStrength;
    private float[] startDirectionalColor;
    public float[] currentDirectionalColor;
    private float[] targetDirectionalColor;
    private float startUnderglowStrength;
    public float currentUnderglowStrength;
    private float targetUnderglowStrength;
    private float[] startUnderglowColor;
    public float[] currentUnderglowColor;
    private float[] targetUnderglowColor;
    private float startGroundFogStart;
    public float currentGroundFogStart;
    private float targetGroundFogStart;
    private float startGroundFogEnd;
    public float currentGroundFogEnd;
    private float targetGroundFogEnd;
    private float startGroundFogOpacity;
    public float currentGroundFogOpacity;
    private float targetGroundFogOpacity;
    private float startLightPitch;
    public float currentLightPitch;
    private float targetLightPitch;
    private float startLightYaw;
    public float currentLightYaw;
    private float targetLightYaw;
    private boolean lightningEnabled;
    private boolean isOverworld;
    private boolean isInHouse;
    private int previousPlane;
    private static final float[] LIGHTNING_COLOR = new float[]{0.25f, 0.25f, 0.25f};
    private static final float NEW_LIGHTNING_BRIGHTNESS = 7.0f;
    private static final float LIGHTNING_FADE_SPEED = 80.0f;
    private static final int MIN_LIGHTNING_INTERVAL = 5500;
    private static final int MAX_LIGHTNING_INTERVAL = 17000;
    private static final float QUICK_LIGHTNING_CHANCE = 2.0f;
    private static final int MIN_QUICK_LIGHTNING_INTERVAL = 40;
    private static final int MAX_QUICK_LIGHTNING_INTERVAL = 150;
    private float lightningBrightness;
    private double nextLightningTime;

    public EnvironmentManager() {
        this.currentEnvironment = this.defaultEnvironment = Environment.OVERWORLD;
        this.startTime = 0L;
        this.transitionCompleteTime = 0L;
        this.lastFrameTime = -1L;
        this.previousPosition = new WorldPoint(0, 0, 0);
        this.startFogColor = new float[]{0.0f, 0.0f, 0.0f};
        this.currentFogColor = new float[]{0.0f, 0.0f, 0.0f};
        this.targetFogColor = new float[]{0.0f, 0.0f, 0.0f};
        this.startWaterColor = new float[]{0.0f, 0.0f, 0.0f};
        this.currentWaterColor = new float[]{0.0f, 0.0f, 0.0f};
        this.targetWaterColor = new float[]{0.0f, 0.0f, 0.0f};
        this.startFogDepth = 0;
        this.currentFogDepth = 0;
        this.targetFogDepth = 0;
        this.startAmbientStrength = 0.0f;
        this.currentAmbientStrength = 0.0f;
        this.targetAmbientStrength = 0.0f;
        this.startAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
        this.currentAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
        this.targetAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
        this.startDirectionalStrength = 0.0f;
        this.currentDirectionalStrength = 0.0f;
        this.targetDirectionalStrength = 0.0f;
        this.startUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
        this.currentUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
        this.targetUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
        this.startUnderwaterCausticsStrength = 1.0f;
        this.currentUnderwaterCausticsStrength = 1.0f;
        this.targetUnderwaterCausticsStrength = 1.0f;
        this.startDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
        this.currentDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
        this.targetDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
        this.startUnderglowStrength = 0.0f;
        this.currentUnderglowStrength = 0.0f;
        this.targetUnderglowStrength = 0.0f;
        this.startUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
        this.currentUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
        this.targetUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
        this.startGroundFogStart = 0.0f;
        this.currentGroundFogStart = 0.0f;
        this.targetGroundFogStart = 0.0f;
        this.startGroundFogEnd = 0.0f;
        this.currentGroundFogEnd = 0.0f;
        this.targetGroundFogEnd = 0.0f;
        this.startGroundFogOpacity = 0.0f;
        this.currentGroundFogOpacity = 0.0f;
        this.targetGroundFogOpacity = 0.0f;
        this.startLightPitch = 0.0f;
        this.currentLightPitch = 0.0f;
        this.targetLightPitch = 0.0f;
        this.startLightYaw = 0.0f;
        this.currentLightYaw = 0.0f;
        this.targetLightYaw = 0.0f;
        this.lightningEnabled = false;
        this.isOverworld = false;
        this.isInHouse = false;
        this.lightningBrightness = 0.0f;
        this.nextLightningTime = -1.0;
    }

    public void startUp() {
        this.currentEnvironment = null;
        this.changeEnvironment(this.defaultEnvironment, true);
    }

    public void update(SceneContext sceneContext, WorldPoint position) {
        int plane;
        this.isOverworld = Area.OVERWORLD.containsPoint(position);
        int tileChange = Math.max(Math.abs(position.getX() - this.previousPosition.getX()), Math.abs(position.getY() - this.previousPosition.getY()));
        this.previousPosition = position;
        if (this.isInHouse && this.previousPlane != (plane = this.client.getPlane())) {
            this.plugin.reloadSceneNextGameTick();
            this.previousPlane = plane;
        }
        boolean skipTransition = tileChange >= 41;
        for (Environment environment : sceneContext.environments) {
            if (!environment.getArea().containsPoint(position)) continue;
            if (environment == this.currentEnvironment) break;
            if (environment == Environment.PLAYER_OWNED_HOUSE || environment == Environment.PLAYER_OWNED_HOUSE_SNOWY) {
                this.plugin.reloadSceneIn(7);
                this.isInHouse = true;
            } else {
                this.plugin.abortSceneReload();
                this.isInHouse = false;
            }
            this.plugin.setInGauntlet(environment == Environment.THE_GAUNTLET || environment == Environment.THE_GAUNTLET_CORRUPTED);
            this.changeEnvironment(environment, skipTransition);
            break;
        }
        this.updateTargetSkyColor();
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.transitionCompleteTime) {
            this.currentFogColor = this.targetFogColor;
            this.currentWaterColor = this.targetWaterColor;
            this.currentFogDepth = this.targetFogDepth;
            this.currentAmbientStrength = this.targetAmbientStrength;
            this.currentAmbientColor = this.targetAmbientColor;
            this.currentDirectionalStrength = this.targetDirectionalStrength;
            this.currentDirectionalColor = this.targetDirectionalColor;
            this.currentUnderglowStrength = this.targetUnderglowStrength;
            this.currentUnderglowColor = this.targetUnderglowColor;
            this.currentGroundFogStart = this.targetGroundFogStart;
            this.currentGroundFogEnd = this.targetGroundFogEnd;
            this.currentGroundFogOpacity = this.targetGroundFogOpacity;
            this.currentLightPitch = this.targetLightPitch;
            this.currentLightYaw = this.targetLightYaw;
            this.currentUnderwaterCausticsColor = this.targetUnderwaterCausticsColor;
            this.currentUnderwaterCausticsStrength = this.targetUnderwaterCausticsStrength;
        } else {
            float t = (float)(currentTime - this.startTime) / 3000.0f;
            this.currentFogColor = HDUtils.lerpVectors(this.startFogColor, this.targetFogColor, t);
            this.currentWaterColor = HDUtils.lerpVectors(this.startWaterColor, this.targetWaterColor, t);
            this.currentFogDepth = (int)HDUtils.lerp(this.startFogDepth, this.targetFogDepth, t);
            this.currentAmbientStrength = HDUtils.lerp(this.startAmbientStrength, this.targetAmbientStrength, t);
            this.currentAmbientColor = HDUtils.lerpVectors(this.startAmbientColor, this.targetAmbientColor, t);
            this.currentDirectionalStrength = HDUtils.lerp(this.startDirectionalStrength, this.targetDirectionalStrength, t);
            this.currentDirectionalColor = HDUtils.lerpVectors(this.startDirectionalColor, this.targetDirectionalColor, t);
            this.currentUnderglowStrength = HDUtils.lerp(this.startUnderglowStrength, this.targetUnderglowStrength, t);
            this.currentUnderglowColor = HDUtils.lerpVectors(this.startUnderglowColor, this.targetUnderglowColor, t);
            this.currentGroundFogStart = HDUtils.lerp(this.startGroundFogStart, this.targetGroundFogStart, t);
            this.currentGroundFogEnd = HDUtils.lerp(this.startGroundFogEnd, this.targetGroundFogEnd, t);
            this.currentGroundFogOpacity = HDUtils.lerp(this.startGroundFogOpacity, this.targetGroundFogOpacity, t);
            this.currentLightPitch = HDUtils.lerp(this.startLightPitch, this.targetLightPitch, t);
            this.currentLightYaw = HDUtils.lerp(this.startLightYaw, this.targetLightYaw, t);
            this.currentUnderwaterCausticsColor = HDUtils.lerpVectors(this.startUnderwaterCausticsColor, this.targetUnderwaterCausticsColor, t);
            this.currentUnderwaterCausticsStrength = HDUtils.lerp(this.startUnderwaterCausticsStrength, this.targetUnderwaterCausticsStrength, t);
        }
        this.updateLightning();
        this.lastFrameTime = System.currentTimeMillis();
    }

    private void changeEnvironment(Environment newEnvironment, boolean skipTransition) {
        if (this.currentEnvironment == newEnvironment) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.transitionCompleteTime = this.startTime + (long)(skipTransition ? 0 : 3000);
        log.debug("changing environment from {} to {} (instant: {})", new Object[]{this.currentEnvironment, newEnvironment, skipTransition});
        this.currentEnvironment = newEnvironment;
        this.startFogColor = this.currentFogColor;
        this.startWaterColor = this.currentWaterColor;
        this.startFogDepth = this.currentFogDepth;
        this.startAmbientStrength = this.currentAmbientStrength;
        this.startAmbientColor = this.currentAmbientColor;
        this.startDirectionalStrength = this.currentDirectionalStrength;
        this.startDirectionalColor = this.currentDirectionalColor;
        this.startUnderglowStrength = this.currentUnderglowStrength;
        this.startUnderglowColor = this.currentUnderglowColor;
        this.startGroundFogStart = this.currentGroundFogStart;
        this.startGroundFogEnd = this.currentGroundFogEnd;
        this.startGroundFogOpacity = this.currentGroundFogOpacity;
        this.startLightPitch = this.currentLightPitch;
        this.startLightYaw = this.currentLightYaw;
        this.startUnderwaterCausticsColor = this.currentUnderwaterCausticsColor;
        this.startUnderwaterCausticsStrength = this.currentUnderwaterCausticsStrength;
        this.updateTargetSkyColor();
        this.targetFogDepth = newEnvironment.getFogDepth();
        if (this.useWinterTheme() && !newEnvironment.isCustomFogDepth()) {
            this.targetFogDepth = Environment.WINTER.getFogDepth();
        }
        Environment atmospheric = this.config.atmosphericLighting() ? newEnvironment : this.defaultEnvironment;
        this.targetAmbientStrength = atmospheric.getAmbientStrength();
        this.targetAmbientColor = atmospheric.getAmbientColor();
        this.targetDirectionalStrength = atmospheric.getDirectionalStrength();
        this.targetDirectionalColor = atmospheric.getDirectionalColor();
        this.targetUnderglowStrength = atmospheric.getUnderglowStrength();
        this.targetUnderglowColor = atmospheric.getUnderglowColor();
        this.targetLightPitch = atmospheric.getLightPitch();
        this.targetLightYaw = atmospheric.getLightYaw();
        if (this.useWinterTheme()) {
            if (!atmospheric.isCustomAmbientStrength()) {
                this.targetAmbientStrength = Environment.WINTER.getAmbientStrength();
            }
            if (!atmospheric.isCustomAmbientColor()) {
                this.targetAmbientColor = Environment.WINTER.getAmbientColor();
            }
            if (!atmospheric.isCustomDirectionalStrength()) {
                this.targetDirectionalStrength = Environment.WINTER.getDirectionalStrength();
            }
            if (!atmospheric.isCustomDirectionalColor()) {
                this.targetDirectionalColor = Environment.WINTER.getDirectionalColor();
            }
        }
        this.targetGroundFogStart = newEnvironment.getGroundFogStart();
        this.targetGroundFogEnd = newEnvironment.getGroundFogEnd();
        this.targetGroundFogOpacity = newEnvironment.getGroundFogOpacity();
        this.targetUnderwaterCausticsColor = newEnvironment.getUnderwaterCausticsColor();
        this.targetUnderwaterCausticsStrength = newEnvironment.getUnderwaterCausticsStrength();
        this.lightningEnabled = newEnvironment.isLightningEnabled();
    }

    public void updateTargetSkyColor() {
        Environment env;
        Environment environment = env = this.useWinterTheme() ? Environment.WINTER : this.currentEnvironment;
        if (!env.isCustomFogColor() || env.isAllowSkyOverride() && this.config.overrideSky()) {
            DefaultSkyColor sky = this.config.defaultSkyColor();
            this.targetFogColor = sky.getRgb(this.client);
            if (sky == DefaultSkyColor.OSRS) {
                sky = DefaultSkyColor.DEFAULT;
            }
            this.targetWaterColor = sky.getRgb(this.client);
        } else {
            this.targetWaterColor = env.getFogColor();
            this.targetFogColor = this.targetWaterColor;
        }
        if (this.currentEnvironment.isCustomWaterColor()) {
            this.targetWaterColor = this.currentEnvironment.getWaterColor();
        }
    }

    public void loadSceneEnvironments(SceneContext sceneContext) {
        log.debug("Adding environments for scene with regions: {}", (Object)sceneContext.regionIds);
        AABB[] regions = (AABB[])sceneContext.regionIds.stream().map(AABB::new).toArray(AABB[]::new);
        sceneContext.environments.clear();
        block0: for (Environment environment : Environment.values()) {
            for (AABB region : regions) {
                for (AABB aabb : environment.getArea().getAabbs()) {
                    if (!region.intersects(aabb)) continue;
                    log.debug("Added environment: {}", (Object)environment);
                    sceneContext.environments.add(environment);
                    continue block0;
                }
            }
        }
    }

    void updateLightning() {
        if (this.lightningBrightness > 0.0f) {
            int frameTime = (int)(System.currentTimeMillis() - this.lastFrameTime);
            float brightnessChange = (float)frameTime / 1000.0f * 80.0f;
            this.lightningBrightness = Math.max(this.lightningBrightness - brightnessChange, 0.0f);
        }
        if (this.nextLightningTime == -1.0) {
            this.generateNextLightningTime();
            return;
        }
        if ((double)System.currentTimeMillis() > this.nextLightningTime) {
            this.lightningBrightness = 7.0f;
            this.generateNextLightningTime();
        }
        if (this.lightningEnabled && this.config.flashingEffects()) {
            float t = HDUtils.clamp(this.lightningBrightness, 0.0f, 1.0f);
            this.currentFogColor = HDUtils.lerpVectors(this.currentFogColor, LIGHTNING_COLOR, t);
            this.currentWaterColor = HDUtils.lerpVectors(this.currentWaterColor, LIGHTNING_COLOR, t);
        } else {
            this.lightningBrightness = 0.0f;
        }
    }

    void generateNextLightningTime() {
        int lightningInterval = (int)(5500.0 + 11500.0 * Math.random());
        int quickLightningInterval = (int)(40.0 + 110.0 * Math.random());
        this.nextLightningTime = Math.random() <= 0.5 ? (double)(System.currentTimeMillis() + (long)quickLightningInterval) : (double)(System.currentTimeMillis() + (long)lightningInterval);
    }

    public float[] getFogColor() {
        return Arrays.copyOf(this.client.getGameState().getState() >= GameState.LOADING.getState() ? this.currentFogColor : BLACK_COLOR, 3);
    }

    public boolean isUnderwater() {
        return this.currentEnvironment.isUnderwater();
    }

    private boolean useWinterTheme() {
        return this.plugin.configWinterTheme && this.isOverworld;
    }

    public float getLightningBrightness() {
        return this.lightningBrightness;
    }
}

