/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Projectile;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderConfig;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.scene.SceneContext;
import net.runelite.client.plugins.hd.scene.lights.Alignment;
import net.runelite.client.plugins.hd.scene.lights.Light;
import net.runelite.client.plugins.hd.scene.lights.LightType;
import net.runelite.client.plugins.hd.scene.lights.SceneLight;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.Props;
import net.runelite.client.plugins.hd.utils.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LightManager {
    private static final Logger log = LoggerFactory.getLogger(LightManager.class);
    private static final ResourcePath LIGHTS_PATH = Props.getPathOrDefault("rlhd.lights-path", () -> ResourcePath.path(LightManager.class, "lights.json"));
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private EntityHiderPlugin entityHiderPlugin;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ConfigManager configManager;
    @VisibleForTesting
    final ArrayList<SceneLight> WORLD_LIGHTS = new ArrayList();
    @VisibleForTesting
    final ListMultimap<Integer, Light> NPC_LIGHTS = ArrayListMultimap.create();
    @VisibleForTesting
    final ListMultimap<Integer, Light> OBJECT_LIGHTS = ArrayListMultimap.create();
    @VisibleForTesting
    final ListMultimap<Integer, Light> PROJECTILE_LIGHTS = ArrayListMultimap.create();
    @VisibleForTesting
    final ListMultimap<Integer, Light> GRAPHICS_OBJECT_LIGHTS = ArrayListMultimap.create();
    long lastFrameTime = -1L;
    boolean configChanged = false;
    private EntityHiderConfig entityHiderConfig;
    static final float TWO_PI = (float)Math.PI * 2;
    private final ArrayList<Projectile> trackedProjectiles = new ArrayList();

    @VisibleForTesting
    void loadConfig(Gson gson, ResourcePath path) {
        try {
            Light[] lights;
            try {
                lights = path.loadJson(gson, Light[].class);
            }
            catch (IOException ex) {
                log.error("Failed to load lights", ex);
                return;
            }
            this.WORLD_LIGHTS.clear();
            this.NPC_LIGHTS.clear();
            this.OBJECT_LIGHTS.clear();
            this.PROJECTILE_LIGHTS.clear();
            this.GRAPHICS_OBJECT_LIGHTS.clear();
            for (Light l : lights) {
                float[] linearRGBA = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                for (int i = 0; i < Math.min(l.color.length, linearRGBA.length); ++i) {
                    int n = i;
                    float f = l.color[n] / 255.0f;
                    l.color[n] = f;
                    linearRGBA[i] = HDUtils.srgbToLinear(f);
                }
                l.color = linearRGBA;
                if (l.worldX != null && l.worldY != null) {
                    WorldPoint worldPoint = new WorldPoint(l.worldX, l.worldY, l.plane);
                    this.WORLD_LIGHTS.add(new SceneLight(l, worldPoint));
                }
                l.npcIds.forEach(id -> this.NPC_LIGHTS.put((Integer)id, l));
                l.objectIds.forEach(id -> this.OBJECT_LIGHTS.put((Integer)id, l));
                l.projectileIds.forEach(id -> this.PROJECTILE_LIGHTS.put((Integer)id, l));
                l.graphicsObjectIds.forEach(id -> this.GRAPHICS_OBJECT_LIGHTS.put((Integer)id, l));
            }
            log.debug("Loaded {} lights", (Object)lights.length);
            this.configChanged = true;
        }
        catch (Exception ex) {
            log.error("Failed to parse light configuration", ex);
        }
    }

    public void startUp() {
        this.entityHiderConfig = this.configManager.getConfig(EntityHiderConfig.class);
        LIGHTS_PATH.watch(path -> this.loadConfig(this.plugin.getGson(), (ResourcePath)path));
    }

    public void update(SceneContext sceneContext) {
        assert (this.client.isClientThread());
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.configChanged) {
            this.configChanged = false;
            this.loadSceneLights(sceneContext);
            this.client.getNpcs().forEach(npc -> this.addNpcLights(sceneContext, (NPC)npc));
        }
        Tile[][][] tiles = sceneContext.scene.getTiles();
        int[][][] tileHeights = sceneContext.scene.getTileHeights();
        Iterator<SceneLight> lightIterator = sceneContext.lights.iterator();
        while (lightIterator.hasNext()) {
            Tile lightTile;
            Tile aboveTile;
            SceneLight light2 = lightIterator.next();
            long frameTime = System.currentTimeMillis() - this.lastFrameTime;
            light2.distance = Integer.MAX_VALUE;
            if (light2.projectile != null) {
                if (light2.projectile.getRemainingCycles() <= 0) {
                    lightIterator.remove();
                    this.trackedProjectiles.remove(light2.projectile);
                    continue;
                }
                light2.x = (int)light2.projectile.getX();
                light2.y = (int)light2.projectile.getY();
                light2.z = (int)light2.projectile.getZ() - light2.height;
                light2.visible = this.projectileLightVisible();
            }
            if (light2.graphicsObject != null) {
                if (light2.graphicsObject.finished()) {
                    lightIterator.remove();
                    continue;
                }
                light2.x = light2.graphicsObject.getLocation().getX();
                light2.y = light2.graphicsObject.getLocation().getY();
                light2.z = light2.graphicsObject.getZ() - light2.height;
            }
            if (light2.npc != null && light2.npc.getIndex() != -1) {
                int plane;
                if (light2.npc != this.client.getCachedNPCs()[light2.npc.getIndex()]) {
                    lightIterator.remove();
                    continue;
                }
                light2.x = light2.npc.getLocalLocation().getX();
                light2.y = light2.npc.getLocalLocation().getY();
                if (light2.alignment == Alignment.NORTH || light2.alignment == Alignment.NORTHEAST || light2.alignment == Alignment.NORTHWEST) {
                    light2.y += 64;
                }
                if (light2.alignment == Alignment.SOUTH || light2.alignment == Alignment.SOUTHEAST || light2.alignment == Alignment.SOUTHWEST) {
                    light2.y -= 64;
                }
                if (light2.alignment == Alignment.EAST || light2.alignment == Alignment.SOUTHEAST || light2.alignment == Alignment.NORTHEAST) {
                    light2.x += 64;
                }
                if (light2.alignment == Alignment.WEST || light2.alignment == Alignment.SOUTHWEST || light2.alignment == Alignment.NORTHWEST) {
                    light2.x -= 64;
                }
                light2.plane = plane = this.client.getPlane();
                int npcTileX = light2.npc.getLocalLocation().getSceneX();
                int npcTileY = light2.npc.getLocalLocation().getSceneY();
                if (npcTileX < 104 && npcTileY < 104 && npcTileX >= 0 && npcTileY >= 0) {
                    if (tiles[plane][npcTileX][npcTileY] != null && tiles[plane][npcTileX][npcTileY].getBridge() != null) {
                        ++plane;
                    }
                    float lerpX = (float)(light2.x % 128) / 128.0f;
                    float lerpY = (float)(light2.y % 128) / 128.0f;
                    int baseTileX = (int)Math.floor((float)light2.x / 128.0f);
                    int baseTileY = (int)Math.floor((float)light2.y / 128.0f);
                    float heightNorth = HDUtils.lerp(tileHeights[plane][baseTileX][baseTileY + 1], tileHeights[plane][baseTileX + 1][baseTileY + 1], lerpX);
                    float heightSouth = HDUtils.lerp(tileHeights[plane][baseTileX][baseTileY], tileHeights[plane][baseTileX + 1][baseTileY], lerpX);
                    float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
                    light2.z = (int)tileHeight - 1 - light2.height;
                    light2.visible = this.npcLightVisible(light2.npc);
                } else {
                    light2.visible = false;
                }
            }
            if (light2.type == LightType.FLICKER) {
                long repeatMs = 60000L;
                int offset = light2.randomOffset;
                float t = (float)Math.PI * 2 * (float)((System.currentTimeMillis() + (long)offset) % repeatMs) / (float)repeatMs;
                float flicker = (float)(Math.pow(Math.cos(11.0f * t), 2.0) + Math.pow(Math.cos(17.0f * t), 4.0) + Math.pow(Math.cos(23.0f * t), 6.0) + Math.pow(Math.cos(31.0f * t), 2.0) + Math.pow(Math.cos(71.0f * t), 2.0) / 3.0 + Math.pow(Math.cos(151.0f * t), 2.0) / 7.0) / 4.335f;
                float maxFlicker = 1.0f + light2.range / 100.0f;
                float minFlicker = 1.0f - light2.range / 100.0f;
                flicker = minFlicker + (maxFlicker - minFlicker) * flicker;
                light2.currentStrength = light2.strength * flicker;
                light2.currentSize = (int)((float)light2.radius * flicker * 1.5f);
            } else if (light2.type == LightType.PULSE) {
                float duration = light2.duration / 1000.0f;
                float range = light2.range / 100.0f;
                float fullRange = range * 2.0f;
                float change = (float)frameTime / 1000.0f / duration;
                light2.currentAnimation += change % 1.0f;
                light2.currentAnimation %= 1.0f;
                float output = light2.currentAnimation > 0.5f ? 1.0f - (light2.currentAnimation - 0.5f) * 2.0f : light2.currentAnimation * 2.0f;
                float multiplier = 1.0f - range + output * fullRange;
                light2.currentSize = (int)((float)light2.radius * multiplier);
                light2.currentStrength = light2.strength * multiplier;
            } else {
                light2.currentStrength = light2.strength;
                light2.currentSize = light2.radius;
                light2.currentColor = light2.color;
            }
            if (light2.fadeInDuration > 0) {
                light2.currentStrength *= Math.min((float)light2.currentFadeIn / (float)light2.fadeInDuration, 1.0f);
                light2.currentFadeIn = (int)((long)light2.currentFadeIn + frameTime);
            }
            int camX = this.plugin.camTarget[0];
            int camY = this.plugin.camTarget[1];
            int camZ = this.plugin.camTarget[2];
            light2.distance = (int)Math.sqrt(Math.pow(camX - light2.x, 2.0) + Math.pow(camY - light2.y, 2.0) + Math.pow(camZ - light2.z, 2.0));
            int tileX = (int)Math.floor((float)light2.x / 128.0f);
            int tileY = (int)Math.floor((float)light2.y / 128.0f);
            int tileZ = light2.plane;
            light2.belowFloor = false;
            light2.aboveFloor = false;
            if (tileX >= 104 || tileY >= 104 || tileX < 0 || tileY < 0 || tileZ < 0) continue;
            Tile tile = aboveTile = tileZ < 3 ? tiles[tileZ + 1][tileX][tileY] : null;
            if (aboveTile != null && (aboveTile.getSceneTilePaint() != null || aboveTile.getSceneTileModel() != null)) {
                light2.belowFloor = true;
            }
            if ((lightTile = tiles[tileZ][tileX][tileY]) == null || lightTile.getSceneTilePaint() == null && lightTile.getSceneTileModel() == null) continue;
            light2.aboveFloor = true;
        }
        sceneContext.lights.sort(Comparator.comparingInt(light -> light.distance));
        this.lastFrameTime = System.currentTimeMillis();
    }

    private boolean npcLightVisible(NPC npc) {
        if (npc.getModel() == null) {
            return false;
        }
        if (this.pluginManager.isPluginEnabled(this.entityHiderPlugin)) {
            boolean isPet = npc.getComposition().isFollower();
            if (this.entityHiderConfig.hideNPCs() && !isPet) {
                return false;
            }
            if (this.entityHiderConfig.hidePets() && isPet) {
                return false;
            }
        }
        return this.plugin.configNpcLights;
    }

    private boolean projectileLightVisible() {
        if (this.pluginManager.isPluginEnabled(this.entityHiderPlugin) && this.entityHiderConfig.hideProjectiles()) {
            return false;
        }
        return this.plugin.configProjectileLights;
    }

    public void loadSceneLights(SceneContext sceneContext) {
        sceneContext.lights.clear();
        this.trackedProjectiles.clear();
        for (SceneLight light : this.WORLD_LIGHTS) {
            assert (light.worldPoint != null);
            if (!sceneContext.regionIds.contains(light.worldPoint.getRegionID())) continue;
            sceneContext.lights.add(light);
            this.updateWorldLightPosition(sceneContext, light);
        }
        Tile[][][] tileArray = sceneContext.scene.getTiles();
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[][] plane;
            Tile[][] tileArray2 = plane = tileArray[i];
            int n2 = tileArray2.length;
            for (int j = 0; j < n2; ++j) {
                Tile[] column;
                for (Tile tile : column = tileArray2[j]) {
                    GroundObject groundObject;
                    WallObject wallObject;
                    if (tile == null) continue;
                    DecorativeObject decorativeObject = tile.getDecorativeObject();
                    if (decorativeObject != null && decorativeObject.getRenderable() != null) {
                        this.addObjectLight(sceneContext, decorativeObject, tile.getRenderLevel());
                    }
                    if ((wallObject = tile.getWallObject()) != null && wallObject.getRenderable1() != null) {
                        int orientation = HDUtils.convertWallObjectOrientation(wallObject.getOrientationA());
                        this.addObjectLight(sceneContext, wallObject, tile.getRenderLevel(), 1, 1, orientation);
                    }
                    if ((groundObject = tile.getGroundObject()) != null && groundObject.getRenderable() != null) {
                        this.addObjectLight(sceneContext, groundObject, tile.getRenderLevel());
                    }
                    for (GameObject gameObject : tile.getGameObjects()) {
                        if (gameObject == null || gameObject.getRenderable() instanceof Actor) continue;
                        this.addObjectLight(sceneContext, gameObject, tile.getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation().getAngle());
                    }
                }
            }
        }
    }

    public ArrayList<SceneLight> getVisibleLights(int maxDistance, int maxLights) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        ArrayList<SceneLight> visibleLights = new ArrayList<SceneLight>();
        if (sceneContext == null) {
            return visibleLights;
        }
        for (SceneLight light : sceneContext.lights) {
            if (light.distance > maxDistance * 128) break;
            if (!light.visible || light.plane < this.client.getPlane() && light.belowFloor || light.plane > this.client.getPlane() && light.aboveFloor) continue;
            visibleLights.add(light);
            if (visibleLights.size() < maxLights) continue;
            break;
        }
        return visibleLights;
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        Projectile projectile = projectileMoved.getProjectile();
        for (Light l : this.PROJECTILE_LIGHTS.get((Object)projectile.getId())) {
            if (this.trackedProjectiles.contains(projectile)) continue;
            SceneLight light = new SceneLight(0, 0, projectile.getFloor(), l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, 300);
            light.projectile = projectile;
            light.x = (int)projectile.getX();
            light.y = (int)projectile.getY();
            light.z = (int)projectile.getZ();
            this.trackedProjectiles.add(projectile);
            if (sceneContext == null) continue;
            sceneContext.lights.add(light);
        }
    }

    private void addNpcLights(SceneContext sceneContext, NPC npc) {
        if (sceneContext == null) {
            return;
        }
        for (Light l : this.NPC_LIGHTS.get((Object)npc.getId())) {
            if (sceneContext.lights.stream().anyMatch(x -> x.npc == npc)) continue;
            SceneLight light = new SceneLight(0, 0, -1, l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, 0);
            light.npc = npc;
            light.visible = false;
            sceneContext.lights.add(light);
        }
    }

    public void removeNpcLight(SceneContext sceneContext, NPC npc) {
        if (sceneContext != null) {
            sceneContext.lights.removeIf(light -> light.npc == npc);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        this.addNpcLights(this.plugin.getSceneContext(), npcSpawned.getNpc());
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        this.removeNpcLight(sceneContext, npcChanged.getNpc());
        this.addNpcLights(sceneContext, npcChanged.getNpc());
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        this.removeNpcLight(this.plugin.getSceneContext(), npcDespawned.getNpc());
    }

    private void addObjectLight(SceneContext sceneContext, TileObject tileObject, int plane) {
        this.addObjectLight(sceneContext, tileObject, plane, 1, 1, -1);
    }

    private void addObjectLight(SceneContext sceneContext, TileObject tileObject, int plane, int sizeX, int sizeY, int orientation) {
        for (Light l : this.OBJECT_LIGHTS.get((Object)tileObject.getId())) {
            if (tileObject.getPlane() <= -1) continue;
            int hash = this.tileObjectHash(tileObject);
            boolean isDuplicate = sceneContext.lights.stream().anyMatch(light -> light.object == tileObject || hash == this.tileObjectHash(light.object));
            if (isDuplicate) continue;
            int localPlane = tileObject.getPlane();
            SceneLight light2 = new SceneLight(0, 0, localPlane, l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, l.fadeInDuration);
            LocalPoint localPoint = tileObject.getLocalLocation();
            int lightX = localPoint.getX();
            int lightY = localPoint.getY();
            int localSizeX = sizeX * 128;
            int localSizeY = sizeY * 128;
            if (orientation != -1 && light2.alignment != Alignment.CENTER) {
                float radius = (float)localSizeX / 2.0f;
                if (!light2.alignment.radial) {
                    radius = (float)Math.sqrt(localSizeX * localSizeX + localSizeX * localSizeX) / 2.0f;
                }
                if (!light2.alignment.relative) {
                    orientation = 0;
                }
                orientation += light2.alignment.orientation;
                float sine = (float)Perspective.SINE[orientation %= 2048] / 65536.0f;
                float cosine = (float)Perspective.COSINE[orientation] / 65536.0f;
                int offsetX = (int)(radius * sine);
                int offsetY = (int)(radius * (cosine /= (float)localSizeX / (float)localSizeY));
                lightX += offsetX;
                lightY += offsetY;
            }
            float tileX = (float)lightX / 128.0f;
            float tileY = (float)lightY / 128.0f;
            float lerpX = (float)(lightX % 128) / 128.0f;
            float lerpY = (float)(lightY % 128) / 128.0f;
            int tileMinX = (int)Math.floor(tileX);
            int tileMinY = (int)Math.floor(tileY);
            int tileMaxX = tileMinX + 1;
            int tileMaxY = tileMinY + 1;
            tileMinX = HDUtils.clamp(tileMinX, 0, 103);
            tileMinY = HDUtils.clamp(tileMinY, 0, 103);
            tileMaxX = HDUtils.clamp(tileMaxX, 0, 103);
            tileMaxY = HDUtils.clamp(tileMaxY, 0, 103);
            int[][][] tileHeights = sceneContext.scene.getTileHeights();
            float heightNorth = HDUtils.lerp(tileHeights[plane][tileMinX][tileMaxY], tileHeights[plane][tileMaxX][tileMaxY], lerpX);
            float heightSouth = HDUtils.lerp(tileHeights[plane][tileMinX][tileMinY], tileHeights[plane][tileMaxX][tileMinY], lerpX);
            float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
            light2.x = lightX;
            light2.y = lightY;
            light2.z = (int)tileHeight - light2.height - 1;
            light2.object = tileObject;
            sceneContext.lights.add(light2);
        }
    }

    private void removeObjectLight(TileObject tileObject) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        LocalPoint localLocation = tileObject.getLocalLocation();
        sceneContext.lights.removeIf(light -> light.object == tileObject && light.x == localLocation.getX() && light.y == localLocation.getY() && light.plane == tileObject.getPlane());
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated graphicsObjectCreated) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        GraphicsObject graphicsObject = graphicsObjectCreated.getGraphicsObject();
        for (Light l : this.GRAPHICS_OBJECT_LIGHTS.get((Object)graphicsObject.getId())) {
            SceneLight light = new SceneLight(0, 0, graphicsObject.getLevel(), l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, 300);
            light.graphicsObject = graphicsObject;
            light.x = graphicsObject.getLocation().getX();
            light.y = graphicsObject.getLocation().getY();
            light.z = graphicsObject.getZ();
            sceneContext.lights.add(light);
        }
    }

    private int tileObjectHash(@Nullable TileObject tileObject) {
        if (tileObject == null) {
            return 0;
        }
        LocalPoint local = tileObject.getLocalLocation();
        int hash = local.getX();
        hash = hash * 31 + local.getY();
        hash = hash * 31 + tileObject.getPlane();
        hash = hash * 31 + tileObject.getId();
        return hash;
    }

    private void updateWorldLightPosition(SceneContext sceneContext, SceneLight light) {
        assert (light.worldPoint != null);
        Optional<LocalPoint> firstLocalPoint = sceneContext.worldInstanceToLocals(light.worldPoint).stream().findFirst();
        if (!firstLocalPoint.isPresent()) {
            return;
        }
        LocalPoint local = firstLocalPoint.get();
        light.x = local.getX() + 64;
        light.y = local.getY() + 64;
        if (local.isInScene()) {
            light.z = sceneContext.scene.getTileHeights()[light.plane][local.getSceneX()][local.getSceneY()] - light.height - 1;
        }
        if (light.alignment == Alignment.NORTH || light.alignment == Alignment.NORTHEAST || light.alignment == Alignment.NORTHWEST) {
            light.y += 64;
        }
        if (light.alignment == Alignment.EAST || light.alignment == Alignment.NORTHEAST || light.alignment == Alignment.SOUTHEAST) {
            light.x += 64;
        }
        if (light.alignment == Alignment.SOUTH || light.alignment == Alignment.SOUTHEAST || light.alignment == Alignment.SOUTHWEST) {
            light.y -= 64;
        }
        if (light.alignment == Alignment.WEST || light.alignment == Alignment.NORTHWEST || light.alignment == Alignment.SOUTHWEST) {
            light.x -= 64;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        GameObject gameObject = gameObjectSpawned.getGameObject();
        this.addObjectLight(sceneContext, gameObject, gameObjectSpawned.getTile().getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation().getAngle());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        this.removeObjectLight(gameObjectDespawned.getGameObject());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned wallObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        WallObject wallObject = wallObjectSpawned.getWallObject();
        this.addObjectLight(sceneContext, wallObject, wallObjectSpawned.getTile().getRenderLevel(), 1, 1, wallObject.getOrientationA());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned wallObjectDespawned) {
        this.removeObjectLight(wallObjectDespawned.getWallObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned decorativeObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        this.addObjectLight(sceneContext, decorativeObjectSpawned.getDecorativeObject(), decorativeObjectSpawned.getTile().getRenderLevel());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned decorativeObjectDespawned) {
        this.removeObjectLight(decorativeObjectDespawned.getDecorativeObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned groundObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        this.addObjectLight(sceneContext, groundObjectSpawned.getGroundObject(), groundObjectSpawned.getTile().getRenderLevel());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned groundObjectDespawned) {
        this.removeObjectLight(groundObjectDespawned.getGroundObject());
    }
}

